/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.catalogentrylist;

import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.hlist.HListInterface;
import com.sas.models.Node;
import com.sas.models.SimpleNodeInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.SASListNodeDelegate;
import com.sas.sasserver.catalogentrylist.CatalogEntryListInterface;
import com.sas.sasserver.sclfuncs.SclfuncsV2Interface;
import com.sas.util.Util;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;

public class CatalogEntryListDelegate
extends SASListNodeDelegate {
    private transient CatalogEntryListInterface m_remoteObject;
    private transient SclfuncsV2Interface sclfuncs;
    protected transient String catalog;
    protected transient String pendingCatalog;
    protected transient String typeFilter;
    protected transient int levelCount;
    protected transient boolean catalogEntryDisplayed;
    protected transient boolean descriptionDisplayed;
    protected transient boolean modifiedDateDisplayed;
    boolean leafNode;

    @Override
    public void _setRemoteHandle(Object o) {
        super._setRemoteHandle(o);
        this.m_remoteObject = (CatalogEntryListInterface)this.remoteObject();
    }

    private String getEntryDescription(String fileName) {
        int fileNameLength;
        if (this.sclfuncs == null) {
            RemoteBaseClient rbc = (RemoteBaseClient)((Object)this.m_remoteObject);
            Connection rocfContext = rbc._RemoteObject_getContext();
            Rocf classFactory = rbc._RemoteObject_getClassFactory();
            try {
                this.sclfuncs = (SclfuncsV2Interface)classFactory.getInstance(SclfuncsV2Interface.class, rocfContext);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        if ((fileNameLength = fileName.length()) > 0) {
            return this.sclfuncs.getEntryDescription(fileName.substring(0, fileNameLength - 1));
        }
        return "";
    }

    protected synchronized String parseItem(HListInterface membersList, int index, boolean catalogEntryDisplayed, boolean descriptionDisplayed, boolean modifiedDateDisplayed, int levelCount) {
        HListInterface subList = membersList.getList(index);
        String stringItem = "";
        String libraryName = subList.getString("LIBNAME");
        String catalogName = subList.getString("CATNAME");
        String memberName = subList.getString("OBJNAME");
        String typeName = subList.getString("OBJTYPE");
        String sasFullFileName = libraryName.trim() + "." + catalogName.trim() + "." + memberName.trim() + "." + typeName.trim() + ".";
        if (catalogEntryDisplayed) {
            int sasFileNameLength;
            String sasFileName = "";
            if (levelCount >= 3) {
                sasFileName = sasFileName + libraryName.trim() + ".";
                sasFileName = sasFileName + catalogName.trim() + ".";
            }
            if (levelCount >= 1) {
                sasFileName = sasFileName + memberName.trim() + ".";
            }
            if (levelCount == 4 || levelCount == 2) {
                sasFileName = sasFileName + typeName.trim() + ".";
            }
            if ((sasFileNameLength = sasFileName.length()) > 0) {
                stringItem = stringItem + sasFileName.substring(0, sasFileNameLength - 1) + " ";
            }
        }
        if (descriptionDisplayed) {
            String desc = "";
            desc = subList.find("OBJDESC", 1, 0) != -1 ? subList.getString("OBJDESC") : this.getEntryDescription(sasFullFileName);
            stringItem = stringItem + desc + " ";
        }
        if (modifiedDateDisplayed) {
            stringItem = stringItem + subList.getString("MODIFIED") + " ";
        }
        stringItem = stringItem.trim();
        return stringItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void parseList(HListInterface membersList, OrderedCollectionInterface parsedList) {
        OrderedCollectionInterface orderedCollectionInterface = parsedList;
        synchronized (orderedCollectionInterface) {
            parsedList.removeAll();
            boolean catalogEntryDisplayed = this.isCatalogEntryDisplayed();
            boolean descriptionDisplayed = this.isDescriptionDisplayed();
            boolean modifiedDateDisplayed = this.isModifiedDateDisplayed();
            int levelCount = this.getLevelCount();
            int count = membersList.count();
            for (int i = 0; i < count; ++i) {
                parsedList.add((Object)this.parseItem(membersList, i, catalogEntryDisplayed, descriptionDisplayed, modifiedDateDisplayed, levelCount));
            }
            if (this.catalog == null || this.catalog.length() == 0) {
                parsedList.removeAll();
            }
        }
    }

    public synchronized String getCatalog() {
        return this.catalog;
    }

    public synchronized void setCatalog(String catalog) {
        String previousCatalog = this.getCatalog();
        if (!Util.equal((Object)catalog, (Object)previousCatalog)) {
            int rc;
            if (catalog == null) {
                catalog = "";
            }
            if ((rc = this.m_remoteObject._setCatalog(catalog)) != 0) {
                throw new IllegalArgumentException();
            }
            this.catalog = catalog;
            this.needs_refresh = true;
            this.resubmitQuery();
            this.pendingCatalog = catalog;
            this.fireContentsChanged();
            this.firePropertyChange("catalog", previousCatalog, catalog);
        }
    }

    public synchronized void setPendingCatalog(String name) {
        this.pendingCatalog = name;
    }

    public synchronized String getTypeFilter() {
        return this.typeFilter;
    }

    public synchronized void setTypeFilter(String typeFilter) {
        String previousTypeFilter = this.getTypeFilter();
        if (!Util.equal((Object)typeFilter, (Object)previousTypeFilter)) {
            this.typeFilter = typeFilter;
            this.m_remoteObject._setTypeFilter(typeFilter);
            this.fireContentsChanged();
            this.firePropertyChange("typeFilter", previousTypeFilter, typeFilter);
        }
    }

    public synchronized int getLevelCount() {
        return this.levelCount;
    }

    public synchronized void setLevelCount(int levelCount) {
        int previousLevelCount = this.getLevelCount();
        if (previousLevelCount != levelCount) {
            if (levelCount < 1 || levelCount > 4) {
                throw new IllegalArgumentException(Util.getCommonStringResource((String)"InvalidLevelCount.ex.txt"));
            }
            this.levelCount = levelCount;
            this.fireContentsChanged();
            this.firePropertyChange("levelCount", new Integer(previousLevelCount), new Integer(levelCount));
        }
    }

    public synchronized boolean isCatalogEntryDisplayed() {
        return this.catalogEntryDisplayed;
    }

    public synchronized void setCatalogEntryDisplayed(boolean catalogEntryDisplayed) {
        if (this.isCatalogEntryDisplayed() != catalogEntryDisplayed) {
            this.catalogEntryDisplayed = catalogEntryDisplayed;
            this.fireContentsChanged();
            this.firePropertyChange("catalogEntryDisplayed", catalogEntryDisplayed ? Boolean.FALSE : Boolean.TRUE, catalogEntryDisplayed ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public synchronized String getCatalogEntry(int index, int levelCount) {
        this.resubmitQuery();
        return this.parseItem(this.membersList, index, true, false, false, levelCount);
    }

    public synchronized boolean isDescriptionDisplayed() {
        return this.descriptionDisplayed;
    }

    public synchronized void setDescriptionDisplayed(boolean descriptionDisplayed) {
        if (this.isDescriptionDisplayed() != descriptionDisplayed) {
            this.descriptionDisplayed = descriptionDisplayed;
            this.fireContentsChanged();
            this.firePropertyChange("descriptionDisplayed", descriptionDisplayed ? Boolean.FALSE : Boolean.TRUE, descriptionDisplayed ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public synchronized String getDescription(int index) {
        this.resubmitQuery();
        return this.parseItem(this.membersList, index, false, true, false, 0);
    }

    public synchronized boolean isModifiedDateDisplayed() {
        return this.modifiedDateDisplayed;
    }

    public synchronized void setModifiedDateDisplayed(boolean modifiedDateDisplayed) {
        if (this.isModifiedDateDisplayed() != modifiedDateDisplayed) {
            this.modifiedDateDisplayed = modifiedDateDisplayed;
            this.fireContentsChanged();
            this.firePropertyChange("modifiedDateDisplayed", modifiedDateDisplayed ? Boolean.FALSE : Boolean.TRUE, modifiedDateDisplayed ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public synchronized String getModifiedDate(int index) {
        this.resubmitQuery();
        return this.parseItem(this.membersList, index, false, false, true, 0);
    }

    @Override
    public synchronized int getNodeChildCount() {
        int childCount;
        if (this.pendingCatalog != null && !this.pendingCatalog.equalsIgnoreCase(this.getCatalog())) {
            this.setCatalog(this.pendingCatalog);
        }
        if ((childCount = this.count()) == 0 && this.hasChildren) {
            this.hasChildren = false;
            this.firePropertyChange("leafNode", Boolean.FALSE, Boolean.TRUE);
        }
        return childCount;
    }

    @Override
    public synchronized SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        int nodeChildCount = this.getNodeChildCount();
        SimpleNodeInterface[] childrenArray = new SimpleNodeInterface[count];
        if (nodeChildCount == 0) {
            return childrenArray;
        }
        int levelCount = this.getLevelCount();
        for (int index = startIndex; index < startIndex + count && index < startIndex + nodeChildCount; ++index) {
            String catalogEntryName = (String)this.get(index);
            Node node = new Node(catalogEntryName, "CatalogEntry");
            node.setNodeExpandedText(this.getCatalogEntry(index, 4));
            Node nodeInterface = node;
            childrenArray[index - startIndex] = nodeInterface;
        }
        return childrenArray;
    }

    @Override
    public synchronized boolean isLeafNode() {
        if (this.leafNode) {
            return true;
        }
        if (this.pendingCatalog != null && !this.pendingCatalog.equalsIgnoreCase(this.getCatalog())) {
            if (this.pendingCatalog.trim().length() == 0) {
                this.hasChildren = false;
            }
        } else if (this.getCatalog() == null || this.getCatalog().trim().length() == 0) {
            this.hasChildren = false;
        }
        return !this.hasChildren;
    }

    public synchronized void setLeafNode(boolean leafNode) {
        this.leafNode = leafNode;
    }

    @Override
    public synchronized String getNodeText() {
        return this.pendingCatalog;
    }

    @Override
    public synchronized IconInterface getDefaultIcon() {
        return new ImageView(Resources.getImage((String)"Catalog"));
    }

    @Override
    public synchronized IconInterface getExpandedIcon() {
        return new ImageView(Resources.getImage((String)"CatalogExpanded"));
    }

    public void setDefaultValues() {
        super.setDefaultValues();
        this.catalogEntryDisplayed = true;
        this.levelCount = 2;
    }

    public synchronized void setRootText(String rootText) {
    }
}

