/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver;

import com.sas.RunningObjectTable;
import com.sas.awt.util.Util;
import com.sas.collection.OrderedCollection;
import com.sas.rmi.Connection;
import com.sas.rmi.ConnectionUtility;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.RemoteDesignTimeBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.RB;
import com.sas.sasserver.RemoteObjectSelectorDialog;
import com.sas.security.SecuritySupport;
import com.sas.text.Message;
import com.sas.util.ThreadedCommand;
import com.sas.visuals.CommandProgress;
import com.sas.visuals.CustomizerPanel;
import com.sas.visuals.MessageBox;
import java.awt.Dialog;

public abstract class RemoteObjectCustomizerPanel
extends CustomizerPanel {
    protected boolean isConnectionDesignTimeActive;
    protected Connection connection;
    private Connection realConnection;
    protected Rocf rocf;
    protected ConnectionUtility connectionUtility;
    protected OrderedCollection remoteObjects;
    protected boolean dialogAsynchronous;
    private transient boolean designTimeObject;
    private boolean wasCancelled;
    private boolean exceptionThrown;
    protected OrderedCollection dialogDisposeList;

    public RemoteObjectCustomizerPanel(String tabName) {
        super(tabName);
    }

    protected void registerDialog(RemoteObjectSelectorDialog dialog) {
        if (this.dialogDisposeList == null) {
            this.dialogDisposeList = new OrderedCollection();
        }
        if (dialog != null) {
            this.dialogDisposeList.add((Object)dialog);
        }
    }

    protected void registerRemoteBaseClient(RemoteBaseClient rbc) {
        if (this.remoteObjects == null) {
            this.remoteObjects = new OrderedCollection();
        }
        if (rbc != null) {
            this.remoteObjects.add((Object)rbc);
        }
    }

    protected boolean isDesignTimeObject() {
        return this.designTimeObject;
    }

    protected void initializeConnection(RemoteBaseClient rbc) {
        this.designTimeObject = rbc instanceof RemoteDesignTimeBaseClient;
        if (this.designTimeObject) {
            this.realConnection = RemoteObjectCustomizerPanel.getConnection(rbc);
        }
        if (this.realConnection == null) {
            this.realConnection = rbc._RemoteObject_getContext();
        }
        if (this.realConnection != null) {
            this.isConnectionDesignTimeActive = this.realConnection.isDesignTimeActive();
            if (this.connection != null) {
                this.connection.stop();
            }
            this.connection = (Connection)this.realConnection.clone();
        }
        if (this.connection == null) {
            // empty if block
        }
    }

    public static final Connection getConnection(RemoteBaseClient rbc) {
        String contextName = rbc.getContextName();
        if (contextName != null) {
            if (contextName.indexOf(46) != -1) {
                return (Connection)RunningObjectTable.lookupComponent((String)contextName);
            }
            String thisComp = RunningObjectTable.lookupComponentName((Object)rbc);
            if (thisComp != null) {
                String frame = thisComp.substring(0, thisComp.indexOf(46));
                return (Connection)RunningObjectTable.lookupComponent((String)(frame + '.' + contextName));
            }
        }
        return null;
    }

    protected void createRocf() {
        if (this.rocf == null) {
            this.rocf = new Rocf();
            this.firePropertyChange("rocf", null, (Object)this.rocf);
        }
    }

    protected void createRemoteObjects() throws Exception {
        this.initializeConnectionInfo();
    }

    protected void createAlternateRemoteObjects() throws Exception {
        this.initializeConnectionInfo();
    }

    private void initializeConnectionInfo() throws Exception {
        this.createRocf();
        if (this.connection == null) {
            this.connection = (Connection)this.realConnection.clone();
        }
        try {
            this.rocf.connect(this.connection);
        }
        catch (Exception e) {
            this.connection = null;
            throw e;
        }
    }

    protected void disposeRemoteObjects() {
        int i;
        int cnt;
        if (this.remoteObjects != null) {
            cnt = this.remoteObjects.count();
            for (i = 0; i < cnt; ++i) {
                RemoteBaseClient rbc = (RemoteBaseClient)this.remoteObjects.get(i);
                rbc.stop();
            }
        }
        if (this.dialogDisposeList != null) {
            cnt = this.dialogDisposeList.count();
            for (i = 0; i < cnt; ++i) {
                Dialog dlg = (Dialog)this.dialogDisposeList.get(i);
                dlg.dispose();
            }
        }
        if (this.rocf != null) {
            this.rocf.stop();
        }
    }

    protected void disposeRemoteObject(Object remoteObject) {
        if (remoteObject instanceof RemoteBaseClient && this.remoteObjects != null && this.remoteObjects.contains(remoteObject)) {
            RemoteBaseClient rbc = (RemoteBaseClient)remoteObject;
            rbc.stop();
            this.remoteObjects.remove(remoteObject);
        }
    }

    protected void connectionThreadEnding() {
    }

    protected void connectionAlternateThreadEnding() {
    }

    protected void runConnectionThread() {
        if (this.dialogAsynchronous) {
            this.runAsynchronously();
        } else {
            this.runSynchronously();
        }
    }

    protected void runAlternateConnectionThread() {
        if (this.dialogAsynchronous) {
            this.runAlternateAsynchronously();
        } else {
            this.runAlternateSynchronously();
        }
    }

    private void runAsynchronously() {
        SecuritySupport.securitySupport.createThread(new Runnable(){

            @Override
            public void run() {
                RemoteObjectCustomizerPanel.this.runSynchronously();
            }
        }).start();
    }

    private void runSynchronously() {
        this.runThread(false);
        this.connectionThreadEnding();
    }

    private void runAlternateAsynchronously() {
        SecuritySupport.securitySupport.createThread(new Runnable(){

            @Override
            public void run() {
                RemoteObjectCustomizerPanel.this.runAlternateSynchronously();
            }
        }).start();
    }

    private void runAlternateSynchronously() {
        this.runThread(true);
        this.connectionAlternateThreadEnding();
    }

    private void runThread(boolean alternate) {
        block6: {
            try {
                this.wasCancelled = false;
                this.exceptionThrown = false;
                if (this.connection.isDeferUserInfoUntilRuntime() || this.connection.isDeferApplicationUserInfoUntilRuntime()) {
                    if (alternate) {
                        this.createAlternateRemoteObjects();
                    } else {
                        this.createRemoteObjects();
                    }
                    this.connection.showLoginDialog();
                } else {
                    CommandProgress.executeAsynchronously(new Connect(alternate), null, RB.getStringResource("progressDialogTitle.txt"), Message.format((String)RB.getStringResource("progressDialogText.txt"), (Object)this.realConnection.getHost()), this, this);
                }
            }
            catch (Exception e) {
                boolean bl = this.wasCancelled = e.getMessage() == com.sas.visuals.RB.getStringResource((String)"CommandProgress.cancelMessage.txt");
                if (this.wasCancelled) break block6;
                this.showException(e);
            }
        }
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public boolean wasExceptionThrown() {
        return this.exceptionThrown;
    }

    @Override
    public void customizerClosing() {
        this.disposeRemoteObjects();
        super.customizerClosing();
    }

    @Override
    public void setObject(Object bean) {
        super.setObject(bean);
        if (bean instanceof RemoteBaseClient) {
            this.initializeConnection((RemoteBaseClient)bean);
        }
    }

    private void showException(Exception e) {
        this.exceptionThrown = true;
        e.printStackTrace();
        MessageBox mb = new MessageBox(Util.getParentFrame(this), RB.getStringResource("exceptionDialogTitle.txt"), true, Message.format((String)RB.getStringResource("exceptionDialogText.txt"), (Object)e.getMessage()), 1, 1, 2);
        mb.centerOver(this);
        mb.setVisible(true);
    }

    class Connect
    implements ThreadedCommand {
        boolean _alternate;

        public Connect(boolean alternate) {
            this._alternate = alternate;
        }

        public void execute(Object o) {
            if (RemoteObjectCustomizerPanel.this.connectionUtility == null) {
                RemoteObjectCustomizerPanel.this.connectionUtility = new ConnectionUtility(this);
            }
            RemoteObjectCustomizerPanel.this.connectionUtility.setBusy(true);
            try {
                if (this._alternate) {
                    RemoteObjectCustomizerPanel.this.createAlternateRemoteObjects();
                } else {
                    RemoteObjectCustomizerPanel.this.createRemoteObjects();
                }
            }
            catch (Exception e) {
                RemoteObjectCustomizerPanel.this.showException(e);
                RemoteObjectCustomizerPanel.this.disposeRemoteObjects();
            }
            RemoteObjectCustomizerPanel.this.connectionUtility.setBusy(false);
        }

        public void interrupt() {
            RemoteObjectCustomizerPanel.this.wasCancelled = true;
            RemoteObjectCustomizerPanel.this.disposeRemoteObjects();
        }
    }
}

