/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver;

import com.sas.GlobalInfoTable;
import com.sas.ModelInterface;
import com.sas.awt.Label;
import com.sas.awt.ListBox;
import com.sas.awt.Panel;
import com.sas.collection.StringCollection;
import com.sas.models.NodeExpandedTextPredicate;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.RB;
import com.sas.sasserver.RemoteObjectSelectorDialog;
import com.sas.sasserver.metabaselist.MetabaseListInterface;
import com.sas.util.PredicateInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.EmptyComponent;
import com.sas.visuals.NodeView;
import com.sas.visuals.TreeView;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class MetabaseSelectorDialog
extends RemoteObjectSelectorDialog
implements ItemListener {
    public static final String RB_KEY = "MetabaseSelectorDialog.";
    protected MetabaseListInterface metabaseList;
    protected String sasFile;
    protected TreeView tree;
    protected ListBox databaseListBox;
    protected StringCollection databaseNames;
    protected String database;
    protected String metabase;
    protected String metabaseDescription;

    public MetabaseSelectorDialog(Frame parent, Component owner, Connection connection, Rocf rocf, String metabase, String database) {
        this(parent, owner, connection, true, rocf, metabase, database);
    }

    public MetabaseSelectorDialog(Frame parent, Component owner, Connection connection, boolean cloneConnection, Rocf rocf, String metabase, String database) {
        super(parent, owner, connection, cloneConnection, rocf, RB.getStringResource(RB_KEY, "dialogTitle.txt"));
        this.metabase = metabase == null || metabase.length() == 0 ? null : metabase;
        this.database = database == null || database.length() == 0 ? null : database;
        this.databaseNames = new StringCollection();
    }

    @Override
    protected void close() {
        this.database = this.databaseListBox.getSelectedItem();
        super.close();
    }

    @Override
    protected void createRemoteObjects() throws Exception {
        super.createRemoteObjects();
        this.metabaseList = (MetabaseListInterface)this.rocf.newInstance(GlobalInfoTable.loadClass((String)"com.sas.sasserver.metabaselist.MetabaseListInterface"), this.connection);
        if (this.metabaseList instanceof RemoteBaseClient) {
            this.registerRemoteBaseClient((RemoteBaseClient)((Object)this.metabaseList));
        }
    }

    @Override
    protected void disposeRemoteObjects() {
        this.metabaseList = null;
        super.disposeRemoteObjects();
    }

    @Override
    public void initialize() {
        super.initialize();
        Panel panel = this.getMainPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 2, 5, 5, true, true, true);
        layout.setRemainderColumn(1);
        layout.setRemainderRow(2);
        panel.setLayout((LayoutManager)layout);
        panel.setInsets(10, 10, 10, 10);
        Label label = new Label(RB.getStringResource(RB_KEY, "label.txt"));
        panel.add(label);
        panel.add(new EmptyComponent());
        this.tree = new TreeView();
        this.tree.initialize();
        this.tree.addItemListener(this);
        panel.add(this.tree);
        this.databaseListBox = new ListBox();
        this.databaseListBox.initialize();
        this.databaseListBox.setModelInterface((ModelInterface)this.databaseNames);
        panel.add(this.databaseListBox);
        if (!this.wasCancelled() && !this.wasExceptionThrown() && this.metabaseList != null) {
            this.tree.setModelInterface((ModelInterface)this.metabaseList);
            NodeView rNode = this.tree.getRoot();
            rNode.setExpanded(true);
            if (this.metabase != null) {
                NodeView node = this.tree.getNodeView((PredicateInterface)new NodeExpandedTextPredicate(this.metabase));
                if (node != null) {
                    node.setVisible();
                    node.setSelected(true);
                }
                this.databaseNames.removeAll();
                this.databaseNames.addItems(this.metabaseList.getDatabaseNames(this.metabase).getItems());
            }
            if (this.database != null) {
                this.databaseListBox.setSelectedItem(this.database);
            }
        }
    }

    public String getDatabase() {
        return this.database;
    }

    public String getDataSet() {
        return this.getDatabase();
    }

    private String getLibrary(String metabaseName) {
        int index = metabaseName.indexOf(46);
        if (index != -1) {
            return metabaseName.substring(0, index);
        }
        return null;
    }

    public String getMetabase() {
        return this.metabase;
    }

    private String getMetabase(String metabaseName) {
        int index = metabaseName.indexOf(46);
        if (index != -1) {
            return metabaseName.substring(index, metabaseName.length());
        }
        return null;
    }

    public String getMetabaseDescription() {
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            NodeView selNode = this.tree.getSelectedNode();
            if (selNode.getDepth() == 2) {
                this.metabase = selNode.getParent().getNodeText() + '.' + selNode.getNodeText();
                this.databaseNames.removeAll();
                this.databaseNames.addItems(this.metabaseList.getDatabaseNames(this.metabase).getItems());
            } else if (selNode.getDepth() == 1) {
                this.metabase = selNode.getNodeText();
                this.databaseNames.removeAll();
                this.databaseNames.addItems(this.metabaseList.getDatabaseNames(this.metabase).getItems());
            }
        }
    }
}

