/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver;

import com.sas.iom.SASGMS.IGMSAppl;
import com.sas.iom.SASGMS.IGMSApplHelper;
import com.sas.net.brg.orb.BrgOrb;
import com.sas.sasserver.IMDBException;
import com.sas.sasserver.RB;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public class IMDB {
    public transient IGMSAppl gms = null;
    private transient ORB orb = null;
    private static final String GMSid = "9C186A64-83E4-11D2-B956-00C04F81993C";
    static final String RB_KEY = "IMDB.";

    public void ServerConnect(String host, String port, String userName, String password) {
        Properties p = new Properties();
        p.put("host", host);
        p.put("port", port);
        p.put("userName", userName);
        p.put("password", password);
        String objRef = IMDB.propertiesToUrl(GMSid, p);
        this.orb = new BrgOrb();
        Object obj = this.orb.string_to_object(objRef);
        this.gms = IGMSApplHelper.narrow((Object)obj);
        if (this.gms == null || this.gms._non_existent()) {
            throw new IMDBException(RB.getStringResource(RB_KEY, "badServerConnect.ex.txt"));
        }
    }

    public void SetContext(String applicationContext) {
        this.gms.applicationContext(applicationContext);
    }

    public String DoRequest(String request) {
        String retStr = null;
        StringHolder s = new StringHolder();
        try {
            this.gms.DoRequest(request, s);
        }
        catch (Exception ex) {
            throw new IMDBException(RB.getStringResource(RB_KEY, "requestFailed.ex.txt"));
        }
        retStr = s.value;
        if (retStr.indexOf("ERROR") == 0) {
            throw new IMDBException(retStr);
        }
        return retStr;
    }

    public String[][] DoRequestToArray(String request, int numColumns) {
        String[][] retArray = null;
        if (numColumns < 0) {
            String[] colTitles = IMDB.getReturnVars(request);
            numColumns = colTitles.length;
        }
        StringHolder s = new StringHolder();
        try {
            this.gms.DoRequest(request, s);
        }
        catch (Exception ex) {
            throw new IMDBException(RB.getStringResource(RB_KEY, "requestFailed.ex.txt"));
        }
        String outstr = s.value;
        if (outstr.toUpperCase().indexOf("ERROR") == 0) {
            retArray = new String[1][1];
            retArray[0][0] = outstr;
            throw new IMDBException(outstr);
        }
        StringTokenizer t = new StringTokenizer(outstr, "^", true);
        int numRecs = t.countTokens();
        try {
            if (numRecs > 0) {
                numRecs = new Integer(t.nextToken().toString().trim());
            }
            retArray = new String[numRecs][numColumns];
            boolean skip = false;
            for (int i = 0; i < numRecs; ++i) {
                for (int j = 0; j < numColumns; ++j) {
                    if (!skip) {
                        t.nextToken();
                    }
                    retArray[i][j] = t.nextToken().toString().trim();
                    if (retArray[i][j].equals("^")) {
                        retArray[i][j] = "";
                        skip = true;
                        continue;
                    }
                    skip = false;
                }
            }
        }
        catch (NumberFormatException e) {
            retArray = new String[1][1];
            retArray[0][0] = outstr;
        }
        return retArray;
    }

    public String DoRequestToHTML(String request, String[] columnTitles) {
        String retHTML = "HTML goes here\n";
        int numCols = -1;
        if (columnTitles == null) {
            columnTitles = IMDB.getReturnVars(request);
        }
        numCols = columnTitles.length;
        String[][] retArray = this.DoRequestToArray(request, numCols);
        numCols = retArray[0].length;
        int numRecs = retArray.length;
        if (numRecs == 0) {
            retHTML = "ERROR from DoRequest<BR>\n";
        } else {
            int i;
            retHTML = "<BR>\n";
            retHTML = retHTML + "Number of Records: " + numRecs + " Number of Columns: " + numCols + "<BR><BR>\n";
            retHTML = retHTML + "<table border=\"2\">\n";
            retHTML = retHTML + "<tr>\n";
            for (i = 0; i < numCols; ++i) {
                retHTML = retHTML + "<td>" + columnTitles[i] + "</td>\n";
            }
            retHTML = retHTML + "</tr>\n";
            for (i = 0; i < numRecs; ++i) {
                retHTML = retHTML + "<tr>\n";
                for (int j = 0; j < numCols; ++j) {
                    retHTML = retHTML + "<td>" + retArray[i][j] + "</td>\n";
                }
                retHTML = retHTML + "</tr>\n";
            }
            retHTML = retHTML + "</table>\n";
        }
        return retHTML;
    }

    public void ServerDisconnect() {
        this.orb.shutdown(false);
    }

    public static String[] getReturnVars(String request) {
        String[] retCols = null;
        StringTokenizer t = null;
        int numColumns = 0;
        int curpos = request.toLowerCase().lastIndexOf("return");
        if (curpos > 0) {
            t = new StringTokenizer(request.substring(curpos + 6), "^");
            numColumns = t.countTokens();
        }
        retCols = new String[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            retCols[i] = t.nextToken().toString().trim();
        }
        return retCols;
    }

    public static String[] getReturnVars(String request, boolean returnColumnsOnly) {
        String[] retCols = IMDB.getReturnVars(request);
        if (returnColumnsOnly) {
            for (int i = 0; i < retCols.length; ++i) {
                String substr;
                int offset = retCols[i].indexOf(":");
                if (offset == -1) continue;
                retCols[i] = substr = retCols[i].substring(0, offset);
            }
        }
        return retCols;
    }

    protected static String propertiesToUrl(String id, Properties properties) {
        StringBuffer buffer = new StringBuffer("bridge://");
        buffer.append(properties.getProperty("host"));
        buffer.append(":");
        buffer.append(properties.getProperty("port"));
        buffer.append("/");
        buffer.append(id);
        StringBuffer query = null;
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            if (propertyName.equals("host") || propertyName.equals("port")) continue;
            if (query == null) {
                query = new StringBuffer();
            } else {
                query.append("&");
            }
            query.append(propertyName);
            query.append("=");
            query.append(properties.getProperty(propertyName));
        }
        if (query != null) {
            buffer.append("?");
            buffer.append(query.toString());
        }
        return buffer.toString();
    }
}

