/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver;

import com.sas.GlobalInfoTable;
import com.sas.ModelInterface;
import com.sas.awt.Label;
import com.sas.awt.ListBox;
import com.sas.awt.Panel;
import com.sas.awt.util.ChangeCursorCommand;
import com.sas.awt.util.Util;
import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.RB;
import com.sas.sasserver.RemoteObjectSelectorDialog;
import com.sas.sasserver.librarylist.LibraryListInterface;
import com.sas.sasserver.sasfilelist.CatalogListInterface;
import com.sas.util.ApplyInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class CatalogSelectorDialog
extends RemoteObjectSelectorDialog {
    static final String RB_KEY = "CatalogSelectorDialog.";
    protected LibraryListInterface libraryList;
    protected CatalogListInterface catalogList;
    protected ListBox libraryListBox;
    protected ListBox catalogListBox;
    protected String catalog;

    public void createComponents() {
        Panel panel = this.getMainPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 2);
        layout.setVgap(5);
        layout.setHgap(5);
        layout.setUseColumnRemainder(true);
        layout.setUseRowRemainder(true);
        panel.setLayout((LayoutManager)layout);
        panel.setInsets(new Insets(10, 10, 10, 10));
        Label libraryListBoxLabel = new Label(RB.getStringResource(RB_KEY, "libraryListBoxLabel.txt"));
        panel.add(libraryListBoxLabel);
        Label catalogListBoxLabel = new Label(RB.getStringResource(RB_KEY, "catalogListBoxLabel.txt"));
        panel.add(catalogListBoxLabel);
        this.libraryListBox = new ListBox();
        panel.add(this.libraryListBox);
        this.catalogListBox = new ListBox();
        panel.add(this.catalogListBox);
    }

    public CatalogSelectorDialog(Frame parent, Connection connection, Rocf rocf, String catalog) {
        this(parent, parent, connection, rocf, catalog);
    }

    public CatalogSelectorDialog(Frame parent, Component owner, Connection connection, Rocf rocf, String catalog) {
        this(parent, owner, connection, true, rocf, catalog);
    }

    public CatalogSelectorDialog(Frame parent, Component owner, Connection connection, boolean cloneConnection, Rocf rocf, String catalog) {
        super(parent, owner, connection, cloneConnection, rocf, RB.getStringResource(RB_KEY, "DialogTitle.txt"));
        this.catalog = catalog.toUpperCase();
        this.createComponents();
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.wasCancelled() && !this.wasExceptionThrown() && this.catalogList != null && this.libraryList != null) {
            this.libraryListBox.setModelInterface((ModelInterface)this.libraryList);
            this.catalogListBox.setModelInterface((ModelInterface)this.catalogList);
            int dotpos = this.catalog.indexOf(46);
            if (dotpos > 0) {
                String libraryName = this.catalog.substring(0, dotpos).toUpperCase();
                this.catalogList.setLibrary(libraryName);
            }
            this.libraryListBox.addLink("selectedItem", this.catalogList, "library");
            this.catalogListBox.setSelectedItem(this.catalog);
            this.libraryListBox.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getSource() == this.libraryListBox && evt.getPropertyName().equals("selectedItem")) {
            ChangeCursorCommand cmd = new ChangeCursorCommand(Cursor.getPredefinedCursor(3));
            Util.setEnabledOnContainer(this, false);
            Util.apply(this, (ApplyInterface)cmd);
            CatalogRun run = new CatalogRun(this, this.catalogList, this.libraryListBox, cmd);
            new Thread(run).start();
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    @Override
    protected void close() {
        this.catalog = this.catalogListBox.getSelectedItem();
        super.close();
    }

    @Override
    protected void cancel() {
        super.cancel();
    }

    @Override
    protected void createRemoteObjects() throws Exception {
        super.createRemoteObjects();
        this.libraryList = (LibraryListInterface)this.rocf.newInstance(GlobalInfoTable._loadClass((String)"com.sas.sasserver.librarylist.LibraryListInterface"), this.connection);
        if (this.libraryList instanceof RemoteBaseClient) {
            this.registerRemoteBaseClient((RemoteBaseClient)((Object)this.libraryList));
        }
        this.catalogList = (CatalogListInterface)this.rocf.newInstance(GlobalInfoTable._loadClass((String)"com.sas.sasserver.sasfilelist.CatalogListInterface"), this.connection);
        if (this.catalogList instanceof RemoteBaseClient) {
            this.registerRemoteBaseClient((RemoteBaseClient)((Object)this.catalogList));
        }
    }

    @Override
    protected void disposeRemoteObjects() {
        this.libraryList = null;
        this.catalogList = null;
        super.disposeRemoteObjects();
    }

    class CatalogRun
    implements Runnable {
        CatalogListInterface catalogList;
        ListBox libraryListBox;
        Container container;
        ChangeCursorCommand cmd;

        CatalogRun(Container cont, CatalogListInterface cList, ListBox listBox, ChangeCursorCommand command) {
            this.container = cont;
            this.catalogList = cList;
            this.libraryListBox = listBox;
            this.cmd = command;
        }

        @Override
        public void run() {
            this.catalogList.setLibrary(this.libraryListBox.getSelectedItem());
            Util.setEnabledOnContainer(this.container, true);
            this.cmd.undoAll();
        }
    }
}

