/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.util.Classes;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.Remote;

public class ValEjb {
    public static void main(String[] args) {
        new ValEjb().doit(args);
    }

    void doit(String[] args) {
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                ValEjb.validate(args[i]);
            }
        } else {
            System.out.println("Usage: " + this.getClass().getName() + " class");
        }
    }

    public static boolean validate(String clsName) {
        boolean valid = true;
        Class<?> cls = null;
        Object obj = null;
        try {
            cls = Class.forName(clsName);
            obj = cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.println(clsName + ":" + e);
        }
        catch (IllegalAccessException e) {
            System.err.println(clsName + ":" + e);
        }
        catch (InstantiationException e) {
            // empty catch block
        }
        Method[] methods = cls.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?> ret = method.getReturnType();
            Class<?>[] parms = method.getParameterTypes();
            Class<?>[] exceps = method.getExceptionTypes();
            if (!ValEjb.ival(ret)) {
                valid = false;
                System.out.println("Class: " + clsName + " Method:" + method.getName() + " Invalid return type: " + ret.getName());
            }
            for (int j = 0; j < parms.length; ++j) {
                Class<?> parm = parms[j];
                if (ValEjb.ival(parm)) continue;
                valid = false;
                System.out.println("Class: " + clsName + " Method:" + method.getName() + " Invalid parameter type: " + parm.getName());
            }
            boolean foundrem = false;
            for (int j = 0; !foundrem && j < exceps.length; ++j) {
                Class<?> excep = exceps[j];
                foundrem = excep.getName().equals("java.rmi.RemoteException");
            }
            if (foundrem) continue;
            valid = false;
            System.out.println("Class: " + clsName + " Method:" + method.getName() + " missing throws java.rmi.RemoteException");
        }
        return valid;
    }

    public static boolean ival(Class c) {
        return c.isPrimitive() || c.isArray() && ValEjb.ival(c.getComponentType()) || Classes.implementsInterface((Class)c, Remote.class) || Classes.implementsInterface((Class)c, Serializable.class);
    }
}

