/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorBaseTarget;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.ProxyName;
import com.sas.rmi.Template;
import com.sas.rmi.UTCServerTemplate;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class UTCServerTarget
extends CodeGeneratorBaseTarget {
    int m_ordinal = 0;

    @Override
    public String getGeneratorName() {
        return "UTC_Server";
    }

    @Override
    public Template getTemplate() {
        return new UTCServerTemplate();
    }

    @Override
    public String getTargetName(String sourceName) {
        ProxyName pn = new ProxyName();
        pn.setAccessMethod("UTC");
        pn.setClassName(sourceName);
        return pn.getServerProxyName();
    }

    @Override
    public void generateMethodCode(Class source, Method method, CodeGeneratorOutputStream out) throws Exception {
        int modifier = method.getModifiers();
        if (!Modifier.isPublic(modifier) || Modifier.isFinal(modifier)) {
            return;
        }
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        out.println("");
        out.println("// " + method.getName(), 3);
        out.println("case " + this.m_ordinal + ":", 3);
        Class<?>[] params = method.getParameterTypes();
        String p = "";
        for (int j = 0; j < params.length; ++j) {
            String s = CodeGenerator.convertType(params[j].getName());
            if (p.length() > 0) {
                p = p + ", ";
            }
            String argName = "p" + this.m_ordinal + "_" + (j + 1);
            p = p + argName;
            if (s.equals("boolean")) {
                out.println("Boolean " + argName + "temp = (Boolean) in.readObject();", 4);
                out.println("boolean " + argName + " = " + argName + "temp.booleanValue();", 4);
                continue;
            }
            if (s.equals("byte")) {
                out.println("Byte " + argName + "temp = (Byte) in.readObject();", 4);
                out.println("byte " + argName + " = " + argName + "temp.byteValue();", 4);
                continue;
            }
            if (s.equals("char")) {
                out.println("Character " + argName + "temp = (Character) in.readObject();", 4);
                out.println("char " + argName + " = " + argName + "temp.charValue();", 4);
                continue;
            }
            if (s.equals("short")) {
                out.println("Short " + argName + "temp = (Short) in.readObject();", 4);
                out.println("short " + argName + " = " + argName + "temp.shortValue();", 4);
                continue;
            }
            if (s.equals("int")) {
                out.println("Integer " + argName + "temp = (Integer) in.readObject();", 4);
                out.println("int " + argName + " = " + argName + "temp.intValue();", 4);
                continue;
            }
            if (s.equals("long")) {
                out.println("Long " + argName + "temp = (Long) in.readObject();", 4);
                out.println("long " + argName + " = " + argName + "temp.longValue();", 4);
                continue;
            }
            if (s.equals("float")) {
                out.println("Float " + argName + "temp = (Float) in.readObject();", 4);
                out.println("float " + argName + " = " + argName + "temp.floatValue();", 4);
                continue;
            }
            if (s.equals("double")) {
                out.println("Double " + argName + "temp = (Double) in.readObject();", 4);
                out.println("double " + argName + " = " + argName + "temp.doubleValue();", 4);
                continue;
            }
            out.println(s + " " + argName + " = (" + s + ") in.readObject();", 4);
        }
        if (ret.equals("void")) {
            out.println("_target." + method.getName() + "(" + p + ");", 4);
            out.println("out.writeInt(ordinal);", 4);
        } else {
            String varName = "returnValue" + this.m_ordinal;
            out.println(ret + " " + varName + " = _target." + method.getName() + "(" + p + ");", 4);
            out.println("out.writeInt(ordinal);", 4);
            if (ret.equals("boolean")) {
                out.println("out.writeObject(new Boolean(" + varName + "));", 4);
            } else if (ret.equals("byte")) {
                out.println("out.writeObject(new Byte(" + varName + "));", 4);
            } else if (ret.equals("char")) {
                out.println("out.writeObject(new Character(" + varName + "));", 4);
            } else if (ret.equals("short")) {
                out.println("out.writeObject(new Short(" + varName + "));", 4);
            } else if (ret.equals("int")) {
                out.println("out.writeObject(new Integer(" + varName + "));", 4);
            } else if (ret.equals("long")) {
                out.println("out.writeObject(new Long(" + varName + "));", 4);
            } else if (ret.equals("float")) {
                out.println("out.writeObject(new Float(" + varName + "));", 4);
            } else if (ret.equals("double")) {
                out.println("out.writeObject(new Double(" + varName + "));", 4);
            } else {
                out.println("out.writeObject(" + varName + ");", 4);
            }
        }
        out.println("break;", 4);
        ++this.m_ordinal;
    }

    @Override
    public boolean implementationMustExist() {
        return false;
    }

    @Override
    public boolean generatesServerCode() {
        return true;
    }
}

