/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.security.BaseSecuritySupport;
import com.sas.util.TimedOutException;

public class TimeoutDriver {
    private transient boolean started;
    private transient boolean finished;

    public synchronized void timeout(long timeout, Runnable runner) throws TimedOutException {
        TimeoutRunner run2 = new TimeoutRunner(runner, this);
        Thread t = BaseSecuritySupport.securitySupport.createThread((Runnable)run2);
        t.setDaemon(true);
        t.start();
        try {
            if (!this.isStarted()) {
                this.wait();
            }
            if (!this.isFinished()) {
                this.wait(timeout);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.isFinished()) {
            throw new TimedOutException();
        }
    }

    public synchronized void setStarted(boolean started) {
        this.started = started;
        this.notifyAll();
    }

    public synchronized void setFinished(boolean finished) {
        this.finished = finished;
        this.notifyAll();
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isFinished() {
        return this.finished;
    }

    class TimeoutRunner
    implements Runnable {
        Runnable runner;
        TimeoutDriver td;

        TimeoutRunner(Runnable runner, TimeoutDriver td) {
            this.runner = runner;
            this.td = td;
        }

        @Override
        public void run() {
            this.td.setStarted(true);
            this.runner.run();
            this.td.setFinished(true);
        }
    }
}

