/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.QueueKey;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SingleThreadedQueue {
    private transient LinkedList ll = new LinkedList();
    private transient long count;
    private transient boolean printQueue;
    private transient boolean failAll;
    private transient String name;
    private transient boolean skipWait;
    private static final boolean WAITNOTIFYALGORITHM = true;

    public SingleThreadedQueue() {
        this("Queue", false);
    }

    public SingleThreadedQueue(String s) {
        this(s, false);
    }

    public SingleThreadedQueue(String s, boolean skipWait) {
        this.setQueueName(s);
        this.setSkipWait(skipWait);
    }

    public boolean isSkipWait() {
        return this.skipWait;
    }

    public void setSkipWait(boolean sw) {
        this.skipWait = sw;
    }

    public void setPrintQueue(boolean b) {
        this.printQueue = b;
    }

    public void setQueueName(String s) {
        this.name = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getQueue() {
        LinkedList linkedList = this.ll;
        synchronized (linkedList) {
            return (List)this.ll.clone();
        }
    }

    public int size() {
        return this.ll.size();
    }

    public QueueKey topKey() {
        return this.firstKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueKey pushLastKey(Object caller, String callerInfo) {
        LinkedList linkedList = this.ll;
        synchronized (linkedList) {
            QueueKey newKey = new QueueKey(++this.count, caller, callerInfo);
            this.ll.addLast(newKey);
            return newKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueKey firstKey() {
        LinkedList linkedList = this.ll;
        synchronized (linkedList) {
            return (QueueKey)this.ll.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueKey popFirstKey() {
        LinkedList linkedList = this.ll;
        synchronized (linkedList) {
            return (QueueKey)this.ll.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeKey(QueueKey key) {
        LinkedList linkedList = this.ll;
        synchronized (linkedList) {
            this.ll.remove(key);
        }
    }

    private long msecs() {
        return System.currentTimeMillis();
    }

    public Object acquire(Object caller, String callerInfo) {
        QueueKey qk = this.pushLastKey(caller, callerInfo);
        this.p("Acquire", qk);
        return qk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void p(String s, QueueKey qk) {
        if (this.printQueue) {
            System.out.println(this.name + "[Hash=" + this.hashCode() + "] (" + s + ") {");
            LinkedList linkedList = this.ll;
            synchronized (linkedList) {
                Iterator iterator = this.ll.iterator();
                while (iterator.hasNext()) {
                    System.out.println("       " + iterator.next());
                }
                System.out.println("      }");
            }
        }
    }

    public synchronized boolean enter(Object omyKey, long timeOut) throws InterruptedException {
        QueueKey myKey = (QueueKey)omyKey;
        myKey.start = this.msecs();
        if (!this.skipWait) {
            if (this.size() > 1 && myKey.thread == this.firstKey().thread) {
                myKey.nested = true;
            } else {
                while (this.size() > 0 && !this.firstKey().equals(myKey)) {
                    try {
                        this.wait(timeOut);
                        long waitTime = this.msecs() - myKey.start;
                        if (waitTime < timeOut) continue;
                        System.out.println("STQ Timeout: waitTime=" + waitTime + " timeOut=" + timeOut);
                        this.p("Timeout", myKey);
                        this.removeKey(myKey);
                        return false;
                    }
                    catch (InterruptedException ie) {
                        this.p("Interrupt", myKey);
                        this.removeKey(myKey);
                        throw ie;
                    }
                }
            }
        }
        if (this.failAll) {
            this.p("Fail", myKey);
            this.removeKey(myKey);
            return false;
        }
        myKey.enter = this.msecs();
        this.p("Enter", myKey);
        return true;
    }

    public synchronized void exit(Object okey) {
        QueueKey qk = (QueueKey)okey;
        if (qk != null) {
            if (qk.enter > 0L) {
                qk.exit = this.msecs();
                this.p("Exit", qk);
                if (qk.nested) {
                    if (this.size() > 0) {
                        this.removeKey(qk);
                    }
                } else if (this.size() == 0 || !this.firstKey().equals(qk)) {
                    this.fpq(qk, "NOTE: STQ: out of order exit");
                    if (this.size() > 0) {
                        this.removeKey(qk);
                    }
                } else {
                    this.popFirstKey();
                }
            } else {
                this.p("Exit", qk);
                this.fpq(qk, "NOTE: STQ: intentional out of order exit on aborted op");
                if (this.size() > 0) {
                    this.removeKey(qk);
                }
            }
        }
        if (!this.skipWait) {
            this.notifyAll();
        }
    }

    void fpq(QueueKey qk, String errMsg) {
        boolean opq = this.printQueue;
        this.printQueue = true;
        this.p(errMsg, qk);
        this.printQueue = opq;
        System.err.println(errMsg);
        Thread.dumpStack();
    }

    public synchronized void setFailAll(boolean b) {
        this.failAll = b;
        if (!this.skipWait) {
            this.notifyAll();
        }
    }

    public boolean isFailAll() {
        return this.failAll;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

