/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseInterface;
import com.sas.rmi.RocfClass;
import com.sas.rmi.RocfORBInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public class RocfServer {
    protected transient RocfORBInterface m_orb;
    private transient boolean m_debug;

    public static void main(String[] args) {
        RocfServer rs = new RocfServer();
        boolean started = rs.process(args);
        if (!started) {
            System.exit(1);
        }
    }

    public boolean process(String[] args) {
        return this.process(args, null);
    }

    public boolean process(String[] args, RocfORBInterface rocfORB) {
        RemoteBaseInterface mObject = null;
        if (args.length == 0 || this.argExists(args, "-?")) {
            this.displayHelp();
            return false;
        }
        this.m_debug = this.argExists(args, "-d");
        int classPtr = this.findClassName(args);
        if (classPtr == -1) {
            System.out.println("\nClass to load must be given. Use -? for help.");
            return false;
        }
        String[] myArgs = new String[classPtr];
        for (int i = 0; i < classPtr; ++i) {
            myArgs[i] = args[i];
        }
        String accessMethod = this.getArg(myArgs, "-a");
        if (accessMethod == null) {
            accessMethod = Connection.ACCESS_METHOD_RMI;
        }
        this._getFunnelOrb();
        Connection ctxt = new Connection();
        ctxt.setAccessMethod(Connection.ACCESS_METHOD_RMI);
        String serverObjectName = args[classPtr];
        if (mObject == null) {
            throw new RuntimeException(this.getClass().getName() + "::Cannot create " + serverObjectName);
        }
        int n = args.length - classPtr - 1;
        String[] serverArgs = new String[n];
        this._p("n=" + n);
        for (int i = 0; i < n; ++i) {
            serverArgs[i] = args[classPtr + i + 1];
            this._p("serverArgs[" + i + "] = " + serverArgs[i]);
        }
        this._p("Got a handle to " + mObject);
        try {
            this._p("Create delegate");
            mObject._RemoteObject_newInstance();
            this._p("Call main(" + serverArgs + ") on delegate");
            mObject._RemoteObject_main(serverArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void _p(String s) {
        if (this.m_debug) {
            System.out.println(s);
        }
    }

    private boolean invokeMain(Class c, String[] args) {
        System.out.println("invoke main");
        boolean rc = false;
        String methodName = "main";
        Method m = null;
        try {
            Class[] params = new Class[]{args.getClass()};
            m = c.getDeclaredMethod(methodName, params);
        }
        catch (NoSuchMethodException ex) {
            System.out.println("\n'" + methodName + "' method not found for " + c.getName());
        }
        catch (SecurityException ex) {
            System.out.println("\nSecurity exception for " + c.getName());
            System.out.println("Error: " + ex.getMessage());
        }
        if (m != null) {
            System.out.println("Starting " + c.getName());
            Object[] a = new Object[]{args};
            try {
                m.invoke((Object)c, a);
                rc = true;
            }
            catch (InvocationTargetException ex) {
                System.out.println("\n'" + methodName + "' for " + c.getName() + " threw exception: ");
                ex.getTargetException().printStackTrace();
            }
            catch (Exception ex) {
                System.out.println("\nError invoking '" + methodName + "' for " + c.getName());
                System.out.println("Error: " + ex.getMessage());
            }
        }
        System.out.println("rc=" + rc);
        return rc;
    }

    private boolean setORB(Class c, RocfORBInterface rocfORB) {
        boolean rc = false;
        String methodName = "_RemoteObject_setORB";
        Method m = null;
        try {
            Class[] params = new Class[1];
            System.out.println("" + rocfORB.getClass());
            params[0] = RocfClass.forName("com.sas.rmi.RocfORBInterface");
            m = c.getMethod(methodName, params);
        }
        catch (NoSuchMethodException ex) {
            System.out.println("\n'" + methodName + "' method not found for " + c.getName());
        }
        catch (SecurityException ex) {
            System.out.println("\nSecurity exception for " + c.getName());
            System.out.println("Error: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (m != null) {
            System.out.println("Setting the ROCF ORB on " + c.getName());
            Object[] a = new Object[]{rocfORB};
            try {
                m.invoke((Object)c, a);
                rc = true;
            }
            catch (InvocationTargetException ex) {
                System.out.println("\n'" + methodName + "' for " + c.getName() + " threw exception: ");
                ex.getTargetException().printStackTrace();
            }
            catch (Exception ex) {
                System.out.println("\nError invoking '" + methodName + "' for " + c.getName());
                System.out.println("Error: " + ex.getMessage());
            }
        }
        return rc;
    }

    private Class find(String name) {
        Class c = null;
        try {
            c = RocfClass.forName(name);
        }
        catch (ClassNotFoundException ex) {
            System.out.println("\nClass not found: " + name);
        }
        return c;
    }

    private int findClassName(String[] args) {
        int index = -1;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) continue;
            index = i;
            break;
        }
        return index;
    }

    private String getArg(String[] args, String s) {
        String arg = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith(s)) continue;
            arg = args[i].substring(s.length());
            if (arg.length() != 0) break;
            arg = null;
            break;
        }
        return arg;
    }

    private boolean argExists(String[] args, String s) {
        boolean rc = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith(s)) continue;
            rc = true;
            break;
        }
        return rc;
    }

    private void displayHelp() {
        System.out.println("\nRocfServer - ROCF Server Object Factory\n");
        System.out.println("Usage: RocfServer [args] <className> [classArgs]\n");
        System.out.println("Args:  -a<access method> {RMI, VISIBROKER}");
    }

    private Object _getFunnelOrb() {
        if (this.m_orb == null) {
            String fHost = this.getFunnelHost();
            String errmsgPrefix = this.getClass().getName() + "::host(" + fHost + ")::";
            RocfORBInterface orb = null;
            try {
                String orbName = "//" + fHost + "/RocfORB";
                orb = (RocfORBInterface)Naming.lookup(orbName);
            }
            catch (RemoteException re) {
                throw new RuntimeException(errmsgPrefix + "RMIRegistry service not started");
            }
            catch (NotBoundException e) {
                throw new RuntimeException(errmsgPrefix + "RocfORB not started");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(errmsgPrefix + e.toString());
            }
            this._setFunnelOrb(orb);
        }
        return this.m_orb;
    }

    private String getFunnelHost() {
        return "localhost";
    }

    public void _setFunnelOrb(Object orb) {
        this.m_orb = (RocfORBInterface)orb;
    }
}

