/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.ClientNotifyInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.QueueKey;
import com.sas.rmi.RocfORB;
import com.sas.rmi.RocfORBClient;
import com.sas.rmi.RocfORBMachine;
import com.sas.rmi.RocfORBResPool;
import com.sas.rmi.RocfORBSession;
import com.sas.rmi.RocfORBTree;
import com.sas.rmi.TerminatedServerException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimerTask;
import java.util.Vector;

public class RocfORBRefCnt {
    private transient Hashtable ht = new Hashtable();
    private transient RocfORB orb;
    private transient Object vdObj = new Object();
    private transient boolean active;

    RocfORBRefCnt(RocfORB orb) {
        this.orb = orb;
    }

    synchronized void addref(Object clientCallback, RocfORBTree deepestNode) {
        this.ht.put(clientCallback, deepestNode);
    }

    synchronized void release(Object clientCallback) {
        RocfORBTree deepestNode = (RocfORBTree)this.ht.get(clientCallback);
        if (deepestNode != null) {
            this.ht.remove(clientCallback);
            this.orb.getTimer().schedule((TimerTask)new Deleter(deepestNode), 0L);
        }
    }

    void spawnDelete(final RocfORBTree tree) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RocfORBRefCnt.this.internalDelete(tree);
            }
        }).start();
    }

    void internalDelete(RocfORBTree t) {
        try {
            t._RemoteObject_remove();
        }
        catch (RemoteException e) {
            System.out.println("Handling following removal error:");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Handling following removal error:");
            e.printStackTrace();
        }
    }

    synchronized void moveref(Object clientCallback, RocfORBTree deepestNode) {
        boolean preload;
        boolean bl = preload = !(clientCallback instanceof ClientNotifyInterface);
        if (this.ht.get(clientCallback) == null) {
            System.out.println("WARNING: Delete during create, just add/deref bottom node:");
        } else {
            this.addref(clientCallback, deepestNode);
        }
    }

    boolean releasedClient(Object clientCallback) {
        return this.ht.get(clientCallback) == null;
    }

    Object getClientLoc(Object clientCallback) {
        return this.ht.get(clientCallback);
    }

    void qrelease(Object clientCallback) {
        RocfORBTree deepestNode = (RocfORBTree)this.ht.get(clientCallback);
        this.ht.remove(clientCallback);
    }

    void validate(Object treeNode, Object clientCallback) throws RemoteException {
        Object object = this.vdObj;
        synchronized (object) {
            RocfORBTree myTree = (RocfORBTree)treeNode;
            RocfORBTree clientTree = (RocfORBTree)this.ht.get(clientCallback);
            if (myTree == null || clientTree == null) {
                throw new TerminatedServerException();
            }
            if (myTree == clientTree) {
                return;
            }
            RocfORBTree tclientTree = clientTree;
            while (tclientTree != null) {
                if (myTree != (tclientTree = tclientTree._Rocf_getParent())) continue;
                return;
            }
            System.out.println("Reference Count validation error");
            System.out.println("clientCallback=" + clientCallback.hashCode());
            System.out.println("myTree=" + myTree.hashCode());
            System.out.println("clientTree:");
            this.treeprint("Client Tree", clientTree);
            this.treeprint("Request Tree", myTree);
            throw new RemoteException();
        }
    }

    void treeprint(String s, RocfORBTree tree) {
        System.out.println(s);
        if (tree == null) {
            System.out.println("   null");
        } else {
            while (tree != null) {
                System.out.println("   " + tree.getClass().getName() + " Hash=" + tree.hashCode() + " Pending=" + tree._r_pending() + " Children=" + tree._Rocf_numKids());
                tree = tree._Rocf_getParent();
            }
        }
    }

    private void p(String timeStamp) {
        System.out.println(timeStamp);
        Enumeration keys = this.ht.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            String keystr = key == null ? "null" : "" + key.hashCode();
            Object val = this.ht.get(key);
            String valstr = val == null ? "null" : "" + val.hashCode();
            System.out.println(" Client=" + keystr + " DeepestNode=" + valstr);
        }
    }

    void deadClientCheck(RocfORB orb) {
        if (this.active) {
            return;
        }
        this.active = true;
        int actClient = 0;
        int pendCalls = orb._r_getSTQ().size();
        Vector<RocfORBClient> dv = new Vector<RocfORBClient>();
        Vector<RocfORBSession> dvs = new Vector<RocfORBSession>();
        Vector<RocfORBSession> dvq = new Vector<RocfORBSession>();
        Collection cval = this.ht.values();
        int nr = orb.getResPoolCount();
        for (int ir = 0; ir < nr; ++ir) {
            RocfORBResPool _respool = orb.getResPool(ir);
            int nm = _respool.getMachineCount();
            for (int im = 0; im < nm; ++im) {
                RocfORBMachine _machine = _respool.getMachine(im);
                int ns = _machine.getSessionCount();
                for (int is = 0; is < ns; ++is) {
                    RocfORBSession _session = _machine.getSession(is);
                    Connection ctxt = _session.getConnection();
                    if (ctxt == null) continue;
                    long ignoreTime = ctxt.getIgnoreBlockedServerTimeout();
                    long warnTime = ctxt.getWarnBlockedServerTimeout();
                    int squeue = _session._r_getSTQ().size();
                    int spend = _session._r_pending();
                    if (squeue > 0) {
                        QueueKey qk = _session._r_getSTQ().topKey();
                        if (qk.enter > 0L && qk.exit <= 0L) {
                            long runt = System.currentTimeMillis() - qk.enter;
                            if (runt > warnTime * 1000L) {
                                String msg = "WARNING: Possible server crash, long running method detected runtime=" + runt + "ms";
                                System.out.println(msg);
                            }
                            if (runt > ignoreTime * 1000L) {
                                dvq.addElement(_session);
                            }
                        }
                    }
                    if (spend > 0 && !cval.contains(_session)) {
                        _session._r_clearpending();
                        spend = 0;
                    }
                    int nc = _session.getClientCount();
                    if (nc > 0) {
                        for (int ic = 0; ic < nc; ++ic) {
                            RocfORBClient _client = _session.getClient(ic);
                            if (!cval.contains(_client) && squeue < 1 && spend < 1) {
                                dv.addElement(_client);
                                continue;
                            }
                            ++actClient;
                        }
                        continue;
                    }
                    if (squeue >= 1 || spend >= 1) continue;
                    dvs.addElement(_session);
                }
            }
        }
        if (pendCalls <= 1) {
            int i;
            int n = dv.size();
            for (i = 0; i < n; ++i) {
                RocfORBClient deadClient = (RocfORBClient)dv.elementAt(i);
                this.spawnDelete(deadClient);
            }
            n = dvs.size();
            for (i = 0; i < n; ++i) {
                RocfORBSession deadSession = (RocfORBSession)dvs.elementAt(i);
                this.spawnDelete(deadSession);
            }
            n = dvq.size();
            for (i = 0; i < n; ++i) {
                RocfORBSession slowSession = (RocfORBSession)dvq.elementAt(i);
                System.out.println("WARNING: Quick session prune");
                try {
                    slowSession.getMachine()._Rocf_removeChild(slowSession);
                    Object clientCallback = new Object();
                    int countRestarts = slowSession.resetRestarts();
                    slowSession.spawnRestart(countRestarts, clientCallback);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.active = false;
    }

    private void kids(String s, RocfORBTree t) {
        System.out.println(s);
        if (t != null) {
            System.out.println(t.getClass().getName() + "." + t.hashCode());
            int n = t._Rocf_numKids();
            for (int i = 0; i < n; ++i) {
                Object o = t._Rocf_getKid(i);
                System.out.println(i + ":" + o.getClass().getName() + "." + o.hashCode());
            }
        }
    }

    class Deleter
    extends TimerTask {
        private transient RocfORBTree deepestNode;

        Deleter(RocfORBTree deepestNode) {
            this.deepestNode = deepestNode;
        }

        @Override
        public void run() {
            RocfORBRefCnt.this.internalDelete(this.deepestNode);
        }
    }
}

