/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.RMIUtil;
import com.sas.rmi.RocfORB;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class RocfORBProperties {
    private transient Properties m_props = new Properties();
    private transient RocfORB m_rocf;
    private static final int DEFAULT_CLIENT_TIMEOUT = 43200;
    private static final int DEFAULT_HTML_FILE_REFRESH = 30;
    private static final int DEFAULT_HTML_SERVER_REFRESH = 30;
    private static final String DEFAULT_FUNNEL_CONFIG = "funnel.cfg";
    private static final String LOCALHOST = "localhost";
    private static final int DEFAULT_PINGINTERVALSECONDS = 60;
    private static final int DEFAULT_QUEUEWAITTIMEOUT = 301;
    private static final int KV_KEY = 0;
    private static final int KV_DEFAULT = 1;
    private static final int KV_CMDKEY = 2;
    private static final int KV_TYPE = 3;
    private static String[][] kv = new String[][]{{"adminHosts", null, null, "string"}, {"clientTimeout", "43200", "-c", "secs"}, {"connectionTimeout", "0", "-t", "secs"}, {"hostName", RMIUtil.getLocalHost(), "-h", "host"}, {"initialDelay", "0", "-d", "secs"}, {"orbName", null, null, "string"}, {"outputFile", null, null, "string"}, {"port", "1099", "-p", "int"}, {"profileProcessor", "com.sas.rmi.RocfORBProfileProcessor", "-o", "class"}, {"propertyFilename", "RocfORB.properties", "-f", "string"}, {"rolloverDatabase", "funnel.cfg", null, "string"}, {"rolloverType", "0", "-r", "int"}, {"synchLog", "0", "-s", "boolean"}, {"verbose", "0", "-v", "boolean"}, {"inetAddress", null, null, "string"}, {"htmlFile", null, "-l", "string"}, {"htmlFileRefresh", "30", null, "int"}, {"htmlServerRefresh", "30", null, "int"}, {"pingIntervalSeconds", "60", null, "int"}, {"queueWaitTimeout", "301", null, "int"}};

    protected void setDefaults(RocfORB rocf) {
        this.m_rocf = rocf;
        for (int idx = 0; idx < kv.length; ++idx) {
            this.putProp(kv[idx][0], kv[idx][1]);
        }
    }

    protected void processCommandLine(String[] args) {
        block0: for (int idx = 0; idx < kv.length; ++idx) {
            String key;
            String cmdKey = kv[idx][2];
            if (null == cmdKey || null == (key = kv[idx][0])) continue;
            String type = kv[idx][3];
            String val = this.getStringProp(key);
            if (type.equals("string")) {
                this.putProp(key, this.getArg(args, cmdKey, val));
                continue;
            }
            if (type.equals("secs")) {
                this.putProp(key, String.valueOf(this.getIntArg(args, cmdKey, Integer.parseInt(val))));
                continue;
            }
            if (type.equals("int")) {
                this.putProp(key, String.valueOf(this.getIntArg(args, cmdKey, Integer.parseInt(val))));
                continue;
            }
            if (type.equals("class")) {
                this.putProp(key, this.getArg(args, cmdKey, val));
                continue;
            }
            if (type.equals("host")) {
                String host = this.getArg(args, cmdKey, val);
                if (host.equalsIgnoreCase(LOCALHOST)) {
                    host = RMIUtil.getLocalHost();
                }
                this.putProp(key, host);
                continue;
            }
            if (type.equals("boolean")) {
                if (null == args) continue;
                for (int jdx = 0; jdx < args.length; ++jdx) {
                    if (!args[jdx].startsWith(cmdKey)) continue;
                    this.putProp(key, "1");
                    continue block0;
                }
                continue;
            }
            System.err.println("ERROR: unknown command type: " + type);
        }
    }

    protected void setPropertyFilename(String s) {
        this.putProp("propertyFilename", s);
    }

    protected String getPropertyFilename() {
        return this.getStringProp("propertyFilename");
    }

    protected void setHostName(String s) {
        this.putProp("hostName", s);
    }

    protected String getHostName() {
        return this.getStringProp("hostName");
    }

    protected void setPort(String s) {
        this.putProp("port", s);
    }

    protected void setPort(int n) {
        this.putProp("port", String.valueOf(n));
    }

    protected int getPort() {
        return this.getIntegerProp("port");
    }

    protected void setOrbName(String s) {
        this.putProp("orbName", s);
    }

    protected String getOrbName() {
        return this.getStringProp("orbName");
    }

    protected void setInitialDelay(String s) {
        this.putProp("initialDelay", s);
    }

    protected void setInitialDelay(int n) {
        this.putProp("initialDelay", String.valueOf(n));
    }

    protected int getInitialDelay() {
        return this.getIntegerProp("initialDelay");
    }

    protected void setConnectionTimeout(String s) {
        this.putProp("connectionTimeout", s);
    }

    protected void setConnectionTimeout(int n) {
        this.putProp("connectionTimeout", String.valueOf(n));
    }

    protected int getConnectionTimeout() {
        return this.getIntegerProp("connectionTimeout");
    }

    protected int getConnectionTimeoutMss() {
        return this.getIntegerProp("connectionTimeout") * 1000;
    }

    protected void setClientTimeout(String s) {
        this.putProp("clientTimeout", s);
    }

    protected void setClientTimeout(int n) {
        this.putProp("clientTimeout", String.valueOf(n));
    }

    protected int getClientTimeout() {
        return this.getIntegerProp("clientTimeout");
    }

    protected int getClientTimeoutMss() {
        return this.getIntegerProp("clientTimeout") * 1000;
    }

    protected void setProfileProcessor(String s) {
        this.putProp("profileProcessor", s);
    }

    protected String getProfileProcessor() {
        return this.getStringProp("profileProcessor");
    }

    protected void setRolloverDatabase(String s) {
        this.putProp("rolloverDatabase", s);
    }

    protected String getRolloverDatabase() {
        return this.getStringProp("rolloverDatabase");
    }

    protected void setInetAddress(String s) {
        this.putProp("inetAddress", s);
    }

    protected String getInetAddress() {
        return this.getStringProp("inetAddress");
    }

    protected void setRolloverType(String s) {
        this.putProp("rolloverType", s);
    }

    protected void setRolloverType(int n) {
        this.putProp("rolloverType", String.valueOf(n));
    }

    protected int getRolloverType() {
        return this.getIntegerProp("rolloverType");
    }

    protected void setAdminHosts(String s) {
        this.putProp("adminHosts", s);
    }

    protected String getAdminHosts() {
        return this.getStringProp("adminHosts");
    }

    protected void setOutputFile(String s) {
        this.putProp("outputFile", s);
    }

    protected String getOutputFile() {
        return this.getStringProp("outputFile");
    }

    protected void setHtmlFile(String s) {
        this.putProp("htmlFile", s);
    }

    protected String getHtmlFile() {
        return this.getStringProp("htmlFile");
    }

    protected void setHtmlFileRefresh(String s) {
        this.putProp("htmlFileRefresh", s);
    }

    protected void setHtmlFileRefresh(int n) {
        this.putProp("htmlFileRefresh", String.valueOf(n));
    }

    protected int getHtmlFileRefresh() {
        return this.getIntegerProp("htmlFileRefresh");
    }

    protected void setHtmlServerRefresh(String s) {
        this.putProp("htmlServerRefresh", s);
    }

    protected void setHtmlServerRefresh(int n) {
        this.putProp("htmlServerRefresh", String.valueOf(n));
    }

    protected int getHtmlServerRefresh() {
        return this.getIntegerProp("htmlServerRefresh");
    }

    protected void setVerbose(String s) {
        this.putProp("verbose", s);
    }

    protected void setVerbose(int n) {
        this.putProp("verbose", String.valueOf(n));
    }

    protected boolean getVerbose() {
        int n = this.getIntegerProp("verbose");
        return 0 != n;
    }

    protected void setSynchLog(String s) {
        this.putProp("synchLog", s);
    }

    protected void setSynchLog(int n) {
        this.putProp("synchLog", String.valueOf(n));
    }

    protected void setSynchLog(boolean b) {
        if (!b) {
            this.setSynchLog(0);
        } else {
            this.setSynchLog(1);
        }
    }

    protected boolean getSynchLog() {
        int n = this.getIntegerProp("synchLog");
        return 0 != n;
    }

    protected void setQueueWaitTimeout(String s) {
        this.putProp("queueWaitTimeout", s);
    }

    protected void setQueueWaitTimeout(int n) {
        this.putProp("queueWaitTimeout", String.valueOf(n));
    }

    protected int getQueueWaitTimeout() {
        return this.getIntegerProp("queueWaitTimeout");
    }

    protected void setPingIntervalSeconds(String s) {
        this.putProp("pingIntervalSeconds", s);
    }

    protected void setPingIntervalSeconds(int n) {
        this.putProp("pingIntervalSeconds", String.valueOf(n));
    }

    protected int getPingIntervalSeconds() {
        return this.getIntegerProp("pingIntervalSeconds");
    }

    protected int getPingIntervalSecondsMss() {
        return this.getIntegerProp("pingIntervalSeconds") * 1000;
    }

    protected Properties getProperties(String prefix) {
        Properties p = new Properties();
        Enumeration<?> enumer = this.m_props.propertyNames();
        while (enumer.hasMoreElements()) {
            String name = (String)enumer.nextElement();
            if (!name.startsWith(prefix)) continue;
            String newname = name.substring(prefix.length());
            p.put(newname, this.m_props.getProperty(name));
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readProperties(String fname) {
        FileInputStream fis = null;
        try {
            File f = new File(fname);
            if (!f.exists() || !f.isFile()) {
                this.m_rocf.traceRB("propertyFileNotFound.txt", fname);
                return;
            }
            this.m_rocf.traceRB("loadingPropertyFile.txt", fname);
            fis = new FileInputStream(f);
            this.m_props.load(fis);
        }
        catch (IOException ex) {
            System.out.println("Error: reading properties file:" + ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected String getProperty(String s) {
        return this.getStringProp(s);
    }

    protected void dumpProperties() {
        Enumeration<?> enumer = this.m_props.propertyNames();
        System.out.println("RocfORBProperties:");
        while (enumer.hasMoreElements()) {
            String name = (String)enumer.nextElement();
            System.out.print(name);
            try {
                System.out.println("\t " + this.getStringProp(name));
            }
            catch (Exception e) {
                System.out.println("\t " + this.getIntegerProp(name));
            }
        }
    }

    private void putProp(String s, String v) {
        if (null != v) {
            this.m_props.put(s, v);
        }
    }

    private String getStringProp(String s) {
        return (String)this.m_props.get(s);
    }

    private int getIntegerProp(String s) {
        int n;
        String v = this.getStringProp(s);
        String str = v.trim();
        if (v != null) {
            try {
                n = Integer.parseInt(str);
            }
            catch (Exception e) {
                n = 0;
            }
        } else {
            n = 0;
        }
        return n;
    }

    protected String getArg(String[] args, String s, String defaultVal) {
        String v = this.getArg(args, s);
        if (v == null) {
            v = defaultVal;
        }
        return v;
    }

    private String getArg(String[] args, String s) {
        String arg = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith(s)) continue;
            arg = args[i].substring(s.length());
            if (arg.length() != 0) break;
            arg = null;
            break;
        }
        return arg;
    }

    protected int getIntArg(String[] args, String s, int defaultVal) {
        int n = 0;
        String arg = this.getArg(args, s);
        if (null != arg) {
            try {
                n = Integer.parseInt(arg);
            }
            catch (Exception e) {
                n = defaultVal;
            }
        } else {
            n = defaultVal;
        }
        return n;
    }
}

