/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.Connection;
import com.sas.rmi.ConnectionUtility;
import com.sas.rmi.RB;
import com.sas.rmi.RocfORBProfile2Interface;
import com.sas.util.ArrayAccess;
import com.sas.util.Comparator;
import com.sas.util.IndexedSetInterface;
import com.sas.util.Sort;
import com.sas.util.StringComparator;
import java.io.FileInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class RocfORBProfileProcessor
implements RocfORBProfile2Interface {
    String profileDatabase;
    Properties profileProps;
    Hashtable noProperties = new Hashtable();
    public static final String RB_KEY = "RocfORB.";
    public static final String CONNECTION_NAME = "connection";

    @Override
    public boolean initialize(Properties props) {
        boolean rc = true;
        this.profileDatabase = props.getProperty("profileDatabase");
        if (this.profileDatabase == null) {
            System.out.println("Warning: profileDatabase not given.");
            return false;
        }
        rc = this.loadProperties();
        return rc;
    }

    @Override
    public boolean exists(String profile) {
        boolean rc = false;
        if (profile != null && this.profileProps != null) {
            profile = profile + ".";
            Hashtable h = new Hashtable();
            Enumeration<?> enumer = this.profileProps.propertyNames();
            while (enumer.hasMoreElements()) {
                String p = (String)enumer.nextElement();
                if (!p.startsWith(profile)) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }

    @Override
    public void applyProfileProperties(String profile, Connection c) throws RemoteException {
        if (this.profileProps == null) {
            return;
        }
        if (!this.hasProperties(profile)) {
            if (this.noProperties.get(profile) == null) {
                System.out.println("Warning: No profile for '" + profile + "'");
                this.noProperties.put(profile, "");
            }
        } else {
            ConnectionUtility.applyPropertyFile(c, this.profileProps, CONNECTION_NAME, profile);
        }
    }

    @Override
    public void reload() {
        this.loadProperties();
    }

    @Override
    public String[] getProfileNames() {
        Object[] s = null;
        if (this.profileProps != null) {
            Hashtable<String, String> h = new Hashtable<String, String>();
            Enumeration<Object> enumer = this.profileProps.propertyNames();
            while (enumer.hasMoreElements()) {
                String name;
                String p = (String)enumer.nextElement();
                int i = p.indexOf(".");
                if (i <= 0 || h.get(name = p.substring(0, i)) != null) continue;
                h.put(name, "");
            }
            s = new String[h.size()];
            enumer = h.keys();
            int i = 0;
            while (enumer.hasMoreElements()) {
                s[i++] = (String)enumer.nextElement();
            }
            ArrayAccess aa = new ArrayAccess(s);
            Sort sort = new Sort((IndexedSetInterface)aa, (Comparator)StringComparator.defaultInstance);
            sort.sort();
        }
        return s;
    }

    protected String getDisplayName() {
        return RB.getStringResource(RB_KEY, "displayName.txt") + ":";
    }

    protected boolean hasProperties(String key) {
        key = key + "." + CONNECTION_NAME + ".";
        Enumeration<?> enumer = this.profileProps.propertyNames();
        while (enumer.hasMoreElements()) {
            String p = (String)enumer.nextElement();
            if (!p.startsWith(key)) continue;
            return true;
        }
        return false;
    }

    protected boolean loadProperties() {
        boolean rc = true;
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.profileDatabase);
            System.out.println("Loading profile file: " + this.profileDatabase);
            this.profileProps = new Properties();
            this.profileProps.load(is);
        }
        catch (Exception ex) {
            System.out.println("Warning: Unable to open " + this.profileDatabase);
            rc = false;
        }
        if (is != null) {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rc;
    }

    @Override
    public String getProperty(String key) {
        return this.profileProps.getProperty(key);
    }
}

