/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.RMIUtil;
import com.sas.rmi.RocfORBInterface;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class RocfORBManager {
    public static final String SHUTDOWN_SWITCH = "-shutdown";
    public static final String KILL_SWITCH = "-kill";
    public static final String RELOAD_SWITCH = "-reload";
    public static final String SLEEP_SWITCH = "-sleep";
    public static final String STATUS_SWITCH = "-status";
    public static final String RELOADCLASSES_SWITCH = "-reloadclasses";

    public static void main(String[] args) {
        RocfORBManager m = new RocfORBManager();
        int err = m.go(args);
        System.exit(err);
    }

    public int go(String[] args) {
        String mwsHost;
        int mwsPort = 1099;
        if (args.length < 1 || args.length == 1 && this.argExists(args, "-?") | this.argExists(args, "-help")) {
            this.usage();
            return 1;
        }
        String temp = this.getArg(args, "-p");
        if (temp != null) {
            mwsPort = Integer.parseInt(temp);
        }
        if ((temp = this.getArg(args, "-h")) != null) {
            int colon = temp.indexOf(":");
            if (colon > 0) {
                mwsPort = Integer.parseInt(temp.substring(colon + 1));
                mwsHost = temp.substring(0, colon);
            } else {
                mwsHost = temp;
            }
        } else {
            mwsHost = RMIUtil.getLocalHost();
        }
        RocfORBInterface orb = null;
        try {
            Registry registry = LocateRegistry.getRegistry(mwsHost, mwsPort);
            orb = (RocfORBInterface)registry.lookup("RocfORB");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 1;
        }
        String myHost = null;
        try {
            myHost = RMIUtil.getLocalHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.argExists(args, SHUTDOWN_SWITCH)) {
                orb.command(1, myHost);
            }
            if (this.argExists(args, KILL_SWITCH)) {
                orb.command(2, myHost);
            }
            if (this.argExists(args, RELOADCLASSES_SWITCH)) {
                orb.command(6, myHost);
            }
            if (this.argExists(args, RELOAD_SWITCH)) {
                orb.command(3, myHost);
            }
            if (this.argExists(args, STATUS_SWITCH)) {
                System.out.println(orb.command(5, myHost));
            }
            if (this.argExists(args, SLEEP_SWITCH)) {
                System.out.println("ERROR: '-sleep' is not implemented.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 1;
        }
        int ret = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            System.out.println("Unknown argument: " + args[i]);
            ret = 1;
        }
        return ret;
    }

    private String getArg(String[] args, String s) {
        String arg = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || !args[i].startsWith(s)) continue;
            arg = args[i].substring(s.length());
            if (arg.length() == 0) {
                arg = null;
            }
            args[i] = null;
            break;
        }
        return arg;
    }

    private boolean argExists(String[] args, String s) {
        boolean rc = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || !args[i].startsWith(s)) continue;
            rc = true;
            args[i] = null;
            break;
        }
        return rc;
    }

    private void usage() {
        System.out.println("java com.sas.rmi.RocfORBManager\n\t[-? | -help]\tThis usage note\n\t[-hhost]\tThe Middleware Server host as <host>:<port>\n\t\t\t\t(default: localhost:1099)\n\t[-shutdown] \tGracefully shutdown the Middlware Server\n\t[-kill] \tKill the Middleware Server immediately\n\t[-reload] \tReload any options/properties\n\t[-status] \tDisplay status information\n");
    }
}

