/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.RocfORBEvent;
import com.sas.rmi.RocfORBListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;

public final class RocfORBListenerList
implements Serializable,
RocfORBListener {
    static final long serialVersionUID = -9196778000L;
    private int numberOfListeners;
    private RocfORBListener[] listenerList;
    private static RocfORBListener[] emptyListenerList;
    private RocfORBListener[] listeners;
    private int increment;
    private static final int DEFAULT_INCREMENT = 8;
    private boolean reThrowExceptions;
    private boolean logExceptions;

    public RocfORBListenerList() {
        this(8, true, false);
    }

    public RocfORBListenerList(int initialIncrement, boolean logExceptions, boolean reThrowExceptions) {
        this.increment = initialIncrement <= 0 ? 8 : initialIncrement;
        this.logExceptions = logExceptions;
        this.reThrowExceptions = reThrowExceptions;
    }

    public RocfORBListenerList(int initialIncrement) {
        this(initialIncrement, true, false);
    }

    public int count() {
        return this.numberOfListeners;
    }

    public void setExceptionLoggingEnabled(boolean logExceptions) {
        this.logExceptions = logExceptions;
    }

    public boolean isExceptionLoggingEnabled() {
        return this.logExceptions;
    }

    protected void handleException(RuntimeException exception) {
        if (this.isExceptionLoggingEnabled()) {
            System.err.println(exception.getMessage());
            exception.printStackTrace(System.err);
        }
        if (this.isExceptionReThrown()) {
            throw exception;
        }
    }

    public void setExceptionReThrown(boolean reThrow) {
        this.reThrowExceptions = reThrow;
    }

    public boolean isExceptionReThrown() {
        return this.reThrowExceptions;
    }

    private int indexOf(RocfORBListener listener) {
        if (this.listenerList != null) {
            for (int i = 0; i < this.numberOfListeners; ++i) {
                RocfORBListener o1 = this.listenerList[i];
                RocfORBListener o2 = listener;
                if (!o1.equals(o2)) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized void add(RocfORBListener listener) {
        if (listener == null) {
            return;
        }
        if (this.indexOf(listener) != -1) {
            return;
        }
        this.listeners = null;
        if (this.listenerList == null || this.numberOfListeners >= this.listenerList.length) {
            if (this.numberOfListeners > 4 * this.increment) {
                this.increment *= 2;
            }
            RocfORBListener[] newListenerList = new RocfORBListener[this.numberOfListeners + this.increment];
            if (this.listenerList != null) {
                System.arraycopy(this.listenerList, 0, newListenerList, 0, this.numberOfListeners);
            }
            this.listenerList = newListenerList;
        }
        this.listenerList[this.numberOfListeners++] = listener;
    }

    public synchronized RocfORBListener[] getListeners() {
        if (this.listeners == null) {
            if (this.numberOfListeners > 0) {
                this.listeners = new RocfORBListener[this.numberOfListeners];
                System.arraycopy(this.listenerList, 0, this.listeners, 0, this.numberOfListeners);
            } else {
                if (emptyListenerList == null) {
                    emptyListenerList = new RocfORBListener[0];
                }
                return emptyListenerList;
            }
        }
        return this.listeners;
    }

    public synchronized void remove(RocfORBListener listener) {
        int index = this.indexOf(listener);
        if (index == -1) {
            return;
        }
        this.listeners = null;
        --this.numberOfListeners;
        if (this.numberOfListeners == 0) {
            if (emptyListenerList == null) {
                emptyListenerList = new RocfORBListener[0];
            }
            this.listenerList = null;
            return;
        }
        this.listenerList[index] = null;
        while (index < this.numberOfListeners) {
            this.listenerList[index++] = this.listenerList[index];
        }
    }

    @Override
    public void orbEventOccurred(RocfORBEvent event) {
        if (this.numberOfListeners == 0) {
            return;
        }
        for (RocfORBListener listener : this.getListeners()) {
            try {
                listener.orbEventOccurred(event);
            }
            catch (RemoteException re) {
                this.remove(listener);
            }
            catch (RuntimeException exception) {
                this.handleException(exception);
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.numberOfListeners == 0) {
            this.listenerList = null;
        }
    }
}

