/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.collection.hlist.DoubleItem;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.ListItem;
import com.sas.collection.hlist.StringItem;
import com.sas.rmi.Connection;
import com.sas.rmi.HttpEventListener;
import com.sas.rmi.HttpTunnel;
import com.sas.rmi.PacketOutputStream;
import com.sas.rmi.RSCLBaseClient;
import com.sas.rmi.RemoteException;
import com.sas.rmi.Rocf;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class RemoteUtility {
    private int finishedSequence = -1;
    private transient Rocf m_rocf;
    private Connection m_ctxt;
    private boolean m_tpc;
    private boolean m_needToWait;
    private int eventSequence;
    protected String hostName;
    protected int hostPort;
    protected Socket socket;
    protected DataOutputStream out;
    protected DataInputStream in;
    protected int objectHandle;
    protected boolean debug = false;
    protected boolean lockConnection = false;
    protected int m_listenerHandle = 0;
    protected int m_queueHandle = 0;
    protected Socket m_queueSocket = null;
    protected DataOutputStream m_queueOut = null;
    protected Socket lockSocket = null;
    protected int lockSocketRef = 0;
    protected boolean m_tunnel = false;
    protected HttpTunnel m_http = null;
    protected String m_tunnelURL;
    protected HttpEventListener m_tunnelEvent = null;
    public static final int OP_ACK = 40;
    public static final int OP_NACK = 41;
    public static final int OP_ACK_EVENT = 42;
    public static final int OP_CONSTRUCT = 50;
    public static final int OP_METHOD = 51;
    public static final int OP_DESTRUCT = 52;
    public static final int OP_EXCEPTION = 53;
    public static final int OP_REGLISTEN = 54;
    public static final int OP_DEREGLISTEN = 55;
    public static final int OP_HTTPINFO = 56;
    public static final int OP_HTTPLISTEN = 57;
    public static final int OP_ACTION = 70;
    public static final int ACTION_KILLSERVER = 1;
    public static final int ACTION_TRACE = 2;
    public static final int ACTION_PING = 3;
    public static final int CONSTRUCT_MAGIC = 1667394413;
    public static final short CONSTRUCT_VERSION = 1;
    public static final int TYPE_VOID = 0;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_DOUBLE = 2;
    public static final int TYPE_STRINGA1 = 3;
    public static final int TYPE_DOUBLEA1 = 4;
    public static final int TYPE_LIST = 5;
    public static final int TYPE_KEY = 6;
    public static final int TYPE_NULLKEY = 7;
    public static final int TYPE_HLIST = 8;
    public static final int TYPE_NULLHLIST = 9;
    public static final int TYPE_NULLSTRING = 10;
    public static final int TYPE_NULLSTRINGA1 = 11;
    public static final int TYPE_NULLDOUBLEA1 = 12;
    public static final int TYPE_INPUT = 40;
    public static final int TYPE_UPDATE = 41;
    public static final int REG_NONQUEUE = 0;
    public static final int REG_QUEUE = 1;
    public static final int STATUS_EVENTS = 1;
    public static final int STATUS_MOREDATA = 2;

    public RemoteUtility(String host, int port) {
        this.hostName = host;
        this.hostPort = port;
    }

    public RemoteUtility(String host, int port, boolean locking, Socket lock) {
        this.hostName = host;
        this.hostPort = port;
        this.lockConnection = locking;
        this.lockSocket = lock;
    }

    public RemoteUtility(String host, int port, boolean locking, Socket lock, String url) {
        this.hostName = host;
        this.hostPort = port;
        this.lockConnection = locking;
        this.lockSocket = lock;
        if (url != null && url.length() != 0) {
            this.lockConnection = true;
            this.m_tunnelURL = url;
            this.m_tunnel = true;
        }
    }

    public RemoteUtility(DataInputStream i, DataOutputStream o) {
        this.in = i;
        this.out = o;
    }

    public DataInputStream getIn() {
        return this.in;
    }

    public DataOutputStream getOut() {
        return this.out;
    }

    public void setIn(DataInputStream i) {
        this.in = i;
    }

    public void setOut(DataOutputStream o) {
        this.out = o;
    }

    public int getSCLHandle() {
        return this.objectHandle;
    }

    public void bind(int sclHandle) throws IOException {
        this.objectHandle = sclHandle;
    }

    public synchronized void init(String objectName) throws IOException {
        long t = 0L;
        this.connect(false);
        try {
            if (this.debug) {
                System.out.println("Initializing Object " + objectName);
                System.out.println("Lock Connection = " + this.lockConnection);
                System.out.println("Sending initialization packet");
                t = System.currentTimeMillis();
            }
            this.out.writeByte(50);
            this.out.writeInt(1667394413);
            this.out.writeShort(1);
            this.out.writeUTF(objectName);
            this.out.flush();
            if (this.debug) {
                System.out.println(" Sent in " + (System.currentTimeMillis() - t) + "ms");
                System.out.println(" Waiting for response");
                t = System.currentTimeMillis();
            }
            this.in.readInt();
            byte status = this.in.readByte();
            byte ack = this.in.readByte();
            if (this.debug) {
                System.out.println(" Response in " + (System.currentTimeMillis() - t) + "ms");
            }
            switch (ack) {
                case 40: {
                    this.objectHandle = this.in.readInt();
                    break;
                }
                case 53: {
                    this.getException();
                    break;
                }
                case 41: {
                    throw new RemoteException("Initialization denied");
                }
                default: {
                    throw new RemoteException("Unknown opcode " + ack);
                }
            }
            this.processEvents(status);
        }
        catch (RemoteException ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw ex;
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
        this.close(this.lockConnection);
    }

    public void endMethod() throws IOException {
        this.close(this.lockConnection);
        if (this.needWait()) {
            this.waitForEventCompletion();
            this.waitOff();
        }
    }

    public synchronized void _finalize() throws IOException {
        long t = 0L;
        this.connect(this.lockConnection);
        try {
            if (this.debug) {
                System.out.println("Sending termination packet");
                t = System.currentTimeMillis();
            }
            this.out.writeByte(52);
            this.out.writeInt(this.objectHandle);
            this.out.flush();
            if (this.debug) {
                System.out.println(" Sent in " + (System.currentTimeMillis() - t) + "ms");
                System.out.println(" Waiting for response");
                t = System.currentTimeMillis();
            }
            this.in.readInt();
            byte status = this.in.readByte();
            byte ack = this.in.readByte();
            if (this.debug) {
                System.out.println(" Response in " + (System.currentTimeMillis() - t) + "ms");
            }
            switch (ack) {
                case 40: {
                    break;
                }
                case 53: {
                    this.getException();
                    break;
                }
                case 41: {
                    throw new RemoteException("Finalization denied");
                }
                default: {
                    throw new RemoteException("Unknown opcode " + ack);
                }
            }
            this.processEvents(status);
            if (this.m_tunnelEvent != null) {
                this.m_tunnelEvent.stop();
                this.m_tunnelEvent = null;
            }
        }
        catch (RemoteException ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(false);
            throw ex;
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(false);
            throw new IOException(ex.getMessage());
        }
        this.close(false);
    }

    public void action(int code) throws IOException {
        this.connect(this.lockConnection);
        try {
            if (this.debug) {
                System.out.println("Sending action " + code);
            }
            this.out.writeByte(70);
            this.out.writeInt(this.m_queueHandle);
            this.out.writeByte(code);
            this.out.flush();
            this.in.readInt();
            byte status = this.in.readByte();
            byte ack = this.in.readByte();
            switch (ack) {
                case 40: {
                    break;
                }
                case 53: {
                    this.getException();
                    break;
                }
                case 41: {
                    throw new RemoteException("Action denied");
                }
                default: {
                    throw new RemoteException("Unknown opcode " + ack);
                }
            }
            this.processEvents(status);
        }
        catch (RemoteException ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw ex;
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
        this.close(this.lockConnection);
    }

    public void killServer() throws IOException {
        this.action(1);
    }

    public void trace() throws IOException {
        this.action(2);
    }

    public void setDebug(boolean value) {
        this.debug = value;
        if (this.debug) {
            System.out.println("RemoteUtility debugging ON");
        }
    }

    public void methodHeader(String methodName) throws IOException {
        long t = 0L;
        this.waitOff();
        this.connect(this.lockConnection);
        try {
            if (this.debug) {
                System.out.println("Sending header for " + methodName);
                t = System.currentTimeMillis();
            }
            this.out.writeByte(51);
            this.out.writeInt(this.objectHandle);
            this.out.writeUTF(methodName);
            this.out.writeInt(this.m_listenerHandle);
            this.out.writeInt(this.m_queueHandle);
            if (this.debug) {
                System.out.println(" Sent in " + (System.currentTimeMillis() - t) + "ms");
            }
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
    }

    public void numParams(int n) throws IOException {
        long t = 0L;
        try {
            if (this.debug) {
                System.out.println("Sending parameter count " + n);
                t = System.currentTimeMillis();
            }
            this.out.writeShort(n);
            if (this.debug) {
                System.out.println(" Sent in " + (System.currentTimeMillis() - t) + "ms");
            }
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
    }

    public void param(String s, boolean paramsAreUpdate) throws IOException {
        long t = 0L;
        try {
            if (this.debug) {
                System.out.println("Sending parameter '" + s + "'");
                t = System.currentTimeMillis();
            }
            this.parameterDirection(paramsAreUpdate, true);
            this.write(s);
            if (this.debug) {
                System.out.println(" Sent in " + (System.currentTimeMillis() - t) + "ms");
            }
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
    }

    public void readUpdateParam(String s, boolean paramsAreUpdate) throws IOException {
    }

    public void param(String[] s, boolean paramsAreUpdate) throws IOException {
        long t = 0L;
        try {
            if (this.debug) {
                System.out.println("Sending String[] parameter");
                t = System.currentTimeMillis();
            }
            this.parameterDirection(paramsAreUpdate, false);
            this.write(s);
            if (this.debug) {
                System.out.println(" Sent in " + (System.currentTimeMillis() - t) + "ms");
            }
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
    }

    public void readUpdateParam(String[] s, boolean paramsAreUpdate) throws IOException {
        if (paramsAreUpdate && s != null) {
            String[] update = this.stringA1Method(false);
            for (int i = 0; i < s.length; ++i) {
                s[i] = update == null ? null : (i >= update.length ? null : update[i]);
            }
        }
    }

    public void param(boolean b, boolean paramsAreUpdate) throws IOException {
        this.param(b ? 1.0 : 0.0, paramsAreUpdate);
    }

    public void param(byte b, boolean paramsAreUpdate) throws IOException {
        this.param((double)b, paramsAreUpdate);
    }

    public void param(char b, boolean paramsAreUpdate) throws IOException {
        this.param((double)b, paramsAreUpdate);
    }

    public void param(short b, boolean paramsAreUpdate) throws IOException {
        this.param((double)b, paramsAreUpdate);
    }

    public void param(int b, boolean paramsAreUpdate) throws IOException {
        this.param((double)b, paramsAreUpdate);
    }

    public void param(long b, boolean paramsAreUpdate) throws IOException {
        this.param((double)b, paramsAreUpdate);
    }

    public void param(float b, boolean paramsAreUpdate) throws IOException {
        this.param((double)b, paramsAreUpdate);
    }

    public void param(double d, boolean paramsAreUpdate) throws IOException {
        long t = 0L;
        try {
            if (this.debug) {
                System.out.println("Sending parameter " + d);
                t = System.currentTimeMillis();
            }
            this.parameterDirection(paramsAreUpdate, true);
            this.write(d);
            if (this.debug) {
                System.out.println(" Sent in " + (System.currentTimeMillis() - t) + "ms");
            }
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
    }

    public void objectParam(Object o, boolean paramsAreUpdate) throws IOException {
        RSCLBaseClient rbc = (RSCLBaseClient)o;
        this.param(rbc._RemoteObject_getSCLHandle(), paramsAreUpdate);
    }

    public void readObjectParam(Object o, boolean paramsAreUpdate) throws IOException {
    }

    public void readUpdateParam(double d, boolean paramsAreUpdate) throws IOException {
    }

    public void readUpdateParam(boolean b, boolean paramsAreUpdate) throws IOException {
    }

    public void param(double[] d, boolean paramsAreUpdate) throws IOException {
        long t = 0L;
        try {
            if (this.debug) {
                System.out.println("Sending double[] parameter");
                t = System.currentTimeMillis();
            }
            this.parameterDirection(paramsAreUpdate, false);
            this.write(d);
            if (this.debug) {
                System.out.println(" Sent in " + (System.currentTimeMillis() - t) + "ms");
            }
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
    }

    public void readUpdateParam(double[] d, boolean paramsAreUpdate) throws IOException {
        if (paramsAreUpdate && d != null) {
            double[] update = this.doubleA1Method(false);
            for (int i = 0; i < d.length; ++i) {
                d[i] = update == null ? 0.0 : (i >= update.length ? 0.0 : update[i]);
            }
        }
    }

    public void param(int[] a, boolean paramsAreUpdate) throws IOException {
        double[] d = null;
        if (a != null) {
            d = new double[a.length];
            for (int i = 0; i < a.length; ++i) {
                d[i] = a[i];
            }
        }
        this.param(d, paramsAreUpdate);
    }

    public void param(boolean[] a, boolean paramsAreUpdate) throws IOException {
        double[] d = null;
        if (a != null) {
            d = new double[a.length];
            for (int i = 0; i < a.length; ++i) {
                d[i] = a[i] ? 1.0 : 0.0;
            }
        }
        this.param(d, paramsAreUpdate);
    }

    public void param(byte[] a, boolean paramsAreUpdate) throws IOException {
        double[] d = null;
        if (a != null) {
            d = new double[a.length];
            for (int i = 0; i < a.length; ++i) {
                d[i] = a[i];
            }
        }
        this.param(d, paramsAreUpdate);
    }

    public void param(char[] a, boolean paramsAreUpdate) throws IOException {
        double[] d = null;
        if (a != null) {
            d = new double[a.length];
            for (int i = 0; i < a.length; ++i) {
                d[i] = a[i];
            }
        }
        this.param(d, paramsAreUpdate);
    }

    public void param(short[] a, boolean paramsAreUpdate) throws IOException {
        double[] d = null;
        if (a != null) {
            d = new double[a.length];
            for (int i = 0; i < a.length; ++i) {
                d[i] = a[i];
            }
        }
        this.param(d, paramsAreUpdate);
    }

    public void param(long[] a, boolean paramsAreUpdate) throws IOException {
        double[] d = null;
        if (a != null) {
            d = new double[a.length];
            for (int i = 0; i < a.length; ++i) {
                d[i] = a[i];
            }
        }
        this.param(d, paramsAreUpdate);
    }

    public void param(float[] a, boolean paramsAreUpdate) throws IOException {
        double[] d = null;
        if (a != null) {
            d = new double[a.length];
            for (int i = 0; i < a.length; ++i) {
                d[i] = a[i];
            }
        }
        this.param(d, paramsAreUpdate);
    }

    public void readUpdateParam(int[] a, boolean paramsAreUpdate) throws IOException {
        if (a != null) {
            double[] d = new double[a.length];
            this.readUpdateParam(d, paramsAreUpdate);
            for (int i = 0; i < a.length; ++i) {
                a[i] = (int)d[i];
            }
        }
    }

    public void readUpdateParam(byte[] a, boolean paramsAreUpdate) throws IOException {
        if (a != null) {
            double[] d = new double[a.length];
            this.readUpdateParam(d, paramsAreUpdate);
            for (int i = 0; i < a.length; ++i) {
                a[i] = (byte)d[i];
            }
        }
    }

    public void readUpdateParam(char[] a, boolean paramsAreUpdate) throws IOException {
        if (a != null) {
            double[] d = new double[a.length];
            this.readUpdateParam(d, paramsAreUpdate);
            for (int i = 0; i < a.length; ++i) {
                a[i] = (char)d[i];
            }
        }
    }

    public void readUpdateParam(short[] a, boolean paramsAreUpdate) throws IOException {
        if (a != null) {
            double[] d = new double[a.length];
            this.readUpdateParam(d, paramsAreUpdate);
            for (int i = 0; i < a.length; ++i) {
                a[i] = (short)d[i];
            }
        }
    }

    public void readUpdateParam(long[] a, boolean paramsAreUpdate) throws IOException {
        if (a != null) {
            double[] d = new double[a.length];
            this.readUpdateParam(d, paramsAreUpdate);
            for (int i = 0; i < a.length; ++i) {
                a[i] = (long)d[i];
            }
        }
    }

    public void readUpdateParam(float[] a, boolean paramsAreUpdate) throws IOException {
        if (a != null) {
            double[] d = new double[a.length];
            this.readUpdateParam(d, paramsAreUpdate);
            for (int i = 0; i < a.length; ++i) {
                a[i] = (float)d[i];
            }
        }
    }

    public void readUpdateParam(boolean[] a, boolean paramsAreUpdate) throws IOException {
        if (a != null) {
            double[] d = new double[a.length];
            this.readUpdateParam(d, paramsAreUpdate);
            for (int i = 0; i < a.length; ++i) {
                a[i] = d[i] != 0.0;
            }
        }
    }

    public void param(HListInterface l, boolean paramType) throws IOException {
        this.writeList(l, paramType, true);
    }

    public void readUpdateParam(HListInterface l, boolean paramsAreUpdate) throws IOException {
        if (paramsAreUpdate && l != null) {
            HListInterface update = this.hlistMethod(false);
            l.removeAll();
            if (update != null) {
                for (int i = 0; i < update.count(); ++i) {
                    l.add((Object)update.getItem(i));
                }
            }
        }
    }

    protected void writeList(HListInterface l, boolean paramType, boolean writeDirection) throws IOException {
        int index = 0;
        if (writeDirection) {
            this.parameterDirection(paramType, false);
        }
        if (l == null) {
            this.out.writeShort(9);
            return;
        }
        this.out.writeShort(8);
        this.out.writeInt(l.count());
        Enumeration en = l.getItems();
        while (en.hasMoreElements()) {
            HListItem item = (HListItem)en.nextElement();
            if (item instanceof StringItem) {
                if (item == null) {
                    this.out.writeShort(10);
                } else {
                    this.out.writeShort(1);
                    this.out.writeUTF(((StringItem)item).getValue());
                }
            } else if (item instanceof DoubleItem) {
                this.out.writeShort(2);
                this.out.writeDouble(((DoubleItem)item).getValue());
            } else if (item instanceof ListItem) {
                ListItem li = null;
                HListInterface hl = null;
                li = (ListItem)item;
                hl = li.getValue();
                this.writeList(hl, paramType, writeDirection);
            } else {
                this.out.writeShort(2);
                this.out.writeDouble(0.0);
            }
            String key = l.getName(index);
            if (key == null) {
                this.out.writeShort(7);
            } else {
                this.out.writeShort(6);
                this.out.writeUTF(key);
            }
            ++index;
        }
    }

    public HListInterface hlistMethod() throws IOException {
        return this.hlistMethod(true);
    }

    public HListInterface hlistMethod(boolean returnValue) throws IOException {
        long t = 0L;
        byte status = 0;
        HListInterface list = null;
        try {
            if (returnValue) {
                if (this.debug) {
                    System.out.println("HLIST method");
                    t = System.currentTimeMillis();
                }
                this.out.writeShort(8);
                this.out.flush();
                if (this.debug) {
                    System.out.println(" Sent in " + (System.currentTimeMillis() - t) + "ms");
                    System.out.println(" Waiting for response");
                    t = System.currentTimeMillis();
                }
                int packetLen = this.in.readInt();
                if (this.debug) {
                    System.out.println(" Packet length of " + packetLen);
                }
                status = this.in.readByte();
                byte ack = this.in.readByte();
                if (this.debug) {
                    System.out.println(" Response in " + (System.currentTimeMillis() - t) + "ms");
                }
                switch (ack) {
                    case 40: {
                        break;
                    }
                    case 42: {
                        this.waitOn();
                        break;
                    }
                    case 53: {
                        this.getException();
                        break;
                    }
                    case 41: {
                        throw new RemoteException("Method denied");
                    }
                    default: {
                        throw new RemoteException("Unknown opcode " + ack);
                    }
                }
            }
            if (this.debug) {
                System.out.println(" Waiting for return");
                t = System.currentTimeMillis();
            }
            short type = this.readType();
            if (this.debug) {
                System.out.println(" Return in " + (System.currentTimeMillis() - t) + "ms");
                t = System.currentTimeMillis();
            }
            list = this.readList(type);
            if (this.debug) {
                System.out.println(" List read in " + (System.currentTimeMillis() - t) + "ms");
            }
            this.processEvents(status);
        }
        catch (RemoteException ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw ex;
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
        return list;
    }

    protected void readList(HListInterface list, int size) throws IOException {
        block10: for (int i = 0; i < size; ++i) {
            short type = this.in.readShort();
            switch (type) {
                case 1: {
                    list.add((Object)new StringItem(this.in.readUTF()));
                    break;
                }
                case 2: {
                    list.add((Object)new DoubleItem(this.in.readDouble()));
                    break;
                }
                case 8: {
                    int len = this.in.readInt();
                    if (len <= 0) break;
                    HList l = new HList();
                    this.readList((HListInterface)l, len);
                    list.add((Object)new ListItem((HListInterface)l));
                    break;
                }
                case 9: {
                    list.add((Object)null);
                    break;
                }
                default: {
                    throw new IOException("Unknown list element type " + type + " at " + i);
                }
            }
            type = this.in.readShort();
            switch (type) {
                case 6: {
                    list.setName(this.in.readUTF(), i);
                    continue block10;
                }
                case 7: {
                    continue block10;
                }
                default: {
                    throw new IOException("Invalid KEY at " + i);
                }
            }
        }
    }

    public void voidMethod() throws IOException {
        long t = 0L;
        try {
            if (this.debug) {
                System.out.println("VOID method");
                t = System.currentTimeMillis();
            }
            this.out.writeShort(0);
            this.out.flush();
            if (this.debug) {
                System.out.println(" Sent in " + (System.currentTimeMillis() - t) + "ms");
                System.out.println(" Waiting for response");
                t = System.currentTimeMillis();
            }
            int packetLen = this.in.readInt();
            if (this.debug) {
                System.out.println(" Got packet of " + packetLen + " bytes");
            }
            byte status = this.in.readByte();
            byte ack = this.in.readByte();
            if (this.debug) {
                System.out.println(" Response in " + (System.currentTimeMillis() - t) + "ms");
            }
            switch (ack) {
                case 40: {
                    break;
                }
                case 42: {
                    this.waitOn();
                    break;
                }
                case 53: {
                    this.getException();
                    break;
                }
                case 41: {
                    throw new RemoteException("Method denied");
                }
                default: {
                    throw new RemoteException("Unknown opcode " + ack);
                }
            }
            if (this.debug) {
                System.out.println(" Waiting for return");
                t = System.currentTimeMillis();
            }
            short type = this.in.readShort();
            if (this.debug) {
                System.out.println(" Return in " + (System.currentTimeMillis() - t) + "ms");
            }
            if (type != 0) {
                throw new IOException("Expecting VOID; got " + type);
            }
            this.processEvents(status);
        }
        catch (RemoteException ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw ex;
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
    }

    public String stringMethod() throws IOException {
        long t = 0L;
        String ret = null;
        try {
            if (this.debug) {
                System.out.println("STRING method");
                t = System.currentTimeMillis();
            }
            this.out.writeShort(1);
            this.out.flush();
            if (this.debug) {
                System.out.println(" Sent in " + (System.currentTimeMillis() - t) + "ms");
                System.out.println(" Waiting for response");
                t = System.currentTimeMillis();
            }
            this.in.readInt();
            byte status = this.in.readByte();
            byte ack = this.in.readByte();
            if (this.debug) {
                System.out.println(" Response in " + (System.currentTimeMillis() - t) + "ms");
            }
            switch (ack) {
                case 40: {
                    break;
                }
                case 42: {
                    this.waitOn();
                    break;
                }
                case 53: {
                    this.getException();
                    break;
                }
                case 41: {
                    throw new RemoteException("Method denied");
                }
                default: {
                    throw new RemoteException("Unknown opcode " + ack);
                }
            }
            if (this.debug) {
                System.out.println(" Waiting for return");
                t = System.currentTimeMillis();
            }
            short type = this.readType();
            ret = this.readString(type);
            if (this.debug) {
                System.out.println(" Return of '" + ret + "' in " + (System.currentTimeMillis() - t) + "ms");
            }
            this.processEvents(status);
        }
        catch (RemoteException ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw ex;
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
        return ret;
    }

    public String[] stringA1Method() throws IOException {
        return this.stringA1Method(true);
    }

    public String[] stringA1Method(boolean returnValue) throws IOException {
        long t = 0L;
        String[] ret = null;
        byte status = 0;
        try {
            if (returnValue) {
                if (this.debug) {
                    System.out.println("STRING SINGLE ARRAY method");
                    t = System.currentTimeMillis();
                }
                this.out.writeShort(3);
                this.out.flush();
                if (this.debug) {
                    System.out.println(" Sent in " + (System.currentTimeMillis() - t) + "ms");
                    System.out.println(" Waiting for response");
                    t = System.currentTimeMillis();
                }
                this.in.readInt();
                status = this.in.readByte();
                byte ack = this.in.readByte();
                if (this.debug) {
                    System.out.println(" Response in " + (System.currentTimeMillis() - t) + "ms");
                }
                switch (ack) {
                    case 40: {
                        break;
                    }
                    case 42: {
                        this.waitOn();
                        break;
                    }
                    case 53: {
                        this.getException();
                        break;
                    }
                    case 41: {
                        throw new RemoteException("Method denied");
                    }
                    default: {
                        throw new RemoteException("Unknown opcode " + ack);
                    }
                }
            }
            if (this.debug) {
                System.out.println(" Waiting for return");
                t = System.currentTimeMillis();
            }
            short type = this.readType();
            ret = this.readStringArray(type);
            if (this.debug) {
                System.out.println(" Return of array in " + (System.currentTimeMillis() - t) + "ms");
            }
            this.processEvents(status);
        }
        catch (RemoteException ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw ex;
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
        return ret;
    }

    public double doubleMethod() throws IOException {
        long t = 0L;
        double ret = 0.0;
        try {
            if (this.debug) {
                System.out.println("DOUBLE method");
                t = System.currentTimeMillis();
            }
            this.out.writeShort(2);
            this.out.flush();
            if (this.debug) {
                System.out.println(" Sent in " + (System.currentTimeMillis() - t) + "ms");
                System.out.println(" Waiting for response");
                t = System.currentTimeMillis();
            }
            this.in.readInt();
            byte status = this.in.readByte();
            byte ack = this.in.readByte();
            if (this.debug) {
                System.out.println(" Response in " + (System.currentTimeMillis() - t) + "ms");
            }
            switch (ack) {
                case 40: {
                    break;
                }
                case 42: {
                    this.waitOn();
                    break;
                }
                case 53: {
                    this.getException();
                    break;
                }
                case 41: {
                    throw new RemoteException("Method denied");
                }
                default: {
                    throw new RemoteException("Unknown opcode " + ack);
                }
            }
            if (this.debug) {
                System.out.println(" Waiting for return");
                t = System.currentTimeMillis();
            }
            short type = this.readType();
            ret = this.readDouble(type);
            if (this.debug) {
                System.out.println(" Return of " + ret + " in " + (System.currentTimeMillis() - t) + "ms");
            }
            this.processEvents(status);
        }
        catch (RemoteException ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw ex;
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
        return ret;
    }

    public double[] doubleA1Method() throws IOException {
        return this.doubleA1Method(true);
    }

    public double[] doubleA1Method(boolean returnValue) throws IOException {
        long t = 0L;
        double[] ret = null;
        byte status = 0;
        try {
            if (returnValue) {
                if (this.debug) {
                    System.out.println("DOUBLE SINGLE ARRAY method");
                    t = System.currentTimeMillis();
                }
                this.out.writeShort(4);
                this.out.flush();
                if (this.debug) {
                    System.out.println(" Sent in " + (System.currentTimeMillis() - t) + "ms");
                    System.out.println(" Waiting for response");
                    t = System.currentTimeMillis();
                }
                this.in.readInt();
                status = this.in.readByte();
                byte ack = this.in.readByte();
                if (this.debug) {
                    System.out.println(" Response in " + (System.currentTimeMillis() - t) + "ms");
                }
                switch (ack) {
                    case 40: {
                        break;
                    }
                    case 42: {
                        this.waitOn();
                        break;
                    }
                    case 53: {
                        this.getException();
                        break;
                    }
                    case 41: {
                        throw new RemoteException("Method denied");
                    }
                    default: {
                        throw new RemoteException("Unknown opcode " + ack);
                    }
                }
            }
            if (this.debug) {
                System.out.println(" Waiting for return");
                t = System.currentTimeMillis();
            }
            short type = this.readType();
            ret = this.readDoubleArray(type);
            if (this.debug) {
                System.out.println(" Return of array in " + (System.currentTimeMillis() - t) + "ms");
            }
            this.processEvents(status);
        }
        catch (RemoteException ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw ex;
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
        return ret;
    }

    public int[] intA1Method() throws IOException {
        double[] d = this.doubleA1Method();
        int[] a = null;
        if (d != null) {
            a = new int[d.length];
            for (int i = 0; i < d.length; ++i) {
                a[i] = (int)d[i];
            }
        }
        return a;
    }

    public boolean[] booleanA1Method() throws IOException {
        double[] d = this.doubleA1Method();
        boolean[] a = null;
        if (d != null) {
            a = new boolean[d.length];
            for (int i = 0; i < d.length; ++i) {
                a[i] = d[i] != 0.0;
            }
        }
        return a;
    }

    public byte[] byteA1Method() throws IOException {
        double[] d = this.doubleA1Method();
        byte[] a = null;
        if (d != null) {
            a = new byte[d.length];
            for (int i = 0; i < d.length; ++i) {
                a[i] = (byte)d[i];
            }
        }
        return a;
    }

    public char[] charA1Method() throws IOException {
        double[] d = this.doubleA1Method();
        char[] a = null;
        if (d != null) {
            a = new char[d.length];
            for (int i = 0; i < d.length; ++i) {
                a[i] = (char)d[i];
            }
        }
        return a;
    }

    public short[] shortA1Method() throws IOException {
        double[] d = this.doubleA1Method();
        short[] a = null;
        if (d != null) {
            a = new short[d.length];
            for (int i = 0; i < d.length; ++i) {
                a[i] = (short)d[i];
            }
        }
        return a;
    }

    public long[] longA1Method() throws IOException {
        double[] d = this.doubleA1Method();
        long[] a = null;
        if (d != null) {
            a = new long[d.length];
            for (int i = 0; i < d.length; ++i) {
                a[i] = (long)d[i];
            }
        }
        return a;
    }

    public float[] floatA1Method() throws IOException {
        double[] d = this.doubleA1Method();
        float[] a = null;
        if (d != null) {
            a = new float[d.length];
            for (int i = 0; i < d.length; ++i) {
                a[i] = (float)d[i];
            }
        }
        return a;
    }

    public byte byteMethod() throws IOException {
        return (byte)this.doubleMethod();
    }

    public char charMethod() throws IOException {
        return (char)this.doubleMethod();
    }

    public boolean booleanMethod() throws IOException {
        boolean b = false;
        if (this.doubleMethod() != 0.0) {
            b = true;
        }
        return b;
    }

    public short shortMethod() throws IOException {
        return (short)this.doubleMethod();
    }

    public int intMethod() throws IOException {
        return (int)this.doubleMethod();
    }

    public long longMethod() throws IOException {
        return (long)this.doubleMethod();
    }

    public float floatMethod() throws IOException {
        return (float)this.doubleMethod();
    }

    public Socket getLockSocket() {
        return this.lockSocket;
    }

    protected void connect(boolean locking) throws IOException {
        if (!locking) {
            if (this.m_tunnel) {
                this.connectTunnel();
            } else {
                long t = 0L;
                this.setStatusWorking("Connecting to " + this.hostName + ":" + this.hostPort);
                if (this.debug) {
                    System.out.println("Connecting to " + this.hostName + ":" + this.hostPort);
                    t = System.currentTimeMillis();
                }
                if (!this.lockConnection || this.lockConnection && this.lockSocket == null) {
                    this.socket = new Socket(this.hostName, this.hostPort);
                    if (this.lockConnection) {
                        this.lockSocket = this.socket;
                        this.lockSocketRef = 1;
                    }
                } else {
                    this.socket = this.lockSocket;
                    ++this.lockSocketRef;
                }
                try {
                    this.socket.setTcpNoDelay(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                this.out = new DataOutputStream(new PacketOutputStream(this.out, this.debug));
                this.in = new DataInputStream(this.socket.getInputStream());
                if (this.debug) {
                    System.out.println(" Connected in " + (System.currentTimeMillis() - t) + "ms");
                }
            }
        }
    }

    protected void connectTunnel() throws IOException {
        long t = 0L;
        this.setStatusWorking("Connecting to HTTP tunnel at " + this.m_tunnelURL);
        if (this.debug) {
            System.out.println("Connecting to HTTP tunnel at " + this.m_tunnelURL);
            System.out.println(" passing through to " + this.hostName + ":" + this.hostPort);
            t = System.currentTimeMillis();
        }
        this.m_http = new HttpTunnel();
        this.m_http.setDebug(this.debug);
        this.m_http.setup(this.m_tunnelURL, this.hostName, this.hostPort);
        this.in = this.m_http.getInputStream();
        this.out = this.m_http.getOutputStream();
        this.out = new DataOutputStream(new PacketOutputStream(this.out, this.debug));
        this.m_http.start();
    }

    protected void close(boolean locking) throws IOException {
        if (!locking) {
            long t = 0L;
            if (this.debug) {
                System.out.println("Closing");
                t = System.currentTimeMillis();
            }
            if (!this.lockConnection) {
                if (this.socket != null) {
                    if (this.debug) {
                        System.out.println("Closing socket=" + this.socket);
                    }
                    this.socket.close();
                }
            } else {
                --this.lockSocketRef;
                if (this.lockSocketRef == 0) {
                    if (this.debug) {
                        System.out.println("Closing lock socket=" + this.lockSocket);
                    }
                    this.lockSocket.close();
                }
            }
            this.socket = null;
            if (this.m_http != null) {
                this.m_http.stop();
                this.m_http = null;
            }
            if (this.debug) {
                System.out.println(" Closed in " + (System.currentTimeMillis() - t) + "ms");
            }
        }
    }

    protected void getException() throws IOException {
        String msg;
        int code;
        boolean failed = true;
        try {
            if (this.debug) {
                System.out.println("EXCEPTION");
                long l = System.currentTimeMillis();
            }
            code = this.in.readInt();
            msg = this.in.readUTF();
            if (this.debug) {
                System.out.println(" Got code " + code);
                System.out.println(" Got message " + msg);
            }
            failed = false;
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
        if (!failed) {
            throw new RemoteException(msg, code);
        }
    }

    protected void parameterDirection(boolean paramsAreUpdate, boolean scalarType) throws IOException {
        try {
            int type = 40;
            if (!scalarType && paramsAreUpdate) {
                type = 41;
            }
            this.out.writeShort(type);
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
    }

    public void registerListener(String host, int port) throws IOException {
        this.connect(this.lockConnection);
        try {
            if (this.m_tunnel) {
                if (this.m_tunnelEvent == null) {
                    this.m_tunnelEvent = new HttpEventListener(this.m_tunnelURL, this.hostName, this.hostPort, this.debug);
                    this.m_tunnelEvent.setup(host, port);
                    this.m_tunnelEvent.start();
                }
            } else {
                if (this.debug) {
                    System.out.println("Registering non-queued listener");
                }
                this.out.writeByte(54);
                this.out.writeUTF(host);
                this.out.writeInt(port);
                this.out.writeByte(0);
                this.out.flush();
                this.in.readInt();
                byte status = this.in.readByte();
                byte ack = this.in.readByte();
                switch (ack) {
                    case 40: {
                        break;
                    }
                    case 53: {
                        this.getException();
                        break;
                    }
                    case 41: {
                        throw new RemoteException("Server denied listener registration");
                    }
                    default: {
                        throw new RemoteException("Unknown opcode " + ack);
                    }
                }
                this.m_listenerHandle = this.in.readInt();
                if (this.debug) {
                    System.out.println("Listener handle = " + this.m_listenerHandle);
                }
                this.processEvents(status);
            }
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
        this.close(this.lockConnection);
    }

    public void deregisterListener() throws IOException {
        if (this.m_listenerHandle == 0) {
            return;
        }
        this.connect(this.lockConnection);
        try {
            this.out.writeInt(this.m_listenerHandle);
            this.out.flush();
            this.in.readInt();
            byte status = this.in.readByte();
            byte ack = this.in.readByte();
            switch (ack) {
                case 40: {
                    break;
                }
                case 53: {
                    this.getException();
                    break;
                }
                case 41: {
                    throw new RemoteException("Listener not deregistered");
                }
                default: {
                    throw new RemoteException("Unknown opcode " + ack);
                }
            }
            this.processEvents(status);
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            this.close(this.lockConnection);
            throw new IOException(ex.getMessage());
        }
        this.close(this.lockConnection);
        this.m_listenerHandle = 0;
        if (this.m_tunnelEvent != null) {
            this.m_tunnelEvent.stop();
            this.m_tunnelEvent = null;
        }
        if (this.m_queueSocket != null) {
            this.m_queueSocket.close();
        }
        this.m_queueSocket = null;
        this.m_queueOut = null;
        this.m_queueHandle = 0;
    }

    protected synchronized void processEvents(byte status) throws Exception {
        byte[] buf;
        if ((status & 1) == 0) {
            return;
        }
        if (this.debug) {
            System.out.println("Processing piggy backed events");
        }
        int len = this.in.readInt();
        Vector<byte[]> v = new Vector<byte[]>();
        while (len != 0) {
            int bytesRead;
            if (this.debug) {
                System.out.println(" event packet length = " + len);
            }
            if ((bytesRead = this.in.read(buf = new byte[len])) != len) {
                throw new Exception("Error reading event");
            }
            v.addElement(buf);
            len = this.in.readInt();
            if (len != 0 || !this.debug) continue;
            System.out.println(" end of events");
        }
        for (int i = 0; i < v.size(); ++i) {
            buf = (byte[])v.elementAt(i);
            if (this.debug) {
                System.out.println("Sending event " + i + " to listener");
            }
            this.m_queueOut.writeInt(buf.length);
            this.m_queueOut.write(buf);
        }
        v.removeAllElements();
    }

    public void sequenceComplete(int sequence) {
        this.finishedSequence = sequence;
    }

    protected void waitForEventCompletion() throws IOException {
        String mthName = "waitForEventCompletion";
        boolean printed = false;
        int waitTime = 5;
        int maxTime = 10000;
        boolean done = false;
        while (!done) {
            if (this.finishedSequence > this.eventSequence + 28672 || this.finishedSequence < this.eventSequence) {
                try {
                    if (!printed) {
                        this._p(mthName + ":block, sleep, waiting on event completion");
                        printed = true;
                    }
                    Thread.sleep(waitTime);
                    if ((maxTime -= waitTime) > 0) continue;
                    done = true;
                }
                catch (Exception exception) {}
                continue;
            }
            done = true;
        }
        if (maxTime <= 0 && this.debug) {
            this._p(mthName + ":Timeout waiting for " + this.eventSequence + ", highest was " + this.finishedSequence);
        }
        if (printed) {
            this._p(mthName + ":event actions complete");
        }
    }

    public void setTraceProxyClient(boolean tpc) {
        this.m_tpc = tpc;
    }

    private void _p(String s) {
        if (this.m_tpc) {
            System.out.println(this.getClass().getName() + "::" + s);
        }
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public short readType() throws IOException {
        return this.in.readShort();
    }

    public int readLen() throws IOException {
        return this.in.readInt();
    }

    public int readSequence() throws IOException {
        return this.in.readInt();
    }

    public boolean isString(short type) {
        boolean b = false;
        if (type == 1 || type == 10) {
            b = true;
        }
        return b;
    }

    public boolean isStringArray(short type) {
        boolean b = false;
        if (type == 3 || type == 11) {
            b = true;
        }
        return b;
    }

    public boolean isDouble(short type) {
        boolean b = false;
        if (type == 2) {
            b = true;
        }
        return b;
    }

    public boolean isDoubleArray(short type) {
        boolean b = false;
        if (type == 4 || type == 12) {
            b = true;
        }
        return b;
    }

    public boolean isList(short type) {
        boolean b = false;
        if (type == 8 || type == 9) {
            b = true;
        }
        return b;
    }

    public String readString(short type) throws IOException {
        String ret = null;
        if (!this.isString(type)) {
            throw new IOException("Expecting String; got " + type);
        }
        if (type == 1) {
            ret = this.in.readUTF();
        }
        return ret;
    }

    public String[] readStringArray(short type) throws IOException {
        String[] ret = null;
        if (!this.isStringArray(type)) {
            throw new IOException("Expecting String array; got " + type);
        }
        if (type == 3) {
            int count = this.in.readShort();
            ret = new String[count];
            for (int i = 0; i < count; ++i) {
                ret[i] = this.in.readUTF();
            }
        }
        return ret;
    }

    public double readDouble(short type) throws IOException {
        double ret = 0.0;
        if (!this.isDouble(type)) {
            throw new IOException("Expecting double; got " + type);
        }
        ret = this.in.readDouble();
        return ret;
    }

    public double[] readDoubleArray(short type) throws IOException {
        double[] ret = null;
        if (!this.isDoubleArray(type)) {
            throw new IOException("Expecting double array; got " + type);
        }
        if (type == 4) {
            int count = this.in.readShort();
            ret = new double[count];
            for (int i = 0; i < count; ++i) {
                ret[i] = this.in.readDouble();
            }
        }
        return ret;
    }

    public HListInterface readList(short type) throws IOException {
        int len;
        HList list = null;
        if (!this.isList(type)) {
            throw new IOException("Expecting HLIST; got " + type);
        }
        if (type == 8 && (len = this.in.readInt()) > 0) {
            list = new HList();
            this.readList((HListInterface)list, len);
        }
        return list;
    }

    public void writeSequence(int s) throws IOException {
        this.out.writeInt(s);
    }

    public void write(String s) throws IOException {
        if (s == null) {
            this.out.writeShort(10);
        } else {
            this.out.writeShort(1);
            this.out.writeUTF(s);
        }
    }

    public void write(String[] s) throws IOException {
        if (s == null) {
            this.out.writeShort(11);
        } else {
            this.out.writeShort(3);
            this.out.writeShort(s.length);
            for (int i = 0; i < s.length; ++i) {
                this.out.writeUTF(s[i]);
            }
        }
    }

    public void write(double d) throws IOException {
        this.out.writeShort(2);
        this.out.writeDouble(d);
    }

    public void write(double[] d) throws IOException {
        if (d == null) {
            this.out.writeShort(12);
        } else {
            this.out.writeShort(4);
            this.out.writeShort(d.length);
            for (int i = 0; i < d.length; ++i) {
                this.out.writeDouble(d[i]);
            }
        }
    }

    public void write(HListInterface l) throws IOException {
        this.writeList(l, false, false);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void setRocf(Rocf rocf) {
        this.m_rocf = rocf;
    }

    public void setContext(Connection ctxt) {
        this.m_ctxt = ctxt;
    }

    public Object objectMethod(Class c) throws IOException {
        Object o = null;
        try {
            o = this.m_rocf.newInstance(c, this.m_ctxt, null, this.intMethod());
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        return o;
    }

    private void waitOff() {
        this.m_needToWait = false;
    }

    private void waitOn() throws IOException {
        this.eventSequence = this.in.readInt();
        this.m_needToWait = true;
    }

    private boolean needWait() {
        return this.m_needToWait;
    }

    protected void setStatusWorking(String status) {
        if (this.m_ctxt != null) {
            this.m_ctxt.fireStatusEvent(0, status);
        }
    }

    protected void setStatusSuccess() {
        if (this.m_ctxt != null) {
            this.m_ctxt.fireStatusEvent(1, "Success");
        }
    }

    protected void setStatusFailed(String msg) {
        if (this.m_ctxt != null) {
            this.m_ctxt.fireStatusEvent(2, "Failure: " + msg);
        }
    }
}

