/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.Connection;
import com.sas.rmi.RemoteBaseClient;
import java.io.IOException;

public class RemoteSetupThread
extends Thread {
    private RemoteBaseClient m_client;
    private Connection m_context;
    private RemoteSetupThread m_waitOnSetup = null;
    private RemoteSetupThread m_waiterSetup = null;

    public RemoteSetupThread(RemoteBaseClient client, Connection context) {
        this.m_client = client;
        this.m_context = context;
        this.m_client._RemoteObject_setSetupState(RemoteBaseClient.SETUP_RUNNING);
        this.m_client._RemoteObject_setSetupStatus("Remote Object setup started");
    }

    public void setSetupToWaitOn(RemoteSetupThread t) {
        this.m_waitOnSetup = t;
    }

    public void setSetupWaiter(RemoteSetupThread t) {
        this.m_waiterSetup = t;
    }

    public boolean hasSetupWaiter() {
        boolean rc = false;
        if (this.m_waiterSetup != null) {
            rc = true;
        }
        return rc;
    }

    @Override
    public void run() {
        if (this.m_waitOnSetup != null) {
            while (this.m_waitOnSetup.isAlive()) {
                try {
                    RemoteSetupThread.sleep(5L);
                }
                catch (Exception exception) {}
            }
        }
        try {
            this.m_client._RemoteObject_setup(this.m_context);
            this.m_client._RemoteObject_setSetupState(RemoteBaseClient.SETUP_COMPLETE);
            this.m_client._RemoteObject_setSetupStatus("Remote Object setup complete");
        }
        catch (Exception e) {
            this.m_client._RemoteObject_setSetupException(e);
            this.m_client._RemoteObject_broadcast(new IOException(e.toString()));
            this.m_client._RemoteObject_setSetupStatus("Remote Object setup failed");
        }
    }

    public RemoteBaseClient getClient() {
        return this.m_client;
    }

    public Connection getContext() {
        return this.m_context;
    }
}

