/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorBaseTarget;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.RemoteRuntimeTemplate;
import com.sas.rmi.Template;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class RemoteRuntimeGeneratorTarget
extends CodeGeneratorBaseTarget {
    protected Hashtable dataTypes = new Hashtable();

    @Override
    public String getGeneratorName() {
        return "Run_Time";
    }

    public RemoteRuntimeGeneratorTarget() {
        this.dataTypes.put("java.lang.String", "_getStringValue");
        this.dataTypes.put("int", "_getIntValue");
        this.dataTypes.put("com.sas.collection.hlist.HListInterface", "_getListValue");
        this.dataTypes.put("double[]", "_getDoubleA1Value");
        this.dataTypes.put("int[]", "_getIntA1Value");
        this.dataTypes.put("java.lang.String[]", "_getStringA1Value");
        this.dataTypes.put("double", "_getdoubleValue");
    }

    @Override
    public Template getTemplate() {
        return new RemoteRuntimeTemplate();
    }

    @Override
    public String getTargetName(String sourceName) {
        return "NO LONGER SUPPORTED";
    }

    @Override
    public void generateMethodCode(Class source, Method method, CodeGeneratorOutputStream out) throws Exception {
        int j;
        int modifier = method.getModifiers();
        if (!Modifier.isPublic(modifier) || Modifier.isFinal(modifier)) {
            return;
        }
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        out.println("");
        out.println("// " + method.getName(), 1);
        String s = "public " + ret + " " + method.getName() + "(";
        out.println(s, 1);
        Class<?>[] params = method.getParameterTypes();
        String p = "";
        for (j = 0; j < params.length; ++j) {
            s = CodeGenerator.convertType(params[j].getName()) + " p" + (j + 1);
            p = p + "p" + (j + 1);
            if (j + 1 < params.length) {
                s = s + ",";
                p = p + ",";
            }
            out.println(s, 2);
        }
        out.println(")", 1);
        Class<?>[] exceptions = method.getExceptionTypes();
        for (j = 0; j < exceptions.length; ++j) {
            s = "";
            if (j == 0) {
                s = "throws ";
            }
            s = s + exceptions[j].getName();
            if (j + 1 < exceptions.length) {
                s = s + ",";
            }
            out.println(s, 3);
        }
        out.println("{", 2);
        if (method.getName().startsWith("set") && ret.equals("void") && method.getName().length() > 3 && params.length == 1) {
            out.println("_setValue(\"" + method.getName().substring(3) + "\", p1);", 3);
        } else if (method.getName().startsWith("get") && !ret.equals("void") && method.getName().length() > 3 && params.length == 0) {
            String methodName = (String)this.dataTypes.get(ret);
            if (methodName == null) {
                throw new Exception("Unsupported type: " + ret);
            }
            out.println("return " + methodName + "(\"" + method.getName().substring(3) + "\");", 3);
        } else if (!ret.equals("void")) {
            if (ret.equals("double") || ret.equals("byte") || ret.equals("char") || ret.equals("boolean") || ret.equals("short") || ret.equals("int") || ret.equals("long") || ret.equals("float")) {
                out.println("return 0;", 3);
            } else {
                out.println("return null;", 3);
            }
        }
        out.println("}", 2);
    }
}

