/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.RMIClientTemplate;
import com.sas.rmi.RMIRemoteTemplate;
import com.sas.rmi.RMIServerTemplate;
import com.sas.rmi.RocfClass;
import com.sas.rmi.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;

class RMIGeneratorEngine {
    Class mSourceClass = null;
    boolean mOverwriteSource = false;
    PrintStream mVerbosePrintStream = null;
    String mClassName = null;
    String mPackageName = null;
    String mDir = null;
    int mIfLevel = 0;
    boolean[] bWrite = new boolean[20];
    int nExclude = 0;
    String[] mExclude = new String[20];
    String mClassPrefix = "Remote";
    String mClientSuffix = "Client";
    String mServerSuffix = "Server";
    String mSourceExtension = ".java";
    String mInterfaceName;
    String mClientName;
    String mServerName;
    String mInterfaceFileName;
    FileOutputStream mInterfaceFile = null;
    String mClientFileName;
    FileOutputStream mClientFile = null;
    String mServerFileName;
    FileOutputStream mServerFile = null;

    public RMIGeneratorEngine(Class sourceClass, boolean overwriteSource, PrintStream verbosePrintStream) {
        this.mSourceClass = sourceClass;
        this.mOverwriteSource = overwriteSource;
        this.mVerbosePrintStream = verbosePrintStream;
    }

    public RMIGeneratorEngine(Class sourceClass, boolean overwriteSource) {
        this.mSourceClass = sourceClass;
        this.mOverwriteSource = overwriteSource;
    }

    public RMIGeneratorEngine(Class sourceClass) {
        this.mSourceClass = sourceClass;
    }

    public boolean generate() {
        boolean failed = this.validateClass();
        if (!failed) {
            this.setNames();
            failed = this.createFiles();
        }
        if (!failed) {
            try {
                failed = this.generate(new RMIRemoteTemplate(), this.mInterfaceFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                failed = true;
            }
        }
        if (!failed) {
            try {
                failed = this.generate(new RMIClientTemplate(), this.mClientFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                failed = true;
            }
        }
        if (!failed) {
            try {
                failed = this.generate(new RMIServerTemplate(), this.mServerFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                failed = true;
            }
        }
        this.cleanup();
        return failed;
    }

    public void setDirectory(String dir) {
        this.mDir = dir;
    }

    protected boolean generate(Template t, FileOutputStream out) throws Exception {
        boolean failed = false;
        String[] template = t.getTemplate();
        String separator = "%";
        this.nExclude = 0;
        this.mIfLevel = 0;
        this.bWrite[this.mIfLevel] = true;
        for (int line = 0; line < template.length && !failed; ++line) {
            String trimLine = template[line].trim();
            if (trimLine.startsWith("#")) continue;
            int startPos = template[line].indexOf(separator);
            while (startPos >= 0) {
                int endPos = template[line].indexOf(separator, startPos + 1);
                if (endPos >= 0) {
                    if (startPos > 0) {
                        this.print(out, template[line].substring(0, startPos));
                    }
                    String tag = template[line].substring(startPos + 1, endPos);
                    failed = this.processTag(out, tag);
                    if (endPos + 1 < template[line].length()) {
                        template[line] = template[line].substring(endPos + 1);
                        startPos = template[line].indexOf(separator);
                        continue;
                    }
                    startPos = -1;
                    template[line] = "";
                    continue;
                }
                startPos = -1;
            }
            this.println(out, template[line]);
        }
        return failed;
    }

    protected boolean processTag(FileOutputStream out, String tag) throws Exception {
        boolean failed = false;
        String uTag = tag.toUpperCase();
        if (tag.equalsIgnoreCase("NAME")) {
            this.print(out, this.mClassName);
        } else if (tag.equalsIgnoreCase("PACKAGE")) {
            if (this.mPackageName != null) {
                this.print(out, "package " + this.mPackageName + ";");
            }
        } else if (tag.equalsIgnoreCase("TIMESTAMP")) {
            this.print(out, new Date().toString());
        } else if (tag.equalsIgnoreCase("INTERFACES")) {
            this.createInterfaces(out);
        } else if (tag.equalsIgnoreCase("INTERFACE")) {
            this.createInterfaceNames(out, false);
        } else if (tag.equalsIgnoreCase("INTERFACE,")) {
            this.createInterfaceNames(out, true);
        } else if (tag.equalsIgnoreCase("CLIENT_METHODS")) {
            this.createClientMethods(out);
        } else if (tag.equalsIgnoreCase("SERVER_METHODS")) {
            this.createServerMethods(out);
        } else if (uTag.startsWith("IF")) {
            ++this.mIfLevel;
            this.bWrite[this.mIfLevel] = this.ifMacro(tag.substring(2));
        } else if (uTag.startsWith("EXCLUDE ")) {
            String intf = tag.substring(8).trim();
            if (this.implementsInterface(intf)) {
                this.mExclude[this.nExclude] = intf;
                this.sendToOutput("Excluding interface " + this.mExclude[this.nExclude]);
                ++this.nExclude;
            } else {
                this.sendToOutput("Interface " + intf + " specified to EXCLUDE, but it is not implemented");
            }
        } else if (tag.equalsIgnoreCase("ENDIF")) {
            if (this.mIfLevel > 0) {
                --this.mIfLevel;
            } else {
                this.sendToOutput("Unmatched %ENDIF%");
                failed = true;
            }
        } else {
            failed = true;
            this.print(out, " <<Unknown tag " + tag + ">> ");
        }
        return failed;
    }

    protected boolean ifMacro(String macro) {
        int index;
        boolean rc = false;
        boolean Not = false;
        String org = macro;
        String uMacro = (macro = macro.trim()).toUpperCase();
        if (uMacro.startsWith("NOT")) {
            Not = true;
            macro = macro.substring(3).trim();
        } else if (uMacro.startsWith("!")) {
            Not = true;
            macro = macro.substring(1).trim();
        }
        if (!macro.startsWith("(")) {
            this.sendToOutput("Malformed %IF macro: " + org);
            return false;
        }
        uMacro = (macro = macro.substring(1).trim()).toUpperCase();
        if (uMacro.startsWith("INTERFACE")) {
            if (!(macro = macro.substring(9).trim()).startsWith("(")) {
                this.sendToOutput("Malformed INTERFACE directive: " + org);
                return false;
            }
            index = (macro = macro.substring(1).trim()).indexOf(")");
            if (index == -1) {
                this.sendToOutput("Malformed INTERFACE directive: " + org);
                return false;
            }
        } else {
            this.sendToOutput("Unknown %IF directive: " + org);
            return false;
        }
        String intf = macro.substring(0, index).trim();
        rc = this.implementsInterface(intf);
        if (Not && rc) {
            rc = false;
        } else if (Not && !rc) {
            rc = true;
        }
        return rc;
    }

    protected boolean createInterfaceNames(FileOutputStream out, boolean comma) {
        boolean failed = false;
        String s = "";
        Class<?>[] interfaces = this.mSourceClass.getInterfaces();
        try {
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    s = s + ", ";
                }
                s = s + this.stripPackage(interfaces[i].getName(), this.mPackageName);
            }
            if (s.length() > 0) {
                if (comma) {
                    s = s + ", ";
                }
                this.print(out, s);
            }
        }
        catch (Exception ex) {
            failed = true;
        }
        return failed;
    }

    protected boolean implementsInterface(String intf) {
        boolean rc = false;
        Class<?>[] interfaces = this.mSourceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!intf.equals(interfaces[i].getName())) continue;
            rc = true;
            break;
        }
        return rc;
    }

    protected boolean excludeMethod(String name) {
        boolean rc = false;
        for (int i = 0; i < this.nExclude; ++i) {
            try {
                Method[] methods;
                Class c = RocfClass.forName(this.mExclude[i]);
                if (c == null || !c.isInterface() || (methods = c.getDeclaredMethods()) == null) continue;
                for (int j = 0; j < methods.length; ++j) {
                    if (!name.equals(methods[j].getName())) continue;
                    this.sendToOutput("Excluding method " + methods[j].getName());
                    return true;
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rc;
    }

    protected String stripPackage(String name, String pkg) {
        String temp;
        String s = name;
        if (pkg != null && name.startsWith(pkg) && (temp = name.substring(pkg.length())).startsWith(".") && (temp = temp.substring(1)).indexOf(".") == -1) {
            s = temp;
        }
        return s;
    }

    protected boolean createInterfaces(FileOutputStream out) throws Exception {
        Method[] methods;
        Class<?>[] exceptions;
        String s;
        int j;
        String p;
        Class<?>[] params;
        boolean failed = false;
        Constructor<?>[] constructors = this.mSourceClass.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            params = constructors[i].getParameterTypes();
            this.println(out, "");
            this.println(out, "// " + this.mInterfaceName + "Constructor", 1);
            this.println(out, "public void " + this.mInterfaceName + "Constructor(", 1);
            p = "";
            params = constructors[i].getParameterTypes();
            for (j = 0; j < params.length; ++j) {
                s = this.convertType(params[j].getName()) + " p" + (j + 1);
                p = p + "p" + (j + 1);
                if (j + 1 < params.length) {
                    s = s + ",";
                    p = p + ",";
                }
                this.println(out, s, 2);
            }
            this.println(out, ")", 1);
            this.println(out, "throws Exception, java.rmi.RemoteException", 1);
            exceptions = constructors[i].getExceptionTypes();
            for (j = 0; j < exceptions.length; ++j) {
                this.println(out, exceptions[j].getName(), 3);
            }
            this.println(out, ";", 1);
        }
        if (constructors.length == 0) {
            this.println(out, "");
            this.println(out, "// " + this.mInterfaceName + "Constructor", 1);
            this.println(out, "public void " + this.mInterfaceName + "Constructor() throws Exception, java.rmi.RemoteException;", 1);
        }
        if ((methods = this.mSourceClass.getDeclaredMethods()) == null) {
            return false;
        }
        this.sendToOutput("Creating public methods");
        for (int i = 0; i < methods.length; ++i) {
            int modifier;
            if (this.excludeMethod(methods[i].getName()) || !Modifier.isPublic(modifier = methods[i].getModifiers()) || Modifier.isFinal(modifier)) continue;
            Class<?> rt = methods[i].getReturnType();
            String ret = this.convertType(rt.getName());
            this.println(out, "");
            this.println(out, "// " + methods[i].getName(), 1);
            s = ret + " " + methods[i].getName() + "(";
            this.println(out, s, 1);
            params = methods[i].getParameterTypes();
            p = "";
            for (j = 0; j < params.length; ++j) {
                s = this.convertType(params[j].getName()) + " p" + (j + 1);
                p = p + "p" + (j + 1);
                if (j + 1 < params.length) {
                    s = s + ",";
                    p = p + ",";
                }
                this.println(out, s, 2);
            }
            this.println(out, ")", 1);
            s = "throws  Exception, java.rmi.RemoteException";
            this.println(out, s, 1);
            exceptions = methods[i].getExceptionTypes();
            for (j = 0; j < exceptions.length; ++j) {
                s = ", " + exceptions[j].getName();
                this.println(out, s, 3);
            }
            this.println(out, ";", 1);
        }
        return failed;
    }

    protected boolean createClientMethods(FileOutputStream out) throws Exception {
        Method[] methods;
        Class<?>[] exceptions;
        String s;
        int j;
        String p;
        Class<?>[] params;
        boolean failed = false;
        Constructor<?>[] constructors = this.mSourceClass.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            params = constructors[i].getParameterTypes();
            this.println(out, "");
            this.println(out, "// " + this.mInterfaceName + "Constructor", 1);
            this.println(out, "public void " + this.mInterfaceName + "Constructor(", 1);
            p = "";
            params = constructors[i].getParameterTypes();
            for (j = 0; j < params.length; ++j) {
                s = this.convertType(params[j].getName()) + " p" + (j + 1);
                p = p + "p" + (j + 1);
                if (j + 1 < params.length) {
                    s = s + ",";
                    p = p + ",";
                }
                this.println(out, s, 2);
            }
            this.println(out, ")", 1);
            this.println(out, "throws Exception, java.rmi.RemoteException", 1);
            exceptions = constructors[i].getExceptionTypes();
            for (j = 0; j < exceptions.length; ++j) {
                this.println(out, exceptions[j].getName(), 3);
            }
            this.println(out, "{", 1);
            this.println(out, "}", 1);
            this.println(out, "", 1);
            this.println(out, "// newRemoteObject", 1);
            this.println(out, "public void newRemoteObject(", 1);
            p = "";
            params = constructors[i].getParameterTypes();
            for (j = 0; j < params.length; ++j) {
                s = this.convertType(params[j].getName()) + " p" + (j + 1);
                p = p + "p" + (j + 1);
                if (j + 1 < params.length) {
                    s = s + ",";
                    p = p + ",";
                }
                this.println(out, s, 2);
            }
            this.println(out, ")", 1);
            this.println(out, "throws Exception", 1);
            exceptions = constructors[i].getExceptionTypes();
            for (j = 0; j < exceptions.length; ++j) {
                this.println(out, exceptions[j].getName(), 3);
            }
            this.println(out, "{", 1);
            this.println(out, "mObject." + this.mInterfaceName + "Constructor(" + p + ");", 2);
            this.println(out, "}", 1);
        }
        if (constructors.length == 0) {
            this.println(out, "");
            this.println(out, "// " + this.mInterfaceName + "Constructor", 1);
            this.println(out, "public void " + this.mInterfaceName + "Constructor() throws Exception, java.rmi.RemoteException", 1);
            this.println(out, "{", 1);
            this.println(out, "}", 1);
            this.println(out, "");
            this.println(out, "// newRemoteObject", 1);
            this.println(out, "public void newRemoteObject() throws Exception", 1);
            this.println(out, "{", 1);
            this.println(out, "mObject." + this.mInterfaceName + "Constructor();", 2);
            this.println(out, "}", 1);
        }
        if ((methods = this.mSourceClass.getDeclaredMethods()) == null) {
            return false;
        }
        for (int i = 0; i < methods.length; ++i) {
            int modifier;
            if (this.excludeMethod(methods[i].getName()) || !Modifier.isPublic(modifier = methods[i].getModifiers()) || Modifier.isFinal(modifier)) continue;
            Class<?> rt = methods[i].getReturnType();
            String ret = this.convertType(rt.getName());
            this.println(out, "");
            this.println(out, "// " + methods[i].getName(), 1);
            s = "public " + ret + " " + methods[i].getName() + "(";
            this.println(out, s, 1);
            params = methods[i].getParameterTypes();
            p = "";
            for (j = 0; j < params.length; ++j) {
                s = this.convertType(params[j].getName()) + " p" + (j + 1);
                p = p + "p" + (j + 1);
                if (j + 1 < params.length) {
                    s = s + ",";
                    p = p + ",";
                }
                this.println(out, s, 2);
            }
            this.println(out, ")", 1);
            s = "throws  Exception, java.rmi.RemoteException";
            this.println(out, s, 1);
            exceptions = methods[i].getExceptionTypes();
            for (j = 0; j < exceptions.length; ++j) {
                s = ", " + exceptions[j].getName();
                this.println(out, s, 3);
            }
            this.println(out, "{", 1);
            s = "";
            if (!ret.equals("void")) {
                s = "return ";
            }
            s = s + "mObject." + methods[i].getName() + "(" + p + ");";
            this.println(out, s, 2);
            this.println(out, "}", 1);
        }
        return failed;
    }

    protected boolean createServerMethods(FileOutputStream out) throws Exception {
        Method[] methods;
        Class<?>[] exceptions;
        String s;
        int j;
        String p;
        Class<?>[] params;
        boolean failed = false;
        Constructor<?>[] constructors = this.mSourceClass.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            params = constructors[i].getParameterTypes();
            this.println(out, "");
            this.println(out, "// " + this.mInterfaceName + "Constructor", 1);
            this.println(out, "public void " + this.mInterfaceName + "Constructor(", 1);
            p = "";
            params = constructors[i].getParameterTypes();
            for (j = 0; j < params.length; ++j) {
                s = this.convertType(params[j].getName()) + " p" + (j + 1);
                p = p + "p" + (j + 1);
                if (j + 1 < params.length) {
                    s = s + ",";
                    p = p + ",";
                }
                this.println(out, s, 2);
            }
            this.println(out, ")", 1);
            this.println(out, "throws Exception, java.rmi.RemoteException", 1);
            exceptions = constructors[i].getExceptionTypes();
            for (j = 0; j < exceptions.length; ++j) {
                this.println(out, exceptions[j].getName(), 3);
            }
            this.println(out, "{", 1);
            this.println(out, "if (mTracing) System.out.println(\"Instantiating " + this.mClassName + "\");", 2);
            this.println(out, "mObject = new " + this.mClassName + "(" + p + ");", 2);
            this.println(out, "}", 1);
        }
        if (constructors.length == 0) {
            this.println(out, "");
            this.println(out, "// " + this.mInterfaceName + "Constructor", 1);
            this.println(out, "public void " + this.mInterfaceName + "Constructor() throws Exception, java.rmi.RemoteException", 1);
            this.println(out, "{", 1);
            this.println(out, "mObject = new " + this.mClassName + "();", 2);
            this.println(out, "}", 1);
        }
        if ((methods = this.mSourceClass.getDeclaredMethods()) == null) {
            return false;
        }
        for (int i = 0; i < methods.length; ++i) {
            int modifier;
            if (this.excludeMethod(methods[i].getName()) || !Modifier.isPublic(modifier = methods[i].getModifiers()) || Modifier.isFinal(modifier)) continue;
            Class<?> rt = methods[i].getReturnType();
            String ret = this.convertType(rt.getName());
            this.println(out, "");
            this.println(out, "// " + methods[i].getName(), 1);
            s = "public " + ret + " " + methods[i].getName() + "(";
            this.println(out, s, 1);
            params = methods[i].getParameterTypes();
            p = "";
            for (j = 0; j < params.length; ++j) {
                s = this.convertType(params[j].getName()) + " p" + (j + 1);
                p = p + "p" + (j + 1);
                if (j + 1 < params.length) {
                    s = s + ",";
                    p = p + ",";
                }
                this.println(out, s, 2);
            }
            this.println(out, ")", 1);
            s = "throws  Exception, java.rmi.RemoteException";
            this.println(out, s, 1);
            exceptions = methods[i].getExceptionTypes();
            for (j = 0; j < exceptions.length; ++j) {
                s = ", " + exceptions[j].getName();
                this.println(out, s, 3);
            }
            this.println(out, "{", 1);
            this.println(out, "if (mTracing) System.out.println(\"Calling " + methods[i].getName() + "\");", 2);
            s = "";
            if (!ret.equals("void")) {
                s = "return ";
            }
            s = s + "mObject." + methods[i].getName() + "(" + p + ");";
            this.println(out, s, 2);
            this.println(out, "}", 1);
        }
        return failed;
    }

    protected boolean validateClass() {
        String invalidType = null;
        boolean failed = false;
        this.sendToOutput("Validating class file");
        if (this.mSourceClass == null) {
            invalidType = "null";
        } else if (this.mSourceClass.isArray()) {
            invalidType = "array";
        } else if (this.mSourceClass.isInterface()) {
            invalidType = "interface";
        } else if (this.mSourceClass.isPrimitive()) {
            invalidType = "primitive type";
        }
        if (invalidType != null) {
            this.sendToOutput("\nInvalid class type: " + invalidType);
            failed = true;
        }
        return failed;
    }

    protected void setNames() {
        String name = this.mSourceClass.getName();
        int pos = name.lastIndexOf(".");
        if (pos < 0) {
            this.mClassName = name;
        } else {
            this.mPackageName = name.substring(0, pos);
            this.mClassName = name.substring(pos + 1);
        }
    }

    protected String getFilePrefix() {
        String s = "";
        if (this.mDir != null && !(s = s + this.mDir.trim()).endsWith("/") && !s.endsWith("\\")) {
            s = s + "/";
        }
        if (this.mPackageName != null && !(s = s + this.mPackageName.replace('.', '/')).endsWith("/") && !s.endsWith("\\")) {
            s = s + "/";
        }
        return s;
    }

    protected boolean createFiles() {
        boolean failed = false;
        try {
            this.mInterfaceName = this.mClassPrefix + this.mClassName;
            String name = this.getFilePrefix() + this.mInterfaceName + this.mSourceExtension;
            this.sendToOutput("Creating " + name);
            File f = new File(name);
            if (f.exists()) {
                if (this.mOverwriteSource) {
                    f.delete();
                } else {
                    throw new IOException(name + " already exists");
                }
            }
            this.mInterfaceFileName = name;
            this.mInterfaceFile = new FileOutputStream(f);
            this.mClientName = this.mClassPrefix + this.mClassName + this.mClientSuffix;
            name = this.getFilePrefix() + this.mClientName + this.mSourceExtension;
            this.sendToOutput("Creating " + name);
            f = new File(name);
            if (f.exists()) {
                if (this.mOverwriteSource) {
                    f.delete();
                } else {
                    throw new IOException(name + " already exists");
                }
            }
            this.mClientFileName = name;
            this.mClientFile = new FileOutputStream(f);
            this.mServerName = this.mClassPrefix + this.mClassName + this.mServerSuffix;
            name = this.getFilePrefix() + this.mServerName + this.mSourceExtension;
            this.sendToOutput("Creating " + name);
            f = new File(name);
            if (f.exists()) {
                if (this.mOverwriteSource) {
                    f.delete();
                } else {
                    throw new IOException(name + " already exists");
                }
            }
            this.mServerFileName = name;
            this.mServerFile = new FileOutputStream(f);
        }
        catch (IOException ex) {
            System.out.println("\nFile I/O Error: " + ex.getMessage());
            failed = true;
        }
        return failed;
    }

    protected void println(FileOutputStream fos, String line, int indent) throws Exception {
        if (this.bWrite[this.mIfLevel]) {
            for (int i = 0; i < indent; ++i) {
                this.print(fos, "  ");
            }
            this.println(fos, line);
        }
    }

    protected void println(FileOutputStream fos, String line) throws Exception {
        if (this.bWrite[this.mIfLevel]) {
            this.print(fos, line);
            fos.write(10);
        }
    }

    protected void print(FileOutputStream fos, String line) throws Exception {
        if (this.bWrite[this.mIfLevel]) {
            fos.write(line.getBytes());
        }
    }

    protected void sendToOutput(String s) {
        if (this.mVerbosePrintStream != null) {
            this.mVerbosePrintStream.println(s);
        }
    }

    protected void cleanup() {
        try {
            this.sendToOutput("Closing files");
            if (this.mInterfaceFile != null) {
                this.mInterfaceFile.close();
            }
            if (this.mClientFile != null) {
                this.mClientFile.close();
            }
            if (this.mServerFile != null) {
                this.mServerFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String convertType(String descriptor) {
        String s = descriptor;
        String a = "";
        while (descriptor.startsWith("[")) {
            a = a + "[]";
            descriptor = descriptor.substring(1);
        }
        if (a.length() > 0) {
            char field = descriptor.charAt(0);
            descriptor = descriptor.substring(1);
            switch (field) {
                case 'B': {
                    s = "byte";
                    break;
                }
                case 'C': {
                    s = "char";
                    break;
                }
                case 'D': {
                    s = "double";
                    break;
                }
                case 'F': {
                    s = "float";
                    break;
                }
                case 'I': {
                    s = "int";
                    break;
                }
                case 'J': {
                    s = "long";
                    break;
                }
                case 'L': {
                    s = descriptor.substring(0, descriptor.length() - 1);
                    break;
                }
                case 'S': {
                    s = "short";
                    break;
                }
                case 'Z': {
                    s = "boolean";
                    break;
                }
                default: {
                    s = descriptor;
                }
            }
            s = s + a;
        }
        return s;
    }
}

