/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.Connection;
import com.sas.rmi.IOMBaseClient;
import com.sas.rmi.J2Factory;
import com.sas.rmi.RMIBaseInterface;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.rmi.RocfClass;
import com.sas.rmi.RocfORB;
import com.sas.rmi.RocfORBClient;
import com.sas.rmi.RocfORBMachine;
import com.sas.rmi.RocfORBObjectDescriptor;
import com.sas.rmi.RocfORBSession;
import com.sas.rmi.RocfORBTree;
import com.sas.rmi.ServerBusyTimeoutException;
import com.sas.rmi.ServerMain;
import com.sas.rmi.SingleThreadedQueue;
import com.sas.rmi.TerminatedServerException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class RMIBaseServer
extends RocfORBTree
implements RMIBaseInterface {
    private transient Vector objVec = new Vector();
    private transient boolean mDebug = false;
    private transient String m_name = "";
    private transient String m_pkg;
    private transient String m_bindName;
    private transient Object m_delegate;
    private transient String[] m_args;
    private transient boolean m_reuseSingleDelegate = false;
    private transient Rocf m_rocf;
    private transient Connection m_connection;
    private transient boolean m_passThru;
    private transient boolean m_parsed;
    private transient String m_contextClassPath;
    private transient int count;
    private transient RocfORB m_rocforb;
    private transient boolean m_debug = false;
    private transient String m_catalog = "";
    private transient int m_sclhandle = 0;
    private transient Properties m_rop;
    private transient String activeMethod;
    private transient long methodStartTime;
    private transient String m_onm;

    @Override
    public boolean _RemoteObject_getDebug() throws RemoteException, Exception {
        return this.mDebug;
    }

    @Override
    public void _RemoteObject_setDebug(boolean t) throws RemoteException, Exception {
        this.mDebug = t;
    }

    @Override
    public void _RemoteObject_setRocforbProperties(Properties p) throws RemoteException, Exception {
        this.m_rop = p;
    }

    public Properties _RemoteObject_getRocforbProperties() throws RemoteException, Exception {
        return this.m_rop;
    }

    public Object _RMIBaseServer_getDelegate() throws RemoteException, Exception {
        this._RemoteObject_touch();
        return this.m_delegate;
    }

    public void _RMIBaseServer_setDelegate(Object o) throws RemoteException, Exception {
        this.m_delegate = o;
    }

    @Override
    public void _RemoteObject_setReuseSingleDelegate(boolean b) throws RemoteException {
        this._RMIBaseServer_setReuseSingleDelegate(b);
    }

    public void _RMIBaseServer_setReuseSingleDelegate(boolean b) {
        this.m_reuseSingleDelegate = b;
    }

    public boolean _RMIBaseServer_getReuseSingleDelegate() {
        return this.m_reuseSingleDelegate;
    }

    public void _RMIBaseServer_setArgs(String[] args) {
        this.m_args = args;
    }

    @Override
    public int _RemoteObject_stop() throws RemoteException, Exception {
        this._RemoteObject_remove();
        return 0;
    }

    public static void _RMIBaseServer_main(String modelName, String packageName, String[] args) {
    }

    static void ps(String s) {
        System.out.println("com.sas.rmi.RMIBaseServer::" + s);
    }

    void p(String s) {
        if (this.mDebug) {
            System.out.println(this.getClass().getName() + "::" + s);
        }
    }

    @Override
    public Object _RemoteObject_enter(String methodName) throws ServerBusyTimeoutException {
        return this._Rocf_getClient()._RemoteObject_enter(this.munge(methodName));
    }

    @Override
    public Object _RemoteObject_enter(String methodName, long timeout) throws ServerBusyTimeoutException {
        if (this._Rocf_getClient().getSession().qisdead()) {
            System.out.println("rbs:tse");
            throw new TerminatedServerException();
        }
        return this._Rocf_getClient()._RemoteObject_enter(this.munge(methodName), timeout);
    }

    @Override
    public void _RemoteObject_exit(String methodName, Object o) {
        this._Rocf_getClient()._RemoteObject_exit(this.munge(methodName), o);
    }

    private String munge(String methodName) {
        String mName = this._Rocf_oname() + "." + methodName;
        return mName;
    }

    @Override
    public SingleThreadedQueue _r_getSTQ() {
        return this._Rocf_getClient()._r_getSTQ();
    }

    public void _RemoteObject_broadcast(IOException e) {
        throw new RuntimeException(e.toString());
    }

    @Override
    public void _RemoteObject_setupServer(String host, int socketNum) throws RemoteException, Exception {
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void _RemoteObject_action(int actionCode) throws RemoteException, Exception {
        if (actionCode == 1) {
            try {
                this.finalize();
            }
            catch (Throwable t) {
                throw new Exception(t.toString());
            }
        }
    }

    @Override
    public void _RemoteObject_newInstance() throws RemoteException, Exception {
        ++this.count;
        String methodName = "_RemoteObject_newInstance()";
        this.p(methodName + "::Creating a remote object");
        this.p(methodName + "::Creating an instance of " + this.m_name + " as a delegate");
        this._RemoteObject_createDelegate();
    }

    @Override
    public synchronized void _RemoteObject_getInstance() throws RemoteException, Exception {
        this.p("_RemoteObject_getInstance()::Getting a remote object");
        if (this.m_delegate == null) {
            this._RemoteObject_newInstance();
        }
    }

    public synchronized void _RemoteObject_setRocfORB(RocfORB orb) {
        this.m_rocforb = orb;
    }

    public synchronized void _RemoteObject_setContext(Connection c) {
        this.m_connection = c;
    }

    public synchronized void _RemoteObject_setName(String name) {
        this.m_name = name;
    }

    @Override
    public synchronized void _RemoteObject_setCatalog(String s) throws RemoteException, Exception {
        this.m_catalog = s;
    }

    @Override
    public synchronized void _RemoteObject_setSCLHandle(int sclhandle) throws RemoteException, Exception {
        this.m_sclhandle = sclhandle;
    }

    private void _RemoteObject_createDelegate() throws RemoteException, Exception {
    }

    public void stop() {
    }

    RocfORBClient _Rocf_getClient() {
        return (RocfORBClient)this._Rocf_getParent();
    }

    void setup(RocfORBObjectDescriptor odesc) throws RemoteException {
        RocfORBClient client = this._Rocf_getClient();
        RocfORBSession session = client.getSession();
        RocfORBMachine machine = session.getMachine();
        RocfORB orb = machine.getORB();
        Rocf rocf = session.getRocf();
        Connection ctxt = client.getConnection();
        J2Factory j2f = client.getFactory();
        if (ctxt.isJ2()) {
            ctxt.setJ2Factory(j2f);
        }
        try {
            if (ctxt.isJ2()) {
                this.m_delegate = rocf.newInstance(odesc.serverObjectName, ctxt, odesc.catalog, odesc.sclhandle);
            } else if (ctxt.isIOM() || ctxt.isGMS() || ctxt.isOLAP()) {
                IOMBaseClient.iomhash(ctxt, "session client object >>");
                this.m_delegate = rocf.newInstance(odesc.serverObjectName, ctxt, odesc.catalog, odesc.sclhandle);
                IOMBaseClient.iomhash(ctxt, "session client object <<");
            } else if (ctxt.isRMI()) {
                try {
                    String className = odesc.serverObjectName;
                    this.m_delegate = RocfClass.forName(className).newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e.toString());
                }
                catch (ClassCastException e) {
                    throw new RuntimeException(e.toString());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e.toString());
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e.toString());
                }
            } else {
                throw new RuntimeException(this.getClass().getName() + ":unknown protocol:" + ctxt.getAccessMethod());
            }
            this.m_debug = this.mDebug = odesc.debug;
        }
        catch (Exception e) {
            throw new RemoteException(e.toString());
        }
    }

    public void setup(String host, int socketNum) throws IOException {
        if (this.m_debug) {
            System.out.println("MethodClient on " + host + ":" + socketNum);
        }
    }

    @Override
    public void _RemoteObject_main(String[] args) throws RemoteException, Exception {
        if (this.m_delegate instanceof ServerMain) {
            ((ServerMain)this.m_delegate).serverMain(args);
        }
    }

    private boolean invokeMain(Class c, String[] args) {
        System.out.println("invoke main:i am:" + this.getClass().getName());
        System.out.println("invoke main:invoking main on delegate:" + c.getName());
        boolean rc = false;
        String methodName = "main";
        Method m = null;
        try {
            Class[] params = new Class[]{args.getClass()};
            m = c.getDeclaredMethod(methodName, params);
        }
        catch (NoSuchMethodException ex) {
            System.out.println("\n'" + methodName + "' method not found for " + c.getName());
        }
        catch (SecurityException ex) {
            System.out.println("\nSecurity exception for " + c.getName());
            System.out.println("Error: " + ex.getMessage());
        }
        if (m != null) {
            System.out.println("Starting " + c.getName());
            Object[] a = new Object[]{args};
            try {
                m.invoke((Object)c, a);
                rc = true;
            }
            catch (InvocationTargetException ex) {
                System.out.println("\n'" + methodName + "' for " + c.getName() + " threw exception: ");
                ex.getTargetException().printStackTrace();
            }
            catch (Exception ex) {
                System.out.println("\nError invoking '" + methodName + "' for " + c.getName());
                System.out.println("Error: " + ex.getMessage());
            }
        }
        System.out.println("rc=" + rc);
        return rc;
    }

    public long _RemoteObject_entering(String methodName) {
        long retVal = 0L;
        if (this.activeMethod == null) {
            this.activeMethod = methodName;
            this.methodStartTime = System.currentTimeMillis();
            String s = this._Rocf_oname() + "." + methodName;
            this._Rocf_getClient().setRemoteMethodStartStats(s, this.methodStartTime);
        } else {
            System.out.println(this._Rocf_oname() + " multithreaded single object method references detected");
        }
        if (this.mDebug) {
            retVal = System.currentTimeMillis();
            this.p(methodName + ":Enter:" + retVal);
        }
        this._RemoteObject_touch();
        return retVal;
    }

    public void _RemoteObject_exiting(String methodName, long t1) {
        this.activeMethod = null;
        this.methodStartTime = 0L;
        this._Rocf_getClient().setRemoteMethodStopStats();
        if (this.mDebug) {
            long t2 = System.currentTimeMillis();
            long diff = t2 - t1;
            this.p(methodName + ":Exit:" + t2 + ":Elapsed:" + diff);
        }
    }

    protected long getMethodDuration() {
        if (this.methodStartTime != 0L) {
            long currentTime = System.currentTimeMillis();
            return currentTime - this.methodStartTime;
        }
        return 0L;
    }

    public void _RemoteObject_touch() {
        if (this.m_delegate == null || this.m_delegate instanceof RemoteBaseClient) {
            // empty if block
        }
    }

    @Override
    public synchronized Object _RemoteObject_getChildImpl(Object parms) throws RemoteException {
        throw new RemoteException(this.getClass().getName() + ":getChildImpl");
    }

    @Override
    public synchronized void _RemoteObject_removeImpl() throws RemoteException {
        super._RemoteObject_removeImpl();
    }

    String _Rocf_oname() {
        if (this.m_onm == null) {
            int end;
            String s = this.getClass().getName();
            int start = s.indexOf("_rprxRemote");
            if (start > 0) {
                s = s.substring(start + 11);
            }
            if ((end = s.indexOf("Server")) > 0) {
                s = s.substring(0, end);
            }
            this.m_onm = s;
        }
        return this.m_onm;
    }

    @Override
    public String toString() {
        String s;
        if (this.activeMethod != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("mm:ss");
            String duration = formatter.format(new Date(this.getMethodDuration()));
            s = this._Rocf_oname() + "{" + this.activeMethod + "," + duration + "} ";
        } else {
            s = this._Rocf_oname();
        }
        return s;
    }

    public String getActiveMethod() {
        return this.activeMethod;
    }

    public long getMethodStartTime() {
        return this.methodStartTime;
    }
}

