/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGeneratorOptions;
import com.sas.rmi.CompileCommand;
import com.sas.rmi.Connection;
import com.sas.rmi.IOMBaseClient;
import com.sas.rmi.RocfClass;
import java.lang.reflect.Field;
import java.util.Vector;

public class ProxyName {
    String m_AccessMethod;
    String m_Package;
    String m_ClassName;
    String m_compiler = "javac";
    String m_rmicompiler = "rmic";
    protected boolean m_postcompile = true;
    static final int RMI = 1;
    static final int J2 = 2;
    static final int RSCL = 3;
    static final int LOCAL = 4;
    static final int RDT = 5;
    static final int VISIBROKER = 6;
    static final int UTC = 7;
    static final int ORBIX = 8;
    static final int UTC102 = 9;
    static final int IOM = 10;
    static final int EJB = 11;
    static final int GMS = 12;
    static final int OLAP = 13;
    int m_amIndex;
    boolean m_override;
    String m_homeDir = null;
    String mSwitches;
    Vector generatorSwitches = null;
    private static String[] am = new String[]{Connection.ACCESS_METHOD_RMI, Connection.ACCESS_METHOD_RSCL, Connection.ACCESS_METHOD_J2, Connection.ACCESS_METHOD_JCONNECT, Connection.ACCESS_METHOD_J2_ALIAS1, Connection.ACCESS_METHOD_J2_ALIAS2, Connection.ACCESS_METHOD_LOCAL, Connection.ACCESS_METHOD_REMOTEDESIGNTIME, Connection.ACCESS_METHOD_VISIBROKER, Connection.ACCESS_METHOD_CORBA, "UTC", Connection.ACCESS_METHOD_ORBIX, "UTC102", Connection.ACCESS_METHOD_IOM, Connection.ACCESS_METHOD_EJB, Connection.ACCESS_METHOD_GMS, Connection.ACCESS_METHOD_OLAP};
    private static int[] ami = new int[]{1, 3, 2, 2, 2, 2, 4, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13};

    public void setCompiler(String name) {
        this.m_compiler = name;
    }

    public String getCompiler() {
        return this.m_compiler;
    }

    public void setRMICompiler(String name) {
        this.m_rmicompiler = name;
    }

    public String getRMICompiler() {
        return this.m_rmicompiler;
    }

    public String getAccessMethod() {
        return this.m_AccessMethod;
    }

    public void setAccessMethod(String s) {
        this.m_AccessMethod = s;
        this.m_amIndex = 0;
        for (int i = 0; i < am.length; ++i) {
            if (!am[i].equalsIgnoreCase(s)) continue;
            this.m_amIndex = ami[i];
            break;
        }
    }

    public boolean validAccessMethod() {
        return this.m_amIndex != 0;
    }

    String getPackage() {
        return this.m_Package;
    }

    void setPackage(String s) {
        this.m_Package = s;
    }

    void setGeneratorSwitches(String switches) {
        this.mSwitches = switches;
    }

    void setGeneratorSwitches(Vector switches) {
        this.generatorSwitches = switches;
    }

    String getGeneratorSwitches() {
        return this.mSwitches;
    }

    Vector getGeneratorSwitchesVector() {
        return this.generatorSwitches;
    }

    public void setHomeDir(String dir) {
        this.m_homeDir = dir;
    }

    public String getHomeDir() {
        return this.m_homeDir;
    }

    public void setPostcompile(boolean mode) {
        this.m_postcompile = mode;
    }

    public boolean getPostcompile() {
        return this.m_postcompile;
    }

    String getDir() {
        String dir = "";
        if (this.m_homeDir != null) {
            dir = this.m_homeDir;
            if (this.m_Package != null) {
                dir = dir + this.m_Package.replace('.', '/') + "/";
            }
        }
        return dir;
    }

    public String getClassName() {
        return this.m_ClassName;
    }

    public String getFullClassName() {
        String s = this.getClassName();
        if (this.getPackage() != null) {
            s = this.getPackage() + "." + s;
        }
        return s;
    }

    public void setClassName(String s) {
        int lio = s.lastIndexOf(46);
        if (lio >= 0) {
            this.m_ClassName = s.substring(lio + 1);
            this.setPackage(s.substring(0, lio));
        } else {
            this.m_ClassName = s;
            this.setPackage(null);
        }
        this.m_ClassName = ProxyName.removeSuffix(this.m_ClassName, "Interface");
    }

    public static String removeSuffix(String string, String suffix) {
        if (string.endsWith(suffix)) {
            return string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    public static String removePrefix(String string, String prefix) {
        if (string.startsWith(prefix)) {
            return string.substring(prefix.length());
        }
        return string;
    }

    public void setClientClassName(String className) {
        this.setClassName(className);
        if (this.m_ClassName.startsWith("_rprx")) {
            this.m_override = false;
            this.m_ClassName = ProxyName.removePrefix(this.m_ClassName, "_rprx");
        }
        if (this.m_ClassName.startsWith("Final")) {
            this.m_override = true;
            this.m_ClassName = ProxyName.removePrefix(this.m_ClassName, "Final");
        }
        this.m_ClassName = ProxyName.removeSuffix(this.m_ClassName, "Client");
        this.m_ClassName = ProxyName.removePrefix(this.m_ClassName, "");
        this.m_amIndex = 4;
        this.m_AccessMethod = Connection.ACCESS_METHOD_LOCAL;
        int amLen = am.length;
        for (int i = 0; i < amLen; ++i) {
            String amName = am[i];
            if (!this.m_ClassName.startsWith(amName)) continue;
            this.m_ClassName = ProxyName.removePrefix(this.m_ClassName, amName);
            this.m_amIndex = ami[i];
            this.m_AccessMethod = amName;
            break;
        }
    }

    public String getDelegateClassName() {
        return this.m_ClassName + "Delegate";
    }

    public String getFullDelegateClassName() {
        String s = this.getDelegateClassName();
        if (this.getPackage() != null) {
            s = this.getPackage() + "." + s;
        }
        return s;
    }

    public boolean getOverride() {
        return this.m_override;
    }

    public void setOverride(boolean b) {
        this.m_override = b;
    }

    public String getGenericProxyPrefix() {
        return this.m_override ? "Final" : "_rprx";
    }

    public String getAccessMethodPrefix() {
        String s = null;
        switch (this.m_amIndex) {
            case 4: {
                s = "";
                break;
            }
            case 2: {
                s = this.getGenericProxyPrefix() + "J2";
                break;
            }
            case 1: {
                s = this.getGenericProxyPrefix() + "Remote";
                break;
            }
            case 3: {
                s = this.getGenericProxyPrefix() + "RSCL";
                break;
            }
            case 5: {
                s = this.getGenericProxyPrefix() + "RemoteDesignTime";
                break;
            }
            case 6: {
                s = this.getGenericProxyPrefix() + "Visi";
                break;
            }
            case 7: {
                s = this.getGenericProxyPrefix() + "UTC";
                break;
            }
            case 9: {
                s = this.getGenericProxyPrefix() + "UTC102";
                break;
            }
            case 8: {
                s = this.getGenericProxyPrefix() + "Orbix";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                s = this.getGenericProxyPrefix() + "IOM";
                break;
            }
            case 11: {
                s = "";
                break;
            }
        }
        return s;
    }

    String getAccessMethodClientSuffix() {
        String s = "";
        switch (this.m_amIndex) {
            case 1: 
            case 6: 
            case 8: {
                s = "Client";
            }
        }
        return s;
    }

    public String getFullClientProxyName() {
        String s = this.getClientProxyName();
        if (this.getPackage() != null) {
            s = this.getPackage() + "." + s;
        }
        return s;
    }

    public String getFullServerProxyName() {
        String s = this.getServerProxyName();
        if (this.getPackage() != null) {
            s = this.getPackage() + "." + s;
        }
        return s;
    }

    String getClientSourceName() {
        String s = this.getClassName() + ".java";
        if (this.getPackage() != null) {
            s = this.getPackage().replace('.', '/') + "/" + s;
        }
        return s;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getClientProxyName() {
        String s = null;
        switch (this.m_amIndex) {
            case 11: {
                return this.getClassName();
            }
            case 4: {
                return this.getClassName();
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                return this.getAccessMethodPrefix() + this.getClassName() + this.getAccessMethodClientSuffix();
            }
            case 10: {
                s = this.getAccessMethodPrefix() + this.getClassName() + this.getAccessMethodClientSuffix();
                String packagePrefix = this.getPackage();
                packagePrefix = packagePrefix == null ? "" : packagePrefix + ".";
                try {
                    Class<?> clazz = Class.forName(packagePrefix + s);
                    return s;
                }
                catch (NoClassDefFoundError ncdfe) {
                    return s;
                }
                catch (Exception cnfe) {
                    int interfaceVersion = 2;
                    try {
                        while (true) {
                            String subInterfaceName = packagePrefix + this.getClassName() + "V" + interfaceVersion + "Interface";
                            Class<?> subInterface = Class.forName(subInterfaceName);
                            try {
                                String subProxyName = packagePrefix + this.getAccessMethodPrefix() + this.getClassName() + "V" + interfaceVersion;
                                Class<?> subProxy = Class.forName(subProxyName);
                                if (!IOMBaseClient.class.isAssignableFrom(subProxy)) return s;
                                return this.getAccessMethodPrefix() + this.getClassName() + "V" + interfaceVersion;
                            }
                            catch (Exception cnfe3) {
                                ++interfaceVersion;
                                continue;
                            }
                            catch (NoClassDefFoundError ncdfe) {
                                return s;
                            }
                            break;
                        }
                    }
                    catch (Exception cnfe2) {
                        return s;
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        return s;
                    }
                }
            }
        }
        return s;
    }

    boolean isRMI() {
        return this.m_amIndex == 1;
    }

    boolean isEJB() {
        return this.m_amIndex == 11;
    }

    String getInterfaceProxyName() {
        String s = null;
        if (this.isRMI()) {
            s = this.getAccessMethodPrefix() + this.getClassName();
        } else if (this.isEJB()) {
            s = this.getAccessMethodPrefix() + this.getClassName();
        }
        return s;
    }

    String getServerProxyName() {
        String s = null;
        switch (this.m_amIndex) {
            case 1: {
                s = this.getAccessMethodPrefix() + this.getClassName() + "Server";
                break;
            }
            case 6: {
                s = this.getAccessMethodPrefix() + this.getClassName() + "Server";
                break;
            }
            case 7: 
            case 9: {
                s = this.getAccessMethodPrefix() + this.getClassName() + "Server";
                break;
            }
            case 8: {
                s = this.getAccessMethodPrefix() + this.getClassName() + "Server";
            }
        }
        return s;
    }

    String packageCD() {
        String s = null;
        String p = this.getPackage();
        if (p != null) {
            s = "..";
            for (int i = 0; i < p.length(); ++i) {
                if (p.charAt(i) != '.') continue;
                s = s + "/..";
            }
        }
        if (s == null) {
            s = ".";
        }
        return s;
    }

    static String ejbhome() {
        return "Home";
    }

    static String ejbremote() {
        return "";
    }

    static String ejbbean() {
        return "Bean";
    }

    String[][] getBuildCommand() {
        boolean postCompile = this.m_postcompile;
        String[][] s = null;
        String gen = null;
        String execcmd = CompileCommand.getExecuteCommand();
        switch (this.m_amIndex) {
            case 4: {
                break;
            }
            case 2: {
                gen = "J2Generator";
                break;
            }
            case 1: {
                gen = "RMIGenerator";
                postCompile = true;
                break;
            }
            case 3: {
                gen = "RSCLGenerator";
                break;
            }
            case 5: {
                gen = "RemoteDesignTimeGenerator";
                break;
            }
            case 6: {
                gen = "VisiGenerator";
                break;
            }
            case 7: {
                gen = "UTCGenerator";
                break;
            }
            case 8: {
                gen = "OrbixGenerator";
                break;
            }
            case 9: {
                gen = "UTC102Generator";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                gen = "IOMGenerator";
                break;
            }
            case 11: {
                gen = "EJBGenerator";
                break;
            }
        }
        if (gen != null) {
            Vector generatorSwitches;
            String[] s1 = new String[2];
            String[] s2 = new String[2];
            String[] s3 = new String[4];
            int i = 0;
            i = 0;
            s1[0] = execcmd;
            s1[++i] = "com.sas.rmi." + gen;
            String switches = this.getGeneratorSwitches();
            if (switches != null) {
                s1 = this.add(s1, switches);
            }
            if ((generatorSwitches = this.getGeneratorSwitchesVector()) != null) {
                for (int v = 0; v < generatorSwitches.size(); ++v) {
                    s1 = this.add(s1, (String)generatorSwitches.elementAt(v));
                }
            }
            s1 = this.add(s1, "-o");
            if (this.m_homeDir != null) {
                s1 = this.add(s1, "-d");
                s1 = this.add(s1, this.m_homeDir);
            }
            s1 = this.add(s1, this.fullName());
            if (!postCompile) {
                s = new String[][]{s1};
                return s;
            }
            i = 0;
            s2[0] = this.getCompiler();
            s2[++i] = this.getDir() + this.getClientProxyName() + ".java";
            this.setOverride(true);
            String z = this.getDir() + this.getClientProxyName() + ".java";
            s2 = this.add(s2, z);
            this.setOverride(false);
            switch (this.m_amIndex) {
                case 7: 
                case 9: {
                    s = new String[2][];
                    s2 = this.add(s2, this.getDir() + this.getServerProxyName() + ".java");
                    break;
                }
                case 1: {
                    s2 = this.add(s2, this.getDir() + this.getInterfaceProxyName() + ".java");
                    s2 = this.add(s2, this.getDir() + this.getServerProxyName() + ".java");
                    i = 0;
                    s3[0] = CompileCommand.getRMICompileCommand();
                    s3[++i] = "-d";
                    s3[++i] = this.m_homeDir != null ? this.m_homeDir : this.packageCD();
                    s3[++i] = this.getFullServerProxyName();
                    s = new String[3][];
                    s[2] = s3;
                    break;
                }
                case 11: {
                    s = new String[2][];
                    i = 0;
                    s2[0] = this.getCompiler();
                    s2[++i] = this.getDir() + this.getClassName() + "Interface.java";
                    s2 = this.add(s2, this.getDir() + this.getClassName() + ProxyName.ejbhome() + ".java");
                    s2 = this.add(s2, this.getDir() + this.getClassName() + ProxyName.ejbremote() + ".java");
                    s2 = this.add(s2, this.getDir() + this.getClassName() + ProxyName.ejbbean() + ".java");
                    break;
                }
                case 8: {
                    String[] idlgen = new String[6];
                    i = 0;
                    idlgen[0] = execcmd;
                    idlgen[++i] = "com.sas.rmi.IDLGenerator";
                    idlgen[++i] = "-o";
                    idlgen[++i] = "-uSAS_";
                    idlgen[++i] = "-l_SAS%3";
                    idlgen[++i] = this.getPackage() == null ? this.getClassName() : this.getPackage() + "." + this.getClassName();
                    String[] orbixidl = new String[4];
                    i = 0;
                    orbixidl[0] = "idl";
                    orbixidl[++i] = "-m interOp";
                    orbixidl[++i] = "-jO " + this.packageCD();
                    orbixidl[++i] = this.getClassName() + "CORBA.idl";
                    String[] orbixc = new String[2];
                    i = 0;
                    orbixc[0] = this.getCompiler();
                    orbixc[++i] = this.getClassName() + "CORBA.java";
                    orbixc = this.add(orbixc, "_" + this.getClassName() + "CORBARef.java");
                    orbixc = this.add(orbixc, "_tie_" + this.getClassName() + "CORBA.java");
                    orbixc = this.add(orbixc, "_dispatcher_" + this.getClassName() + "CORBA.java");
                    orbixc = this.add(orbixc, "_" + this.getClassName() + "CORBAHolder.java");
                    orbixc = this.add(orbixc, "_boaimpl_" + this.getClassName() + "CORBA.java");
                    orbixc = this.add(orbixc, "_" + this.getClassName() + "CORBAOperations.java");
                    orbixc = this.add(orbixc, "byte_array.java");
                    s1 = new String[6];
                    i = 0;
                    s1[0] = execcmd;
                    s1[++i] = "com.sas.rmi." + gen;
                    s1[++i] = "-o";
                    s1[++i] = "-uSAS_";
                    s1[++i] = "-l_SAS%3";
                    s1[++i] = this.fullName();
                    s2 = this.add(s2, this.getDir() + this.getServerProxyName() + ".java");
                    s = new String[][]{idlgen, orbixidl, orbixc, s1, s2};
                    return s;
                }
                case 6: {
                    String[] idl = new String[6];
                    String[] idl2java = new String[7];
                    i = 0;
                    idl[0] = execcmd;
                    idl[++i] = "com.sas.rmi.IDLGenerator";
                    idl[++i] = "-o";
                    idl[++i] = "-uSAS_";
                    idl[++i] = "-l_SAS%3";
                    idl[++i] = this.getPackage() == null ? this.getClassName() : this.getPackage() + "." + this.getClassName();
                    i = 0;
                    idl2java[0] = execcmd;
                    idl2java[++i] = "-mx64m";
                    idl2java[++i] = "-DORBdisableLocator";
                    idl2java[++i] = "com.visigenic.vbroker.tools.idl2java";
                    idl2java[++i] = "-verbose";
                    idl2java[++i] = "-root_dir " + this.packageCD();
                    idl2java[++i] = this.getClassName() + "CORBA.idl";
                    String[] c0 = new String[2];
                    i = 0;
                    c0[0] = this.getCompiler();
                    c0[++i] = this.getClassName() + "CORBA.java";
                    c0 = this.add(c0, this.getClassName() + "CORBAHolder.java");
                    c0 = this.add(c0, this.getClassName() + "CORBAHelper.java");
                    c0 = this.add(c0, "_st_" + this.getClassName() + "CORBA.java");
                    c0 = this.add(c0, "_sk_" + this.getClassName() + "CORBA.java");
                    c0 = this.add(c0, "_" + this.getClassName() + "CORBAImplBase.java");
                    c0 = this.add(c0, this.getClassName() + "CORBAOperations.java");
                    c0 = this.add(c0, "_tie_" + this.getClassName() + "CORBA.java");
                    c0 = this.add(c0, "string_arrayHolder.java");
                    c0 = this.add(c0, "string_arrayHelper.java");
                    c0 = this.add(c0, "boolean_arrayHolder.java");
                    c0 = this.add(c0, "boolean_arrayHelper.java");
                    c0 = this.add(c0, "char_arrayHolder.java");
                    c0 = this.add(c0, "char_arrayHelper.java");
                    c0 = this.add(c0, "byte_arrayHolder.java");
                    c0 = this.add(c0, "byte_arrayHelper.java");
                    c0 = this.add(c0, "short_arrayHolder.java");
                    c0 = this.add(c0, "short_arrayHelper.java");
                    c0 = this.add(c0, "int_arrayHolder.java");
                    c0 = this.add(c0, "int_arrayHelper.java");
                    c0 = this.add(c0, "float_arrayHolder.java");
                    c0 = this.add(c0, "float_arrayHelper.java");
                    c0 = this.add(c0, "double_arrayHolder.java");
                    c0 = this.add(c0, "double_arrayHelper.java");
                    s1 = new String[6];
                    i = 0;
                    s1[0] = execcmd;
                    s1[++i] = "com.sas.rmi." + gen;
                    s1[++i] = "-o";
                    s1[++i] = "-uSAS_";
                    s1[++i] = "-l_SAS%3";
                    s1[++i] = this.fullName();
                    s2 = this.add(s2, this.getDir() + this.getServerProxyName() + ".java");
                    s = new String[][]{idl, idl2java, c0, s1, s2};
                    return s;
                }
                default: {
                    s = new String[][]{s1, s2};
                }
            }
        }
        return s;
    }

    String fullName() {
        return this.fullName(this.getClassName());
    }

    String fullName(String name) {
        return this.getPackage() == null ? name : this.getPackage() + "." + name;
    }

    public String getProxyInterfaceClassName() {
        return this.getGenericProxyPrefix() + this.getClassName() + "Interface";
    }

    public String getFullProxyInterfaceClassName() {
        String packageName = this.getPackage();
        if (packageName != null) {
            return packageName + "." + this.getProxyInterfaceClassName();
        }
        return this.getProxyInterfaceClassName();
    }

    public String getCORBAInterfaceName(Class sourceClass, CodeGeneratorOptions codeGenOptions) {
        String name = this.getCORBAInterfaceName(sourceClass, codeGenOptions, false);
        try {
            RocfClass.forName(name);
            return name;
        }
        catch (Exception ex) {
            name = this.getCORBAInterfaceName(sourceClass, codeGenOptions, true);
            return name;
        }
    }

    public String getCORBAInterfaceName(Class sourceClass, CodeGeneratorOptions codeGenOptions, boolean removeVersionNum) {
        int i;
        String name = codeGenOptions.getArg("-i");
        if (name != null) {
            return name;
        }
        name = "";
        String packageName = "";
        String interfaceName = sourceClass.getName();
        int p = interfaceName.lastIndexOf(".");
        if (p > 0) {
            packageName = interfaceName.substring(0, p);
            interfaceName = interfaceName.substring(p + 1);
        }
        if (removeVersionNum && (i = interfaceName.lastIndexOf("Interface")) != -1) {
            int j;
            for (j = i - 1; j >= 0 && Character.isDigit(interfaceName.charAt(j)); --j) {
            }
            if (interfaceName.charAt(j) == 'V') {
                interfaceName = interfaceName.substring(0, j) + interfaceName.substring(i);
            }
        }
        try {
            Field moduleNameField = sourceClass.getDeclaredField("MODULE_NAME");
            String modName = (String)moduleNameField.get(null);
            name = modName + "." + interfaceName;
        }
        catch (Exception moduleNameField) {
            // empty catch block
        }
        if (name.length() == 0 && packageName.length() != 0) {
            String leafName = "";
            int q = packageName.lastIndexOf(".");
            leafName = q > 0 ? packageName.substring(q + 1) : packageName;
            name = packageName + ".corba." + leafName + "." + interfaceName;
        }
        return name;
    }

    public static String getSCLClassInfoName(String interfaceName) {
        String name = interfaceName;
        int i = name.lastIndexOf("Interface");
        if (i != -1) {
            int j;
            for (j = i - 1; j >= 0 && Character.isDigit(name.charAt(j)); --j) {
            }
            if (name.charAt(j) == 'V') {
                name = name.substring(0, j) + name.substring(i);
            }
        }
        return name + "SCLClassInfo";
    }

    String[] add(String[] src, String item) {
        String[] s = null;
        if (src == null) {
            s = new String[]{item};
        } else {
            int l = src.length;
            s = new String[l + 1];
            for (int i = 0; i < l; ++i) {
                s[i] = src[i];
            }
            s[l] = item;
        }
        return s;
    }

    public static void main(String[] args) {
        int m;
        String[] cls = new String[]{"foo", "baz"};
        String[] am = new String[]{"RSCL", "RMI", "J2", "RemoteDesignTime", "IOM", "EJB"};
        String[] pkg = new String[]{null, "com.sas.sasserver.samples"};
        ProxyName pn = new ProxyName();
        for (int i = 0; i < cls.length; ++i) {
            pn.setClassName(cls[i]);
            System.out.println("cls=" + pn.getClassName());
            for (int j = 0; j < pkg.length; ++j) {
                pn.setPackage(pkg[j]);
                System.out.println("pkg=" + pn.getPackage());
                for (int k = 0; k < am.length; ++k) {
                    pn.setAccessMethod(am[k]);
                    System.out.println("am=" + pn.getAccessMethod());
                    System.out.println("cpn=" + pn.getClientProxyName());
                    String[][] s = pn.getBuildCommand();
                    System.out.println("s=" + s);
                    for (int l = 0; l < s.length; ++l) {
                        String[] sub = s[l];
                        System.out.println("sub=" + sub);
                        for (m = 0; sub != null && m < sub.length && sub[m] != null; ++m) {
                            System.out.print(sub[m] + " ");
                        }
                        System.out.println();
                    }
                }
            }
        }
        System.out.println("args=" + args + "args.length=" + args.length);
        for (int y = 0; y < args.length; ++y) {
            String testCase = args[y];
            System.out.println("testcase=" + testCase);
            ProxyName pn2 = new ProxyName();
            pn2.setClassName(testCase);
            System.out.println();
            for (int z = 0; z < am.length; ++z) {
                pn2.setAccessMethod(am[z]);
                String[][] s = pn2.getBuildCommand();
                for (int l = 0; l < s.length; ++l) {
                    for (m = 0; m < s[l].length && s[l][m] != null; ++m) {
                        System.out.print(s[l][m] + " ");
                    }
                    System.out.println();
                }
            }
        }
    }
}

