/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.BrokerConnector;
import com.sas.rmi.BrokerPool;
import com.sas.rmi.FactoryThread;
import com.sas.security.BaseSecuritySupport;
import java.io.IOException;

public class PoolQueue
implements Runnable {
    Thread m_thread = null;
    boolean m_debug = false;
    int m_poolSize = 0;
    BrokerPool m_pool;
    BrokerConnector m_connector;
    FactoryThread m_factory;
    int m_delay;

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public void setup(BrokerPool pool, int size) {
        this.setup(pool, size, 0);
    }

    public void setup(BrokerPool pool, int size, int delaySeconds) {
        this.m_pool = pool;
        this.fireBrokerEvent(this, "Creating new queue for " + this.m_pool.getPoolDescription());
        this.setPoolSize(size);
        this.m_delay = delaySeconds;
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = BaseSecuritySupport.securitySupport.createThread((Runnable)this);
            this.m_thread.start();
        }
    }

    public void stop() {
        try {
            if (this.m_thread != null) {
                this.m_thread.stop();
                this.m_thread = null;
            }
            if (this.m_factory != null) {
                this.m_factory.stop();
                this.m_factory = null;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public boolean isAlive() {
        boolean rc = false;
        if (this.m_thread != null) {
            rc = this.m_thread.isAlive();
        }
        return rc;
    }

    @Override
    public void run() {
        if (this.m_delay > 0) {
            this.fireBrokerEvent(this, "Delaying new session by " + this.m_delay + " seconds");
        }
        while (this.m_poolSize == 1 && this.m_delay > 0) {
            try {
                Thread.sleep(1000L);
                --this.m_delay;
            }
            catch (Exception exception) {}
        }
        while (this.m_poolSize > 0) {
            this.m_factory = null;
            try {
                this.m_factory = this.createFactoryThread();
                --this.m_poolSize;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (this.m_factory == null) continue;
            while (this.m_factory.isAlive()) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setPoolSize(int value) {
        this.m_poolSize = value;
        this.fireBrokerEvent(this, "Setting queue size to " + this.m_poolSize + " for " + this.m_pool.getPoolDescription());
    }

    public int getPoolSize() {
        return this.m_poolSize;
    }

    private FactoryThread createFactoryThread() throws IOException {
        FactoryThread f = new FactoryThread();
        f.setDebug(this.m_debug);
        f.setup(this.m_pool);
        f.start();
        this.m_pool.getFactories().addElement(f);
        return f;
    }

    public void fireBrokerEvent(Object source, String msg) {
        this.m_pool.fireBrokerEvent(source, msg);
    }
}

