/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.collection.AssociationList;
import com.sas.rmi.Connection;
import com.sas.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class PersistedConnectionList
extends AssociationList {
    static final long serialVersionUID = 894027530916925859L;
    public static final String m_prefix = "PersistedConnectionName";
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private transient String equalChar = "=";
    private transient String m_dir;
    private transient String m_fileName;
    private transient String m_filePathName;
    private transient Vector v = new Vector();
    private transient long lastModified;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public PersistedConnectionList() {
        this(".", "ConnectionResources.txt");
    }

    public PersistedConnectionList(String filePathName) {
        this.setFilePathName(filePathName);
    }

    public PersistedConnectionList(String defDir, String fileName) {
        this.m_filePathName = null;
        this.setDirectory(defDir);
        this.setFileName(fileName);
    }

    public String getFilePathName() {
        return this.m_filePathName;
    }

    public void setFilePathName(String filePathName) {
        this.m_filePathName = filePathName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setDirectory(String dirName) {
        this.m_dir = dirName;
    }

    public String getDirectory() {
        return this.m_dir;
    }

    public Properties nonDefaultConnectionProperties(Properties connectionProps) {
        Connection defaultConn = new Connection();
        Properties defaultProps = defaultConn.getProperties();
        Properties diffProps = new Properties();
        String deferUserValue = (String)connectionProps.get(Connection.DEFERUSERINFOUNTILRUNTIME);
        String deferAllValue = (String)connectionProps.get(Connection.DEFERALLUNTILRUNTIME);
        boolean deferUserInfo = false;
        if (Util.equal((Object)deferUserValue, (Object)"true") || Util.equal((Object)deferAllValue, (Object)"true")) {
            deferUserInfo = true;
        }
        Enumeration<?> connectionEnum = connectionProps.propertyNames();
        while (connectionEnum.hasMoreElements()) {
            String key = (String)connectionEnum.nextElement();
            String connectionValue = connectionProps.getProperty(key);
            String defaultValue = defaultProps.getProperty(key);
            if (deferUserInfo && (Util.equal((Object)key, (Object)Connection.USERNAME) || Util.equal((Object)key, (Object)Connection.PASSWORD))) continue;
            String accessor = defaultConn.getAccessor(key);
            if (accessor != null) {
                key = accessor;
            }
            if (!Util.unequal((Object)defaultValue, (Object)connectionValue)) continue;
            diffProps.put(key, connectionValue);
        }
        return diffProps;
    }

    public boolean saveProperties() throws IOException {
        Enumeration keys = this.getKeys();
        File file = null;
        file = this.m_filePathName != null ? new File(this.m_filePathName) : new File(this.m_dir, this.m_fileName);
        if (file != null && (!file.exists() || file.canWrite())) {
            if (this.lastModified != file.lastModified()) {
                return false;
            }
            FileOutputStream fout = new FileOutputStream(file);
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Properties connectionProps = (Properties)this.get(key);
                Properties propertyList = this.nonDefaultConnectionProperties(connectionProps);
                key = this.saveConvert(key, true);
                key = m_prefix + this.equalChar + key;
                propertyList.save(fout, key);
            }
            fout.close();
            this.lastModified = file.lastModified();
        }
        return true;
    }

    public synchronized void loadProperties() throws IOException {
        File file = null;
        file = this.m_filePathName != null ? new File(this.m_filePathName) : new File(this.m_dir, this.m_fileName);
        this.lastModified = file.lastModified();
        if (file != null && file.canRead()) {
            this.loadProperties(new FileInputStream(file));
        }
    }

    public void copyProperties(Properties source, Properties target) {
        Enumeration<?> e = source.propertyNames();
        while (e.hasMoreElements()) {
            String propertyKey = (String)e.nextElement();
            String propertyValue = source.getProperty(propertyKey);
            target.put(propertyKey, propertyValue);
        }
    }

    public void updateConnectionProperties(Connection conn, String key) {
        Properties p = (Properties)this.get(key);
        Enumeration<?> e = p.propertyNames();
        Connection defaultConn = new Connection();
        while (e.hasMoreElements()) {
            String propertyKey = (String)e.nextElement();
            String propertyValue = p.getProperty(propertyKey);
            String internalName = defaultConn.getInternalName(propertyKey);
            if (internalName != null) {
                propertyKey = internalName;
            }
            conn.getProperties().put(propertyKey, propertyValue);
        }
    }

    public String getJSPConnectionProperties(String key) {
        Properties p = (Properties)this.get(key);
        Enumeration<?> e = p.propertyNames();
        Connection defaultConn = new Connection();
        String conn = "";
        while (e.hasMoreElements()) {
            String propertyKey = (String)e.nextElement();
            String propertyValue = p.getProperty(propertyKey);
            String accessor = defaultConn.getAccessor(propertyKey);
            if (accessor != null) {
                propertyKey = accessor;
            }
            conn = conn + propertyKey + "=\"" + propertyValue + "\" ";
        }
        return conn;
    }

    protected synchronized void addConnectionProperties(Properties p, String key) {
        Connection defaultConn = new Connection();
        Enumeration<?> pEnum = p.propertyNames();
        while (pEnum.hasMoreElements()) {
            String propertyKey = (String)pEnum.nextElement();
            String internalName = defaultConn.getInternalName(propertyKey);
            if (internalName == null) continue;
            Object value = p.get(propertyKey);
            p.remove(propertyKey);
            p.put(internalName, value);
        }
        int count = this.count();
        this.add(count, key, p);
    }

    public synchronized void loadProperties(InputStream inStream) throws IOException {
        String connectionName = null;
        Properties p = new Properties();
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream, "8859_1"));
        while (true) {
            int valueIndex;
            int separatorIndex;
            int keyStart;
            String line;
            if ((line = in.readLine()) == null) {
                if (connectionName != null) {
                    this.addConnectionProperties(p, connectionName);
                }
                in.close();
                return;
            }
            if (line.length() <= 0) break;
            char firstChar = line.charAt(0);
            if (firstChar == '!') continue;
            while (this.continueLine(line)) {
                String nextLine = in.readLine();
                if (nextLine == null) {
                    nextLine = "";
                }
                String loppedLine = line.substring(0, line.length() - 1);
                int startIndex = 0;
                for (startIndex = 0; startIndex < nextLine.length() && whiteSpaceChars.indexOf(nextLine.charAt(startIndex)) != -1; ++startIndex) {
                }
                nextLine = nextLine.substring(startIndex, nextLine.length());
                line = new String(loppedLine + nextLine);
            }
            int len = line.length();
            for (keyStart = 0; keyStart < len && whiteSpaceChars.indexOf(line.charAt(keyStart)) != -1; ++keyStart) {
            }
            if (keyStart == len) continue;
            for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
                char currentChar = line.charAt(separatorIndex);
                if (currentChar == '\\') {
                    ++separatorIndex;
                    continue;
                }
                if (keyValueSeparators.indexOf(currentChar) != -1) break;
            }
            for (valueIndex = separatorIndex; valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1; ++valueIndex) {
            }
            if (valueIndex < len && strictKeyValueSeparators.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            while (valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            String key = line.substring(keyStart, separatorIndex);
            String value = separatorIndex < len ? line.substring(valueIndex, len) : "";
            value = this.loadConvert(value);
            if (key.startsWith("#")) {
                if (key.indexOf(m_prefix) == -1) continue;
                if (connectionName != null) {
                    this.addConnectionProperties(p, connectionName);
                }
                p = new Properties();
                connectionName = value;
                continue;
            }
            String newKey = this.convertKey(key);
            if (newKey == null) continue;
            p.put(newKey, value);
        }
        if (connectionName != null) {
            this.addConnectionProperties(p, connectionName);
        }
        in.close();
    }

    private boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    private String loadConvert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(PersistedConnectionList.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(PersistedConnectionList.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(PersistedConnectionList.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(PersistedConnectionList.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    protected String convertKey(String key) {
        if (key == null || key.length() == 0) {
            return key;
        }
        if ("Description".equals(key) || "Prompt".equals(key) || "Server".equals(key)) {
            return null;
        }
        char firstChar = key.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            StringBuffer newKey = new StringBuffer(key);
            firstChar = Character.toLowerCase(firstChar);
            newKey.setCharAt(0, firstChar);
            return newKey.toString();
        }
        return key;
    }

    public static void main(String[] args) {
        PersistedConnectionList cp = new PersistedConnectionList();
        try {
            if (args.length == 2) {
                cp.setDirectory(args[1]);
            }
            if (args.length > 0 && Util.equal((Object)args[0], (Object)"load")) {
                cp.loadProperties();
            } else {
                Connection newCon = new Connection();
                newCon.setHost("swtest1");
                newCon.setPassword("mypassword");
                newCon.setPersistedName("My Favorite Server");
                Connection newCon1 = new Connection();
                newCon1.setHost("d151.us.sas.com");
                newCon1.setUsername("sasbeo");
                newCon1.setPersistedName("My Server");
                Connection newCon2 = new Connection();
                Connection.setServerArchitecture(newCon2, "unix");
                newCon2.setPersistedName("My Favorite Unix Server");
                cp.add(0, "My Favorite Server", newCon.getProperties());
                cp.add(1, "My Favorite Unix Server", newCon2.getProperties());
                cp.add(2, "My Server", newCon1.getProperties());
                cp.saveProperties();
            }
        }
        catch (IOException e) {
            System.out.println("main: caught " + e);
        }
    }

    private void handle(Exception e, String m) {
        System.out.println(((Object)((Object)this)).getClass().getName() + "::" + m + "::caught " + e);
    }
}

