/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class PacketOutputStream
extends OutputStream {
    protected boolean m_debug;
    protected int m_size = 0;
    protected DataOutputStream m_out;
    protected Vector m_vector = new Vector();
    protected int m_bufSize = 4096;

    public PacketOutputStream(DataOutputStream out) {
        this.m_out = out;
    }

    public PacketOutputStream(DataOutputStream out, boolean debug) {
        this.m_out = out;
        this.m_debug = debug;
    }

    @Override
    public void write(int data) throws IOException {
        byte[] b;
        if (this.m_size >= this.m_bufSize || this.m_vector.size() == 0) {
            b = new byte[this.m_bufSize];
            this.m_vector.addElement(b);
            this.m_size = 0;
        } else {
            b = (byte[])this.m_vector.lastElement();
        }
        b[this.m_size] = (byte)data;
        ++this.m_size;
    }

    @Override
    public void flush() throws IOException {
        if (this.m_vector.size() > 0) {
            int totalLen = (this.m_vector.size() - 1) * this.m_bufSize + this.m_size + 1;
            if (this.m_debug) {
                System.out.println("flushing " + totalLen + " bytes");
            }
            this.m_out.writeInt(totalLen);
            this.m_out.writeByte(0);
            for (int i = 0; i < this.m_vector.size() - 1; ++i) {
                if (this.m_debug) {
                    System.out.println(" writing full element " + i + " of " + this.m_bufSize + " bytes");
                }
                this.m_out.write((byte[])this.m_vector.elementAt(i), 0, this.m_bufSize);
            }
            if (this.m_debug) {
                System.out.println(" writing partial element of " + this.m_size + " bytes");
            }
            this.m_out.write((byte[])this.m_vector.lastElement(), 0, this.m_size);
            this.m_out.flush();
        }
        this.m_vector.removeAllElements();
        this.m_size = 0;
    }
}

