/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorBaseTarget;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.Connection;
import com.sas.rmi.OrbixClientTemplate;
import com.sas.rmi.ProxyName;
import com.sas.rmi.TargetMethod;
import com.sas.rmi.Template;
import java.io.IOException;
import java.lang.reflect.Method;

public class OrbixGeneratorClientTarget
extends CodeGeneratorBaseTarget {
    TargetMethod m_tm = new TargetMethod();

    @Override
    public String getGeneratorName() {
        return "OrbixWeb_Client";
    }

    public OrbixGeneratorClientTarget() {
        this.m_tm.addBroadcastException(IOException.class);
    }

    @Override
    public Template getTemplate() {
        return new OrbixClientTemplate();
    }

    @Override
    public String getTargetName(String sourceName) {
        ProxyName pn = new ProxyName();
        pn.setAccessMethod(Connection.ACCESS_METHOD_ORBIX);
        pn.setClassName(sourceName);
        return pn.getClientProxyName();
    }

    @Override
    public void generateMethodCode(Class source, Method method, CodeGeneratorOutputStream out) throws Exception {
        String s = null;
        if (method.getName().equals("clone") && method.getParameterTypes().length == 0) {
            return;
        }
        if (!this.m_tm.generateMethodCodeHeader(source, method, out)) {
            return;
        }
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        Class<?>[] params = method.getParameterTypes();
        String p = "";
        for (int j = 0; j < params.length; ++j) {
            String pType = CodeGenerator.convertType(params[j].getName());
            if (!OrbixGeneratorClientTarget.isTypeSupported(pType)) {
                s = "byte[] p" + (j + 1) + "_bytesTemp = _RemoteObject_convert(\"" + pType + "\", p" + (j + 1) + ");";
                out.println(s, 3);
                s = "byte_array p" + (j + 1) + "_bytes = new byte_array(p" + (j + 1) + "_bytesTemp.length);";
                out.println(s, 3);
                s = "p" + (j + 1) + "_bytes.buffer = p" + (j + 1) + "_bytesTemp;";
                out.println(s, 3);
                p = p + "p" + (j + 1) + "_bytes";
            } else {
                p = p + "p" + (j + 1);
            }
            if (j + 1 >= params.length) continue;
            p = p + ",";
        }
        if (!OrbixGeneratorClientTarget.isTypeSupported(ret)) {
            out.println("byte_array value_bytes;", 2);
            s = "value_bytes = ";
        } else {
            s = !ret.equals("void") ? "value = " : "";
        }
        out.println("try {", 3);
        String methodName = method.getName();
        methodName = this.convertName(methodName);
        s = s + "_RemoteObject_getCORBAObject()." + methodName + "(" + p + ");";
        out.println(s, 4);
        out.println("}", 3);
        out.println("catch (IE.Iona.Orbix2.CORBA.SystemException e) {", 3);
        out.println("e.printStackTrace();", 4);
        out.println("throw new java.io.IOException(e.getMessage());", 4);
        out.println("}", 3);
        if (!OrbixGeneratorClientTarget.isTypeSupported(ret)) {
            s = "value = (" + ret + ") _RemoteObject_convert(\"" + ret + "\", value_bytes.buffer);";
            out.println(s, 3);
        }
        this.m_tm.generateMethodCodeTrailer(source, method, out);
    }

    public static boolean isTypeSupported(String type) {
        boolean rc = false;
        if (type.equals("void") || type.equals("java.lang.String") || type.equals("boolean") || type.equals("char") || type.equals("byte") || type.equals("short") || type.equals("int") || type.equals("float") || type.equals("double") || type.equals("java.lang.String[]") || type.equals("boolean[]") || type.equals("char[]") || type.equals("byte[]") || type.equals("short[]") || type.equals("int[]") || type.equals("float[]") || type.equals("double[]")) {
            rc = true;
        }
        return rc;
    }
}

