/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.Logger;
import java.util.TimerTask;

public abstract class NotifyTimerTask
extends TimerTask {
    private transient boolean started;
    private transient boolean finished;
    private static long MAXWAIT = 600000L;
    private transient long creationTime = System.currentTimeMillis();

    public NotifyTimerTask() {
        Logger.p(this, ":<init>");
    }

    synchronized void waitForStart() {
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        while (!this.started) {
            try {
                this.wait(MAXWAIT);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if ((elapsed = System.currentTimeMillis() - start) < MAXWAIT) continue;
            break;
        }
    }

    synchronized void waitForFinish() {
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        while (!this.finished) {
            try {
                this.wait(MAXWAIT);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if ((elapsed = System.currentTimeMillis() - start) < MAXWAIT) continue;
            break;
        }
    }

    synchronized void releaseStartWaiters() {
        this.started = true;
        this.notifyAll();
    }

    synchronized void releaseFinishWaiters() {
        this.finished = true;
        this.notifyAll();
    }

    @Override
    public void run() {
        long start;
        this.creationTime = start = System.currentTimeMillis();
        this.releaseStartWaiters();
        this.runImpl();
        long elapsed = System.currentTimeMillis() - start;
        Logger.p(this, ":run (elapsed=" + elapsed + "ms)");
        this.releaseFinishWaiters();
    }

    public abstract void runImpl();
}

