/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.GlobalInfoTable;
import com.sas.rmi.ChooserInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.RMIUtil;
import com.sas.rmi.RocfORBInterface;
import com.sas.rmi.TunnelingSocketFactory;
import java.applet.Applet;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class MWSLocator {
    public static RocfORBInterface locate(Connection ctxt) throws Exception {
        String mwsHost = ctxt.getTrueFunnelHost();
        boolean useRouter = ctxt.getUseRouter();
        String routerURL = ctxt.getRouterURL();
        int mwsPort = 1099;
        RocfORBInterface orb = null;
        int colon = mwsHost.indexOf(58);
        if (colon > 0) {
            mwsPort = Integer.parseInt(mwsHost.substring(colon + 1));
            mwsHost = mwsHost.substring(0, colon);
        }
        if (useRouter) {
            ctxt.setUseRouter(Connection.USEROUTER_DEFAULT);
            ctxt.setRouterURL(Connection.ROUTERURL_DEFAULT);
        }
        Registry registry = MWSLocator.getRegistry(mwsHost, mwsPort, useRouter, routerURL);
        orb = (RocfORBInterface)registry.lookup("RocfORB");
        return orb;
    }

    public static String resolveName(Connection ctxt) {
        int colon;
        String mwsHost = ctxt.getFunnelHost();
        boolean isRelative = ctxt.isAppletCodebaseRelative();
        int mwsPort = 1099;
        boolean useChooser = false;
        String completeHost = null;
        if (mwsHost.startsWith("Chooser/")) {
            useChooser = true;
            mwsHost = mwsHost.substring(8);
        }
        if ((colon = mwsHost.indexOf(58)) > 0) {
            mwsPort = Integer.parseInt(mwsHost.substring(colon + 1));
            mwsHost = mwsHost.substring(0, colon);
        }
        if (isRelative) {
            mwsHost = MWSLocator.appletHost();
        }
        if (useChooser) {
            try {
                int chooserPort = colon > 0 ? mwsPort : 1098;
                Registry registry = MWSLocator.getRegistry(mwsHost, chooserPort, ctxt.getUseRouter(), ctxt.getRouterURL());
                ChooserInterface ci = (ChooserInterface)registry.lookup("Chooser");
                mwsHost = ci.nextName();
            }
            catch (RemoteException rex) {
                rex.printStackTrace();
                mwsHost = "localhost";
            }
            catch (MalformedURLException rex) {
                rex.printStackTrace();
                mwsHost = "localhost";
            }
            catch (NotBoundException rex) {
                rex.printStackTrace();
                mwsHost = "localhost";
            }
            colon = mwsHost.indexOf(58);
            if (colon > 0) {
                mwsPort = Integer.parseInt(mwsHost.substring(colon + 1));
                mwsHost = mwsHost.substring(0, colon);
            }
        }
        try {
            mwsHost = RMIUtil.hostNormalize((String)mwsHost);
        }
        catch (RemoteException rex) {
            rex.printStackTrace();
            mwsHost = "localhost";
        }
        completeHost = mwsHost + ":" + mwsPort;
        return completeHost;
    }

    private static String appletHost() {
        Applet appl = (Applet)GlobalInfoTable.getObject();
        URL url = null;
        String newHost = "localhost";
        String s = null;
        if (appl != null && (url = appl.getCodeBase()) != null && (s = url.getHost()) != null && s.length() > 0) {
            newHost = s;
        }
        return newHost;
    }

    public static Registry getRegistry(String host, int port, boolean tunnel, String tunnelURL) throws RemoteException, MalformedURLException {
        TunnelingSocketFactory clientFactory = null;
        Registry registry = null;
        if (tunnel) {
            if (tunnelURL == null || tunnelURL.length() == 0) {
                clientFactory = new TunnelingSocketFactory();
            } else {
                URL url = new URL(tunnelURL);
                String tprotocol = url.getProtocol();
                String thost = url.getHost();
                String tfile = url.getFile();
                clientFactory = new TunnelingSocketFactory(tprotocol, thost, tfile);
            }
        }
        registry = LocateRegistry.getRegistry(host, port, clientFactory);
        return registry;
    }
}

