/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.Connection;
import com.sas.rmi.LoadBalanceBound;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class LoadBalancer {
    private Vector m_bounds = new Vector();
    private Hashtable m_connectionProps = new Hashtable();
    private int m_clientCount = 0;

    public LoadBalancer() {
        this.m_connectionProps.put(Connection.HOST, Connection.HOST_DEFAULT);
        this.m_connectionProps.put(Connection.USERNAME, Connection.USERNAME_DEFAULT);
        this.m_connectionProps.put(Connection.ARCHITECTURE, "PC");
        this.m_connectionProps.put(Connection.COMMAND, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String configFile) {
        boolean rc = false;
        File f = new File(configFile);
        if (!f.exists()) {
            System.out.println(configFile + " does not exist");
            return false;
        }
        if (!f.isFile()) {
            System.out.println(configFile + " is not a file");
            return false;
        }
        System.out.println("Load balancing using " + configFile);
        FileReader fr = null;
        int lines = 0;
        try {
            String line;
            fr = new FileReader(f);
            BufferedReader in = new BufferedReader(fr);
            while ((line = in.readLine()) != null) {
                LoadBalanceBound b;
                ++lines;
                if ((line = line.trim()).length() == 0 || line.startsWith("//") || line.startsWith("#") || !(b = new LoadBalanceBound(line)).isValid()) continue;
                b.setLoadBalancer(this);
                b.setLineNo(lines);
                this.m_bounds.addElement(b);
            }
            System.out.println("" + lines + " lines processed");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Exception exception) {}
            }
        }
        this.validate();
        return rc;
    }

    public Vector getBounds() {
        return this.m_bounds;
    }

    protected void validate() {
        int lastUpper = 0;
        LoadBalanceBound last = null;
        for (int i = 0; i < this.m_bounds.size(); ++i) {
            LoadBalanceBound b = (LoadBalanceBound)this.m_bounds.elementAt(i);
            if (last != null) {
                if (b.getUpperClientBound() < last.getUpperClientBound()) {
                    System.out.println("Upper client bound at line " + b.getLineNo() + " is not valid; the bound will be ignored");
                    b.setUpperClientBound(last.getUpperClientBound());
                }
                if (b.getUpperObjectBound() < last.getUpperObjectBound()) {
                    System.out.println("Upper object bound at line " + b.getLineNo() + " is not valid; the bound will be ignored");
                    b.setUpperObjectBound(0);
                }
            }
            b.setMaxClients(b.getUpperClientBound() - lastUpper);
            lastUpper = b.getUpperClientBound();
            last = b;
        }
    }

    public boolean isBalancing(Connection con) {
        boolean rc = false;
        LoadBalanceBound bound = this.getBaseBound();
        if (bound == null) {
            return false;
        }
        Connection boundCon = bound.getConnection();
        rc = this.isEqual(con, boundCon);
        return rc;
    }

    private LoadBalanceBound getBaseBound() {
        LoadBalanceBound bound = null;
        for (int i = 0; i < this.m_bounds.size(); ++i) {
            LoadBalanceBound lbb = (LoadBalanceBound)this.m_bounds.elementAt(i);
            if (!lbb.isValid()) continue;
            bound = lbb;
            break;
        }
        return bound;
    }

    public synchronized void addClient() {
        ++this.m_clientCount;
    }

    public synchronized void removeClient() {
        if (this.m_clientCount > 0) {
            --this.m_clientCount;
        }
    }

    public synchronized LoadBalanceBound balance(Connection con) {
        LoadBalanceBound bound = this.getCurrentBound();
        if (bound != null) {
            System.out.println("Balancing client request");
            this.setConnection(con, bound);
        } else {
            bound = this.getBaseBound();
        }
        if (bound != null) {
            bound.addClient();
        }
        return bound;
    }

    public boolean containsBound(LoadBalanceBound bound) {
        boolean rc = false;
        if (bound != null) {
            for (int i = 0; i < this.m_bounds.size(); ++i) {
                LoadBalanceBound lbb = (LoadBalanceBound)this.m_bounds.elementAt(i);
                if (lbb != bound) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }

    protected LoadBalanceBound getCurrentBound() {
        LoadBalanceBound bound = null;
        boolean first = true;
        for (int i = 0; i < this.m_bounds.size(); ++i) {
            LoadBalanceBound lbb = (LoadBalanceBound)this.m_bounds.elementAt(i);
            if (!lbb.isValid()) continue;
            if (lbb.isAcceptingClients()) {
                System.out.println("" + lbb + "@" + i + " is accepting new clients");
                bound = lbb;
                break;
            }
            System.out.println("" + lbb + "@" + i + " is not accepting new clients");
            first = false;
        }
        if (first) {
            bound = null;
        }
        return bound;
    }

    protected void setConnection(Connection target, LoadBalanceBound bound) {
        Connection con = bound.getConnection();
        Enumeration<Object> enumer = this.m_connectionProps.keys();
        while (enumer.hasMoreElements()) {
            String key = (String)enumer.nextElement();
            String value = con.getString(key);
            target.setString(key, value);
        }
        Properties p = bound.getProperties();
        if (p != null) {
            enumer = p.keys();
            while (enumer.hasMoreElements()) {
                String key = (String)enumer.nextElement();
                String value = p.getProperty(key);
                target.setString(key, value);
            }
        }
    }

    protected boolean isEqual(Connection con1, Connection con2) {
        boolean rc = true;
        Enumeration enumer = this.m_connectionProps.keys();
        while (enumer.hasMoreElements()) {
            String s2;
            String key = (String)enumer.nextElement();
            String dfault = (String)this.m_connectionProps.get(key);
            String s1 = con1.getString(key);
            if (s1 == null) {
                s1 = dfault;
            }
            if ((s2 = con2.getString(key)) == null) {
                s2 = dfault;
            }
            if (s1.equals(s2)) continue;
            rc = false;
            break;
        }
        return rc;
    }
}

