/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.StringItem;
import com.sas.net.server.RemoteSasException;
import com.sas.net.server.SessionInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.Handshaker;
import com.sas.rmi.J2BaseClient;
import com.sas.rmi.QueueKey;
import com.sas.rmi.RB;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.RemoteException;
import com.sas.rmi.Rocf;
import com.sas.rmi.ServerBusyTimeoutException;
import com.sas.rmi.SingleThreadedQueue;
import com.sas.rmi.TimeoutDriver;
import com.sas.sasserver.factory.FactoryInterface;
import com.sas.sasserver.inputstream.InputStreamInterface;
import com.sas.sasserver.logtrap.LogTrapInterface;
import com.sas.sasserver.mapname.MapNameInterface;
import com.sas.sasserver.prodauth.ProdauthV2Interface;
import com.sas.sasserver.profiler.ProfilerInterface;
import com.sas.sasserver.serverinfo.ServerInfoInterface;
import com.sas.sasserver.submit.SubmitInterface;
import com.sas.text.Message;
import com.sas.util.TimedCommand;
import com.sas.util.TimedCommandInterface;
import com.sas.util.TimedOutException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class J2Factory {
    public static final String RB_KEY = "J2Factory.";
    public int SESSION_RELEASE_TIMEOUT = 5000;
    public int PRODAUTH_LOGIN_TIMEOUT = 8000;
    public int HANDSHAKE_TIMEOUT = 3000;
    public int FACTORY_DESTROY_TIMEOUT = 20000;
    private transient Rocf m_rocf;
    private transient Connection m_ctxt;
    private transient ProdauthV2Interface m_prodauth;
    private transient FactoryInterface m_factory;
    private transient SubmitInterface m_submit;
    private transient MapNameInterface m_mapper;
    private transient LogTrapInterface m_logtrap;
    private transient ProfilerInterface m_profiler;
    private transient InputStreamInterface m_lt_istream;
    private transient SubmitInterface m_lt_submit;
    private transient ServerInfoInterface m_serverInfo;
    private transient int m_ofId;
    private transient Properties m_cachemap = new Properties();
    private transient boolean m_sepTask;
    private transient Vector m_objvec = new Vector();
    private transient Vector m_gobjvec = new Vector();
    private transient boolean m_ready;
    private transient boolean initialStatementSubmitted = false;
    private transient boolean verbose;
    private transient boolean logonInterrupted;
    private transient Exception originalException;
    private transient boolean sleepCompleted;
    private transient boolean implCompleted;
    private transient HListInterface m_logonList;
    private transient SessionInterface m_session;
    private transient boolean locallyCreatedLogTrap;
    private transient boolean skipAppl;
    private transient boolean loggingOn;
    private static final String COMMAND_LOGON = "prodauth logon";
    private static final String COMMAND_RELEASE = "session release";
    private static final String COMMAND_HANDSHAKE = "encoding handshake";
    private static final String COMMAND_LOGOFF = "logoff";
    private transient Commands timedCommand;
    private transient TimedCommand timer;

    public J2Factory(Rocf rocf, Connection ctxt, boolean sepTask) {
        this.m_rocf = rocf;
        this.m_ctxt = ctxt;
        this.m_sepTask = sepTask;
        this.m_ready = false;
        this.SESSION_RELEASE_TIMEOUT = this.giprop(ctxt.getSessionReleaseTimeout(), this.SESSION_RELEASE_TIMEOUT);
        this.PRODAUTH_LOGIN_TIMEOUT = this.giprop(ctxt.getProdauthLoginTimeout(), this.PRODAUTH_LOGIN_TIMEOUT);
        this.HANDSHAKE_TIMEOUT = this.giprop(ctxt.getHandshakeTimeout(), this.HANDSHAKE_TIMEOUT);
        this.FACTORY_DESTROY_TIMEOUT = this.giprop(ctxt.getFactoryDestroyTimeout(), this.FACTORY_DESTROY_TIMEOUT);
    }

    void setWaitFactor(int waitFactor) {
        this.SESSION_RELEASE_TIMEOUT *= waitFactor;
        this.PRODAUTH_LOGIN_TIMEOUT *= waitFactor;
        this.HANDSHAKE_TIMEOUT *= waitFactor;
        this.FACTORY_DESTROY_TIMEOUT *= waitFactor;
    }

    private int giprop(int newval, int oldval) {
        int rv = 0;
        rv = newval > 0 && newval < Integer.MAX_VALUE ? newval * 1000 : oldval;
        return rv;
    }

    Commands getTimedCommand() {
        if (this.timedCommand == null) {
            this.timedCommand = new Commands();
        }
        return this.timedCommand;
    }

    void remoteRelease(SessionInterface session) throws RemoteException {
        this.m_session = session;
        this.timedRemoteMethod(this.SESSION_RELEASE_TIMEOUT, this.getTimedCommand(), COMMAND_RELEASE);
    }

    void remoteLogon() throws RemoteException {
        this.timedRemoteMethod(this.PRODAUTH_LOGIN_TIMEOUT, this.getTimedCommand(), COMMAND_LOGON);
    }

    void remoteHandshake() throws RemoteException {
        this.timedRemoteMethod(this.HANDSHAKE_TIMEOUT, this.getTimedCommand(), COMMAND_HANDSHAKE);
    }

    void remoteLogoff() throws RemoteException {
        this.timedRemoteMethod(this.FACTORY_DESTROY_TIMEOUT, this.getTimedCommand(), COMMAND_LOGOFF);
        if (this.timer != null) {
            this.timer.setFinishOnCompletion(true);
            this.timer = null;
        }
    }

    private boolean ignoreTimeout() {
        return this.m_ctxt != null && this.m_ctxt.isIgnoreTimeout();
    }

    void timedRemoteMethod(long timeout, Commands action, String arg) throws RemoteException {
        Object result = null;
        try {
            if (this.ignoreTimeout()) {
                action.run(arg);
            } else {
                final String farg = arg;
                final Commands faction = action;
                new TimeoutDriver().timeout(timeout, new Runnable(){

                    @Override
                    public void run() {
                        faction.runnoe(farg);
                    }
                });
                if (this.originalException != null) {
                    throw new InvocationTargetException(this.originalException);
                }
            }
        }
        catch (InvocationTargetException e) {
            throw new RemoteException(Message.format((String)RB.getStringResource(RB_KEY, "OpException.ex.txt"), (Object)J2Factory.safe(arg, "null"), (Object)J2Factory.safe(e.getMessage(), "")));
        }
        catch (TimedOutException e) {
            throw new RemoteException(Message.format((String)RB.getStringResource(RB_KEY, "TimedOut.ex.txt"), (Object)J2Factory.safe(arg, "null"), (Object)new Long(timeout)));
        }
        catch (InterruptedException e) {
            throw new RemoteException(Message.format((String)RB.getStringResource(RB_KEY, "OpException.ex.txt"), (Object)J2Factory.safe(arg, "null"), (Object)J2Factory.safe(e.getMessage(), "")));
        }
    }

    private static Object safe(Object object, Object ifNull) {
        return object == null ? ifNull : object;
    }

    boolean needAbort() {
        this.logonInterrupted = this.m_ctxt.stopping();
        if (this.logonInterrupted) {
            this.quickKill(this.m_prodauth);
            this.quickKill(this.m_factory);
            this.quickKill(this.m_logtrap);
            this.quickKill(this.m_submit);
            this.quickKill(this.m_mapper);
            this.quickKill(this.m_serverInfo);
            this.quickKill(this.m_profiler);
            this.m_prodauth = null;
            this.m_factory = null;
            this.m_logtrap = null;
            this.m_submit = null;
            this.m_mapper = null;
            this.m_serverInfo = null;
            this.m_profiler = null;
            this.m_ofId = 0;
        }
        return this.logonInterrupted;
    }

    public void logon() throws Exception {
        this.logonInterrupted = false;
        if (this.m_prodauth == null && !this.loggingOn) {
            this.loggingOn = true;
            this.m_logtrap = (LogTrapInterface)this.findGlobalObject(LogTrapInterface.class);
            this.m_profiler = (ProfilerInterface)this.findGlobalObject(ProfilerInterface.class);
            this.m_prodauth = (ProdauthV2Interface)this.findGlobalObject(ProdauthV2Interface.class);
            this.m_mapper = (MapNameInterface)this.findGlobalObject(MapNameInterface.class);
            this.m_submit = (SubmitInterface)this.findGlobalObject(SubmitInterface.class);
            this.m_serverInfo = (ServerInfoInterface)this.findGlobalObject(ServerInfoInterface.class);
            this.m_submit = (SubmitInterface)this.getGlobalObject(SubmitInterface.class);
            double sasVersion = this.m_ctxt.getSASVersion();
            if (this.m_logtrap == null && this.m_ctxt.isLogTrap()) {
                System.out.println(this.m_submit.getLogText());
                this.m_logtrap = (LogTrapInterface)this.getGlobalObject(LogTrapInterface.class);
                this.m_logtrap.setPrintStream(null);
                this.m_lt_istream = this.m_logtrap.getInputStream();
                this.m_lt_submit = this.m_logtrap.getSubmit();
                this.locallyCreatedLogTrap = true;
            }
            if (this.needAbort()) {
                return;
            }
            String istmt = this.m_ctxt.getInitialStatement();
            if (!this.m_sepTask && istmt != null && istmt.length() > 0) {
                this.m_submit = (SubmitInterface)this.getGlobalObject(SubmitInterface.class);
                this.m_submit.setProgramText(istmt);
            }
            this.verbose = this.m_ctxt.isTraceProxyClient();
            if (this.needAbort()) {
                return;
            }
            if (this.m_prodauth == null) {
                this.m_prodauth = (ProdauthV2Interface)this.getGlobalObject(ProdauthV2Interface.class);
            }
            if (this.needAbort()) {
                return;
            }
            HList l = new HList();
            int pos = 0;
            l.addItem(this.m_ctxt.getUsername(), pos++, "USERID");
            l.addItem(this.m_ctxt.getPassword(), pos++, "PASSWORD");
            if (sasVersion == 6.12 || sasVersion >= 8.2) {
                l.addItem("TRUE", pos++, "Funnel");
            } else {
                l.addItem(("" + this.m_sepTask).toUpperCase(), pos++, "Funnel");
            }
            String applUser = this.m_ctxt.getApplicationUsername();
            if (applUser == null) {
                applUser = this.m_ctxt.getUsername();
            }
            l.addItem(applUser, pos++, "APPLUSER");
            String applPassword = this.m_ctxt.getApplicationPassword();
            if (applPassword == null) {
                applPassword = this.m_ctxt.getPassword();
            }
            l.addItem(applPassword, pos++, "APPLPWD");
            String applClass = this.m_ctxt.getInitialClass();
            if (applClass != null) {
                l.addItem(applClass, pos++, "APPLCLS");
            }
            HListInterface applData = this.getApplicationData(this.m_ctxt);
            l.addItem(applData, pos++, "APPLDATA");
            if (this.needAbort()) {
                return;
            }
            if (this.skipAppl) {
                l.setItem(--pos, (HListInterface)new HList());
                l.setItem(--pos, "");
                l.setItem(--pos, "");
                if (applClass != null) {
                    l.setItem(--pos, "");
                }
            }
            this.m_logonList = l;
            this.remoteLogon();
            if (this.needAbort()) {
                return;
            }
            this.m_factory = (FactoryInterface)this.m_rocf.newInstance(FactoryInterface.class, this.m_ctxt, this.m_ofId);
            if (this.needAbort()) {
                return;
            }
            if (this.m_serverInfo == null) {
                int srvinfoId = this.newObject("SASHELP.RSASMOD.SRVINFO.CLASS");
                if (srvinfoId > 0) {
                    this.m_serverInfo = (ServerInfoInterface)this.m_rocf.newInstance(ServerInfoInterface.class, this.m_ctxt, srvinfoId);
                    String key = this.globalKey(ServerInfoInterface.class);
                    ServerInfoInterface val = this.m_serverInfo;
                    this.m_ctxt.setObject(key, val);
                }
                this.remoteHandshake();
            }
            if (this.needAbort()) {
                return;
            }
            if (this.m_profiler != null || this.m_ctxt.isProfiler()) {
                // empty if block
            }
            if (this.needAbort()) {
                return;
            }
            if (this.m_mapper == null) {
                this.m_mapper = (MapNameInterface)this.getGlobalObject(MapNameInterface.class);
                String sd = this.m_ctxt.getSearchDataSets();
                if (sd != null) {
                    HList hl = new HList();
                    StringTokenizer st = new StringTokenizer(sd, " ,");
                    while (st.hasMoreElements()) {
                        String tok = st.nextToken();
                        hl.addItem((HListItem)new StringItem(tok));
                    }
                    if (this.needAbort()) {
                        return;
                    }
                    this.m_mapper.setSearch((HListInterface)hl);
                }
            }
            if (this.needAbort()) {
                return;
            }
            if (sasVersion == 6.12 || sasVersion >= 8.2) {
                this.m_ctxt.setParameterMode(Connection.PARAMETERMODE_INPUT);
            }
            this.m_ready = true;
            this.loggingOn = false;
        }
    }

    void removeElement(Object o) {
        int indx = this.m_objvec.indexOf(o);
        if (indx >= 0) {
            this.m_objvec.removeElementAt(indx);
        }
    }

    void ostop(Object o) {
        this._p("ostop " + o);
        if (o != null) {
            if (o instanceof RemoteBaseClient) {
                RemoteBaseClient rbc = (RemoteBaseClient)o;
                int hndl = rbc._RemoteObject_getSCLHandle();
                String nm = rbc.getClass().getName();
                this._p("_TERM_ " + hndl + " " + nm);
                Connection c = rbc._RemoteObject_getContext();
                c.stop(rbc);
            }
            this.removeElement(o);
        }
    }

    void _p(String s) {
        if (this.verbose) {
            System.out.println(this.getClass().getName() + "::" + s);
        }
    }

    void quickKill(Object o) {
        if (o != null) {
            if (this.m_objvec.contains(o)) {
                this.m_objvec.removeElement(o);
            }
            if (this.m_gobjvec.contains(o)) {
                this.m_gobjvec.removeElement(o);
            }
            this.m_ctxt.removeElement(o);
        }
    }

    public void logoff() {
        if (this.m_prodauth == null) {
            return;
        }
        try {
            this.m_prodauth.logoff(this.m_ofId);
        }
        catch (Exception e) {
            System.out.println("Warning: Error logging off client");
        }
        if (this.locallyCreatedLogTrap && this.m_logtrap != null) {
            ((RemoteBaseClient)((Object)this.m_logtrap)).stop();
        }
        this.m_ofId = 0;
        this.m_prodauth = null;
        this.m_logtrap = null;
        this.locallyCreatedLogTrap = false;
    }

    void logoffImpl() {
        while (this.m_objvec.size() > 0) {
            this.ostop(this.m_objvec.elementAt(this.m_objvec.size() - 1));
        }
        if (this.m_ofId > 0) {
            this.m_prodauth.logoff(this.m_ofId);
        }
        if (this.m_factory != null) {
            this.m_ctxt.removeElement(this.m_factory);
            this.removeElement(this.m_factory);
            if (this.m_factory instanceof J2BaseClient) {
                J2BaseClient j2bc = (J2BaseClient)((Object)this.m_factory);
                j2bc.resetLocals();
            }
            this.m_factory = null;
        }
        this.m_ofId = 0;
        if (!this.m_sepTask) {
            this.deleteGlobalObjects();
        }
        this.m_submit = null;
        this.m_prodauth = null;
        this.m_mapper = null;
        this.m_serverInfo = null;
        this.m_logtrap = null;
        this.m_profiler = null;
    }

    public boolean preallocatedObject(Object o) {
        boolean r = false;
        if (o != null) {
            r = o == this.m_prodauth || o == this.m_factory || o == this.m_submit || o == this.m_logtrap || o == this.m_mapper || o == this.m_profiler || o == this.m_lt_istream || o == this.m_lt_submit || o == this.m_serverInfo;
        }
        return r;
    }

    public boolean ready() {
        return this.m_ready;
    }

    public int newObject(String remoteObjName) throws Exception {
        return this.m_factory.createObject(remoteObjName);
    }

    public void destroy(int objectId) {
        if (objectId > 0) {
            if (objectId == this.m_ofId) {
                this._p("Skipping destroy request against FACTORY");
            } else if (this.m_factory == null) {
                this._p("m_factory=null, skip destroy " + objectId);
            } else {
                RemoteBaseClient rbc = (RemoteBaseClient)((Object)this.m_factory);
                int fcth = rbc._RemoteObject_getSCLHandle();
                this._p("destroy:m_factory=" + fcth + " obj=" + objectId);
                this.m_factory.destroy(objectId);
            }
        }
    }

    public void reset(String applUser, String applPwd) {
        throw new RuntimeException(this.getClass().getName() + ":reset not implemented");
    }

    String map(String name) {
        String ret = this.m_cachemap.getProperty(name);
        if (ret == null) {
            if (this.m_mapper == null) {
                ret = name;
            } else {
                ret = this.m_mapper.map(name);
                this.m_cachemap.put(name, ret);
            }
        }
        return ret;
    }

    void add(Object o) {
    }

    Vector getObjects() {
        return this.m_objvec;
    }

    void addGlobalObject(Object o) {
    }

    void deleteGlobalObjects() {
        while (this.m_gobjvec.size() > 0) {
            int i = this.m_gobjvec.size() - 1;
            Object o = this.m_gobjvec.elementAt(i);
            this._p("delete " + o);
            this.ostop(o);
            this.m_gobjvec.removeElementAt(i);
            this.m_ctxt.removeElement(o);
        }
    }

    Vector getGlobalObjects() {
        return this.m_gobjvec;
    }

    int factoryId() {
        return this.m_ofId;
    }

    protected HListInterface getApplicationData(Connection c) {
        HList l = new HList();
        int pos = 0;
        Properties p = c._getApplicationData();
        if (p != null) {
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = p.getProperty(key);
                l.addItem(value, pos++, key);
            }
        }
        return l;
    }

    void setSkipAppl(boolean b) {
        this.skipAppl = b;
    }

    public Object _RemoteObject_enter(String methodName) throws ServerBusyTimeoutException {
        long timeout = 600000L;
        return this._RemoteObject_enter(methodName, 600000L);
    }

    public Object _RemoteObject_enter(String methodName, long timeout) throws ServerBusyTimeoutException {
        SingleThreadedQueue stq = this.m_ctxt.getSTQ();
        Object key = stq.acquire(this, methodName);
        try {
            boolean canEnterMethod = stq.enter(key, timeout);
            if (!canEnterMethod) {
                throw new ServerBusyTimeoutException();
            }
        }
        catch (InterruptedException e) {
            throw new ServerBusyTimeoutException();
        }
        return key;
    }

    public void _RemoteObject_exit(String methodName, Object o) {
        QueueKey qk = (QueueKey)o;
        SingleThreadedQueue stq = this.m_ctxt.getSTQ();
        stq.exit(qk);
    }

    String globalKey(Class interfaceClass) {
        return "Singleton:" + interfaceClass.getName();
    }

    Object findGlobalObject(Class interfaceClass) {
        String key = this.globalKey(interfaceClass);
        Object val = this.m_ctxt.getObject(key);
        return val;
    }

    Object getGlobalObject(Class interfaceClass) throws Exception {
        String key = this.globalKey(interfaceClass);
        Object val = this.m_ctxt.getObject(key);
        if (val == null) {
            val = this.m_rocf.newInstance(interfaceClass, this.m_ctxt);
            this.m_ctxt.setObject(key, val);
        }
        return val;
    }

    class Commands
    implements TimedCommandInterface {
        Commands() {
        }

        public synchronized void execute(Object arg) {
            try {
                this.run(arg);
            }
            catch (TimedOutException timedOutException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void interrupt() {
        }

        public void run(Object arg) throws InterruptedException, TimedOutException, InvocationTargetException {
            if (arg == J2Factory.COMMAND_LOGON) {
                J2Factory.this.m_ofId = J2Factory.this.m_prodauth.logon(J2Factory.this.m_logonList);
            } else if (arg == J2Factory.COMMAND_RELEASE) {
                Object _o = null;
                try {
                    _o = J2Factory.this._RemoteObject_enter("ENDSAS");
                    J2Factory.this.m_session.release();
                }
                catch (ServerBusyTimeoutException e) {
                    throw new TimedOutException(e.toString());
                }
                catch (RemoteSasException e) {
                    throw new InvocationTargetException((Throwable)((Object)e));
                }
                finally {
                    J2Factory.this._RemoteObject_exit("ENDSAS", _o);
                }
            } else if (arg == J2Factory.COMMAND_HANDSHAKE) {
                Handshaker shaker = new Handshaker(J2Factory.this.m_rocf, J2Factory.this.m_ctxt, J2Factory.this.m_serverInfo);
                shaker.handshake();
            } else if (arg == J2Factory.COMMAND_LOGOFF) {
                J2Factory.this.logoffImpl();
            }
        }

        public void runnoe(Object arg) {
            try {
                this.run(arg);
            }
            catch (InterruptedException ie) {
                J2Factory.this.originalException = ie;
            }
            catch (TimedOutException toe) {
                J2Factory.this.originalException = (Exception)((Object)toe);
            }
            catch (InvocationTargetException ite) {
                J2Factory.this.originalException = ite;
            }
        }
    }
}

