/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.collection.hlist.HListInterface;
import com.sas.net.server.AfAccessInterface;
import com.sas.net.server.AfRequestInterface;
import com.sas.net.server.RemoteSasException;
import com.sas.net.server.SessionFactory;
import com.sas.net.server.SessionFactoryNotificationInterface;
import com.sas.net.server.SessionInterface;
import com.sas.net.server.WorkspaceInterface;
import com.sas.rmi.ClientTaskManager;
import com.sas.rmi.Connection;
import com.sas.rmi.ConnectionPropertyUtil;
import com.sas.rmi.J2Factory;
import com.sas.rmi.LocalModelInterface;
import com.sas.rmi.QueueKey;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.rmi.ServerBusyTimeoutException;
import com.sas.rmi.SingleThreadedQueue;
import com.sas.rmi.remotesupport.RemoteSupportInterface;
import java.util.Properties;

public abstract class J2BaseClient
extends RemoteBaseClient
implements SessionFactoryNotificationInterface {
    private transient AfRequestInterface m_remoteObject;
    private transient AfAccessInterface m_client;
    private transient Connection m_ctxt;
    private transient AfRequestInterface m_eventHandler;
    private transient SessionInterface m_session;
    private transient WorkspaceInterface m_workspace;
    private transient ClientTaskManager m_ctm;
    private transient Exception m_exception;
    private transient Object _del;
    private transient boolean t_done;
    private transient boolean m_AfBypass;
    private transient boolean m_eventTrapping;
    private transient boolean m_delegateReady;
    private transient boolean m_clientReady;
    private transient boolean m_factoryAllocated;
    private transient boolean m_factoryAdded;
    private transient long timeout;

    protected void resetLocals() {
        this.m_remoteObject = null;
        this.m_client = null;
        this.m_ctxt = null;
        this.m_eventHandler = null;
        this.m_session = null;
        this.m_workspace = null;
        this.m_ctm = null;
        this.m_exception = null;
        this._del = null;
        this.t_done = false;
        this.m_AfBypass = false;
        this.m_eventTrapping = false;
        this.m_delegateReady = false;
        this.m_clientReady = false;
        this.m_factoryAllocated = false;
        this.m_factoryAdded = false;
    }

    public J2BaseClient() {
        this.resetLocals();
    }

    void startSASBlocked(Properties p) {
        this.t_done = false;
        try {
            this.m_session = SessionFactory.getNewSession(p);
        }
        catch (RemoteSasException e) {
            this.m_exception = e;
        }
        this.t_done = true;
    }

    synchronized void startSASThreaded(Properties p) {
        this.t_done = false;
        this.startSASBlocked(p);
        this.t_done = true;
    }

    @Override
    public void sessionReady(SessionInterface s) {
        this.t_done = true;
        this.m_session = s;
        this.m_ctxt.wakeupSnoozers();
    }

    @Override
    public void sessionCreationFailed(RemoteSasException e) {
        this.t_done = true;
        this.m_exception = e;
        this.m_ctxt.wakeupSnoozers();
    }

    public Object _RemoteObject_enter(String methodName) throws ServerBusyTimeoutException {
        return this._RemoteObject_enter(methodName, this.timeout);
    }

    public Object _RemoteObject_enter(String methodName, long timeout) throws ServerBusyTimeoutException {
        SingleThreadedQueue stq = this.m_ctxt.getSTQ();
        Object key = stq.acquire(this, methodName);
        try {
            boolean canEnterMethod = stq.enter(key, timeout);
            if (!canEnterMethod) {
                throw new ServerBusyTimeoutException();
            }
        }
        catch (InterruptedException e) {
            throw new ServerBusyTimeoutException();
        }
        return key;
    }

    public void _RemoteObject_exit(String methodName, Object o) {
        QueueKey qk = (QueueKey)o;
        SingleThreadedQueue stq = this.m_ctxt.getSTQ();
        stq.exit(qk);
    }

    String _Rocf_oname() {
        String s = this.getClass().getName();
        int start = s.indexOf("_rprxJ2");
        if (start == -1) {
            start = s.indexOf("FinalJ2");
        }
        if (start > 0) {
            s = s.substring(start + 7);
        }
        return s;
    }

    public String toString() {
        return this._Rocf_oname();
    }

    @Override
    public void _RemoteObject_setupClient(Connection ctxt) throws Exception {
        String methodName = "_RemoteObject_setupClient";
        this.m_ctxt = ctxt;
        this.timeout = this.m_ctxt.getQueueWaitTimeout() * 1000;
        this.m_AfBypass = this._RemoteObject_getCatalog().equals("none");
        this._RemoteObject_setSetupStatus("Setting up JConnect client...");
        this.setStatusWorking("Creating J2 Client");
        ctxt.getSTQ().setPrintQueue(ctxt.isTraceProxyClient());
        ctxt.preloadCheck();
        this.m_session = (SessionInterface)this.m_ctxt._getSession();
        if (this.m_session == null) {
            if (this.m_ctxt.tpc()) {
                ConnectionPropertyUtil.printConnection(this.m_ctxt);
            }
            Properties p = ConnectionPropertyUtil.patchProperties(this.m_ctxt);
            String key = "host";
            p.put(key, this.m_ctxt.getTrueHost());
            this.setStatusWorking("Connecting to J2");
            Object _o = null;
            try {
                _o = this._RemoteObject_enter("StartSAS");
                this.m_exception = null;
                if (ctxt.isIgnoreTimeout()) {
                    this.startSASBlocked(p);
                } else {
                    this.startSASThreaded(p);
                }
                if (this.m_exception != null) {
                    throw (RemoteSasException)((Object)this.m_exception);
                }
                if (!this.t_done) {
                    throw new InterruptedException();
                }
            }
            catch (RemoteSasException e) {
                throw e;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (ServerBusyTimeoutException e) {
                throw e;
            }
            finally {
                this._RemoteObject_exit("StartSAS", _o);
            }
            this.m_ctxt.setRuntimeFlag(Connection.DESTROY_CLIENT);
            this.m_ctxt._setSession(this.m_session);
        }
        this.m_workspace = (WorkspaceInterface)this.m_ctxt._getWorkspace();
        if (this.m_workspace == null) {
            this.setStatusWorking("Getting J2 workspace");
            this.m_workspace = this.m_session.getNewWorkspace();
            this.m_ctxt._setWorkspace(this.m_workspace);
        }
        this.m_client = (AfAccessInterface)this.m_ctxt._getAfAccess();
        if (this.m_client == null && !this.m_AfBypass) {
            this.m_client = this.m_workspace.getAfAccessObject();
            this.m_ctxt._setAfAccess(this.m_client);
        }
        if (this.m_workspace == null) {
            throw new RuntimeException("Cannot get session for binding");
        }
    }

    @Override
    public void _RemoteObject_getInstance() throws Exception {
        String methodName = "_RemoteObject_getInstance";
        this._RemoteObject_newInstance();
    }

    private void addtofac() {
        J2Factory j2f;
        if (this.m_ctxt != null && (j2f = this.m_ctxt.getJ2Factory()) != null && j2f.ready() && !this.m_factoryAdded) {
            this.m_factoryAdded = true;
            j2f.add(this);
        }
    }

    private void delfmfac() {
        J2Factory j2f;
        if (this.m_ctxt != null && (j2f = this.m_ctxt.getJ2Factory()) != null && j2f.ready() && this.m_factoryAdded) {
            this.m_factoryAdded = false;
            j2f.removeElement(this);
        }
    }

    @Override
    public void _RemoteObject_newInstance() throws Exception {
        String newName;
        String iName;
        if (this.m_AfBypass) {
            this.m_clientReady = true;
            this.addtofac();
            return;
        }
        String methodName = "_RemoteObject_newInstance";
        String catalog = this._RemoteObject_getTrueCatalog();
        String remoteObjName = catalog + "." + this._RemoteObject_getTrueName() + ".class";
        int sclHandle = this._RemoteObject_getSCLHandle();
        Connection ctxt = this._RemoteObject_getContext();
        J2Factory j2f = this.m_ctxt.getJ2Factory();
        Rocf rocf = this._RemoteObject_getClassFactory();
        String iTail = iName = this._RemoteObject_getInterfaceName();
        int inindx = iName.lastIndexOf(46);
        if (inindx >= 0) {
            iTail = iName.substring(inindx + 1);
        }
        rocf.setStatus(iTail);
        if (sclHandle < 1 && j2f.ready() && !(newName = j2f.map(iName)).startsWith("WARNING:")) {
            remoteObjName = newName;
        }
        if (sclHandle < 1) {
            if (j2f.ready()) {
                sclHandle = j2f.newObject(remoteObjName);
                this.m_factoryAllocated = true;
                if (sclHandle == 0) {
                    String s = iName + ":instance(loadclass(" + remoteObjName + "))=0";
                    throw new RemoteSasException(s);
                }
                this.m_remoteObject = this.m_client.bindRemoteInstance(sclHandle);
            } else {
                this.m_remoteObject = this.m_client.createRemoteInstance(remoteObjName);
            }
        } else {
            this.m_factoryAllocated = true;
            this.m_remoteObject = this.m_client.bindRemoteInstance(sclHandle);
        }
        this.addtofac();
        rocf.setStatus(null);
        sclHandle = (int)this.m_remoteObject.getHandle();
        this._RemoteObject_setSCLHandle(sclHandle);
        this._RemoteObject_setUtility(this.m_remoteObject);
        ctxt.postloadCheck();
        this.m_clientReady = true;
    }

    @Override
    public synchronized void stop() {
        if (this.m_ctxt == null) {
            return;
        }
        J2Factory j2f = this.m_ctxt.getJ2Factory();
        if (j2f == null) {
            return;
        }
        if (this.m_ctxt._getSession() == null) {
            return;
        }
        try {
            int sclhandle = this._RemoteObject_getSCLHandle();
            if (this.m_factoryAllocated) {
                j2f.destroy(sclhandle);
            }
            if (this.m_remoteObject != null) {
                this.m_remoteObject.release();
            }
            this.delfmfac();
            if (sclhandle > 0) {
                // empty if block
            }
            if (this.m_eventHandler != null) {
                this._p("stop:_TERM_ remote model event handler");
                this.m_eventHandler.destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.resetLocals();
        super.stop();
    }

    public void destroy() throws Exception {
        this.stop();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public void _RemoteObject_postMethodInvocation() {
    }

    public Object _j2bc_getObject(Class c) {
        Object o = null;
        try {
            Rocf rocf = this._RemoteObject_getClassFactory();
            Connection ctxt = this._RemoteObject_getContext();
            double d = this.m_remoteObject.getDoubleArgument();
            o = rocf.newInstance(c, ctxt, null, (int)d);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        return o;
    }

    public void _j2bc_addObjectArgument(Object o, int pmode) throws RemoteSasException {
        RemoteBaseClient rbc = (RemoteBaseClient)o;
        this.m_remoteObject.addDoubleArgument(rbc._RemoteObject_getSCLHandle(), pmode);
    }

    @Override
    public boolean _RemoteObject_useThreads() {
        return false;
    }

    @Override
    public boolean _RemoteObject_ping() {
        boolean isThere = false;
        this.setStatusWorking("Checking remote object");
        try {
            AfRequestInterface remote = (AfRequestInterface)this._RemoteObject_getUtility();
            remote.clearArguments();
            remote.addStringArgument(null, 12);
            remote.invokeRemoteMethod("_type_of_");
            remote.getStringArgument();
            isThere = true;
            this.setStatusSuccess();
        }
        catch (Exception ex) {
            this.setStatusFailed(ex.getMessage());
            ex.printStackTrace();
        }
        return isThere;
    }

    protected void setStatusWorking(String status) {
        if (this.m_ctxt != null) {
            this.m_ctxt.fireStatusEvent(0, status);
        }
    }

    protected void setStatusSuccess() {
        if (this.m_ctxt != null) {
            this.m_ctxt.fireStatusEvent(1, "Success");
        }
    }

    protected void setStatusFailed(String msg) {
        if (this.m_ctxt != null) {
            this.m_ctxt.fireStatusEvent(2, "Failure: " + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConnection(Connection ctxt) {
        SessionInterface session = (SessionInterface)ctxt._getSession();
        if (session == null) {
            return;
        }
        SingleThreadedQueue stq = ctxt.getSTQ();
        Object key = null;
        J2Factory j2f = ctxt.getJ2Factory();
        if (j2f != null) {
            j2f.logoff();
        }
        String methodName = "releaseConnection";
        long timeout = 10000L;
        try {
            key = stq.acquire("J2BaseClient", methodName);
            boolean canEnterMethod = stq.enter(key, timeout);
            if (canEnterMethod) {
                session.release();
                ctxt._setSession(null);
            } else {
                System.out.println("Timed out waiting to ENDSAS");
            }
        }
        catch (InterruptedException e) {
            System.out.println("Caught exception of SAS exit");
            e.printStackTrace();
        }
        catch (RemoteSasException e) {
            System.out.println("Caught exception of SAS exit");
            e.printStackTrace();
        }
        finally {
            stq.exit(key);
        }
    }

    @Override
    public Object _getDelegate(Class c) {
        if (c == null) {
            return null;
        }
        if (this._del == null) {
            try {
                this._del = c.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("IllegalAccessException");
            }
            catch (InstantiationException ie) {
                throw new RuntimeException("InstantiationException");
            }
        }
        this._setupDelegate();
        return this._del;
    }

    private void _setupDelegate() {
        if (this.m_clientReady && this._del != null && !this.m_delegateReady) {
            this.m_delegateReady = true;
            if (this._del instanceof LocalModelInterface) {
                ((LocalModelInterface)this._del)._setRemoteHandle(this);
            }
        }
    }

    protected RemoteSupportInterface getRemoteSupportObject() {
        RemoteSupportInterface remoteSupport = (RemoteSupportInterface)this.m_ctxt.getObject("RemoteSupportInterface");
        if (remoteSupport == null) {
            Rocf rocf = this._RemoteObject_getClassFactory();
            try {
                remoteSupport = (RemoteSupportInterface)rocf.newInstance(RemoteSupportInterface.class, this.m_ctxt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.m_ctxt.setObject("RemoteSupportInterface", remoteSupport);
        }
        return remoteSupport;
    }

    public String getCharacterAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        return remoteSupport.getCharacterAttributeValue(remoteObjectId, sclAttributeName);
    }

    public double getDoubleAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        return remoteSupport.getNumericAttributeValue(remoteObjectId, sclAttributeName);
    }

    public int getIntAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        return (int)remoteSupport.getNumericAttributeValue(remoteObjectId, sclAttributeName);
    }

    public byte getByteAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        return (byte)remoteSupport.getNumericAttributeValue(remoteObjectId, sclAttributeName);
    }

    public short getShortAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        return (short)remoteSupport.getNumericAttributeValue(remoteObjectId, sclAttributeName);
    }

    public float getFloatAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        return (float)remoteSupport.getNumericAttributeValue(remoteObjectId, sclAttributeName);
    }

    public long getLongAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        return (long)remoteSupport.getNumericAttributeValue(remoteObjectId, sclAttributeName);
    }

    public char getCharAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        String str = remoteSupport.getCharacterAttributeValue(remoteObjectId, sclAttributeName);
        if (str.length() > 0) {
            return str.charAt(0);
        }
        return '\u0000';
    }

    public HListInterface getListAttributeValue(int remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        return remoteSupport.getListAttributeValue(remoteObjectId, sclAttributeName);
    }

    public String[] getStringArrayAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        return remoteSupport.getCharacterArrayAttributeValue(remoteObjectId, sclAttributeName);
    }

    public double[] getDoubleArrayAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        return remoteSupport.getNumericArrayAttributeValue(remoteObjectId, sclAttributeName);
    }

    public int[] getIntArrayAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        double[] remoteArray = remoteSupport.getNumericArrayAttributeValue(remoteObjectId, sclAttributeName);
        int[] returnArray = new int[remoteArray.length];
        for (int i = 0; i < remoteArray.length; ++i) {
            returnArray[i] = (int)remoteArray[i];
        }
        return returnArray;
    }

    public byte[] getByteArrayAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        double[] remoteArray = remoteSupport.getNumericArrayAttributeValue(remoteObjectId, sclAttributeName);
        byte[] returnArray = new byte[remoteArray.length];
        for (int i = 0; i < remoteArray.length; ++i) {
            returnArray[i] = (byte)remoteArray[i];
        }
        return returnArray;
    }

    public short[] getShortArrayAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        double[] remoteArray = remoteSupport.getNumericArrayAttributeValue(remoteObjectId, sclAttributeName);
        short[] returnArray = new short[remoteArray.length];
        for (int i = 0; i < remoteArray.length; ++i) {
            returnArray[i] = (short)remoteArray[i];
        }
        return returnArray;
    }

    public float[] getFloatArrayAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        double[] remoteArray = remoteSupport.getNumericArrayAttributeValue(remoteObjectId, sclAttributeName);
        float[] returnArray = new float[remoteArray.length];
        for (int i = 0; i < remoteArray.length; ++i) {
            returnArray[i] = (float)remoteArray[i];
        }
        return returnArray;
    }

    public long[] getLongArrayAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        double[] remoteArray = remoteSupport.getNumericArrayAttributeValue(remoteObjectId, sclAttributeName);
        long[] returnArray = new long[remoteArray.length];
        for (int i = 0; i < remoteArray.length; ++i) {
            returnArray[i] = (long)remoteArray[i];
        }
        return returnArray;
    }

    public char[] getCharArrayAttributeValue(double remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        String str = remoteSupport.getCharacterAttributeValue(remoteObjectId, sclAttributeName);
        return str.toCharArray();
    }

    public HListInterface[] getListArrayAttributeValue(int remoteObjectId, String sclAttributeName) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        return remoteSupport.getListArrayAttributeValue(remoteObjectId, sclAttributeName);
    }

    public void setCharacterAttributeValue(int remoteObjectId, String sclAttributeName, String value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        remoteSupport.setCharacterAttributeValue(remoteObjectId, sclAttributeName, value);
    }

    public void setDoubleAttributeValue(int remoteObjectId, String sclAttributeName, double value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        remoteSupport.setNumericAttributeValue(remoteObjectId, sclAttributeName, value);
    }

    public void setIntAttributeValue(int remoteObjectId, String sclAttributeName, int value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        remoteSupport.setNumericAttributeValue(remoteObjectId, sclAttributeName, value);
    }

    public void setByteAttributeValue(int remoteObjectId, String sclAttributeName, byte value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        remoteSupport.setNumericAttributeValue(remoteObjectId, sclAttributeName, value);
    }

    public void setShortAttributeValue(int remoteObjectId, String sclAttributeName, short value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        remoteSupport.setNumericAttributeValue(remoteObjectId, sclAttributeName, value);
    }

    public void setFloatAttributeValue(int remoteObjectId, String sclAttributeName, float value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        remoteSupport.setNumericAttributeValue(remoteObjectId, sclAttributeName, value);
    }

    public void setLongAttributeValue(int remoteObjectId, String sclAttributeName, long value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        remoteSupport.setNumericAttributeValue(remoteObjectId, sclAttributeName, value);
    }

    public void setCharAttributeValue(int remoteObjectId, String sclAttributeName, char value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        remoteSupport.setNumericAttributeValue(remoteObjectId, sclAttributeName, value);
    }

    public void setListAttributeValue(int remoteObjectId, String sclAttributeName, HListInterface value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        remoteSupport.setListAttributeValue(remoteObjectId, sclAttributeName, value);
    }

    public void setStringArrayAttributeValue(int remoteObjectId, String sclAttributeName, String[] value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        remoteSupport.setCharacterArrayAttributeValue(remoteObjectId, sclAttributeName, value);
    }

    public void setDoubleArrayAttributeValue(int remoteObjectId, String sclAttributeName, double[] value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        remoteSupport.setNumericArrayAttributeValue(remoteObjectId, sclAttributeName, value);
    }

    public void setIntArrayAttributeValue(int remoteObjectId, String sclAttributeName, int[] value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        double[] remoteArray = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            remoteArray[i] = value[i];
        }
        remoteSupport.setNumericArrayAttributeValue(remoteObjectId, sclAttributeName, remoteArray);
    }

    public void setByteArrayAttributeValue(int remoteObjectId, String sclAttributeName, byte[] value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        double[] remoteArray = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            remoteArray[i] = value[i];
        }
        remoteSupport.setNumericArrayAttributeValue(remoteObjectId, sclAttributeName, remoteArray);
    }

    public void setShortArrayAttributeValue(int remoteObjectId, String sclAttributeName, short[] value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        double[] remoteArray = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            remoteArray[i] = value[i];
        }
        remoteSupport.setNumericArrayAttributeValue(remoteObjectId, sclAttributeName, remoteArray);
    }

    public void setFloatArrayAttributeValue(int remoteObjectId, String sclAttributeName, float[] value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        double[] remoteArray = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            remoteArray[i] = value[i];
        }
        remoteSupport.setNumericArrayAttributeValue(remoteObjectId, sclAttributeName, remoteArray);
    }

    public void setLongArrayAttributeValue(int remoteObjectId, String sclAttributeName, long[] value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        double[] remoteArray = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            remoteArray[i] = value[i];
        }
        remoteSupport.setNumericArrayAttributeValue(remoteObjectId, sclAttributeName, remoteArray);
    }

    public void setCharArrayAttributeValue(int remoteObjectId, String sclAttributeName, char[] value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        String remoteValue = new String(value);
        remoteSupport.setCharacterAttributeValue(remoteObjectId, sclAttributeName, remoteValue);
    }

    public void setListArrayAttributeValue(int remoteObjectId, String sclAttributeName, HListInterface[] value) {
        RemoteSupportInterface remoteSupport = this.getRemoteSupportObject();
        remoteSupport.setListArrayAttributeValue(remoteObjectId, sclAttributeName, value);
    }
}

