/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.StringItem;
import com.sas.rmi.Connection;
import com.sas.rmi.IOMBaseClient;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.sasserver.inputstream.InputStreamInterface;
import com.sas.sasserver.logtrap.LogTrapInterface;
import com.sas.sasserver.mapname.MapNameInterface;
import com.sas.sasserver.ofactory.corba.ofactory.OfactoryInterface;
import com.sas.sasserver.profiler.ProfilerInterface;
import com.sas.sasserver.rprdauth.ProdAuthInterface;
import com.sas.sasserver.submit.SubmitInterface;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.COMM_FAILURE;

public class IOMFactory {
    private transient Rocf m_rocf;
    private transient Connection m_ctxt;
    private transient OfactoryInterface m_Ofactory;
    private transient SubmitInterface m_submit;
    private transient MapNameInterface m_mapper;
    private transient ProdAuthInterface m_prodauth;
    private transient LogTrapInterface m_logtrap;
    private transient ProfilerInterface m_profiler;
    private transient InputStreamInterface m_lt_istream;
    private transient SubmitInterface m_lt_submit;
    private transient Properties m_cachemap = new Properties();
    private transient boolean m_sepTask;
    private transient Vector m_objvec = new Vector();
    private transient Vector m_gobjvec = new Vector();
    private transient boolean m_ready;
    private transient boolean preallocatedLogTrap;
    private transient boolean preallocatedProdauth;
    private transient boolean preallocatedProfiler;
    private transient boolean preallocatedOfactory;
    private transient boolean preallocatedSubmit;
    private transient boolean preallocatedMapName;
    private transient boolean verbose;
    private transient boolean locallyCreatedLogTrap;
    private transient int factoryId;
    private transient boolean skipAppl;
    private transient HListInterface m_logonList;

    public IOMFactory(Rocf rocf, Connection ctxt, boolean sepTask) {
        this.m_rocf = rocf;
        this.m_ctxt = ctxt;
        this.m_sepTask = sepTask;
        this.m_ready = false;
    }

    public void logon() throws Exception {
        if (!this.m_ctxt.isGMS() && !this.m_ctxt.isOLAP()) {
            if (this.m_Ofactory == null) {
                String istmt;
                this.preallocatedLogTrap = false;
                this.preallocatedProdauth = false;
                this.preallocatedProfiler = false;
                this.preallocatedOfactory = false;
                this.preallocatedMapName = false;
                this.preallocatedSubmit = false;
                String key = "Singleton:" + SubmitInterface.class.getName();
                this.m_submit = null;
                if (this.m_submit == null) {
                    this.m_submit = (SubmitInterface)this.m_rocf.newInstance(SubmitInterface.class, this.m_ctxt);
                    this.m_ctxt.setObject(key, this.m_submit);
                }
                if ((istmt = this.m_ctxt.getInitialStatement()) != null && istmt.length() > 0) {
                    this.m_submit.setProgramText(istmt);
                }
                this.m_ctxt.getSASVersion();
                if (!this.preallocatedLogTrap && this.m_ctxt.isLogTrap()) {
                    this.m_logtrap = (LogTrapInterface)this.m_rocf.newInstance(LogTrapInterface.class, this.m_ctxt);
                    key = "Singleton:" + LogTrapInterface.class.getName();
                    this.m_ctxt.setObject(key, this.m_logtrap);
                    this.m_logtrap.setPrintStream(this.m_ctxt._getLogTrapOut());
                    this.locallyCreatedLogTrap = true;
                }
                if (this.m_logtrap != null) {
                    this.m_lt_istream = this.m_logtrap.getInputStream();
                    this.m_lt_submit = this.m_logtrap.getSubmit();
                }
                this.verbose = this.m_ctxt.isTraceProxyClient();
                if (!this.preallocatedOfactory) {
                    Object o = this.m_ctxt.getObject(IOMBaseClient.FACTORYKEY);
                    this.m_Ofactory = (OfactoryInterface)o;
                }
                if (!this.preallocatedProdauth) {
                    this.m_prodauth = (ProdAuthInterface)this.m_rocf.newInstance(ProdAuthInterface.class, this.m_ctxt);
                }
                HList l = new HList();
                int pos = 0;
                l.addItem(this.m_ctxt.getUsername(), pos++, "USERID");
                l.addItem(this.m_ctxt.getPassword(), pos++, "PASSWORD");
                l.addItem("FALSE", pos++, "Funnel");
                String applUser = this.m_ctxt.getApplicationUsername();
                if (applUser == null) {
                    applUser = this.m_ctxt.getUsername();
                }
                l.addItem(applUser, pos++, "APPLUSER");
                String applPassword = this.m_ctxt.getApplicationPassword();
                if (applPassword == null) {
                    applPassword = this.m_ctxt.getPassword();
                }
                l.addItem(applPassword, pos++, "APPLPWD");
                String applClass = this.m_ctxt.getInitialClass();
                if (applClass != null) {
                    l.addItem(applClass, pos++, "APPLCLS");
                }
                HListInterface applData = this.getApplicationData(this.m_ctxt);
                l.addItem(applData, pos++, "APPLDATA");
                if (this.skipAppl) {
                    l.setItem(--pos, (HListInterface)new HList());
                    l.setItem(--pos, "");
                    l.setItem(--pos, "");
                    if (applClass != null) {
                        l.setItem(--pos, "");
                    }
                }
                this.factoryId = (int)this.m_prodauth.logon((HListInterface)l);
                if (this.factoryId == 0) {
                    throw new RuntimeException("prodauth logon failed");
                }
                if (!this.preallocatedProfiler && this.m_ctxt.isProfiler()) {
                    this.m_profiler = (ProfilerInterface)this.m_rocf.newInstance(ProfilerInterface.class, this.m_ctxt);
                }
                if (!this.preallocatedMapName) {
                    this.m_mapper = (MapNameInterface)this.m_rocf.newInstance(MapNameInterface.class, this.m_ctxt);
                    String sd = this.m_ctxt.getSearchDataSets();
                    if (sd != null) {
                        HList hl = new HList();
                        StringTokenizer st = new StringTokenizer(sd, " ,");
                        while (st.hasMoreElements()) {
                            String tok = st.nextToken();
                            hl.addItem((HListItem)new StringItem(tok));
                        }
                        this.m_mapper.setSearch((HListInterface)hl);
                    }
                }
                this.addGlobalObject(this.m_profiler);
                this.addGlobalObject(this.m_logtrap);
                this.addGlobalObject(this.m_Ofactory);
                this.addGlobalObject(this.m_mapper);
                this.addGlobalObject(this.m_submit);
                this.m_ready = true;
            }
        } else {
            this.m_ready = true;
        }
    }

    void removeElement(Object o) {
        int indx = this.m_objvec.indexOf(o);
        if (indx >= 0) {
            this.m_objvec.removeElementAt(indx);
        }
    }

    void ostop(Object o) {
        this._p("ostop " + o);
        if (o != null) {
            if (o instanceof RemoteBaseClient) {
                RemoteBaseClient rbc = (RemoteBaseClient)o;
                int hndl = rbc._RemoteObject_getSCLHandle();
                String nm = rbc.getClass().getName();
                this._p("_TERM_ " + hndl + " " + nm);
                Connection c = rbc._RemoteObject_getContext();
                c.stop(rbc);
            }
            this.removeElement(o);
        }
    }

    void _p(String s) {
        if (this.verbose) {
            System.out.println(this.getClass().getName() + "::" + s);
        }
    }

    public void logoff() throws Exception {
        if (this.m_prodauth == null) {
            return;
        }
        try {
            this.m_prodauth.logoff();
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
        }
        catch (Exception e) {
            System.out.println("Warning: Error logging off client");
        }
        if (this.locallyCreatedLogTrap && this.m_logtrap != null) {
            ((RemoteBaseClient)((Object)this.m_logtrap)).stop();
            this.m_logtrap = null;
        }
    }

    public void reset(String applUser, String applPwd) {
        throw new RuntimeException(this.getClass().getName() + ":reset not implemented");
    }

    public boolean preallocatedObject(Object o) {
        boolean r = false;
        if (o != null) {
            r = o == this.m_Ofactory || o == this.m_submit || o == this.m_logtrap || o == this.m_mapper || o == this.m_profiler || o == this.m_lt_istream || o == this.m_lt_submit;
        }
        return r;
    }

    public boolean ready() {
        return this.m_ready;
    }

    public Object newObject(String remoteObjName) throws Exception {
        return this.m_Ofactory.createObject(remoteObjName);
    }

    public void destroy(int objectId) {
        if (objectId > 0) {
            if (this.m_Ofactory == null) {
                this._p("m_Ofactory=null, skip destroy " + objectId);
            } else {
                RemoteBaseClient rbc = (RemoteBaseClient)((Object)this.m_Ofactory);
                Object opaqueObj = rbc._RemoteObject_getObject();
                this._p("destroy:m_Ofactory=" + this.m_Ofactory + " obj=" + opaqueObj);
                System.out.println(this.getClass().getName() + "::ofactory needs a destroy");
            }
        }
    }

    String map(String name) {
        String ret = this.m_cachemap.getProperty(name);
        if (ret == null) {
            if (this.m_mapper == null) {
                ret = null;
            } else {
                ret = this.m_mapper.map(name);
                this.m_cachemap.put(name, ret);
            }
        }
        return ret;
    }

    void add(Object o) {
        if (o != null && !this.m_objvec.contains(o) && !this.m_ctxt.getBoolean(Connection.SKIPOBJECTTRACKING)) {
            this.m_objvec.addElement(o);
        }
    }

    Vector getObjects() {
        return this.m_objvec;
    }

    void addGlobalObject(Object o) {
        if (o != null && !this.m_gobjvec.contains(o)) {
            this.m_gobjvec.addElement(o);
        }
    }

    void deleteGlobalObjects() {
        while (this.m_gobjvec.size() > 0) {
            int i = this.m_gobjvec.size() - 1;
            Object o = this.m_gobjvec.elementAt(i);
            this._p("delete " + o);
            this.ostop(o);
            this.m_gobjvec.removeElementAt(i);
            this.m_ctxt.removeElement(o);
        }
    }

    Vector getGlobalObjects() {
        return this.m_gobjvec;
    }

    int factoryId() {
        return 0;
    }

    protected HListInterface getApplicationData(Connection c) {
        HList l = new HList();
        int pos = 0;
        Properties p = c._getApplicationData();
        if (p != null) {
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = p.getProperty(key);
                l.addItem(value, pos++, key);
            }
        }
        return l;
    }

    void setSkipAppl(boolean b) {
        this.skipAppl = b;
    }
}

