/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.collection.hlist.DoubleItem;
import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.HListItem;
import com.sas.collection.hlist.StringItem;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASGMS.IGMSAppl;
import com.sas.iom.SASGMS.IGMSApplHelper;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASMDX.IMDXAdmin;
import com.sas.iom.SASMDX.IMDXAdminHelper;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.IMDXServerHelper;
import com.sas.iom.WorkspaceConnector;
import com.sas.iom.WorkspaceFactory;
import com.sas.net.brg.orb.BrgOrb;
import com.sas.net.server.AfAccessInterface;
import com.sas.net.server.AfRequestInterface;
import com.sas.net.server.RemoteSasException;
import com.sas.net.server.SessionFactoryNotificationInterface;
import com.sas.net.server.SessionInterface;
import com.sas.net.server.WorkspaceInterface;
import com.sas.rmi.ClientTaskManager;
import com.sas.rmi.CodeGeneratorOptions;
import com.sas.rmi.Connection;
import com.sas.rmi.IOMFactory;
import com.sas.rmi.LocalModelInterface;
import com.sas.rmi.ProxyName;
import com.sas.rmi.QueueKey;
import com.sas.rmi.RB;
import com.sas.rmi.RemoteBaseClient;
import com.sas.rmi.Rocf;
import com.sas.rmi.ServerBusyTimeoutException;
import com.sas.rmi.SingleThreadedQueue;
import com.sas.sasserver.IMDBException;
import com.sas.sasserver.ofactory.corba.ofactory.OfactoryInterface;
import com.sas.sasserver.ofactory.corba.ofactory.OfactoryInterfaceHelper;
import com.sas.sasserver.remoteutilities.SCLlistUtilsInterface;
import com.sas.security.BaseSecuritySupport;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public abstract class IOMBaseClient
extends RemoteBaseClient
implements SessionFactoryNotificationInterface {
    public static final String FACTORYCLASS = "sashelp.iom.ofactory.class";
    public static String WORKSPACEKEY = "IOM:sasworkspace";
    private static final String WORKSPACEINTERNALKEY = "IOM:sasworkspaceInternallyCreated";
    public static String WORKSPACECONNECTORKEY = "IOM:sasworkspaceconnector";
    public static final String WORKSPACEFACTORYKEY = "IOM:sasworkspacefactory";
    public static String GMSKEY = "IOM:gms";
    public static String OLAPKEY = "IOM:olap";
    public static String OLAPADMINKEY = "IOM:olapadmin";
    public static String FACTORYKEY = "IOM:factory";
    public static String LISTUTILKEY = "IOM:scllistutil";
    public static final String LUTILSTAGEKEY = "IOM:scllistutilstage";
    private static final String GMSid = "9C186A64-83E4-11D2-B956-00C04F81993C";
    private static final String OLAPid = "F3F46472-1E31-11D5-87C2-00C04F38F9F6";
    public static final String RB_KEY = "IOMBaseClient.";
    private transient AfRequestInterface m_remoteObject;
    private transient AfAccessInterface m_client;
    private transient AfRequestInterface m_eventHandler;
    private transient Connection m_ctxt;
    private transient SessionInterface m_session;
    private transient WorkspaceInterface m_workspace;
    private transient ClientTaskManager m_ctm;
    private transient Exception m_exception;
    private transient java.lang.Object _del;
    private transient boolean t_done;
    private transient boolean m_AfBypass;
    private transient boolean m_useBroker;
    private transient boolean m_eventTrapping;
    private transient boolean m_delegateReady;
    private transient boolean m_clientReady;
    private transient boolean m_factoryAllocated;
    private transient long timeout;
    private transient SCLlistUtilsInterface sclListUtils;

    public IOMBaseClient() {
        this.resetLocals();
    }

    protected void resetLocals() {
        this.m_remoteObject = null;
        this.m_client = null;
        this.m_ctxt = null;
        this.m_eventHandler = null;
        this.m_session = null;
        this.m_workspace = null;
        this.m_ctm = null;
        this.m_exception = null;
        this._del = null;
        this.t_done = false;
        this.m_AfBypass = false;
        this.m_useBroker = false;
        this.m_eventTrapping = false;
        this.m_delegateReady = false;
        this.m_clientReady = false;
        this.m_factoryAllocated = false;
        this.sclListUtils = null;
    }

    public Class _getDelegateInterfaceClass() {
        Class c = null;
        String iface = this._RemoteObject_getInterfaceName() + "Interface";
        Rocf rocf = this._RemoteObject_getClassFactory();
        ProxyName pn = new ProxyName();
        try {
            String name = pn.getCORBAInterfaceName(rocf.forName(iface), new CodeGeneratorOptions());
            c = rocf.forName(name);
        }
        catch (Exception e) {
            System.err.println(Message.format((String)RB.getStringResource(RB_KEY, "cannotInstantiate.ex.txt"), (java.lang.Object)iface));
            return null;
        }
        return c;
    }

    @Override
    public void sessionReady(SessionInterface session) {
        this.t_done = true;
        this.m_session = session;
    }

    @Override
    public void sessionCreationFailed(RemoteSasException exception) {
        this.t_done = true;
        this.m_exception = exception;
    }

    private static String propertiesToUrl(String id, Properties properties) {
        StringBuffer buffer = new StringBuffer("bridge://");
        buffer.append(properties.getProperty("host"));
        buffer.append(":");
        buffer.append(properties.getProperty("port"));
        buffer.append("/");
        buffer.append(id);
        StringBuffer query = null;
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            if (propertyName.equals("host") || propertyName.equals("port")) continue;
            if (query == null) {
                query = new StringBuffer();
            } else {
                query.append("&");
            }
            query.append(propertyName);
            query.append("=");
            query.append(properties.getProperty(propertyName));
        }
        if (query != null) {
            buffer.append("?");
            buffer.append(query.toString());
        }
        return buffer.toString();
    }

    public java.lang.Object _RemoteObject_enter(String methodName) throws ServerBusyTimeoutException {
        return this._RemoteObject_enter(methodName, this.timeout);
    }

    public java.lang.Object _RemoteObject_enter(String methodName, long timeOut) throws ServerBusyTimeoutException {
        SingleThreadedQueue stq = this.m_ctxt.getSTQ();
        java.lang.Object key = stq.acquire(this, methodName);
        try {
            boolean canEnterMethod = stq.enter(key, timeOut);
            if (!canEnterMethod) {
                throw new ServerBusyTimeoutException();
            }
        }
        catch (InterruptedException e) {
            throw new ServerBusyTimeoutException();
        }
        return key;
    }

    public void _RemoteObject_exit(String methodName, java.lang.Object object) {
        QueueKey qk = (QueueKey)object;
        SingleThreadedQueue stq = this.m_ctxt.getSTQ();
        stq.exit(qk);
    }

    @Override
    public void _RemoteObject_setupClient(Connection ctxt) throws Exception, RuntimeException {
        this.m_ctxt = ctxt;
        this.timeout = this.m_ctxt.getQueueWaitTimeout() * 1000;
        ctxt.getSTQ().setPrintQueue(ctxt.isTraceProxyClient());
        if (!this.m_AfBypass) {
            ctxt.preloadCheck();
        }
        IOMBaseClient.validateFactory(ctxt);
        if ("after".equals(ctxt.getObject(LUTILSTAGEKEY))) {
            this.sclListUtils = (SCLlistUtilsInterface)ctxt.getObject(LISTUTILKEY);
        }
        if (!ctxt.isGMS() && !ctxt.isOLAP()) {
            double sasVersion = ctxt.getSASVersion();
            if (sasVersion > 0.0 && sasVersion < 8.2) {
                String msg = RB.getStringResource(RB_KEY, "setupClient.incompatibility.SAS");
                throw new RuntimeException(msg);
            }
            OfactoryInterface factory = (OfactoryInterface)ctxt.getObject(FACTORYKEY);
            String iface = this._RemoteObject_getInterfaceName();
            String cat = this._RemoteObject_getCatalog();
            if (iface != null && !cat.equalsIgnoreCase("none")) {
                Object opaqueObj = null;
                opaqueObj = factory.createObject(cat);
                if (opaqueObj == null) {
                    throw new RuntimeException(Message.format((String)RB.getStringResource(RB_KEY, "cannotInstantiateServerSide.ex.txt"), (java.lang.Object)cat));
                }
                String helpcls = this._getDelegateInterfaceClass().getName() + "Helper";
                Rocf rocf = this._RemoteObject_getClassFactory();
                Class c = rocf.forName(helpcls);
                Class[] parmTypes = new Class[]{Object.class};
                java.lang.Object[] parmVals = new java.lang.Object[]{opaqueObj};
                Method m1 = BaseSecuritySupport.securitySupport.getMethod(c, "narrow", parmTypes);
                java.lang.Object delegateObject = BaseSecuritySupport.securitySupport.invokeMethod(m1, (java.lang.Object)c, parmVals);
                this._RemoteObject_setObject(delegateObject);
            }
        }
        this.m_clientReady = true;
    }

    @Override
    public void _RemoteObject_getInstance() throws Exception {
        this._RemoteObject_newInstance();
    }

    @Override
    public void _RemoteObject_newInstance() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseConnection(Connection ctxt) {
        WorkspaceFactory factory;
        block14: {
            if (ctxt == null) {
                return;
            }
            java.lang.Object key = null;
            String methodName = "releaseConnection";
            SingleThreadedQueue stq = ctxt.getSTQ();
            IWorkspace sasWorkspace = (IWorkspace)ctxt.getObject(WORKSPACEKEY);
            boolean sasWorkspaceInternallyCreated = ctxt.getBoolean(WORKSPACEINTERNALKEY);
            IOMFactory iomf = (IOMFactory)ctxt.getObject("::iomfactory");
            try {
                if (iomf != null) {
                    try {
                        iomf.logoff();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!sasWorkspaceInternallyCreated || sasWorkspace == null) break block14;
                key = stq.acquire("IOMBaseClient", methodName);
                long timeOut = 10000L;
                try {
                    boolean canEnterMethod = stq.enter(key, timeOut);
                    if (canEnterMethod) {
                        sasWorkspace.Close();
                        ctxt.setObject(WORKSPACEKEY, null);
                    }
                }
                catch (InterruptedException canEnterMethod) {
                }
                finally {
                    stq.exit(key);
                }
            }
            catch (GenericError rex) {
                System.out.println((java.lang.Object)rex);
            }
        }
        java.lang.Object o = ctxt.getObject(WORKSPACECONNECTORKEY);
        WorkspaceConnector connector = (WorkspaceConnector)o;
        if (connector != null) {
            connector.close();
        }
        if ((factory = (WorkspaceFactory)(o = ctxt.getObject(WORKSPACEFACTORYKEY))) != null) {
            factory.destroy();
        }
    }

    @Override
    public synchronized void stop() {
        java.lang.Object o = this._RemoteObject_getObject();
        if (o != null) {
            Object corbaObject = (Object)o;
            corbaObject._release();
            this._RemoteObject_setObject(null);
        }
        super.stop();
    }

    public void destroy() throws Exception {
        this.stop();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }

    String _Rocf_oname() {
        String s = this.getClass().getName();
        int start = s.indexOf("_rprxIOM");
        if (start == -1) {
            start = s.indexOf("FinalIOM");
        }
        if (start > 0) {
            s = s.substring(start + 7);
        }
        return s;
    }

    public String toString() {
        return this._Rocf_oname();
    }

    @Override
    public void _RemoteObject_postMethodInvocation() {
    }

    @Override
    public boolean _RemoteObject_useThreads() {
        return false;
    }

    @Override
    public boolean _RemoteObject_ping() {
        return false;
    }

    protected void setStatusWorking(String status) {
        if (this.m_ctxt != null) {
            this.m_ctxt.fireStatusEvent(0, status);
        }
    }

    protected void setStatusSuccess() {
        if (this.m_ctxt != null) {
            this.m_ctxt.fireStatusEvent(1, RB.getStringResource(RB_KEY, "success.txt"));
        }
    }

    protected void setStatusFailed(String msg) {
        if (this.m_ctxt != null) {
            this.m_ctxt.fireStatusEvent(2, RB.getStringResource(RB_KEY, "failure.txt") + ": " + msg);
        }
    }

    @Override
    public java.lang.Object _getDelegate(Class c) {
        if (c == null) {
            return null;
        }
        if (this._del == null) {
            try {
                this._del = c.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(RB.getStringResource(RB_KEY, "illegalAccessException.ex.txt"));
            }
            catch (InstantiationException ie) {
                throw new RuntimeException(RB.getStringResource(RB_KEY, "instantiationException.ex.txt"));
            }
        }
        this._setupDelegate();
        return this._del;
    }

    private void _setupDelegate() {
        if (this.m_clientReady && this._del != null && !this.m_delegateReady) {
            this.m_delegateReady = true;
            if (this._del instanceof LocalModelInterface) {
                ((LocalModelInterface)this._del)._setRemoteHandle(this);
            }
        }
    }

    public HListInterface marshalListParamIn(double listid, HListInterface list) {
        byte[] listData = this.sclListUtils.ListId2Buffer(listid);
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(listData));
        try {
            list.removeAll();
            list.read(inputStream);
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        return list;
    }

    public HListInterface marshalListInStart(double listid) {
        if (listid == 0.0) {
            return null;
        }
        byte[] listData = this.sclListUtils.ListId2Buffer(listid);
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(listData));
        HList list = new HList();
        try {
            list.removeAll();
            list.read(inputStream);
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        return list;
    }

    public void marshalListInStop(double listid) {
    }

    public double marshalListOutStart(HListInterface list) {
        if (list == null) {
            return 0.0;
        }
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteOutputStream);
        try {
            list.write(outputStream);
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        byte[] listData = byteOutputStream.toByteArray();
        double listid = this.sclListUtils.Buffer2ListId(listData);
        return listid;
    }

    public void marshalListOutStop(double listid) {
        this.sclListUtils.DelList(listid, "Y");
    }

    public HListInterface[] marshalList1DArrayParamIn(double[] listids, HListInterface[] lists) {
        for (int i = 0; i < listids.length; ++i) {
            HList list = new HList();
            byte[] listData = this.sclListUtils.ListId2Buffer(listids[i]);
            DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(listData));
            try {
                list.read(inputStream);
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
            lists[i] = list;
        }
        return lists;
    }

    public HListInterface[] marshalList1DArrayInStart(double[] listids) {
        HListInterface[] lists = new HListInterface[listids.length];
        for (int i = 0; i < listids.length; ++i) {
            byte[] listData = this.sclListUtils.ListId2Buffer(listids[i]);
            DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(listData));
            HList list = new HList();
            try {
                list.read(inputStream);
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
            lists[i] = list;
        }
        return lists;
    }

    public void marshalList1DArrayInStop(double[] listids) {
    }

    public double[] marshalList1DArrayOutStart(HListInterface[] lists) {
        double[] listids = new double[lists.length];
        for (int i = 0; i < lists.length; ++i) {
            double listid;
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(byteOutputStream);
            try {
                lists[i].write(outputStream);
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
            byte[] listData = byteOutputStream.toByteArray();
            listids[i] = listid = this.sclListUtils.Buffer2ListId(listData);
        }
        return listids;
    }

    public void marshalList1DArrayOutStop(double[] listids) {
    }

    public HListInterface[][] marshalList2DArrayParamIn(double[][] listids, HListInterface[][] lists) {
        for (int i = 0; i < listids.length; ++i) {
            lists[i] = new HListInterface[listids[0].length];
            for (int j = 0; j < listids[0].length; ++j) {
                HList list = new HList();
                byte[] listData = this.sclListUtils.ListId2Buffer(listids[i][j]);
                DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(listData));
                try {
                    list.read(inputStream);
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                }
                lists[i][j] = list;
            }
        }
        return lists;
    }

    public HListInterface[][] marshalList2DArrayInStart(double[][] listids) {
        HListInterface[][] lists = new HListInterface[listids.length][];
        for (int i = 0; i < listids.length; ++i) {
            lists[i] = new HListInterface[listids[0].length];
            for (int j = 0; j < listids.length; ++j) {
                byte[] listData = this.sclListUtils.ListId2Buffer(listids[i][j]);
                DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(listData));
                HList list = new HList();
                try {
                    list.read(inputStream);
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                }
                lists[i][j] = list;
            }
        }
        return lists;
    }

    public void marshalList2DArrayInStop(double[][] listids) {
    }

    public double[][] marshalList2DArrayOutStart(HListInterface[][] lists) {
        double[][] listids = new double[lists.length][];
        for (int i = 0; i < lists.length; ++i) {
            listids[i] = new double[lists[i].length];
            for (int j = 0; j < lists[i].length; ++j) {
                double listid;
                ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
                DataOutputStream outputStream = new DataOutputStream(byteOutputStream);
                try {
                    lists[i][j].write(outputStream);
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                }
                byte[] listData = byteOutputStream.toByteArray();
                listids[i][j] = listid = this.sclListUtils.Buffer2ListId(listData);
            }
        }
        return listids;
    }

    public void marshalList2DArrayOutStop(double[][] listids) {
    }

    protected SCLlistUtilsInterface getListUtilObject() {
        SCLlistUtilsInterface sclListUtilsObject = (SCLlistUtilsInterface)this.m_ctxt.getObject(LISTUTILKEY);
        if (sclListUtilsObject == null) {
            Rocf rocf = this._RemoteObject_getClassFactory();
            try {
                sclListUtilsObject = (SCLlistUtilsInterface)rocf.newInstance(SCLlistUtilsInterface.class, this.m_ctxt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.m_ctxt.setObject(LISTUTILKEY, this.sclListUtils);
        }
        return sclListUtilsObject;
    }

    protected HListInterface stringArrayToHList(String[] stringArray) {
        if (stringArray == null) {
            return new HList();
        }
        HList hlist = new HList();
        for (int i = 0; i < stringArray.length; ++i) {
            StringItem strItem = new StringItem(stringArray[i]);
            hlist.addItem((HListItem)strItem);
        }
        return hlist;
    }

    protected String[] hListToStringArray(HListInterface hlist) {
        if (hlist == null) {
            return null;
        }
        String[] stringArray = new String[hlist.count()];
        for (int i = 0; i < hlist.count(); ++i) {
            stringArray[i] = hlist.getString(i);
        }
        return stringArray;
    }

    protected HListInterface doubleArrayToHList(double[] doubleArray) {
        if (doubleArray == null) {
            return new HList();
        }
        HList hlist = new HList();
        for (int i = 0; i < doubleArray.length; ++i) {
            DoubleItem doubleItem = new DoubleItem(doubleArray[i]);
            hlist.addItem((HListItem)doubleItem);
        }
        return hlist;
    }

    protected double[] hListToDoubleArray(HListInterface hlist) {
        if (hlist == null) {
            return null;
        }
        double[] doubleArray = new double[hlist.count()];
        for (int i = 0; i < hlist.count(); ++i) {
            doubleArray[i] = hlist.getDouble(i);
        }
        return doubleArray;
    }

    protected HListInterface ByteArrayToHList(byte[] byteArray) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(byteArray));
        HList hlist = new HList();
        try {
            hlist.read(inputStream);
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        return hlist;
    }

    protected byte[] HListToByteArray(HListInterface hList) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteOutputStream);
        try {
            if (hList == null) {
                hList = new HList();
            }
            hList.write(outputStream);
            return byteOutputStream.toByteArray();
        }
        catch (IOException ie) {
            ie.printStackTrace();
            return null;
        }
    }

    protected HListInterface[] ByteArray2dToHListArray(byte[][] byteArray2d) {
        HListInterface[] hlistArray = new HListInterface[byteArray2d.length];
        for (int i = 0; i < byteArray2d.length; ++i) {
            hlistArray[i] = this.ByteArrayToHList(byteArray2d[i]);
        }
        return hlistArray;
    }

    protected byte[][] HListArrayToByteArray2d(HListInterface[] hList) {
        byte[][] byteArray2d = new byte[hList.length][];
        for (int i = 0; i < hList.length; ++i) {
            byteArray2d[i] = this.HListToByteArray(hList[i]);
        }
        return byteArray2d;
    }

    static void validateFactory(Connection ctxt) throws Exception {
        boolean standardIOM = !ctxt.isGMS() && !ctxt.isOLAP();
        java.lang.Object key = null;
        String methodName = "StartSAS";
        if (ctxt.isGMS()) {
            methodName = "ConnectIMDB";
        } else if (ctxt.isOLAP()) {
            methodName = "ConnectOLAP";
        }
        SingleThreadedQueue stq = ctxt.getSTQ();
        boolean needToInitialize = true;
        if (ctxt.isGMS() && ctxt.getObject(GMSKEY) != null) {
            needToInitialize = false;
        } else if (ctxt.isOLAP() && ctxt.getObject(OLAPKEY) != null && ctxt.getObject(OLAPADMINKEY) != null) {
            needToInitialize = false;
        }
        if (needToInitialize) {
            key = stq.acquire("IOMBaseClient", methodName);
            long timeOut = 10000L;
            try {
                if (stq.enter(key, timeOut)) {
                    if (standardIOM) {
                        IOMBaseClient.iominit(ctxt);
                    } else if (ctxt.isGMS()) {
                        IOMBaseClient.imdbinit(ctxt);
                    } else if (ctxt.isOLAP()) {
                        IOMBaseClient.OLAPinit(ctxt);
                    }
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (ServerBusyTimeoutException e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                stq.exit(key);
            }
        }
    }

    static String getFinalUsername(Connection ctxt) {
        String username = ctxt.getUsername();
        if (username == null || username.length() == 0) {
            username = "iom_username_kludge";
        }
        return username;
    }

    static String getFinalPassword(Connection ctxt) {
        String password = ctxt.getPassword();
        if (password == null || password.length() == 0) {
            password = "iom_password_kludge";
        }
        return password;
    }

    static void iominit(Connection ctxt) throws Exception {
        OfactoryInterface factory;
        IWorkspace sasWorkspace = (IWorkspace)ctxt.getObject(WORKSPACEKEY);
        if (sasWorkspace == null) {
            String iomWorkspaceFactoryType = ctxt.getIomWorkspaceFactoryType();
            sasWorkspace = iomWorkspaceFactoryType.equalsIgnoreCase("pooling") ? IOMBaseClient.getWorkspaceFromPool(ctxt) : (iomWorkspaceFactoryType.equalsIgnoreCase("poolingJNDI") ? IOMBaseClient.getWorkspaceFromJNDIPool(ctxt) : (iomWorkspaceFactoryType.equalsIgnoreCase("JNDI") ? IOMBaseClient.getWorkspaceFromJNDI(ctxt) : IOMBaseClient.getWorkspace(ctxt)));
            ctxt.setObject(WORKSPACEKEY, sasWorkspace);
            ctxt._setWorkspace(sasWorkspace);
            ctxt.setBoolean(WORKSPACEINTERNALKEY, true);
            sasWorkspace.LanguageService();
        }
        if ((factory = (OfactoryInterface)ctxt.getObject(FACTORYKEY)) == null) {
            Object fopaqueObj = sasWorkspace.GetApplication(FACTORYCLASS);
            factory = OfactoryInterfaceHelper.narrow(fopaqueObj);
            ctxt.setObject(FACTORYKEY, factory);
        }
    }

    static IWorkspace getWorkspaceFromPool(Connection ctxt) throws Exception {
        Properties p;
        String s;
        Properties connectionDescriptor = new Properties();
        connectionDescriptor.put("host", ctxt.getTrueHost());
        connectionDescriptor.put("port", "" + ctxt.getPort());
        connectionDescriptor.put("userName", IOMBaseClient.getFinalUsername(ctxt));
        connectionDescriptor.put("password", IOMBaseClient.getFinalPassword(ctxt));
        if (ctxt.getEncryptionPolicy() != null) {
            connectionDescriptor.put("encryptionPolicy", ctxt.getEncryptionPolicy());
        }
        if (ctxt.getEncryptionAlgorithms() != null) {
            connectionDescriptor.put("encryptionAlgorithms", ctxt.getEncryptionAlgorithms());
        }
        if (ctxt.getEncryptionContent() != null) {
            connectionDescriptor.put("encryptionContent", ctxt.getEncryptionContent());
        }
        if ((s = (String)(p = ctxt.getIomWorkspaceFactoryPoolingInfo()).get("sasMaxPerWorkspacePool")) != null) {
            connectionDescriptor.put("sasMaxPerWorkspacePool", s);
        }
        if ((s = (String)p.get("debugLevel")) != null) {
            connectionDescriptor.put("debugLevel", s);
        }
        if ((s = (String)p.get("sasServerConnectionTimesOut")) != null) {
            boolean selected = s.equalsIgnoreCase("true");
            connectionDescriptor.put("sas-ServerRunForever", selected ? "false" : "true");
            if (selected && (s = (String)p.get("sasServerConnectionTimeout")) != null) {
                connectionDescriptor.put("sas-ServerShutdownAfter", s);
            }
        }
        Properties[] connectionDescriptors = new Properties[]{connectionDescriptor};
        Properties poolParameters = new Properties();
        s = (String)p.get("sasMinSize");
        if (s != null) {
            poolParameters.put("sasMinSize", s);
        }
        if ((s = (String)p.get("sasMinAvail")) != null) {
            poolParameters.put("sasMinAvail", s);
        }
        PrintWriter logWriter = null;
        if (ctxt.isLogTrap()) {
            logWriter = new PrintWriter(System.out);
        }
        WorkspaceFactory wsFactory = new WorkspaceFactory(connectionDescriptors, poolParameters, logWriter);
        ctxt.setObject(WORKSPACEFACTORYKEY, wsFactory);
        WorkspaceConnector wsConn = wsFactory.getWorkspaceConnector(0L);
        ctxt.setObject(WORKSPACECONNECTORKEY, wsConn);
        return wsConn.getWorkspace();
    }

    static IWorkspace getWorkspaceFromJNDIPool(Connection ctxt) throws Exception {
        WorkspaceFactory wsFactory;
        Properties p = ctxt.getIomWorkspaceFactoryPoolingJNDIInfo();
        String baseDN = p.getProperty("baseDN");
        String logicalName = p.getProperty("logicalName");
        String initContextFactory = p.getProperty("java.naming.factory.initial");
        String url = p.getProperty("java.naming.provider.url");
        String authentication = p.getProperty("java.naming.security.authentication");
        String authUsername = p.getProperty("java.naming.security.principal");
        String authPassword = p.getProperty("java.naming.security.credentials");
        boolean authorizationRequired = authUsername != null && authPassword != null;
        Hashtable<String, String> jndiInfo = new Hashtable<String, String>(5);
        if (initContextFactory != null) {
            jndiInfo.put("java.naming.factory.initial", initContextFactory);
        }
        if (url != null) {
            jndiInfo.put("java.naming.provider.url", url);
        }
        if (authentication != null) {
            jndiInfo.put("java.naming.security.authentication", authentication);
        }
        if (authUsername != null) {
            jndiInfo.put("java.naming.security.principal", authUsername);
        }
        if (authPassword != null) {
            jndiInfo.put("java.naming.security.credentials", authPassword);
        }
        if ((wsFactory = WorkspaceFactory.getFactory(jndiInfo, (String)baseDN, (String)logicalName)) == null) {
            PrintWriter logWriter = null;
            if (ctxt.isLogTrap()) {
                logWriter = new PrintWriter(System.out);
            }
            wsFactory = new WorkspaceFactory(jndiInfo, baseDN, logicalName, authorizationRequired, authorizationRequired, logWriter);
        }
        WorkspaceConnector wsConn = authorizationRequired ? wsFactory.getWorkspaceConnector(authUsername, authPassword, 0L) : wsFactory.getWorkspaceConnector(0L);
        ctxt.setObject(WORKSPACECONNECTORKEY, wsConn);
        return wsConn.getWorkspace();
    }

    static IWorkspace getWorkspaceFromJNDI(Connection ctxt) throws Exception {
        WorkspaceFactory wsFactory = new WorkspaceFactory();
        ctxt.setObject(WORKSPACEFACTORYKEY, wsFactory);
        Properties p = ctxt.getIomWorkspaceFactoryJNDIInfo();
        String logicalName = p.getProperty("logicalName");
        String sasReferenceDN = p.getProperty("sasReferenceDN");
        String ldapProviderUrl = p.getProperty("ldapProviderUrl");
        Properties ldapProperties = new Properties();
        String s = p.getProperty("baseDN");
        if (s != null) {
            ldapProperties.put("baseDN", s);
        }
        if ((s = p.getProperty("ldapUserName")) != null) {
            ldapProperties.put("ldapUserName", s);
        }
        if ((s = p.getProperty("ldapPassword")) != null) {
            ldapProperties.put("ldapPassword", s);
        }
        if ((s = p.getProperty("authentication")) != null) {
            ldapProperties.put("authentication", s);
        }
        return wsFactory.createWorkspaceByLogicalName(logicalName, sasReferenceDN, "bridge", ldapProviderUrl, ldapProperties);
    }

    static IWorkspace getWorkspace(Connection ctxt) throws Exception {
        WorkspaceFactory wsFactory = new WorkspaceFactory();
        ctxt.setObject(WORKSPACEFACTORYKEY, wsFactory);
        Properties serverInfo = new Properties();
        serverInfo.put("host", ctxt.getTrueHost());
        serverInfo.put("port", "" + ctxt.getPort());
        serverInfo.put("userName", IOMBaseClient.getFinalUsername(ctxt));
        serverInfo.put("password", IOMBaseClient.getFinalPassword(ctxt));
        if (ctxt.getEncryptionPolicy() != null) {
            serverInfo.put("encryptionPolicy", ctxt.getEncryptionPolicy());
        }
        if (ctxt.getEncryptionAlgorithms() != null) {
            serverInfo.put("encryptionAlgorithms", ctxt.getEncryptionAlgorithms());
        }
        if (ctxt.getEncryptionContent() != null) {
            serverInfo.put("encryptionContent", ctxt.getEncryptionContent());
        }
        return wsFactory.createWorkspaceByServer(serverInfo);
    }

    static void imdbinit(Connection ctxt) throws Exception {
        IGMSAppl gms = (IGMSAppl)ctxt.getObject(GMSKEY);
        if (gms == null) {
            String[] argv = null;
            Properties properties = new Properties();
            properties.put("host", ctxt.getTrueHost());
            properties.put("port", "" + ctxt.getPort());
            properties.put("userName", ctxt.getUsername());
            properties.put("password", ctxt.getPassword());
            properties.put("org.omg.CORBA.ORBClass", "com.sas.net.brg.orb.BrgOrb");
            properties.put("org.omg.CORBA.ORBSingletonClass", "com.sas.net.brg.orb.BrgOrb");
            Properties op = new Properties();
            op.put("org.omg.CORBA.ORBClass", properties.getProperty("org.omg.CORBA.ORBClass", "com.sas.net.brg.orb.BrgOrb"));
            op.put("org.omg.CORBA.ORBSingletonClass", properties.getProperty("org.omg.CORBA.ORBSingletonClass", "com.sas.net.brg.orb.BrgOrb"));
            ORB.init(argv, (Properties)op);
            String objRef = IOMBaseClient.propertiesToUrl(GMSid, properties);
            BrgOrb orb = new BrgOrb();
            Object obj = orb.string_to_object(objRef);
            gms = IGMSApplHelper.narrow((Object)obj);
            if (gms == null || gms._non_existent()) {
                throw new IMDBException(RB.getStringResource(RB_KEY, "IMDBConnectFailed.ex.txt"));
            }
            ctxt.setObject(GMSKEY, gms);
        }
    }

    static void OLAPinit(Connection ctxt) throws Exception {
        IMDXServer olap = (IMDXServer)ctxt.getObject(OLAPKEY);
        IMDXAdmin olapadmin = (IMDXAdmin)ctxt.getObject(OLAPADMINKEY);
        if (olap == null || olapadmin == null) {
            Properties properties = new Properties();
            properties.put("host", ctxt.getTrueHost());
            properties.put("port", "" + ctxt.getPort());
            properties.put("userName", ctxt.getUsername());
            properties.put("password", ctxt.getPassword());
            properties.put("protocol", "bridge");
            String objRef = IOMBaseClient.propertiesToUrl(OLAPid, properties);
            BrgOrb orb = new BrgOrb();
            Object obj = orb.string_to_object(objRef);
            olap = IMDXServerHelper.narrow((Object)obj);
            olapadmin = IMDXAdminHelper.narrow((Object)obj);
            if (olap == null || olap._non_existent()) {
                throw new Exception(RB.getStringResource(RB_KEY, "connectOLAPFailed.ex.txt"));
            }
            if (olapadmin == null || olapadmin._non_existent()) {
                throw new Exception(RB.getStringResource(RB_KEY, "connectOLAPFailed.ex.txt"));
            }
            ctxt.setObject(OLAPKEY, olap);
            ctxt.setObject(OLAPADMINKEY, olapadmin);
        }
    }

    public static void iomhash(Connection ctxt, String s) {
    }
}

