/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.security.BaseSecuritySupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.net.URLConnection;

public class HttpTunnel
implements Runnable {
    protected Thread m_thread = null;
    protected String m_url;
    protected String m_host;
    protected int m_port;
    protected boolean m_debug;
    protected DataInputStream m_readIn;
    protected DataOutputStream m_readOut;
    protected DataInputStream m_writeIn;
    protected DataOutputStream m_writeOut;
    protected String m_info = "";

    public void setup(String url) throws IOException {
        this.setup(url, "nobody", 0);
    }

    public void setup(String url, String host, int port) throws IOException {
        this.m_url = url;
        this.m_host = host;
        this.m_port = port;
        if (this.m_debug) {
            System.out.println(this.m_info + "URL:  " + this.m_url);
            System.out.println(this.m_info + "Host: " + this.m_host);
            System.out.println(this.m_info + "Port: " + this.m_port);
        }
        PipedInputStream readPipe = new PipedInputStream();
        PipedOutputStream writePipe = new PipedOutputStream();
        this.m_readIn = new DataInputStream(readPipe);
        this.m_readOut = new DataOutputStream(new PipedOutputStream(readPipe));
        this.m_writeIn = new DataInputStream(new PipedInputStream(writePipe));
        this.m_writeOut = new DataOutputStream(writePipe);
    }

    public void setDebug(boolean value) {
        this.m_debug = value;
    }

    public void setInfo(String value) {
        this.m_info = value;
    }

    public DataInputStream getInputStream() {
        return this.m_writeIn;
    }

    public DataOutputStream getOutputStream() {
        return this.m_readOut;
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = BaseSecuritySupport.securitySupport.createThread((Runnable)this);
            this.m_thread.start();
        }
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    int len = this.m_readIn.readInt();
                    this.processData(len);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.stop();
                continue;
            }
            break;
        }
    }

    protected synchronized void processData(int totalLength) throws IOException {
        byte[] buf = new byte[4096];
        try {
            if (this.m_debug) {
                System.out.println(this.m_info + "Connecting to http server");
            }
            URLConnection con = this.connectToServer();
            con.setRequestProperty("Content-type", "application/octet-stream");
            con.setRequestProperty("Content-length", "" + (totalLength + 4));
            if (this.m_debug) {
                System.out.println(this.m_info + "Sending " + totalLength + " bytes of data");
            }
            DataOutputStream out = new DataOutputStream(con.getOutputStream());
            out.writeInt(totalLength);
            while (totalLength > 0) {
                int bytesToRead = buf.length;
                if (bytesToRead > totalLength) {
                    bytesToRead = totalLength;
                }
                int bytesRead = this.m_readIn.read(buf, 0, bytesToRead);
                out.write(buf, 0, bytesRead);
                totalLength -= bytesRead;
            }
            out.flush();
            out.close();
            this.processResponse(con);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.sendException(ex.getMessage());
        }
    }

    protected URLConnection connectToServer() throws IOException {
        URL url = new URL(this.m_url + "?" + this.m_host + ":" + this.m_port);
        URLConnection con = url.openConnection();
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setUseCaches(false);
        return con;
    }

    protected void processResponse(URLConnection con) throws IOException {
        long t = 0L;
        DataInputStream in = null;
        if (this.m_debug) {
            System.out.println(this.m_info + "Opening http input stream");
            t = System.currentTimeMillis();
        }
        in = new DataInputStream(con.getInputStream());
        if (this.m_debug) {
            System.out.println(" Opened in " + (System.currentTimeMillis() - t) + "ms");
            t = System.currentTimeMillis();
            System.out.println(this.m_info + "Waiting for response from http server");
        }
        boolean moreData = true;
        while (moreData) {
            int packetLen = in.readInt();
            if (this.m_debug) {
                System.out.println(this.m_info + " First response in " + (System.currentTimeMillis() - t) + "ms, packet size " + packetLen);
            }
            this.m_writeOut.writeInt(packetLen);
            byte status = in.readByte();
            this.m_writeOut.writeByte(status);
            while (in.available() != 0) {
                byte b = in.readByte();
                this.m_writeOut.writeByte(b);
            }
            this.m_writeOut.flush();
            if ((status & 2) == 0) {
                moreData = false;
                continue;
            }
            if (!this.m_debug) continue;
            System.out.println(this.m_info + " Waiting for more data from http server");
        }
        in.close();
        if (this.m_debug) {
            System.out.println(this.m_info + "Finished with response");
        }
    }

    protected void sendException(String msg) throws IOException {
        if (this.m_debug) {
            System.out.println(this.m_info + "Sending exception: " + msg);
        }
        if (msg == null) {
            msg = "";
        }
        this.m_writeOut.writeByte(0);
        this.m_writeOut.writeByte(53);
        this.m_writeOut.writeUTF(msg);
        this.m_writeOut.flush();
    }
}

