/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.HttpSendSocket;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class HttpSendInputStream
extends FilterInputStream {
    HttpSendSocket owner;

    public HttpSendInputStream(InputStream in, HttpSendSocket owner) throws IOException {
        super(in);
        this.owner = owner;
    }

    public void deactivate() {
        this.in = null;
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            this.in = this.owner.readNotify();
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.in == null) {
            this.in = this.owner.readNotify();
        }
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n == 0L) {
            return 0L;
        }
        if (this.in == null) {
            this.in = this.owner.readNotify();
        }
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            this.in = this.owner.readNotify();
        }
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.owner.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.in == null) {
            try {
                this.in = this.owner.readNotify();
            }
            catch (IOException e) {
                return;
            }
        }
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.in == null) {
            this.in = this.owner.readNotify();
        }
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        if (this.in == null) {
            try {
                this.in = this.owner.readNotify();
            }
            catch (IOException e) {
                return false;
            }
        }
        return this.in.markSupported();
    }
}

