/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.HttpInputStream;
import com.sas.rmi.HttpOutputStream;
import com.sas.rmi.Logger;
import com.sas.rmi.WrappedSocket;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class HttpReceiveSocket
extends WrappedSocket {
    private boolean headerSent = false;

    public HttpReceiveSocket(Socket socket, InputStream in, OutputStream out) throws IOException {
        super(socket, in, out);
        this.in = new HttpInputStream(in != null ? in : socket.getInputStream());
        this.out = out != null ? out : socket.getOutputStream();
    }

    public boolean isReusable() {
        Logger.p(this, "isReusable");
        return false;
    }

    @Override
    public InetAddress getInetAddress() {
        return null;
    }

    @Override
    public int getPort() {
        return this.socket.getPort();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.headerSent) {
            DataOutputStream dos = new DataOutputStream(this.out);
            dos.writeBytes("HTTP/1.0 200 OK\r\n");
            dos.flush();
            this.headerSent = true;
            this.out = new HttpOutputStream(this.out);
        }
        return this.out;
    }

    @Override
    public synchronized void close() throws IOException {
        this.getOutputStream().close();
        this.socket.close();
    }

    @Override
    public String toString() {
        return "HttpReceive" + this.socket.toString();
    }
}

