/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.io.Encoder;
import com.sas.net.server.AfAccessInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.RB;
import com.sas.rmi.Rocf;
import com.sas.sasserver.serverinfo.ServerInfoInterface;
import com.sas.text.Message;
import java.util.StringTokenizer;

public class Handshaker {
    public static final String RB_KEY = "Handshaker.";
    Rocf rocf;
    Connection connection;
    ServerInfoInterface serverInfo;
    private static final boolean FORCE_UTF8 = false;

    Handshaker(Rocf rocf, Connection ctxt, ServerInfoInterface serverInfo) {
        this.rocf = rocf;
        this.connection = ctxt;
        this.serverInfo = serverInfo;
    }

    void handshake() {
        boolean exceptionsEnabled = this.connection.isRuntimeExceptionAlways();
        try {
            this.connection.setRuntimeExceptionAlways(true);
            if ("false".equals(this.connection.getObject(Connection.SERVERHANDSHAKE))) {
                System.out.println(Message.format((String)RB.getStringResource(RB_KEY, "skipped.txt"), (Object)this.connection.getHost()));
                return;
            }
            if (this.serverInfo == null) {
                System.out.println(Message.format((String)RB.getStringResource(RB_KEY, "aborted.txt"), (Object)this.connection.getHost(), (Object)"SASHELP.RSASMOD.SRVINFO.CLASS"));
                return;
            }
            this.parseServerInfo();
            AfAccessInterface af = (AfAccessInterface)this.connection._getAfAccess();
            af.setProperty(Connection.SERVERENCODING, this.connection.getServerEncoding());
            af.setProperty(Connection.SERVERLISTVERSION, new Integer(this.connection.getServerListVersion()));
        }
        catch (Exception e) {
            System.out.println(Message.format((String)RB.getStringResource(RB_KEY, "remoteException.ex.txt"), (Object)this.connection.getHost()));
        }
        finally {
            this.connection.setRuntimeExceptionAlways(exceptionsEnabled);
        }
    }

    void parseServerInfo() {
        String info = this.serverInfo.getInfo();
        if (info != null && info.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(info, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int pos = token.indexOf(61);
                String propName = "";
                String propValue = "";
                if (pos >= 0) {
                    propName = token.substring(0, pos);
                    propValue = token.substring(pos + 1, token.length());
                } else {
                    propName = propValue = token;
                }
                if (!Connection.SERVERLISTVERSION.equalsIgnoreCase(propName)) continue;
                try {
                    this.connection.setServerListVersion(Integer.parseInt(propValue));
                }
                catch (Exception exception) {}
            }
        }
        String encodings = "UTF8";
        encodings = this.serverInfo.getSupportedEncodings("Java");
        String encoding = this.chooseEncoding(this.serverInfo, encodings);
        this.connection.setServerEncoding(encoding);
        this.serverInfo.useEncoding("Java", encoding);
    }

    String chooseEncoding(ServerInfoInterface serverInfo, String encodings) {
        String preferredEncoding = "UTF8";
        if (encodings != null && encodings.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(encodings, ",");
            while (tokenizer.hasMoreTokens()) {
                String encoding = tokenizer.nextToken();
                if (!Encoder.isValid((String)encoding)) continue;
                preferredEncoding = encoding;
                break;
            }
        }
        return preferredEncoding;
    }
}

