/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.BrokerConfiguration;
import com.sas.rmi.BrokerConnector;
import com.sas.rmi.BrokerPool;
import com.sas.rmi.BrokerProperties;
import com.sas.rmi.Rocf;
import com.sas.security.BaseSecuritySupport;
import java.io.IOException;

public class FactoryThread
implements Runnable {
    Thread m_thread = null;
    boolean m_debug = false;
    boolean m_inUse = false;
    boolean m_isReady = false;
    BrokerProperties m_props = null;
    BrokerPool m_pool;
    BrokerConfiguration m_config;
    Rocf m_rocf;
    long m_createdMillis;
    BrokerConnector m_connector = null;

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public void setup(BrokerPool pool) throws IOException {
        this.m_rocf = new Rocf();
        this.m_pool = pool;
        this.m_config = pool.getConfig();
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = BaseSecuritySupport.securitySupport.createThread((Runnable)this);
            this.m_thread.start();
            this.m_createdMillis = System.currentTimeMillis();
        }
    }

    public void stop() {
        try {
            if (this.m_thread != null) {
                this.m_thread.stop();
                this.m_thread = null;
            }
            if (this.m_connector != null) {
                this.m_connector.stop();
                this.m_connector = null;
            }
            if (this.m_rocf != null) {
                this.m_rocf.stop();
                this.m_rocf = null;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public boolean isAlive() {
        boolean rc = false;
        if (this.m_thread != null) {
            rc = this.m_thread.isAlive();
        }
        return rc;
    }

    @Override
    public void run() {
        try {
            this.fireBrokerEvent(this, "Starting connection for " + this.m_pool.getPoolDescription());
            this.m_connector = this.m_pool.getConnector();
            this.m_props = this.m_connector.connect(this.m_config);
            this.setIsReady(true);
            this.fireBrokerEvent(this, "Connection ready for " + this.m_pool.getPoolDescription() + ": " + this.m_props);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BrokerProperties getConnection() {
        return this.m_props;
    }

    public void setInUse(boolean value) {
        this.m_inUse = value;
    }

    public boolean getInUse() {
        return this.m_inUse;
    }

    public void setIsReady(boolean value) {
        this.m_isReady = value;
    }

    public boolean getIsReady() {
        return this.m_isReady;
    }

    public long getCreatedMillis() {
        return this.m_createdMillis;
    }

    public long getTimeoutMillis() {
        return this.m_config.getSessionTimeout() * 1000;
    }

    public BrokerPool getPool() {
        return this.m_pool;
    }

    public void fireBrokerEvent(Object source, String msg) {
        this.m_pool.fireBrokerEvent(source, msg);
    }
}

