/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.Connection;
import com.sas.rmi.ConnectionUtility;
import com.sas.rmi.Rocf;
import com.sas.rmi.RocfORBProfile2Interface;
import com.sas.sasserver.dataset.DataSetInterface;
import java.io.FileInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ExampleProfileProcessor
implements RocfORBProfile2Interface {
    Properties connectionProperties;
    String dataSet;
    Vector dataSetRows;
    Hashtable propertyFiles;
    public static final String CONNECTION_NAME = "connection";
    public static final String CONNECTION_KEY = "dataset";
    public static final String TEMP_USERNAME = "ExampleProfileProcessor.username";
    public static final String TEMP_PASSWORD = "ExampleProfileProcessor.password";
    public static final int USER_COLUMN = 0;
    public static final int PASSWORD_COLUMN = 1;
    public static final int APPLUSER_COLUMN = 2;
    public static final int APPLPWD_COLUMN = 3;
    public static final int PROPFIL_COLUMN = 4;

    @Override
    public boolean initialize(Properties props) {
        boolean rc = true;
        this.dataSet = props.getProperty(CONNECTION_KEY);
        if (this.dataSet == null) {
            this.trace("dataset must be given");
            return false;
        }
        this.connectionProperties = props;
        rc = this.load(this.dataSet, this.connectionProperties);
        return rc;
    }

    @Override
    public boolean exists(String profile) {
        return false;
    }

    @Override
    public void applyProfileProperties(String profile, Connection c) throws RemoteException {
        String[] data;
        if (this.dataSetRows == null) {
            throw new RemoteException("User database is not available");
        }
        String username = c.getUsername();
        String password = c.getPassword();
        String orgUsername = c.getString(TEMP_USERNAME);
        if (orgUsername != null) {
            username = orgUsername;
            password = c.getString(TEMP_PASSWORD);
        }
        if ((data = this.getUser(username, password)) == null) {
            throw new RemoteException("Invalid username/password");
        }
        c.setString(TEMP_USERNAME, username);
        c.setString(TEMP_PASSWORD, password);
        Properties props = this.getProperties(data[4]);
        ConnectionUtility.applyPropertyFile(c, props, CONNECTION_NAME, profile);
        c.setApplicationUsername(data[2]);
        c.setApplicationPassword(data[3]);
    }

    @Override
    public void reload() {
        this.load(this.dataSet, this.connectionProperties);
    }

    @Override
    public String[] getProfileNames() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean load(String dataset, Properties props) {
        boolean rc = true;
        this.dataSetRows = null;
        this.propertyFiles = null;
        Rocf rocf = new Rocf();
        Connection c = new Connection();
        ConnectionUtility.applyPropertyFile(c, props, CONNECTION_NAME, CONNECTION_KEY);
        try {
            this.trace("Reading " + dataset + " from " + c.getHost());
            DataSetInterface ds = (DataSetInterface)rocf.newInstance(DataSetInterface.class, c);
            ds.setDataSet(dataset);
            if (this.validate(ds)) {
                this.dataSetRows = new Vector();
                int rows = ds.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    String[] row = ds.getFormattedRow(i + 1);
                    this.dataSetRows.addElement(row);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            rc = false;
        }
        finally {
            rocf.stop();
        }
        if (rc) {
            this.trace("Ready");
        }
        return rc;
    }

    protected boolean validate(DataSetInterface ds) {
        Object[] names = null;
        try {
            names = ds.getColumnLabels(1, ds.getColumnCount());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (!this.isCorrectName(names, 0, "USER")) {
            return false;
        }
        if (!this.isCorrectName(names, 1, "PASSWORD")) {
            return false;
        }
        if (!this.isCorrectName(names, 2, "APPLUSER")) {
            return false;
        }
        if (!this.isCorrectName(names, 3, "APPLPWD")) {
            return false;
        }
        return this.isCorrectName(names, 4, "PROPFIL");
    }

    protected boolean isCorrectName(Object[] names, int index, String name) {
        boolean rc = true;
        if (names == null) {
            this.trace("Column names missing");
            rc = false;
        } else if (names.length <= index) {
            this.trace(name + " column is missing");
            rc = false;
        } else {
            String labelName = (String)names[index];
            if (!labelName.equalsIgnoreCase(name)) {
                this.trace("column at " + (index + 1) + " must be " + name);
                rc = false;
            }
        }
        return rc;
    }

    protected void trace(String s) {
        System.out.println("ExampleProfileProcessor::" + s);
    }

    protected String[] getUser(String username, String password) {
        String[] data = null;
        if (this.dataSetRows != null) {
            for (int i = 0; i < this.dataSetRows.size(); ++i) {
                String[] row = (String[])this.dataSetRows.elementAt(i);
                if (!row[0].equals(username) || !row[1].equals(password)) continue;
                data = row;
                break;
            }
        }
        return data;
    }

    protected Properties getProperties(String fn) {
        Properties props;
        if (this.propertyFiles == null) {
            this.propertyFiles = new Hashtable();
        }
        if ((props = (Properties)this.propertyFiles.get(fn)) == null) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(fn);
                this.trace("Loading " + fn);
                props = new Properties();
                props.load(is);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                props = new Properties();
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.propertyFiles.put(fn, props);
        }
        return props;
    }

    @Override
    public String getProperty(String key) {
        return this.connectionProperties.getProperty(key);
    }
}

