/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.awt.util.DisableCommand;
import com.sas.awt.util.Util;
import com.sas.rmi.Connection;
import com.sas.rmi.ConnectionThread;
import com.sas.rmi.J2PrintStream;
import com.sas.rmi.RB;
import com.sas.rmi.Rocf;
import com.sas.util.ApplyInterface;
import com.sas.util.ParamObjectBase;
import java.applet.Applet;
import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class ConnectionUtility {
    protected Object m_container = null;
    protected Vector m_enabledList = null;
    protected J2PrintStream m_J2ps;
    private boolean teeOutput = false;
    public static final String RB_KEY = "ConnectionUtility.";
    public static final String PARM_PROPERTYFILE = "propertyFile";
    public static final String PARM_PROPERTYFILEKEY = "propertyFileKey";
    protected String[] m_args = null;
    private transient DisableCommand m_cmd;
    private transient String sc_host;
    private transient boolean sc_failed;
    private transient String sc_exceptionMessage;
    private transient long sc_start;
    private transient String sc_conMsg;
    private transient SimpleDateFormat sc_formatter;

    public ConnectionUtility(Object container) {
        this.m_container = container;
        this.m_enabledList = new Vector();
    }

    public ConnectionUtility(Object container, String[] args) {
        this.m_container = container;
        this.m_enabledList = new Vector();
        this.m_args = args;
    }

    public void setBusy(boolean busy) {
        if (this.m_container == null) {
            return;
        }
        if (!(this.m_container instanceof Component)) {
            return;
        }
        Component c = (Component)this.m_container;
        if (busy) {
            this.m_cmd = new DisableCommand();
            Util.apply(c, (ApplyInterface)this.m_cmd);
        } else if (this.m_cmd != null) {
            this.m_cmd.undoAll();
            this.m_cmd = null;
        }
    }

    public void connect(Rocf rocf, Vector connections) throws Exception {
        Boolean tet;
        String hostName;
        String status;
        ConnectionThread t;
        int i;
        Connection c;
        boolean trace = false;
        if (rocf == null || connections == null) {
            return;
        }
        if (connections.size() == 0) {
            return;
        }
        if (connections.size() == 1) {
            this.singleConnectionCase(rocf, (Connection)connections.elementAt(0));
            return;
        }
        Vector<ConnectionThread> threads = new Vector<ConnectionThread>();
        Vector<Boolean> threadExceptionThrown = new Vector<Boolean>();
        if (connections.size() > 0) {
            c = (Connection)connections.elementAt(0);
            trace = c.tpc();
            if (this.teeOutput) {
                J2PrintStream.setTee(trace);
            }
        }
        if (this.teeOutput) {
            this.m_J2ps = J2PrintStream.attachToStandardOut();
        }
        for (i = 0; i < connections.size(); ++i) {
            c = (Connection)connections.elementAt(i);
            if (!c.getUseRuntimeParams()) continue;
            ConnectionUtility.applyParams(this.m_container, c, c.getRuntimeParamKeyPrefix());
        }
        for (i = 0; i < connections.size(); ++i) {
            c = (Connection)connections.elementAt(i);
            if (trace) {
                c.setString(Connection.DEBUGTELNETCONNECTCLIENT, Connection.TRUE);
            }
            t = new ConnectionThread(rocf, c);
            threads.addElement(t);
            Boolean b = new Boolean(false);
            threadExceptionThrown.addElement(b);
            t.start();
        }
        int elapsed = 0;
        int sleepTime = 20;
        while (this.threadAlive(threads)) {
            String j32;
            status = "";
            for (int i2 = 0; i2 < threads.size(); ++i2) {
                c = (Connection)connections.elementAt(i2);
                t = (ConnectionThread)threads.elementAt(i2);
                hostName = this.getDisplayHostName(c);
                if (t.didFail()) {
                    if (status.length() > 0) {
                        status = status + ", ";
                    }
                    status = status + hostName + " (" + RB.getStringResource(RB_KEY, "failedMsg") + ")";
                    tet = (Boolean)threadExceptionThrown.elementAt(i2);
                    if (tet.booleanValue()) continue;
                    Boolean b = new Boolean(true);
                    threadExceptionThrown.setElementAt(b, i2);
                    String message = "Connection to " + hostName + " failed.\n" + t.getExceptionMessage();
                    throw new Exception(message);
                }
                if (!t.isAlive()) continue;
                if (status.length() > 0) {
                    status = status + ", ";
                }
                status = status + hostName;
            }
            String statusLine = RB.getStringResource(RB_KEY, "connectingMsg") + " (" + this.formatTime(elapsed / 1000) + ") " + status;
            if (this.teeOutput && (j32 = this.m_J2ps.getBuffer(40).trim()).length() > 0) {
                statusLine = statusLine + " (" + j32 + ")";
            }
            this.showStatus(statusLine);
            try {
                Thread.sleep(sleepTime);
                elapsed += sleepTime;
            }
            catch (InterruptedException j32) {}
        }
        status = "";
        for (int i3 = 0; i3 < threads.size(); ++i3) {
            t = (ConnectionThread)threads.elementAt(i3);
            c = (Connection)connections.elementAt(i3);
            hostName = this.getDisplayHostName(c);
            if (!t.didFail()) continue;
            if (status.length() > 0) {
                status = status + ", ";
            }
            status = status + hostName + " (" + RB.getStringResource(RB_KEY, "failedMsg") + ")";
            tet = (Boolean)threadExceptionThrown.elementAt(i3);
            if (tet.booleanValue()) continue;
            Boolean b = new Boolean(true);
            threadExceptionThrown.setElementAt(b, i3);
            String message = "Connection to " + hostName + " failed.\n" + t.getExceptionMessage();
            throw new Exception(message);
        }
        if (status.length() == 0) {
            status = RB.getStringResource(RB_KEY, "loadingModelsMsg");
        }
        this.showStatus(status);
        if (this.teeOutput) {
            this.m_J2ps.detach();
        }
    }

    protected boolean threadAlive(Vector v) {
        boolean rc = false;
        for (int i = 0; i < v.size(); ++i) {
            if (!((ConnectionThread)v.elementAt(i)).isAlive()) continue;
            rc = true;
            break;
        }
        return rc;
    }

    protected void showStatus(String s) {
        if (this.m_container != null && this.m_container instanceof Applet) {
            ((Applet)this.m_container).showStatus(s);
        }
    }

    protected String getConnectingWord() {
        return "Connecting";
    }

    protected String formatTime(int seconds) {
        int min = seconds / 60;
        if (min > 0) {
            seconds -= min * 60;
        }
        return "" + min + ":" + seconds / 10 + seconds % 10;
    }

    public static void applyParams(Object source, Connection conn, String name) {
        String newValue;
        if (source == null || conn == null) {
            return;
        }
        if (name == null) {
            name = Connection.RUNTIMEPARAMKEYPREFIX_DEFAULT;
        }
        ParamObjectBase param = null;
        if (source instanceof Applet) {
            param = new ParamObjectBase((Applet)source);
        } else if (source instanceof String[]) {
            param = new ParamObjectBase((String[])source);
        }
        if (param == null) {
            return;
        }
        String fname = param.getParam(name + "." + PARM_PROPERTYFILE);
        if (fname != null) {
            String key = param.getParam(name + "." + PARM_PROPERTYFILEKEY);
            ConnectionUtility.processPropertyFile(source, conn, name, fname, key);
        }
        if ((newValue = param.getParam(name + ".serverArchitecture")) != null) {
            Connection.setServerArchitecture(conn, newValue);
        }
        Properties p = conn.getProperties();
        Enumeration<?> enumer = p.propertyNames();
        while (enumer.hasMoreElements()) {
            String pName = (String)enumer.nextElement();
            String aName = conn.getAccessor(pName);
            String paramName = aName != null ? aName : pName;
            paramName = name + "." + paramName;
            newValue = param.getParam(paramName);
            if (newValue == null) continue;
            conn.setString(pName, newValue);
        }
    }

    public static void processPropertyFile(Object source, Connection conn, String connName, String fname, String key) {
        URL url;
        String codeBase = null;
        if (source instanceof Applet && (url = ((Applet)source).getCodeBase()) != null) {
            codeBase = url.toString();
        }
        URL propertyURL = null;
        try {
            propertyURL = new URL(fname);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (propertyURL == null && codeBase != null) {
            try {
                String name = codeBase.toString() + fname;
                propertyURL = new URL(name);
            }
            catch (MalformedURLException name) {
                // empty catch block
            }
        }
        InputStream is = null;
        if (propertyURL != null) {
            try {
                URLConnection c = propertyURL.openConnection();
                String ct = c.getContentType();
                if (ct != null && !ct.equals("text/plain")) {
                    System.out.println("Connection property file may be bad or missing: " + propertyURL);
                }
                is = c.getInputStream();
            }
            catch (IOException ex) {
                System.out.println("Unable to read connection properties: " + propertyURL);
            }
        } else {
            try {
                is = new FileInputStream(fname);
            }
            catch (FileNotFoundException ex) {
                System.out.println("Unable to find connection property file " + fname);
                ex.printStackTrace();
            }
        }
        if (is == null) {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException ex) {
            System.out.println("Error reading connection properties");
            ex.printStackTrace();
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (props != null) {
            ConnectionUtility.applyPropertyFile(conn, props, connName, key);
        }
    }

    public static void applyPropertyFile(Connection conn, Properties props, String connName, String key) {
        int keyLen = 0;
        if (key == null) {
            key = "default";
        }
        if (connName != null) {
            key = key + "." + connName;
        }
        key = key + ".";
        keyLen = key.length();
        String newValue = props.getProperty(key + PARM_PROPERTYFILEKEY);
        if (newValue != null) {
            String cName = connName;
            if (newValue.indexOf(".") >= 0) {
                cName = null;
            }
            ConnectionUtility.applyPropertyFile(conn, props, cName, newValue);
        }
        if ((newValue = props.getProperty(key + "serverArchitecture")) != null) {
            Connection.setServerArchitecture(conn, newValue);
        }
        Enumeration<?> enumer = props.propertyNames();
        while (enumer.hasMoreElements()) {
            String name = (String)enumer.nextElement();
            if (!name.startsWith(key) || (newValue = props.getProperty(name)) == null || (name = name.substring(keyLen)).equals(PARM_PROPERTYFILEKEY)) continue;
            String realName = conn.getInternalName(name);
            if (realName == null) {
                realName = name;
            }
            if (realName.equals("serverArchitecture")) continue;
            conn.setString(realName, newValue);
        }
    }

    private long msecs() {
        return System.currentTimeMillis();
    }

    void singleConnectionStatus() {
        String timePrint = this.sc_formatter.format(new Date(this.msecs() - this.sc_start));
        String statusLine = this.sc_conMsg + " (" + timePrint + ") " + this.sc_host;
        this.showStatus(statusLine);
    }

    void singleConnectionCase(Rocf rocf, Connection ctxt) throws Exception {
        if (ctxt.getUseRuntimeParams()) {
            ConnectionUtility.applyParams(this.m_container, ctxt, ctxt.getRuntimeParamKeyPrefix());
        }
        if (ctxt.tpc()) {
            ctxt.setString(Connection.DEBUGTELNETCONNECTCLIENT, Connection.TRUE);
        }
        OngoingStatusDisplay task = new OngoingStatusDisplay();
        long delay = 0L;
        long period = 1000L;
        this.sc_host = ctxt.getHost();
        this.sc_conMsg = RB.getStringResource(RB_KEY, "connectingMsg");
        this.sc_formatter = new SimpleDateFormat("m:ss");
        this.sc_host = this.getDisplayHostName(ctxt);
        this.sc_start = this.msecs();
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate((TimerTask)task, delay, period);
        this.singleConnect(rocf, ctxt);
        timer.cancel();
        if (this.sc_failed) {
            String message = this.sc_host + " (" + RB.getStringResource(RB_KEY, "failedMsg") + ")";
            this.showStatus(message);
            message = "Connection to " + this.sc_host + " failed.\n" + this.sc_exceptionMessage;
            throw new Exception(message);
        }
        this.showStatus(RB.getStringResource(RB_KEY, "loadingModelsMsg"));
    }

    void singleConnect(Rocf rocf, Connection ctxt) {
        try {
            rocf.connect(ctxt);
            ctxt.preloadCheck();
        }
        catch (AccessControlException ace) {
            String msg = ace.toString();
            if (msg.indexOf("modifyThread") == -1) {
                this.sc_failed = true;
                this.sc_exceptionMessage = msg;
                ace.printStackTrace();
            } else {
                System.out.println("");
                System.out.println("******************** KNOWN PROBLEM - CAN BE IGNORED ********************");
                ace.printStackTrace();
                System.out.println("************************* END OF KNOWN PROBLEM *************************");
                System.out.println("");
            }
        }
        catch (RuntimeException rex) {
            String msg = rex.toString();
            if (msg.indexOf("AccessControlException") == -1 || msg.indexOf("modifyThread") == -1) {
                this.sc_failed = true;
                this.sc_exceptionMessage = msg;
                rex.printStackTrace();
            } else {
                System.out.println("");
                System.out.println("******************** KNOWN PROBLEM - CAN BE IGNORED ********************");
                rex.printStackTrace();
                System.out.println("************************* END OF KNOWN PROBLEM *************************");
                System.out.println("");
            }
        }
        catch (Exception ex) {
            this.sc_failed = true;
            this.sc_exceptionMessage = ex.toString();
            ex.printStackTrace();
        }
    }

    String getDisplayHostName(Connection conn) {
        String hostName = "";
        if (!conn.isAppletCodebaseRelative()) {
            hostName = conn.getHost();
            if (!hostName.equalsIgnoreCase(conn.getTrueHost())) {
                hostName = hostName + " (" + conn.getTrueHost() + ")";
            }
        } else {
            hostName = conn.getTrueHost();
        }
        return hostName;
    }

    class OngoingStatusDisplay
    extends TimerTask {
        OngoingStatusDisplay() {
        }

        @Override
        public void run() {
            ConnectionUtility.this.singleConnectionStatus();
        }
    }
}

