/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.Component;
import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.collection.AssociationList;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.StaticDictionaryInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.lang.ObjectDataInterface;
import com.sas.models.Node;
import com.sas.models.NodeIcon;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.StaticTreeNodeStyleInterface;
import com.sas.models.TreeInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.PersistedConnectionList;
import com.sas.rmi.RB;
import com.sas.swing.visuals.NodeView;
import com.sas.util.Util;
import com.sas.util.transforms.AssociationListItemToKeyTransform;
import com.sas.visuals.ImageView;
import com.sas.visuals.NodeStyle;
import com.sas.visuals.TreeView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;

public class ConnectionTree
extends Component
implements StaticTreeNodeStyleInterface,
TreeInterface,
ContentsChangedListener {
    static final long serialVersionUID = 5139410829627808625L;
    private transient Connection _connection;
    private PersistedConnectionList _persistedConnections;
    private StaticDictionaryInterface _customConnections;
    protected boolean _loneLevelOneParentDisplayed;
    private StaticPropertyBagInterface _persistedStyle;
    private StaticPropertyBagInterface _customStyle;
    protected String _persistedParentText;
    protected String _customParentText;
    protected transient Node _root;
    protected transient Node _persistedParent;
    protected transient Node _customParent;
    public static final String PERSISTED = "persisted";
    public static final String CUSTOM = "custom";

    public ConnectionTree() {
        NodeStyle nodeStyle = new NodeStyle();
        nodeStyle.setDefaultIcon(new ImageView(TreeView.class, "res/SASSystem.gif"));
        this._persistedStyle = nodeStyle;
        this.setPersistedParentNodeText(RB.getStringResource("ConnectionTree.Node.PersistedConnections.txt"));
        nodeStyle = new NodeStyle();
        nodeStyle.setDefaultIcon(new ImageView(TreeView.class, "res/SASSystem.gif"));
        this._customStyle = nodeStyle;
        this.setCustomParentNodeText(RB.getStringResource("ConnectionTree.Node.CustomConnections.txt"));
    }

    public void setDefaultValues() {
        super.setDefaultValues();
        this._loneLevelOneParentDisplayed = true;
    }

    public NodeInterface getRoot() {
        if (this._root == null) {
            this._root = new NodeIcon("com.sas.rmi.ConnectionTree");
            this._root.setNodeType("root");
            this.refresh();
        }
        return this._root;
    }

    public String getPersistedParentNodeText() {
        return this._persistedParentText;
    }

    public void setPersistedParentNodeText(String txt) {
        if (this._persistedParent != null) {
            this._persistedParent.setNodeText(txt);
        }
        this._persistedParentText = txt;
    }

    public String getCustomParentNodeText() {
        return this._customParentText;
    }

    public void setCustomParentNodeText(String txt) {
        if (this._customParent != null) {
            this._customParent.setNodeText(txt);
        }
        this._customParentText = txt;
    }

    public boolean isLoneLevelOneParentDisplayed() {
        return this._loneLevelOneParentDisplayed;
    }

    public void setLoneLevelOneParentDisplayed(boolean newValue) {
        boolean oldValue = this.isLoneLevelOneParentDisplayed();
        this._loneLevelOneParentDisplayed = newValue;
        newValue = this.isLoneLevelOneParentDisplayed();
        if (oldValue != newValue) {
            this.firePropertyChange("loneLevelOneParentDisplayed", oldValue ? Boolean.TRUE : Boolean.FALSE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
        this.refresh();
    }

    public void refresh() {
        if (this._root == null) {
            this._root = new NodeIcon("com.sas.rmi.ConnectionTree");
            this._root.setNodeType("root");
        }
        this._root.removeAllNodeChildren();
        OrderedCollectionInterface oci = this.getConnections();
        if (oci.count() == 1 && !this.isLoneLevelOneParentDisplayed()) {
            NodeInterface node = (NodeInterface)oci.get(0);
            this._root.setNodeType(node.getNodeType());
            int cnt = node.getNodeChildCount();
            for (int i = 0; i < cnt; ++i) {
                this._root.addNodeChild((SimpleNodeInterface)((NodeInterface)node.getNodeChild(i)));
            }
        } else {
            this._root.setNodeType("root");
            int cnt = oci.count();
            for (int i = 0; i < cnt; ++i) {
                this._root.addNodeChild((SimpleNodeInterface)((NodeInterface)oci.get(i)));
            }
        }
    }

    protected OrderedCollectionInterface getConnections() {
        NodeIcon parent;
        OrderedCollection oc = new OrderedCollection();
        if (this.getPersistedConnectionList() != null) {
            parent = new NodeIcon(this.getPersistedParentNodeText());
            parent.setNodeType("persistedParent");
            this.setPersistedParentNode(parent);
            oc.add((Object)parent);
            PersistedConnectionList pcl = this.getPersistedConnectionList();
            if (pcl != null) {
                AssociationListItemToKeyTransform transform = new AssociationListItemToKeyTransform((AssociationList)pcl);
                int cnt = pcl.count();
                for (int i = 0; i < cnt; ++i) {
                    Object key = pcl.getKey(i);
                    Object obj = pcl.get(i);
                    parent.addNodeChild((SimpleNodeInterface)this.newConnectionNode(transform.transform(obj).toString(), PERSISTED, this.getProfileConnection(pcl, key)));
                }
            }
        } else {
            this.setPersistedParentNode(null);
        }
        if (this.getCustomConnectionList() != null) {
            parent = new NodeIcon(this.getCustomParentNodeText());
            parent.setNodeType("customParent");
            this.setCustomParentNode(parent);
            oc.add((Object)parent);
            StaticDictionaryInterface sdi = this.getCustomConnectionList();
            Enumeration enumer = sdi.getKeys();
            while (enumer != null && enumer.hasMoreElements()) {
                Object obj = enumer.nextElement();
                parent.addNodeChild((SimpleNodeInterface)this.newConnectionNode(obj.toString(), CUSTOM, this.getCustomConnection(sdi, obj)));
            }
        } else {
            this.setCustomParentNode(null);
        }
        return oc;
    }

    public String getConnectionName(Connection connection) {
        if (connection == null) {
            return null;
        }
        StaticDictionaryInterface sdi = this.getCustomConnectionList();
        if (sdi != null && sdi.contains((Object)connection)) {
            return sdi.getKey((Object)connection).toString();
        }
        return connection.getPersistedName();
    }

    private void setCurrentConnection(TreeView treeView) {
        com.sas.visuals.NodeView selNode = treeView.getSelectedNode();
        if (selNode != null) {
            if (selNode.getNode() instanceof ObjectDataInterface) {
                Object obj = ((ObjectDataInterface)selNode.getNode()).getObjectData();
                if (obj != null && obj instanceof Connection) {
                    this.setConnection((Connection)obj);
                } else {
                    this.setConnection(null);
                }
            } else {
                this.setConnection(null);
            }
        }
    }

    private void setCurrentConnectionSwing(com.sas.swing.visuals.TreeView treeView) {
        NodeView selNode = treeView.getSelectedNode();
        if (selNode != null) {
            if (selNode.getNode() instanceof ObjectDataInterface) {
                Object obj = ((ObjectDataInterface)selNode.getNode()).getObjectData();
                if (obj != null && obj instanceof Connection) {
                    this.setConnection((Connection)obj);
                } else {
                    this.setConnection(null);
                }
            } else {
                this.setConnection(null);
            }
        }
    }

    public Connection getConnection() {
        return this._connection;
    }

    public void setConnection(Connection newValue) {
        Connection oldValue = this.getConnection();
        this._connection = newValue;
        newValue = this.getConnection();
        if (!this.connectionsEqual(oldValue, newValue)) {
            if (oldValue != null) {
                oldValue.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            }
            if (newValue != null) {
                newValue.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            }
            ComponentInterfaceSupport.firePropertyChangeQuickly((ComponentInterface)this, (String)"connection", (Object)oldValue, (Object)newValue);
        }
    }

    public PersistedConnectionList getPersistedConnectionList() {
        return this._persistedConnections;
    }

    public void setPersistedConnectionList(PersistedConnectionList newValue) {
        PersistedConnectionList oldValue = this.getPersistedConnectionList();
        this._persistedConnections = newValue;
        newValue = this.getPersistedConnectionList();
        if (Util.unequal((Object)((Object)oldValue), (Object)((Object)newValue))) {
            if (oldValue != null) {
                oldValue.removeContentsChangedListener(this);
            }
            if (newValue != null) {
                newValue.addContentsChangedListener(this);
            }
            this.refresh();
            this.firePropertyChange("persistedConnectionList", (Object)oldValue, (Object)newValue);
        }
    }

    public StaticDictionaryInterface getCustomConnectionList() {
        return this._customConnections;
    }

    public void setCustomConnectionList(StaticDictionaryInterface newValue) {
        StaticDictionaryInterface oldValue = this.getCustomConnectionList();
        this._customConnections = newValue;
        newValue = this.getCustomConnectionList();
        if (Util.unequal((Object)oldValue, (Object)newValue)) {
            if (oldValue != null) {
                oldValue.removeContentsChangedListener((ContentsChangedListener)this);
            }
            if (newValue != null) {
                newValue.addContentsChangedListener((ContentsChangedListener)this);
            }
            this.refresh();
            this.firePropertyChange("customConnectionList", oldValue, newValue);
        }
    }

    private void print(OrderedCollectionInterface oci) {
        int cnt = oci.count();
        for (int i = 0; i < cnt; ++i) {
            Node parent = (Node)oci.get(i);
            System.out.println(parent);
            int cnt2 = parent.getNodeChildCount();
            for (int j = 0; j < cnt2; ++j) {
                System.out.println("\t" + parent.getNodeChild(j));
            }
        }
    }

    protected boolean refreshOnContentsChanged() {
        return true;
    }

    public void contentsChanged(ContentsChangedEvent event) {
        Object source = event.getSource();
        if (source == this.getPersistedConnectionList() && this._persistedParent != null) {
            Node tempPersistedParent = this._persistedParent;
            Node tempCustomParent = this._customParent;
            Node root = (Node)this.getRoot();
            OrderedCollectionInterface oci = this.getConnections();
            if (this._persistedParent != null) {
                this.compareBranch(tempPersistedParent, this._persistedParent);
                this.setPersistedParentNode(tempPersistedParent);
                this.setCustomParentNode(tempCustomParent);
                StaticDictionaryInterface customList = this.getCustomConnectionList();
                if (!this.isLoneLevelOneParentDisplayed() && customList == null) {
                    root.removeAllNodeChildren();
                    int count = tempPersistedParent.getNodeChildCount();
                    for (int i = 0; i < count; ++i) {
                        root.addNodeChild(tempPersistedParent.getNodeChild(i));
                    }
                }
                return;
            }
        } else if (source == this.getCustomConnectionList() && this._customParent != null) {
            Node tempPersistedParent = this._persistedParent;
            Node tempCustomParent = this._customParent;
            Node root = (Node)this.getRoot();
            OrderedCollectionInterface oci = this.getConnections();
            if (this._customParent != null) {
                this.compareBranch(tempCustomParent, this._customParent);
                this.setCustomParentNode(tempCustomParent);
                this.setPersistedParentNode(tempPersistedParent);
                PersistedConnectionList persistedList = this.getPersistedConnectionList();
                if (!this.isLoneLevelOneParentDisplayed() && persistedList == null) {
                    root.removeAllNodeChildren();
                    int count = tempCustomParent.getNodeChildCount();
                    for (int i = 0; i < count; ++i) {
                        root.addNodeChild(tempCustomParent.getNodeChild(i));
                    }
                }
                return;
            }
        }
        if (this.refreshOnContentsChanged()) {
            this.refresh();
        }
    }

    private int getIndex(Node parent, Node child) {
        int cnt = parent.getNodeChildCount();
        for (int i = 0; i < cnt; ++i) {
            Node node = (Node)parent.getNodeChild(i);
            if (!Util.equal((Object)node.getNodeText(), (Object)child.getNodeText())) continue;
            return i;
        }
        return -1;
    }

    private Node getNode(Node parent, Node child) {
        int index = this.getIndex(parent, child);
        if (index != -1) {
            return (Node)parent.getNodeChild(index);
        }
        return null;
    }

    private void compareBranch(Node prevNode, Node postNode) {
        int index;
        Node node;
        int i;
        int prevCnt = prevNode.getNodeChildCount();
        int postCnt = postNode.getNodeChildCount();
        for (i = 0; i < prevCnt; ++i) {
            node = (Node)prevNode.getNodeChild(i);
            index = this.getIndex(postNode, node);
            if (index == -1) {
                prevNode.removeNodeChild((SimpleNodeInterface)node);
                this.compareBranch(prevNode, postNode);
                return;
            }
            if (index == i || index >= prevCnt) continue;
            prevNode.moveNodeChild(i, index);
            this.compareBranch(prevNode, postNode);
            return;
        }
        for (i = 0; i < postCnt; ++i) {
            node = (Node)postNode.getNodeChild(i);
            index = this.getIndex(prevNode, node);
            if (index == -1) {
                prevNode.addNodeChild((SimpleNodeInterface)node, i);
                this.compareBranch(prevNode, postNode);
                return;
            }
            if (index == i) continue;
            prevNode.moveNodeChild(index, i);
            this.compareBranch(prevNode, postNode);
            return;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (Util.equal((Object)event.getPropertyName(), (Object)"selectedNode")) {
            if (source instanceof TreeView) {
                this.setCurrentConnection((TreeView)source);
            } else if (source instanceof com.sas.swing.visuals.TreeView) {
                this.setCurrentConnectionSwing((com.sas.swing.visuals.TreeView)source);
            }
        }
    }

    protected Node newConnectionNode(String nodeText, String nodeType, Object connection) {
        Node node = new Node(nodeText);
        node.setNodeType(nodeType);
        node.setObjectData(connection);
        return node;
    }

    public boolean connectionsEqual(Connection c1, Connection c2) {
        return Util.equal((Object)c1, (Object)c2) && Util.equal((Object)this.getConnectionName(c1), (Object)this.getConnectionName(c2));
    }

    protected Connection getProfileConnection(PersistedConnectionList pcl, Object key) {
        Connection connection = new Connection();
        pcl.updateConnectionProperties(connection, (String)key);
        return connection;
    }

    protected Connection getCustomConnection(StaticDictionaryInterface sdi, Object key) {
        try {
            return (Connection)sdi.get(key);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Object values in the custom list must be of type com.sas.rmi.Connection.");
        }
    }

    protected void setPersistedParentNode(Node node) {
        this._persistedParent = node;
    }

    protected void setCustomParentNode(Node node) {
        this._customParent = node;
    }

    public static void selectConnection(TreeView treeView, ConnectionTree connectionTree, Connection connection) {
        com.sas.visuals.NodeView node;
        String name = connectionTree.getConnectionName(connection);
        if (name == null) {
            return;
        }
        int i = 1;
        while ((node = treeView.getNodeView(name, i++)) != null) {
            ObjectDataInterface odi = (ObjectDataInterface)node.getNode();
            if (!connectionTree.connectionsEqual(connection, (Connection)odi.getObjectData())) continue;
            treeView.scrollToNode(node, true);
            break;
        }
    }

    public StaticPropertyBagInterface getDefaultNodeStyle() {
        return null;
    }

    public StaticPropertyBagInterface getNodeTypeStyle(String nodeType) {
        if (Util.equal((Object)nodeType, (Object)PERSISTED)) {
            return this._persistedStyle;
        }
        if (Util.equal((Object)nodeType, (Object)CUSTOM)) {
            return this._customStyle;
        }
        return null;
    }

    public StaticPropertyBagInterface[] getNodeTypeStyles() {
        return new StaticPropertyBagInterface[]{this._persistedStyle, this._customStyle};
    }

    public String[] getNodeTypes() {
        return new String[]{PERSISTED, CUSTOM};
    }

    public static TreeView getConnectionTreeView(ConnectionTree connectionTree) {
        TreeView treeView = new TreeView();
        treeView.initialize();
        treeView.getDefaultNodeStyle().set("imageVisible", (Object)Boolean.FALSE);
        treeView.setRootNodeVisible(false);
        treeView.setLineVisibility(2);
        treeView.setModelInterface((ModelInterface)connectionTree);
        treeView.addPropertyChangeListener((PropertyChangeListener)((Object)connectionTree));
        return treeView;
    }

    public static com.sas.swing.visuals.TreeView getConnectionSwingTreeView(ConnectionTree connectionTree) {
        com.sas.swing.visuals.TreeView treeView = new com.sas.swing.visuals.TreeView();
        treeView.initialize();
        treeView.getDefaultNodeStyle().set("imageVisible", (Object)Boolean.FALSE);
        treeView.setRootNodeVisible(false);
        treeView.setLineVisibility(2);
        treeView.setModel(connectionTree);
        treeView.addPropertyChangeListener((PropertyChangeListener)((Object)connectionTree));
        return treeView;
    }
}

