/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.Connection;
import com.sas.rmi.Rocf;
import com.sas.security.BaseSecuritySupport;
import java.security.AccessControlException;

public class ConnectionThread
implements Runnable {
    protected Rocf m_rocf;
    protected Connection m_connection;
    protected Thread m_thread;
    protected boolean m_failed = false;
    protected String exceptionMessage = "";

    public ConnectionThread(Rocf rocf, Connection connection) {
        this.m_rocf = rocf;
        this.m_connection = connection;
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = BaseSecuritySupport.securitySupport.createThread((Runnable)this);
            this.m_thread.start();
        }
    }

    public void stop() {
        if (this.m_connection != null) {
            this.m_connection.stop();
        }
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
    }

    @Override
    public void run() {
        try {
            this.m_rocf.connect(this.m_connection);
            this.m_connection.preloadCheck();
        }
        catch (AccessControlException ace) {
            String msg = ace.toString();
            if (msg.indexOf("modifyThread") == -1) {
                this.m_failed = true;
                this.exceptionMessage = msg;
                ace.printStackTrace();
            } else {
                ace.printStackTrace();
            }
        }
        catch (RuntimeException rex) {
            String msg = rex.toString();
            if (msg.indexOf("AccessControlException") == -1 || msg.indexOf("modifyThread") == -1) {
                this.m_failed = true;
                this.exceptionMessage = msg;
                rex.printStackTrace();
            } else {
                rex.printStackTrace();
            }
        }
        catch (Exception ex) {
            this.m_failed = true;
            this.exceptionMessage = ex.toString();
            ex.printStackTrace();
        }
    }

    public boolean isAlive() {
        boolean rc = false;
        if (this.m_thread != null) {
            rc = this.m_thread.isAlive();
        }
        return rc;
    }

    public boolean didFail() {
        boolean rc = false;
        if (!this.isAlive()) {
            rc = this.m_failed;
        }
        return rc;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }
}

