/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.collection.OrderedCollectionInterface;
import com.sas.rmi.PersistedConnectionList;
import com.sas.rmi.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.LabelView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ConnectionSaveAsDialog
extends JDialog
implements ActionListener,
DocumentListener {
    public static final String RB_KEY = "ConnectionSaveAsDialog.";
    protected transient JPanel btnPanel;
    protected transient JTextField connectionName;
    protected transient JButton okBtn;
    protected transient JButton cancelBtn;
    protected transient String persistedName;
    protected transient String originalMessageText;
    protected transient LabelView saveLabel;
    private transient PersistedConnectionList propertyList;
    private transient OrderedCollectionInterface reservedNamesList;
    protected transient JComboBox connectionNameCombo;
    protected transient PersistedConnectionList existList;
    protected transient JPanel mainPanel;

    public ConnectionSaveAsDialog(Frame parent) {
        super(parent);
        this.setDefaultValues();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object eSource = event.getSource();
        if (eSource == this.okBtn) {
            this.persistedName = this.getConnectionName();
            if (this.propertyList != null && this.propertyList.containsKey(this.persistedName) || this.reservedNamesList != null && this.reservedNamesList.contains((Object)this.persistedName)) {
                Message errorMessage = new Message(RB.getResources(), "ConnectionSaveAsDialog.nameErrorDialog.errorMessage.txt", (Object)this.persistedName);
                JOptionPane.showMessageDialog(null, errorMessage.toString(), RB.getStringResource(RB_KEY, "nameErrorDialog.title.txt"), 0);
                if (this.connectionNameCombo != null) {
                    this.connectionNameCombo.requestFocus();
                } else {
                    this.connectionName.requestFocus();
                }
                return;
            }
        } else {
            this.persistedName = null;
        }
        this.setVisible(false);
        this.dispose();
    }

    protected String getConnectionName() {
        if (this.connectionNameCombo != null) {
            return (String)this.connectionNameCombo.getSelectedItem();
        }
        return this.connectionName.getText();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        String name = this.connectionName.getText();
        if (name == null || Strings.trimmedLength((String)name) == 0) {
            this.okBtn.setEnabled(false);
        } else {
            this.okBtn.setEnabled(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    public void resetMessageLabel() {
        this.saveLabel.setText(this.originalMessageText);
    }

    public void setMessageLabel(String txt) {
        this.saveLabel.setText(txt);
        this.validate();
    }

    public void setExistingList(PersistedConnectionList existingConnList) {
        this.existList = existingConnList;
        if (this.connectionNameCombo == null) {
            this.connectionNameCombo = new JComboBox();
            this.connectionNameCombo.setEditable(true);
            DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>();
            Enumeration e = existingConnList.getItems();
            while (e.hasMoreElements()) {
                Object item = existingConnList.getKey(e.nextElement());
                if (!(item instanceof String)) {
                    item = item.toString();
                }
                comboModel.addElement(item);
            }
            this.connectionNameCombo.setModel(comboModel);
            this.mainPanel.remove(this.connectionName);
            this.mainPanel.add((Component)this.connectionNameCombo, 1);
            this.validate();
        }
    }

    public void setPropertyList(PersistedConnectionList propList) {
        this.propertyList = propList;
    }

    public void setReservedNamesList(OrderedCollectionInterface reservedNames) {
        this.reservedNamesList = reservedNames;
    }

    public void setPersistedName(String connName) {
        this.connectionName.setText(connName);
    }

    public String getPersistedName() {
        return this.persistedName;
    }

    @Override
    public void setVisible(boolean v) {
        String connText = this.connectionName.getText();
        if (connText == null || connText.length() == 0) {
            this.okBtn.setEnabled(false);
        }
        super.setVisible(v);
    }

    public void setDefaultValues() {
        this.setTitle(RB.getStringResource(RB_KEY, "title.txt"));
        this.setResizable(false);
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.mainPanel = new JPanel();
        AutoSizingGridLayout asgl = new AutoSizingGridLayout(3, 1, 0, 5, true, true, true);
        this.mainPanel.setLayout((LayoutManager)asgl);
        asgl.setRemainderRow(2);
        this.mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.saveLabel = new LabelView();
        this.originalMessageText = RB.getStringResource(RB_KEY, "saveLabel.txt");
        this.saveLabel.setText(this.originalMessageText);
        this.mainPanel.add(this.saveLabel);
        this.connectionName = new JTextField();
        this.mainPanel.add(this.connectionName);
        JPanel extraBtnPanel = new JPanel();
        extraBtnPanel.setLayout(new BorderLayout());
        this.mainPanel.add(extraBtnPanel);
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new GridLayout(1, 2, 5, 0));
        extraBtnPanel.add((Component)this.btnPanel, "East");
        this.okBtn = new JButton(RB.getStringResource("ConnectionEditDialog.", "okBtn.txt"));
        this.btnPanel.add(this.okBtn);
        this.cancelBtn = new JButton(RB.getStringResource("ConnectionEditDialog.", "cancelBtn.txt"));
        this.btnPanel.add(this.cancelBtn);
        this.addListeners();
    }

    protected void addListeners() {
        this.okBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        this.connectionName.getDocument().addDocumentListener(this);
    }
}

