/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.awt.Button;
import com.sas.awt.TextField;
import com.sas.beans.CustomizerUtil;
import com.sas.rmi.Connection;
import com.sas.rmi.RB;
import com.sas.rmi.Rocf;
import com.sas.rmi.UIWorker;
import com.sas.util.ThreadedCommand;
import com.sas.visuals.CommandProgress;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ConnectionDialog
extends Dialog
implements WindowListener,
PropertyChangeListener,
ActionListener,
ThreadedCommand {
    boolean m_done;
    Connection m_ctxt;
    Rocf m_rocf;
    Container m_container;
    Thread m_thread;
    public static final String RB_KEY = "ConnectionDialog.";
    public static final String RB_CED_KEY = "ConnectionEditDialog.";
    public static final String RB_CEV_KEY = "ConnectionEditView.connectionCustomizerPanel.";
    boolean customizeEnabled = true;
    boolean systemUser = false;
    boolean applUser = false;
    int gridRows = 0;
    int hgap = 10;
    int vgap = 5;
    int numButtons = 0;
    transient com.sas.awt.Label connectingLabel;
    transient com.sas.awt.Label userLabel;
    transient TextField userText;
    transient com.sas.awt.Label passwordLabel;
    transient TextField passwordText;
    transient Button okButton;
    transient Button cancelButton;
    transient Button customizeButton;
    transient com.sas.awt.Label applUserLabel;
    transient TextField applUserText;
    transient com.sas.awt.Label applPasswordLabel;
    transient TextField applPasswordText;

    ConnectionDialog(Frame f, boolean modal, Container ctr, Rocf r, Connection c) {
        super(f, modal);
        this.m_rocf = r;
        this.m_container = ctr;
        this.customizeEnabled = c.getAllowCustomize();
        this.systemUser = c.isDeferUserInfoUntilRuntime() || c.isDeferAllUntilRuntime();
        boolean bl = this.applUser = c.isDeferApplicationUserInfoUntilRuntime() || c.isDeferAllUntilRuntime();
        if (this.systemUser) {
            this.gridRows += 2;
        }
        if (this.applUser) {
            this.gridRows += 2;
        }
        this.numButtons = 2;
        if (this.customizeEnabled) {
            ++this.numButtons;
        }
        this.setTitle(RB.getStringResource(RB_KEY, "title.txt") + " " + c.getHost());
        this.m_done = false;
        this.m_ctxt = c;
        this.init();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent _event) {
        Object _source = _event.getSource();
        if (_source != null) {
            if (_source == this.okButton) {
                String msg = "Connecting to " + this.m_ctxt.getHost();
                try {
                    CommandProgress.executeAsynchronously(this, null, msg, msg, this.m_container, this.m_container);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (_source == this.customizeButton) {
                CustomizerUtil.customize(this.m_ctxt, new Frame(), true);
            }
            if (_source == this.cancelButton) {
                if (this.m_thread == null) {
                    this.dispose();
                } else {
                    this.connectingLabel.setText("Cancelling connection");
                    this.m_thread.stop();
                    this.m_thread = null;
                    UIWorker.setBusy(this, false, true, true);
                    if (this.m_ctxt != null) {
                        this.m_ctxt.stop();
                    }
                    this.connectingLabel.setText("Connection cancelled");
                }
                this.stopConnecting();
            }
        }
    }

    public boolean done() {
        return this.m_done;
    }

    void startConnecting() {
        this.cancelButton.setEnabled(true);
        this.cancelButton.setCursor(new Cursor(0));
    }

    void stopConnecting() {
    }

    public void execute(Object o) {
        this.connectingLabel.setText("Connecting...");
        this.startConnecting();
        if (this.m_rocf != null && this.m_ctxt != null) {
            try {
                this.m_rocf.connect(this.m_ctxt);
                this.m_ctxt.preloadCheck();
            }
            catch (Exception e) {
                this.stopConnecting();
                this.connectingLabel.setText("Failure, please see log for exception");
                throw new RuntimeException("" + e);
            }
            this.stopConnecting();
            this.connectingLabel.setText("");
            this.m_done = true;
            this.dispose();
        }
    }

    public void interrupt() {
        if (this.m_ctxt != null) {
            this.m_ctxt.stop();
        }
    }

    public void doSeparatelyThreadedWork() {
        this.connectingLabel.setText("Connecting...");
        this.startConnecting();
        if (this.m_rocf != null && this.m_ctxt != null) {
            this.stopConnecting();
            this.connectingLabel.setText("");
            this.m_done = true;
            this.dispose();
        }
    }

    public void init() {
        this.addWindowListener(this);
        this.createComponents();
        this.addComponents();
        this.createROCFComponents();
        this.initConnections();
        this.repaint();
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowClosed(WindowEvent event) {
    }

    @Override
    public void windowClosing(WindowEvent event) {
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

    public void createComponents() {
        this.connectingLabel = new com.sas.awt.Label("");
        this.userLabel = new com.sas.awt.Label();
        this.userText = new TextField();
        this.passwordLabel = new com.sas.awt.Label();
        this.passwordText = new TextField();
        this.okButton = new Button();
        this.cancelButton = new Button();
        this.customizeButton = new Button();
        this.applUserLabel = new com.sas.awt.Label();
        this.applUserText = new TextField();
        this.applPasswordLabel = new com.sas.awt.Label();
        this.applPasswordText = new TextField();
        if (this.systemUser) {
            this.userLabel.setText(RB.getStringResource(RB_CEV_KEY, "userNameLabel.txt"));
            this.passwordLabel.setText(RB.getStringResource(RB_CEV_KEY, "passwordLabel.txt"));
        }
        if (this.applUser) {
            this.applUserLabel.setText(RB.getStringResource(RB_CEV_KEY, "applicationUserNameLabel.txt"));
            this.applPasswordLabel.setText(RB.getStringResource(RB_CEV_KEY, "applicationPasswordLabel.txt"));
        }
        this.okButton.setText(RB.getStringResource(RB_CED_KEY, "okBtn.txt"));
        this.cancelButton.setText(RB.getStringResource(RB_CED_KEY, "cancelBtn.txt"));
        if (this.customizeEnabled) {
            this.customizeButton.setText(RB.getStringResource(RB_KEY, "customizeBtn.txt"));
        }
        this.connectingLabel.initialize();
        this.userLabel.initialize();
        this.userText.initialize();
        this.passwordLabel.initialize();
        this.passwordText.initialize();
        this.applUserLabel.initialize();
        this.applUserText.initialize();
        this.applPasswordLabel.initialize();
        this.applPasswordText.initialize();
        this.okButton.initialize();
        this.cancelButton.initialize();
        this.customizeButton.initialize();
    }

    public void addComponents() {
        BorderLayout spaceLM = new BorderLayout();
        Panel outer = new Panel();
        BorderLayout outerLM = new BorderLayout(this.hgap, this.vgap);
        outer.setLayout(outerLM);
        Panel entry = new Panel();
        GridLayout entryLM = new GridLayout(this.gridRows, 2, this.hgap, this.vgap);
        entry.setLayout(entryLM);
        if (this.systemUser) {
            entry.add(this.userLabel);
            entry.add(this.userText);
            entry.add(this.passwordLabel);
            entry.add(this.passwordText);
        }
        if (this.applUser) {
            entry.add(this.applUserLabel);
            entry.add(this.applUserText);
            entry.add(this.applPasswordLabel);
            entry.add(this.applPasswordText);
        }
        Panel south = new Panel();
        BorderLayout southLM = new BorderLayout(this.hgap, this.vgap);
        south.setLayout(southLM);
        Panel buttons = new Panel();
        GridLayout buttonLM = new GridLayout(1, this.numButtons, this.hgap, this.vgap);
        buttons.setLayout(buttonLM);
        buttons.add(this.okButton);
        buttons.add(this.cancelButton);
        if (this.customizeEnabled) {
            buttons.add(this.customizeButton);
        }
        south.add("North", buttons);
        south.add("South", this.connectingLabel);
        this.setLayout(spaceLM);
        outer.add("Center", entry);
        outer.add("South", south);
        this.add("Center", outer);
        this.add("East", new Label(""));
        this.add("West", new Label(""));
        this.add("North", new Label(""));
        this.pack();
        if (this.m_container != null) {
            int ypos;
            int width = this.getSize().width;
            int height = this.getSize().height;
            Rectangle rect = this.m_container.getBounds();
            int xpos = (rect.x + rect.width) / 2 - width / 2;
            if (xpos < 0) {
                xpos = 0;
            }
            if ((ypos = (rect.y + rect.height) / 2 - height / 2) < 0) {
                ypos = 0;
            }
            this.setLocation(xpos, ypos);
        }
    }

    public void createROCFComponents() {
    }

    public void initConnections() {
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.customizeButton.addActionListener(this);
        this.userText.setText(this.m_ctxt.getUsername());
        this.passwordText.setText(this.m_ctxt.getPassword());
        this.applUserText.setText(this.m_ctxt.getApplicationUsername());
        this.applPasswordText.setText(this.m_ctxt.getApplicationPassword());
        this.userText.addPropertyChangeListener(this);
        this.passwordText.addPropertyChangeListener(this);
        this.applUserText.addPropertyChangeListener(this);
        this.applPasswordText.addPropertyChangeListener(this);
        this.m_ctxt.addPropertyChangeListener(this);
        this.passwordText.setEchoChar('*');
        this.applPasswordText.setEchoChar('*');
    }

    @Override
    public void propertyChange(PropertyChangeEvent _event) {
        Object _source = _event.getSource();
        String _name = _event.getPropertyName();
        if (_name == null) {
            _name = "";
        }
        if (_source == this.userText && _name.equals("text")) {
            this.m_ctxt.setUsername(this.userText.getText());
        }
        if (_source == this.passwordText && _name.equals("text")) {
            this.m_ctxt.setPassword(this.passwordText.getText());
        }
        if (_source == this.applUserText && _name.equals("text")) {
            this.m_ctxt.setApplicationUsername(this.applUserText.getText());
        }
        if (_source == this.applPasswordText && _name.equals("text")) {
            this.m_ctxt.setApplicationPassword(this.applPasswordText.getText());
        }
        if (_source == this.m_ctxt && _name.equals("host")) {
            String host = this.m_ctxt.getHost();
            this.setTitle(RB.getStringResource(RB_KEY, "title.txt") + " " + host);
        }
        if (_source == this.m_ctxt && _name.equals("username")) {
            this.userText.setText(this.m_ctxt.getUsername());
        }
        if (_source == this.m_ctxt && _name.equals("password")) {
            this.passwordText.setText(this.m_ctxt.getPassword());
        }
        if (_source == this.m_ctxt && _name.equals("applicationUsername")) {
            this.applUserText.setText(this.m_ctxt.getApplicationUsername());
        }
        if (_source == this.m_ctxt && _name.equals("applicationPassword")) {
            this.applPasswordText.setText(this.m_ctxt.getApplicationPassword());
        }
    }
}

