/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.ComponentException;
import com.sas.rmi.Connection;
import com.sas.rmi.J2PrintStream;
import com.sas.rmi.PrintInterface;
import com.sas.rmi.RB;
import com.sas.rmi.Rocf;
import com.sas.rmi.StatusEvent;
import com.sas.rmi.StatusListener;
import com.sas.security.SecuritySupport;
import com.sas.swing.visuals.SwingCustomizerPanel;
import com.sas.text.Message;
import com.sas.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Document;

public class ConnectionCustomizerTestPanel
extends SwingCustomizerPanel
implements ActionListener,
StatusListener,
Runnable,
PrintInterface {
    public static String RB_KEY = "ConnectionCustomizerTestPanel.";
    Connection connection;
    JPanel buttonContainer;
    JButton checkConnection;
    JButton stopConnection;
    JTextArea testLog;
    Rocf m_rocf;
    Thread m_thread;
    J2PrintStream m_j2ps;
    Cursor busyCursor;
    Cursor idleCursor;
    Connection liveConnection;

    public ConnectionCustomizerTestPanel() {
        this("Test");
    }

    public ConnectionCustomizerTestPanel(String tabName) {
        super(tabName);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.createComponents();
        this.layoutComponents();
        this.addListeners();
    }

    protected void createComponents() {
        this.checkConnection = new JButton();
        this.stopConnection = new JButton();
        this.buttonContainer = new JPanel();
        this.testLog = new JTextArea();
        this.busyCursor = new Cursor(3);
        this.idleCursor = new Cursor(0);
        this.testLog.setFont(new Font("Monospaced", 0, 14));
        this.testLog.setEditable(false);
        this.checkConnection.setText(RB.getStringResource(RB_KEY, "checkConnection.txt"));
        this.stopConnection.setText(RB.getStringResource(RB_KEY, "stopConnection.txt"));
        this.stopConnection.setEnabled(false);
        this.checkConnection.setDefaultCapable(false);
        this.stopConnection.setDefaultCapable(false);
    }

    protected void layoutComponents() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout((LayoutManager)new AutoSizingGridLayout(0, 1, 0, 5, true, true, true));
        this.buttonContainer.setLayout((LayoutManager)new AutoSizingGridLayout(1, 2, 5, 0, false, false, false));
        this.buttonContainer.add(this.checkConnection);
        this.buttonContainer.add(this.stopConnection);
        JScrollPane testLogScrollPane = new JScrollPane(this.testLog);
        testLogScrollPane.setPreferredSize(new Dimension(100, 100));
        this.add(this.buttonContainer);
        this.add(testLogScrollPane);
    }

    protected void addListeners() {
        this.checkConnection.addActionListener(this);
        this.stopConnection.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object eSource = evt.getSource();
        if (eSource == this.checkConnection) {
            this.start();
        } else if (eSource == this.stopConnection) {
            this.stop();
        }
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = SecuritySupport.securitySupport.createThread((Runnable)this);
            EventQueue.invokeLater(this.m_thread);
        }
    }

    public void stop() {
        if (this.m_thread != null) {
            this.print(RB.getStringResource(RB_KEY, "stopAbort.txt"));
            this.m_thread.stop();
        }
        this.cleanup();
    }

    @Override
    public void run() {
        J2PrintStream.setTee(false);
        this.m_j2ps = J2PrintStream.attachToStandardOut();
        this.m_j2ps.setCallback(this);
        this.m_rocf = new Rocf();
        this.print(RB.getStringResource(RB_KEY, "startThreadedConnection.txt"), false);
        boolean failed = false;
        String s = "";
        this.testLog.setCursor(this.busyCursor);
        this.checkConnection.setEnabled(false);
        this.stopConnection.setEnabled(true);
        try {
            this.liveConnection = (Connection)this.connection.clone();
            this.liveConnection.setString(Connection.DEBUGTELNETCONNECTCLIENT, Connection.TRUE);
            this.liveConnection.setLogTrap(true);
            this.m_rocf.connect(this.liveConnection);
            this.liveConnection.preloadCheck();
        }
        catch (Exception e) {
            failed = true;
            s = "" + e;
        }
        this.cleanup();
        if (failed) {
            Message msg = new Message(RB.getResources(), RB_KEY + "failure2.txt", (Object)s);
            this.print(msg.toString());
        } else {
            this.print(RB.getStringResource(RB_KEY, "success2.txt"));
            String log = this.testLog.getText();
            if (log.indexOf("ERROR:") != -1) {
                this.print("\n");
                this.print(RB.getStringResource(RB_KEY, "successWithErrors.txt"));
            }
        }
        this.scrollCheckText();
    }

    private void scrollCheckText() {
        Document doc = this.testLog.getDocument();
        if (doc != null) {
            int lastPos = doc.getLength();
            this.testLog.setCaretPosition(lastPos);
        }
    }

    @Override
    public void print(String s) {
        this.print(s, true);
    }

    private void print(final String s, final boolean append) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (append) {
                    ConnectionCustomizerTestPanel.this.testLog.append(s);
                } else {
                    ConnectionCustomizerTestPanel.this.testLog.setText(s);
                }
                ConnectionCustomizerTestPanel.this.scrollCheckText();
            }
        });
    }

    private void cleanup() {
        this.testLog.setCursor(this.idleCursor);
        this.checkConnection.setEnabled(true);
        this.stopConnection.setEnabled(false);
        if (this.m_rocf != null) {
            this.m_rocf.stop();
            this.m_rocf = null;
        }
        this.liveConnection.stop();
        this.m_thread = null;
        if (this.m_j2ps != null) {
            this.m_j2ps.detach();
        }
        this.m_j2ps = null;
    }

    @Override
    public void statusEvent(StatusEvent e) {
        int eventID = e.getEventID();
        switch (eventID) {
            case 0: {
                this.print(e.getStatus());
                break;
            }
            case 1: {
                this.print(RB.getStringResource(RB_KEY, "success1.txt"), false);
                break;
            }
            case 2: {
                Message msg = new Message(RB.getResources(), RB_KEY + "failure1.txt", (Object)e.getStatus());
                this.print(msg.toString());
            }
        }
    }

    @Override
    public void setObject(Object bean) {
        super.setObject(bean);
        if (!(bean instanceof Connection)) {
            Message exceptionMessage = new Message(Util.getCommonResources(), "Customizer.setObject.ex.txt", (Object)"ConnectionCustomizerTestPanel", (Object)"com.sas.rmi.Connection");
            throw new ComponentException(exceptionMessage.toString());
        }
        this.connection = (Connection)bean;
        this.testLog.setText("");
    }
}

