/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.ComponentException;
import com.sas.awt.util.Util;
import com.sas.collection.AssociationList;
import com.sas.rmi.Connection;
import com.sas.rmi.RB;
import com.sas.swing.visuals.SwingCustomizerPanel;
import com.sas.swing.visuals.util.JTextFieldValidator;
import com.sas.text.Message;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.validators.IntegerStringValidator;
import com.sas.util.validators.ValidationInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ConnectionCustomizerConnectionPanel
extends SwingCustomizerPanel
implements ItemListener,
PropertyChangeListener,
DocumentListener {
    public static String RB_KEY = "ConnectionCustomizerConnectionPanel.";
    Connection connection;
    JPanel serverConfigContainer;
    JLabel serverConfigLabel;
    JComboBox serverConfig;
    JCheckBox relativeToWebServer;
    JPanel accessContainer;
    JLabel userNameLabel;
    JTextField userNameField;
    JLabel passwordLabel;
    JPasswordField passwordField;
    JPanel hostContainer;
    JLabel hostNameLabel;
    JTextField hostNameField;
    JLabel portLabel;
    JTextField portField;
    JPanel sasContainer;
    JLabel sasCommandLabel;
    JTextField sasCommandField;
    JLabel initialSubmitLabel;
    JTextField initialSubmitField;
    JTextFieldValidator portFieldValidator;
    boolean updatingFields;
    boolean updatingConnection;
    boolean codeEvent;
    String currentServerType;
    protected static String SERVER_PC = "PC";
    protected static String SERVER_UNIX = "UNIX";
    protected static String SERVER_MVS_SPAWNER = "MVS SPAWNER";
    protected static String SERVER_MVS = "MVS";
    protected static String SERVER_IOM = "IOM";
    protected static String SERVER_RMI = "RMI";
    protected static String SERVER_LOCAL = "LOCAL";
    protected static String SERVER_CORBA = "CORBA";
    protected static String SERVER_GMS = "GMS";
    protected static String SERVER_OLAP = "OLAP";
    protected static boolean showGMS = false;
    protected static boolean showOLAP = false;
    AssociationList serverTypes;

    public ConnectionCustomizerConnectionPanel() {
        this("Connection");
    }

    public ConnectionCustomizerConnectionPanel(String tabName) {
        super(tabName);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.createComponents();
        this.layoutComponents();
        this.addListeners();
    }

    protected void createComponents() {
        this.serverConfigContainer = new JPanel();
        this.serverConfigLabel = new JLabel();
        this.serverConfig = new JComboBox();
        this.relativeToWebServer = new JCheckBox();
        this.accessContainer = new JPanel();
        this.userNameLabel = new JLabel();
        this.userNameField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.hostContainer = new JPanel();
        this.hostNameLabel = new JLabel();
        this.hostNameField = new JTextField();
        this.portLabel = new JLabel();
        this.portField = new JTextField();
        this.sasContainer = new JPanel();
        this.sasCommandLabel = new JLabel();
        this.sasCommandField = new JTextField();
        this.initialSubmitLabel = new JLabel();
        this.initialSubmitField = new JTextField();
        this.serverTypes = new AssociationList();
        int i = 0;
        this.serverTypes.add(i++, (Object)SERVER_PC, (Object)RB.getStringResource(RB_KEY, "serverPC.txt"));
        this.serverTypes.add(i++, (Object)SERVER_UNIX, (Object)RB.getStringResource(RB_KEY, "serverUnix.txt"));
        this.serverTypes.add(i++, (Object)SERVER_MVS_SPAWNER, (Object)RB.getStringResource(RB_KEY, "serverMVSspawner.txt"));
        this.serverTypes.add(i++, (Object)SERVER_MVS, (Object)RB.getStringResource(RB_KEY, "serverMVS.txt"));
        this.serverTypes.add(i++, (Object)SERVER_IOM, (Object)RB.getStringResource(RB_KEY, "serverIOM.txt"));
        this.serverTypes.add(i++, (Object)SERVER_RMI, (Object)RB.getStringResource(RB_KEY, "serverRMI.txt"));
        this.serverTypes.add(i++, (Object)SERVER_CORBA, (Object)RB.getStringResource(RB_KEY, "serverCORBA.txt"));
        this.serverTypes.add(i++, (Object)SERVER_LOCAL, (Object)RB.getStringResource(RB_KEY, "serverLocal.txt"));
        if (showGMS) {
            this.serverTypes.add(i++, (Object)SERVER_GMS, (Object)RB.getStringResource(RB_KEY, "serverGMS.txt"));
        }
        if (showOLAP) {
            this.serverTypes.add(i++, (Object)SERVER_OLAP, (Object)RB.getStringResource(RB_KEY, "serverOLAP.txt"));
        }
        DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>();
        comboModel.addElement(RB.getStringResource(RB_KEY, "serverPC.txt"));
        comboModel.addElement(RB.getStringResource(RB_KEY, "serverUnix.txt"));
        comboModel.addElement(RB.getStringResource(RB_KEY, "serverMVSspawner.txt"));
        comboModel.addElement(RB.getStringResource(RB_KEY, "serverMVS.txt"));
        comboModel.addElement(RB.getStringResource(RB_KEY, "serverIOM.txt"));
        comboModel.addElement(RB.getStringResource(RB_KEY, "serverRMI.txt"));
        comboModel.addElement(RB.getStringResource(RB_KEY, "serverCORBA.txt"));
        comboModel.addElement(RB.getStringResource(RB_KEY, "serverLocal.txt"));
        comboModel.addElement(RB.getStringResource(RB_KEY, "serverGMS.txt"));
        comboModel.addElement(RB.getStringResource(RB_KEY, "serverOLAP.txt"));
        this.serverConfig.setModel(comboModel);
        this.serverConfigLabel.setText(RB.getStringResource(RB_KEY, "serverConfigLabel.txt"));
        this.relativeToWebServer.setText(RB.getStringResource(RB_KEY, "relativeToWebServer.txt"));
        this.accessContainer.setBorder(com.sas.swing.visuals.util.Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "accessContainer.title.txt"), (int)7, (int)5, (int)5, (int)5));
        this.userNameLabel.setText(RB.getStringResource(RB_KEY, "userNameLabel.txt"));
        this.passwordLabel.setText(RB.getStringResource(RB_KEY, "passwordLabel.txt"));
        this.passwordField.setEchoChar('*');
        this.hostContainer.setBorder(com.sas.swing.visuals.util.Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "hostContainer.title.txt"), (int)7, (int)5, (int)5, (int)5));
        this.hostNameLabel.setText(RB.getStringResource(RB_KEY, "hostNameLabel.txt"));
        this.portLabel.setText(RB.getStringResource(RB_KEY, "portLabel.txt"));
        this.portFieldValidator = new JTextFieldValidator(this.portField, (ValidationInterface)new IntegerStringValidator(), (GenericErrorHandlerInterface)new JOptionPaneErrorHandler((Component)this.portField));
        this.sasContainer.setBorder(com.sas.swing.visuals.util.Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "sasContainer.title.txt"), (int)7, (int)5, (int)5, (int)5));
        this.sasCommandLabel.setText(RB.getStringResource(RB_KEY, "sasCommandLabel.txt"));
        this.initialSubmitLabel.setText(RB.getStringResource(RB_KEY, "initialSubmitLabel.txt"));
        this.updatingFields = false;
        this.updatingConnection = false;
    }

    public static void showGMS(boolean flag) {
        showGMS = flag;
    }

    public static void showOLAP(boolean flag) {
        showOLAP = flag;
    }

    protected void layoutComponents() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 1, 0, 5, true, false, true);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout((LayoutManager)layout);
        this.serverConfigContainer.setLayout((LayoutManager)new AutoSizingGridLayout(1, 0, 5, 0, true, false, true));
        AutoSizingGridLayout accessLayout = new AutoSizingGridLayout(2, 2, 5, 5, true, false, true);
        AutoSizingGridLayout hostLayout = new AutoSizingGridLayout(2, 2, 5, 5, true, false, true);
        AutoSizingGridLayout sasLayout = new AutoSizingGridLayout(2, 2, 5, 5, true, false, true);
        accessLayout.setInterlockedColumnContainers(new Container[]{this.accessContainer, this.hostContainer, this.sasContainer});
        hostLayout.setInterlockedColumnContainers(new Container[]{this.accessContainer, this.hostContainer, this.sasContainer});
        sasLayout.setInterlockedColumnContainers(new Container[]{this.accessContainer, this.hostContainer, this.sasContainer});
        accessLayout.setIgnoreSizeOfNonVisibleComponents(true);
        hostLayout.setIgnoreSizeOfNonVisibleComponents(true);
        sasLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.accessContainer.setLayout((LayoutManager)accessLayout);
        this.hostContainer.setLayout((LayoutManager)hostLayout);
        this.sasContainer.setLayout((LayoutManager)sasLayout);
        this.serverConfigContainer.add(this.serverConfigLabel);
        this.serverConfigContainer.add(this.serverConfig);
        this.accessContainer.add(this.userNameLabel);
        this.accessContainer.add(this.userNameField);
        this.accessContainer.add(this.passwordLabel);
        this.accessContainer.add(this.passwordField);
        this.hostContainer.add(this.hostNameLabel);
        this.hostContainer.add(this.hostNameField);
        this.hostContainer.add(this.portLabel);
        this.hostContainer.add(this.portField);
        this.sasContainer.add(this.sasCommandLabel);
        this.sasContainer.add(this.sasCommandField);
        this.sasContainer.add(this.initialSubmitLabel);
        this.sasContainer.add(this.initialSubmitField);
        this.add(this.serverConfigContainer);
        this.add(this.relativeToWebServer);
        this.add(this.accessContainer);
        this.add(this.hostContainer);
        this.add(this.sasContainer);
    }

    protected void addListeners() {
        this.serverConfig.addItemListener(this);
        this.relativeToWebServer.addItemListener(this);
        this.userNameField.getDocument().addDocumentListener(this);
        this.passwordField.getDocument().addDocumentListener(this);
        this.hostNameField.getDocument().addDocumentListener(this);
        this.portFieldValidator.addPropertyChangeListener(this);
        this.sasCommandField.getDocument().addDocumentListener(this);
        this.initialSubmitField.getDocument().addDocumentListener(this);
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        if (this.codeEvent) {
            return;
        }
        if (!this.updatingFields) {
            Document eSource = event.getDocument();
            try {
                this.updatingConnection = true;
                if (eSource == this.userNameField.getDocument()) {
                    this.connection.setUsername(this.userNameField.getText());
                } else if (eSource == this.passwordField.getDocument()) {
                    this.connection.setPassword(new String(this.passwordField.getPassword()));
                } else if (eSource == this.hostNameField.getDocument()) {
                    this.connection.setHost(this.hostNameField.getText());
                } else if (eSource == this.sasCommandField.getDocument()) {
                    this.connection.setCommand(this.sasCommandField.getText());
                } else if (eSource == this.initialSubmitField.getDocument()) {
                    this.connection.setInitialStatement(this.initialSubmitField.getText());
                }
            }
            finally {
                this.updatingConnection = false;
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        Object eSource = evt.getSource();
        if (propName == null) return;
        if (propName.equals("valid") && eSource == this.portFieldValidator && !this.updatingFields) {
            try {
                Integer port = Integer.valueOf(this.portField.getText());
                if (port == null) return;
                this.connection.setPort(port);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            finally {
                this.updatingConnection = false;
            }
        }
        if (eSource != this.connection || this.updatingConnection) return;
        try {
            this.updatingFields = true;
            if (propName.equals("command")) {
                this.sasCommandField.setText(this.connection.getCommand());
                return;
            } else if (propName.equals("username")) {
                this.userNameField.setText(this.connection.getUsername());
                return;
            } else if (propName.equals("password")) {
                this.passwordField.setText(this.connection.getPassword());
                return;
            } else if (propName.equals("host")) {
                this.hostNameField.setText(this.connection.getHost());
                return;
            } else if (propName.equals("port")) {
                this.portField.setText(String.valueOf(this.connection.getPort()));
                return;
            } else {
                if (!propName.equals("initialStatement")) return;
                this.initialSubmitField.setText(this.connection.getInitialStatement());
            }
            return;
        }
        finally {
            this.updatingFields = false;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.codeEvent) {
            return;
        }
        Object eSource = e.getSource();
        if (eSource == this.serverConfig) {
            int typeIndex = this.serverConfig.getSelectedIndex();
            String newServerType = (String)this.serverTypes.getKey(typeIndex);
            if (!newServerType.equals(this.currentServerType)) {
                Connection.setServerArchitecture(this.connection, newServerType);
                this.currentServerType = newServerType;
                this.updateServerType();
            }
        } else if (eSource == this.relativeToWebServer) {
            boolean selected = this.relativeToWebServer.isSelected();
            this.connection.setAppletCodebaseRelative(selected);
            this.hostNameLabel.setEnabled(!selected);
            this.hostNameField.setEnabled(!selected);
        }
    }

    protected void updateServerType() {
        Util.setEnabledOnContainer(this, true);
        boolean selected = this.connection.isAppletCodebaseRelative();
        this.relativeToWebServer.setSelected(selected);
        if (selected) {
            this.hostNameLabel.setEnabled(false);
            this.hostNameField.setEnabled(false);
        }
        if (com.sas.util.Util.equal((Object)this.currentServerType, (Object)SERVER_RMI) || com.sas.util.Util.equal((Object)this.currentServerType, (Object)SERVER_CORBA)) {
            Util.setEnabledOnContainer(this.accessContainer, false);
            this.sasCommandLabel.setEnabled(false);
            this.sasCommandField.setEnabled(false);
        } else if (com.sas.util.Util.equal((Object)this.currentServerType, (Object)SERVER_LOCAL)) {
            Util.setEnabledOnContainer(this.accessContainer, false);
            Util.setEnabledOnContainer(this.hostContainer, false);
            Util.setEnabledOnContainer(this.sasContainer, false);
            this.relativeToWebServer.setEnabled(false);
        } else if (com.sas.util.Util.equal((Object)this.currentServerType, (Object)SERVER_IOM)) {
            this.sasCommandLabel.setEnabled(false);
            this.sasCommandField.setEnabled(false);
        } else if (com.sas.util.Util.equal((Object)this.currentServerType, (Object)SERVER_GMS)) {
            Util.setEnabledOnContainer(this.sasContainer, false);
        } else if (com.sas.util.Util.equal((Object)this.currentServerType, (Object)SERVER_OLAP)) {
            Util.setEnabledOnContainer(this.sasContainer, false);
        }
    }

    @Override
    public void setObject(Object bean) {
        super.setObject(bean);
        if (bean instanceof Connection) {
            this.connection = (Connection)bean;
            try {
                this.updatingFields = true;
                this.codeEvent = true;
                this.currentServerType = Connection.getServerArchitecture(this.connection);
                if (this.currentServerType != null) {
                    this.currentServerType = this.currentServerType.toUpperCase();
                }
                if (this.currentServerType == null || !this.serverTypes.containsKey((Object)this.currentServerType)) {
                    this.currentServerType = SERVER_PC;
                    String host = this.connection.getHost();
                    Connection.setServerArchitecture(this.connection, this.currentServerType);
                    if (host != null) {
                        this.connection.setHost(host);
                    }
                }
                String serverDisplayName = (String)this.serverTypes.get((Object)this.currentServerType);
                this.serverConfig.setSelectedItem(serverDisplayName);
                this.updateServerType();
                this.userNameField.setText(this.connection.getUsername());
                this.passwordField.setText(this.connection.getPassword());
                this.hostNameField.setText(this.connection.getHost());
                this.portField.setText(String.valueOf(this.connection.getPort()));
                this.sasCommandField.setText(this.connection.getCommand());
                this.initialSubmitField.setText(this.connection.getInitialStatement());
            }
            finally {
                this.updatingFields = false;
                this.codeEvent = false;
            }
        } else {
            Message exceptionMessage = new Message(com.sas.util.Util.getCommonResources(), "Customizer.setObject.ex.txt", (Object)"ConnectionCustomizerConnectionPanel", (Object)"com.sas.rmi.Connection");
            throw new ComponentException(exceptionMessage.toString());
        }
        this.connection.addPropertyChangeListener(this);
    }

    @Override
    public void customizerClosing() {
        this.connection.removePropertyChangeListener(this);
        this.updatingFields = true;
    }
}

