/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.ComponentException;
import com.sas.awt.util.Util;
import com.sas.rmi.Connection;
import com.sas.rmi.RB;
import com.sas.swing.visuals.SwingCustomizerPanel;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ConnectionCustomizerAdvancedPanel
extends SwingCustomizerPanel
implements ItemListener,
DocumentListener {
    public static String RB_KEY = "ConnectionCustomizerAdvancedPanel.";
    Connection connection;
    JCheckBox useRuntimeParams;
    JPanel parameterContainer;
    JLabel parameterKeyLabel;
    JTextField parameterKeyField;
    JCheckBox useTunneling;
    JPanel routerContainer;
    JLabel routerLabel;
    JTextField routerField;
    JPanel debugContainer;
    JCheckBox designTimeActive;
    JCheckBox traceProxyClient;
    JCheckBox useProfiler;
    JCheckBox useLogTrap;
    JCheckBox allowCustomize;
    JCheckBox ignoreTimeout;
    boolean codeEvent;

    public ConnectionCustomizerAdvancedPanel() {
        this("Advanced");
    }

    public ConnectionCustomizerAdvancedPanel(String tabName) {
        super(tabName);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.createComponents();
        this.layoutComponents();
        this.addListeners();
    }

    protected void createComponents() {
        this.useRuntimeParams = new JCheckBox();
        this.parameterContainer = new JPanel();
        this.parameterKeyLabel = new JLabel();
        this.parameterKeyField = new JTextField();
        this.useTunneling = new JCheckBox();
        this.routerContainer = new JPanel();
        this.routerLabel = new JLabel();
        this.routerField = new JTextField();
        this.debugContainer = new JPanel();
        this.designTimeActive = new JCheckBox();
        this.traceProxyClient = new JCheckBox();
        this.useProfiler = new JCheckBox();
        this.useLogTrap = new JCheckBox();
        this.allowCustomize = new JCheckBox();
        this.ignoreTimeout = new JCheckBox();
        this.useRuntimeParams.setText(RB.getStringResource(RB_KEY, "useRuntimeParams.txt"));
        this.parameterKeyLabel.setText(RB.getStringResource(RB_KEY, "parameterKeyLabel.txt"));
        this.parameterKeyLabel.setBorder(new EmptyBorder(0, 15, 0, 0));
        this.useTunneling.setText(RB.getStringResource(RB_KEY, "useTunneling.txt"));
        this.routerLabel.setBorder(new EmptyBorder(0, 15, 0, 0));
        this.routerLabel.setText(RB.getStringResource(RB_KEY, "routerLabel.txt"));
        this.debugContainer.setBorder(com.sas.swing.visuals.util.Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "debugContainer.title.txt"), (int)7, (int)5, (int)5, (int)5));
        this.designTimeActive.setText(RB.getStringResource(RB_KEY, "designTimeActive.txt"));
        this.traceProxyClient.setText(RB.getStringResource(RB_KEY, "traceProxyClient.txt"));
        this.useProfiler.setText(RB.getStringResource(RB_KEY, "useProfiler.txt"));
        this.useLogTrap.setText(RB.getStringResource(RB_KEY, "useLogTrap.txt"));
        this.allowCustomize.setText(RB.getStringResource(RB_KEY, "allowCustomize.txt"));
        this.ignoreTimeout.setText(RB.getStringResource(RB_KEY, "ignoreTimeout.txt"));
    }

    protected void layoutComponents() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout((LayoutManager)new AutoSizingGridLayout(0, 1, 0, 5, true, false, true));
        AutoSizingGridLayout parameterLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        AutoSizingGridLayout routerLayout = new AutoSizingGridLayout(1, 2, 5, 0, true, true, true);
        parameterLayout.setInterlockedColumnContainers(new Container[]{this.parameterContainer, this.routerContainer});
        routerLayout.setInterlockedColumnContainers(new Container[]{this.parameterContainer, this.routerContainer});
        this.parameterContainer.setLayout((LayoutManager)parameterLayout);
        this.parameterContainer.add(this.parameterKeyLabel);
        this.parameterContainer.add(this.parameterKeyField);
        this.routerContainer.setLayout((LayoutManager)routerLayout);
        this.routerContainer.add(this.routerLabel);
        this.routerContainer.add(this.routerField);
        this.debugContainer.setLayout((LayoutManager)new AutoSizingGridLayout(0, 1, 0, 5, true, true, true));
        this.debugContainer.add(this.designTimeActive);
        this.debugContainer.add(this.traceProxyClient);
        this.debugContainer.add(this.useProfiler);
        this.debugContainer.add(this.useLogTrap);
        this.debugContainer.add(this.allowCustomize);
        this.debugContainer.add(this.ignoreTimeout);
        this.add(this.useRuntimeParams);
        this.add(this.parameterContainer);
        this.add(this.useTunneling);
        this.add(this.routerContainer);
        this.add(this.debugContainer);
    }

    protected void addListeners() {
        this.useRuntimeParams.addItemListener(this);
        this.useTunneling.addItemListener(this);
        this.designTimeActive.addItemListener(this);
        this.traceProxyClient.addItemListener(this);
        this.useProfiler.addItemListener(this);
        this.useLogTrap.addItemListener(this);
        this.allowCustomize.addItemListener(this);
        this.ignoreTimeout.addItemListener(this);
        this.parameterKeyField.getDocument().addDocumentListener(this);
        this.routerField.getDocument().addDocumentListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.codeEvent) {
            return;
        }
        Object eSource = e.getSource();
        if (eSource == this.useRuntimeParams) {
            boolean selected = this.useRuntimeParams.isSelected();
            Util.setEnabledOnContainer(this.parameterContainer, selected);
            this.connection.setUseRuntimeParams(selected);
        } else if (eSource == this.useTunneling) {
            boolean selected = this.useTunneling.isSelected();
            Util.setEnabledOnContainer(this.routerContainer, selected);
            this.connection.setUseRouter(selected);
        } else if (eSource == this.designTimeActive) {
            this.connection.setDesignTimeActive(this.designTimeActive.isSelected());
        } else if (eSource == this.traceProxyClient) {
            this.connection.setTraceProxyClient(this.traceProxyClient.isSelected());
        } else if (eSource == this.useProfiler) {
            this.connection.setProfiler(this.useProfiler.isSelected());
        } else if (eSource == this.useLogTrap) {
            this.connection.setLogTrap(this.useLogTrap.isSelected());
        } else if (eSource == this.allowCustomize) {
            this.connection.setAllowCustomize(this.allowCustomize.isSelected());
        } else if (eSource == this.ignoreTimeout) {
            this.connection.setIgnoreTimeout(this.ignoreTimeout.isSelected());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        if (this.codeEvent) {
            return;
        }
        Document eSource = event.getDocument();
        if (eSource == this.parameterKeyField.getDocument()) {
            this.connection.setRuntimeParamKeyPrefix(this.parameterKeyField.getText());
        } else if (eSource == this.routerField.getDocument()) {
            this.connection.setRouterURL(this.routerField.getText());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    @Override
    public void setObject(Object bean) {
        super.setObject(bean);
        if (bean instanceof Connection) {
            try {
                this.codeEvent = true;
                this.connection = (Connection)bean;
                this.designTimeActive.setSelected(this.connection.isDesignTimeActive());
                this.useLogTrap.setSelected(this.connection.isLogTrap());
                this.allowCustomize.setSelected(this.connection.getAllowCustomize());
                this.traceProxyClient.setSelected(this.connection.isTraceProxyClient());
                this.useProfiler.setSelected(this.connection.isProfiler());
                this.ignoreTimeout.setSelected(this.connection.isIgnoreTimeout());
                this.useTunneling.setSelected(this.connection.getUseRouter());
                Util.setEnabledOnContainer(this.routerContainer, this.useTunneling.isSelected());
                this.routerField.setText(this.connection.getRouterURL());
                this.useRuntimeParams.setSelected(this.connection.getUseRuntimeParams());
                Util.setEnabledOnContainer(this.parameterContainer, this.useRuntimeParams.isSelected());
                this.parameterKeyField.setText(this.connection.getRuntimeParamKeyPrefix());
            }
            finally {
                this.codeEvent = false;
            }
        } else {
            Message exceptionMessage = new Message(com.sas.util.Util.getCommonResources(), "Customizer.setObject.ex.txt", (Object)"ConnectionCustomizerAdvancedPanel", (Object)"com.sas.rmi.Connection");
            throw new ComponentException(exceptionMessage.toString());
        }
    }
}

