/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.awt.util.Util;
import com.sas.beans.CustomizerClosingInterface;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.graphics.IDEDnDManager;
import com.sas.idesupport.IDEData;
import com.sas.rmi.Connection;
import com.sas.rmi.ConnectionEditView;
import com.sas.rmi.ConnectionSaveAsDialog;
import com.sas.rmi.PersistedConnectionList;
import com.sas.rmi.RB;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ConnectionCustomizer
extends JPanel
implements Customizer,
ItemListener,
ActionListener,
CustomizerClosingInterface,
PropertyChangeListener {
    public static final String RB_KEY = "ConnectionCustomizer.";
    public static final String GLOBAL = "Global - ";
    boolean codeEvent;
    boolean externalPropertyList;
    boolean persistedConnectionsChanged;
    Connection connection;
    Properties customProps;
    ConnectionEditView editView;
    JComboBox connectionName;
    DefaultComboBoxModel connectionNameList;
    JPanel connectionNamePanel;
    ConnectionSaveAsDialog saveAsDialog;
    JButton saveAsBtn;
    PersistedConnectionList persistedConnections;
    OrderedCollectionInterface reservedNamesList;
    String currentConnectionName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.saveAsBtn) {
            if (this.saveAsDialog == null) {
                Frame parentFrame = Util.getParentFrame(this);
                this.saveAsDialog = parentFrame != null ? new ConnectionSaveAsDialog(parentFrame) : new ConnectionSaveAsDialog(new Frame());
                this.saveAsDialog.setExistingList(this.persistedConnections);
                this.saveAsDialog.setReservedNamesList(this.reservedNamesList);
                this.saveAsDialog.pack();
            }
            String origPersistedName = this.connection.getPersistedName();
            this.saveAsDialog.setPersistedName(origPersistedName);
            Util.centerOverWindow(this.saveAsDialog, this);
            Frame parentFrame = Util.getParentFrame(this.saveAsDialog);
            IDEDnDManager.suspend(parentFrame);
            this.saveAsDialog.setVisible(true);
            IDEDnDManager.resume(parentFrame);
            String name = this.saveAsDialog.getPersistedName();
            if (name != null) {
                int index = 0;
                if (this.persistedConnections.containsKey(name)) {
                    Properties props = (Properties)this.persistedConnections.get(name);
                    this.connection.setPersistedName(name);
                    index = this.persistedConnections.getIndex(props, 0) + 1;
                    props.clear();
                    this.persistedConnections.copyProperties(this.connection.getProperties(), props);
                } else {
                    index = this.persistedConnections.count();
                    this.connection.setPersistedName(name);
                    Properties newProps = new Properties();
                    this.persistedConnections.copyProperties(this.connection.getProperties(), newProps);
                    this.persistedConnections.add(index, name, newProps);
                    try {
                        this.codeEvent = true;
                        this.connectionNameList.addElement(name);
                    }
                    finally {
                        this.codeEvent = false;
                    }
                    index = this.connectionNameList.getSize() - 1;
                }
                this.persistedConnectionsChanged = true;
                this.selectConnectionNameIndex(index);
                this.currentConnectionName = this.connectionName.getSelectedItem().toString();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (this.codeEvent) {
            return;
        }
        if (evt.getSource() == this.connectionName && evt.getStateChange() == 1) {
            int index = this.connectionName.getSelectedIndex();
            this.connection.removePropertyChangeListener(this);
            this.editView.customizerClosing();
            Connection conn = new Connection();
            if (index > 0) {
                if (this.connection.getPersistedName() == Connection.PERSISTEDNAME_DEFAULT) {
                    this.customProps = (Properties)this.connection.getProperties().clone();
                }
                String name = (String)this.connectionNameList.getElementAt(index);
                this.persistedConnections.updateConnectionProperties(conn, name);
                Properties connProps = this.connection.getProperties();
                connProps.clear();
                this.persistedConnections.copyProperties(conn.getProperties(), connProps);
                this.currentConnectionName = this.connection.getPersistedName();
            } else {
                if (this.currentConnectionName != null && this.currentConnectionName.equals(Connection.PERSISTEDNAME_DEFAULT)) {
                    return;
                }
                this.currentConnectionName = Connection.PERSISTEDNAME_DEFAULT;
                if (this.customProps == null) {
                    this.customProps = conn.getProperties();
                }
                Properties connProps = this.connection.getProperties();
                connProps.clear();
                this.persistedConnections.copyProperties(this.customProps, connProps);
            }
            this.editView.setObject(this.connection);
            this.connection.addPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object eSource = e.getSource();
        String propName = e.getPropertyName();
        if (eSource == this.connection && com.sas.util.Util.unequal((Object)propName, (Object)"persistedName")) {
            this.selectConnectionNameIndex(0);
            this.connection.setPersistedName(Connection.PERSISTEDNAME_DEFAULT);
            this.currentConnectionName = Connection.PERSISTEDNAME_DEFAULT;
        }
    }

    public ConnectionCustomizer() {
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.externalPropertyList = true;
        this.persistedConnectionsChanged = false;
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout((LayoutManager)new AutoSizingGridLayout(2, 1, 0, 10, true, true, true));
        this.connectionNamePanel = new JPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 2, 5, 0, true, true, true);
        layout.setRemainderColumn(2);
        JLabel connNameLabel = new JLabel();
        this.editView = new ConnectionEditView();
        this.connectionName = new JComboBox();
        this.connectionNameList = new DefaultComboBoxModel();
        this.saveAsBtn = new JButton();
        this.connectionNamePanel.setLayout((LayoutManager)layout);
        connNameLabel.setText(RB.getStringResource(RB_KEY, "connNameLabel.txt"));
        this.saveAsBtn.setText(RB.getStringResource(RB_KEY, "saveAsBtn.txt"));
        this.saveAsBtn.setDefaultCapable(false);
        connNameLabel.setLabelFor(this.connectionName);
        this.connectionNameList.addElement(Connection.PERSISTEDNAME_DEFAULT);
        this.connectionName.setModel(this.connectionNameList);
        this.connectionName.addItemListener(this);
        this.saveAsBtn.addActionListener(this);
        this.connectionNamePanel.add(connNameLabel);
        this.connectionNamePanel.add(this.connectionName);
        this.connectionNamePanel.add(this.saveAsBtn);
        this.add(this.connectionNamePanel);
        this.add(this.editView);
    }

    protected void createPropertyList() {
        this.persistedConnections = new PersistedConnectionList();
        this.persistedConnections.initialize();
        this.loadProperties();
        this.setPropertyList(this.persistedConnections);
        this.externalPropertyList = false;
    }

    protected void loadProperties() {
        try {
            String localFilePath = IDEData.getConnectionsFile();
            if (localFilePath == null) {
                localFilePath = "./LocalConnections.txt";
            }
            boolean loadProps = false;
            try {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkRead(localFilePath);
                }
                loadProps = true;
            }
            catch (SecurityException se) {
                loadProps = false;
            }
            if (loadProps) {
                this.persistedConnections.setFilePathName(localFilePath);
                this.persistedConnections.loadProperties();
            }
            this.saveAsBtn.setEnabled(loadProps);
        }
        catch (IOException e) {
            Message exceptionMessage = new Message(RB.getResources(), "ConnectionCustomizer.loadConnection.ex.txt", (Object)e.toString());
            System.out.println(exceptionMessage.toString());
        }
    }

    protected void saveProperties() {
        try {
            boolean isSaved = this.persistedConnections.saveProperties();
            if (!isSaved) {
                Message errorMessage = new Message(RB.getResources(), "ConnectionListPanel.writeConflictDialog.errorMessage.txt", (Object)this.persistedConnections.getFilePathName());
                JOptionPane.showMessageDialog(null, errorMessage.toString(), RB.getStringResource("ConnectionListPanel.", "writeConflictDialog.title.txt"), 0);
            }
        }
        catch (IOException e) {
            Message exceptionMessage = new Message(RB.getResources(), "ConnectionCustomizer.saveConnection.ex.txt", (Object)e.toString());
            System.out.println(exceptionMessage.toString());
        }
    }

    protected void selectConnectionNameIndex(int index) {
        try {
            this.codeEvent = true;
            this.connectionName.setSelectedIndex(index);
        }
        finally {
            this.codeEvent = false;
        }
    }

    private void printContents() {
        System.out.println(" propertyList contents:  ");
        for (int i = 0; i < this.persistedConnections.count(); ++i) {
            System.out.println(i + " key   = " + this.persistedConnections.getKey(i));
            System.out.println(i + " value = " + System.identityHashCode(this.persistedConnections.get(i)));
            System.out.println(i + "    persistedName = " + ((Properties)this.persistedConnections.get(i)).get(Connection.PERSISTEDNAME));
        }
        System.out.println(" ");
    }

    public void setPropertyList(PersistedConnectionList propList) {
        this.persistedConnections = propList;
        if (propList != null) {
            try {
                this.codeEvent = true;
                this.connectionNameList.removeAllElements();
                this.connectionNameList.addElement(Connection.PERSISTEDNAME_DEFAULT);
                Enumeration enumer = this.persistedConnections.getKeys();
                while (enumer != null && enumer.hasMoreElements()) {
                    this.connectionNameList.addElement(enumer.nextElement());
                }
            }
            finally {
                this.codeEvent = false;
            }
            this.externalPropertyList = true;
        }
    }

    @Override
    public void setObject(Object bean) {
        if (bean instanceof Connection) {
            String name;
            this.connection = (Connection)bean;
            this.editView.setObject(bean);
            if (this.persistedConnections == null) {
                this.createPropertyList();
            }
            if (this.connection != null && !this.connection.isDesignTime() && this.persistedConnections.count() == 0) {
                this.remove(this.connectionNamePanel);
                this.validate();
            }
            this.currentConnectionName = name = this.connection.getPersistedName();
            if (this.connectionNameList.getIndexOf(name) != -1 && !name.equals(Connection.PERSISTEDNAME_DEFAULT)) {
                Connection compareConn = new Connection();
                Properties newProps = compareConn.getProperties();
                Properties persistedProps = (Properties)this.persistedConnections.get(name);
                newProps.putAll((Map<?, ?>)persistedProps);
                Connection tmpConn = new Connection();
                this.connection.copy(tmpConn);
                int index = 0;
                if (tmpConn.equals(compareConn)) {
                    index = this.connectionNameList.getIndexOf(name);
                } else {
                    this.connection.setPersistedName(Connection.PERSISTEDNAME_DEFAULT);
                    this.customProps = this.connection.getProperties();
                    this.currentConnectionName = Connection.PERSISTEDNAME_DEFAULT;
                }
                this.selectConnectionNameIndex(index);
            } else {
                this.selectConnectionNameIndex(0);
                this.customProps = this.connection.getProperties();
            }
            this.connection.addPropertyChangeListener(this);
        }
    }

    public void customizerClosing() {
        this.editView.customizerClosing();
        this.connection.removePropertyChangeListener(this);
        if (this.connectionName.getSelectedIndex() == 0) {
            this.connection.setPersistedName(Connection.PERSISTEDNAME_DEFAULT);
        }
        if (!this.externalPropertyList && this.persistedConnectionsChanged) {
            try {
                this.codeEvent = true;
                this.connectionNameList.removeAllElements();
                this.saveProperties();
            }
            finally {
                this.codeEvent = false;
            }
        }
    }
}

