/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorOptions;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.CodeGeneratorTarget;
import com.sas.rmi.ProxyName;
import com.sas.rmi.RocfClass;
import com.sas.rmi.TargetMethod;
import com.sas.rmi.Template;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class CodeGeneratorBaseTarget
implements CodeGeneratorTarget {
    CodeGeneratorOptions m_options;
    Hashtable m_overload = null;
    String serverMethodPrefix = "_Remote_";
    boolean m_generateTrueRemote = false;
    CodeGenerator m_generator;
    static final int SCLClassInfoMethodMap_KEY = 0;
    static final int SCLClassInfoMethodMap_J2 = 1;
    static final int SCLClassInfoMethodMap_IOM = 2;
    static final int SCLClassInfoMethodMap_COUNT = 3;

    @Override
    public String getGeneratorName() {
        return "";
    }

    @Override
    public Template getTemplate() {
        return null;
    }

    @Override
    public String getTargetName(String sourceName) {
        return null;
    }

    @Override
    public String getSubPackage() {
        return "";
    }

    @Override
    public String getFileExtension() {
        return ".java";
    }

    @Override
    public void generateAttributes(Class source, CodeGeneratorOutputStream out) throws Exception {
    }

    @Override
    public void generateConstructorCode(Class source, Constructor constructor, CodeGeneratorOutputStream out) throws Exception {
    }

    @Override
    public void generateConstructorCode(Class source, String className, CodeGeneratorOutputStream out) throws Exception {
    }

    @Override
    public void generateMethodCode(Class source, Method method, CodeGeneratorOutputStream out) throws Exception {
        this.generateMethodCode(source, method, method.getName(), out);
    }

    @Override
    public void generateMethodCode(Class source, Method method, String methodName, CodeGeneratorOutputStream out) throws Exception {
    }

    @Override
    public boolean generateFromInterface() {
        return true;
    }

    @Override
    public boolean implementationMustExist() {
        return false;
    }

    @Override
    public boolean generatesServerCode() {
        return false;
    }

    @Override
    public boolean generatesInterfaceCode() {
        return false;
    }

    @Override
    public boolean generateTagCode(Class source, String tag, CodeGeneratorOutputStream out) throws Exception {
        return false;
    }

    @Override
    public boolean definedInTemplate(Method method) {
        return false;
    }

    @Override
    public boolean supportsLocalImplementation() {
        return true;
    }

    @Override
    public void setOptions(CodeGeneratorOptions value) {
        this.m_options = value;
    }

    public String getArg(String s) {
        String value = null;
        if (this.m_options != null) {
            value = this.m_options.getArg(s);
        }
        return value;
    }

    protected String convertName(String name) {
        String lReplace;
        String uReplace;
        if (name.startsWith("_") && (uReplace = this.m_options.getArg("-u")) != null) {
            name = uReplace + name.substring(1);
        }
        if ((lReplace = this.m_options.getArg("-l")) != null) {
            Integer iObject;
            if (this.m_overload == null) {
                this.m_overload = new Hashtable();
            }
            if ((iObject = (Integer)this.m_overload.get(name)) != null) {
                int i = iObject;
                this.m_overload.remove(name);
                this.m_overload.put(name, new Integer(++i));
                name = this.overloadName(name, lReplace, i);
            } else {
                this.m_overload.put(name, new Integer(0));
            }
        }
        return name;
    }

    protected String overloadName(String name, String s, int number) {
        String newName = name;
        int index = s.indexOf("%");
        int places = 0;
        if (index >= 0) {
            try {
                places = Integer.parseInt(s.substring(index + 1, index + 2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (places > 0) {
            String p = "" + number;
            for (int i = p.length(); i < places; ++i) {
                p = "0" + p;
            }
            newName = name + s.substring(0, index) + p;
        }
        return newName;
    }

    @Override
    public void generateLocal(Class source, Method method, CodeGeneratorOutputStream out) throws Exception {
        if (!this.generatesServerCode()) {
            if (this.definedInTemplate(method)) {
                return;
            }
            String name = source.getName();
            int pos = name.lastIndexOf(".");
            String ClassName = "";
            ClassName = pos < 0 ? name : name.substring(pos + 1);
            if (ClassName.endsWith("Interface")) {
                ClassName = ClassName.substring(0, ClassName.length() - 9);
            }
            TargetMethod tm = new TargetMethod();
            tm.generateMethodCodeHeader(source, method, out, false);
            Class<?> rt = method.getReturnType();
            String ret = CodeGenerator.convertType(rt.getName());
            Class<?>[] params = method.getParameterTypes();
            String methodCall = "";
            out.println(ClassName + "Delegate _lmh = (" + ClassName + "Delegate)_getDelegate();", 2);
            if (!ret.equals("void")) {
                out.println(ret + " _ret;", 2);
                methodCall = "_ret = ";
            }
            methodCall = methodCall + "_lmh." + method.getName() + "(";
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    methodCall = methodCall + ", ";
                }
                methodCall = methodCall + "p" + (i + 1);
            }
            methodCall = methodCall + ");";
            out.println(methodCall, 2);
            if (!ret.equals("void")) {
                out.println("return _ret;", 2);
            }
            out.println("}", 1);
            this.generateMethodCode(source, method, this.serverMethodPrefix + method.getName(), out);
        } else {
            this.generateMethodCode(source, method, out);
        }
    }

    public CodeGenerator getGenerator() {
        return this.m_generator;
    }

    @Override
    public void setGenerator(CodeGenerator cg) {
        this.m_generator = cg;
    }

    protected String[][] get2dStringArrayField(Class c, String fieldName) {
        try {
            Field field = null;
            try {
                field = c.getDeclaredField(fieldName);
            }
            catch (Exception e) {
                field = c.getField(fieldName);
            }
            String[][] values = (String[][])field.get(null);
            return values;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return new String[0][];
    }

    protected String[][] getAttributeInfo(Class interfaceClass) {
        String[][] attributeInfo = this.get2dStringArrayField(interfaceClass, "attributes");
        return attributeInfo;
    }

    public String[] getAttributeInfo(Class interfaceClass, String methodName) {
        String[] attrInfo = null;
        StringBuffer attributeNameBuffer = new StringBuffer(methodName.substring(3));
        attributeNameBuffer.setCharAt(0, Character.toLowerCase(attributeNameBuffer.charAt(0)));
        try {
            Class infoClass = RocfClass.forName(ProxyName.getSCLClassInfoName(interfaceClass.getName()));
            String[][] attributeInfo = this.getAttributeInfo(infoClass);
            String attributeName = attributeNameBuffer.toString();
            for (int i = 0; i < attributeInfo.length; ++i) {
                if (!attributeName.equalsIgnoreCase(attributeInfo[i][1])) continue;
                attrInfo = attributeInfo[i];
                break;
            }
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("NOTE: Unable to read SCLClassInfo for " + interfaceClass.getName());
        }
        catch (IllegalArgumentException iae) {
            System.out.println("NOTE: Unable to read SCLClassInfo for " + interfaceClass.getName());
        }
        return attrInfo;
    }

    public String[] getMethodInfo(Class interfaceClass, String methodName) {
        String[] methInfo = null;
        try {
            Class infoClass = RocfClass.forName(ProxyName.getSCLClassInfoName(interfaceClass.getName()));
            String[][] methodInfo = this.get2dStringArrayField(infoClass, "methods");
            String[] finalMethodInfo = null;
            for (int i = 0; i < methodInfo.length; ++i) {
                int key;
                if (methodInfo[i].length < 3) {
                    finalMethodInfo = new String[]{methodInfo[i][0], methodInfo[i][1], methodInfo[i][0]};
                    key = 0;
                } else {
                    finalMethodInfo = methodInfo[i];
                    key = 0;
                }
                if (!methodName.equalsIgnoreCase(finalMethodInfo[key])) continue;
                methInfo = finalMethodInfo;
                break;
            }
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("NOTE: Unable to read SCLClassInfo for " + interfaceClass.getName());
        }
        catch (IllegalArgumentException iae) {
            System.out.println("NOTE: Unable to read SCLClassInfo for " + interfaceClass.getName());
        }
        return methInfo;
    }
}

