/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGeneratorOptions;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.CodeGeneratorTarget;
import com.sas.rmi.Connection;
import com.sas.rmi.ProxyName;
import com.sas.rmi.RocfClass;
import com.sas.rmi.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CodeGenerator {
    private boolean m_overrideDelegateInterface;
    Class _delClass = null;
    boolean alreadyLookedUp = false;
    protected Class mSource;
    protected String mClassName;
    protected String mPackageName;
    protected CodeGeneratorTarget mTarget;
    protected String mTargetName;
    protected String mTargetFileName;
    protected FileOutputStream mTargetFile = null;
    protected CodeGeneratorOptions mOptions;
    protected Template mTemplate;
    protected int mIfLevel = 0;
    protected boolean[] bWrite = new boolean[40];
    protected int nExclude = 0;
    protected String[] mExclude = new String[40];
    protected CodeGeneratorOutputStream mOut;
    protected boolean mIsInterface = false;
    protected String mLocalSuffix = "Implementation";
    protected boolean mHasLocal = false;
    protected Class mInterface = null;
    protected Hashtable m_generatedMethods;
    protected Hashtable m_definedFields;
    protected boolean m_isProxySubclass = false;
    protected Class m_proxySubclass;
    protected Vector m_innerMethods;
    protected boolean m_generateTrueRemote = false;
    protected boolean mProxyInterfaceExists = false;
    protected boolean mExistsIOMDtype = false;

    public CodeGenerator(Class sourceClass, CodeGeneratorTarget target, CodeGeneratorOptions options) {
        this.mSource = sourceClass;
        this.mTarget = target;
        this.mOptions = options;
        this.mTarget.setOptions(options);
        this.mTarget.setGenerator(this);
        this.m_generatedMethods = new Hashtable();
        this.m_innerMethods = new Vector();
        this.m_overrideDelegateInterface = false;
    }

    public boolean generate() {
        boolean didFail = false;
        if (this.mTarget == null) {
            this.sendToOutput("CodeGenerator constructed improperly!");
            this.sendToOutput("Target cannot be null (type CodeGeneratorTarget");
            didFail = true;
        }
        if (!didFail) {
            didFail = this.validateSource();
        }
        if (!didFail) {
            this.setNames();
        }
        try {
            ProxyName pn = new ProxyName();
            pn.setClassName(this.mClassName);
            pn.setPackage(this.mPackageName);
            Class c = RocfClass.forName(pn.getFullProxyInterfaceClassName());
            this.mProxyInterfaceExists = true;
        }
        catch (ClassNotFoundException pn) {
            // empty catch block
        }
        if (!didFail) {
            didFail = this.createTarget();
        }
        if (!didFail) {
            this.mTemplate = this.mTarget.getTemplate();
            if (this.mTemplate == null) {
                this.sendToOutput("Invalid template");
                didFail = true;
            }
        }
        if (!didFail) {
            this.mOut = new CodeGeneratorOutputStream(this.mTargetFile);
            try {
                didFail = this.processTemplate();
            }
            catch (Exception ex) {
                this.sendToOutput("Generation failed: " + ex.getMessage());
                didFail = true;
            }
        }
        this.cleanup();
        return didFail;
    }

    public String getTargetFileName() {
        try {
            if (this.validateSource()) {
                this.sendToOutput("CodeGenerator : validate source failed: ");
                return null;
            }
            this.setNames();
            this.mTargetName = this.mTarget.getTargetName(this.mClassName);
            String prefix = "";
            if (this.mOptions.getDirectory() != null) {
                prefix = this.getFilePrefix();
            }
            this.mTargetFileName = prefix + this.mTargetName + this.mTarget.getFileExtension();
            return this.mTargetFileName;
        }
        catch (Exception ex) {
            this.sendToOutput("Get target file name failed: " + ex.getMessage());
            return null;
        }
    }

    protected boolean processTemplate() throws Exception {
        boolean didFail = false;
        String[] template = this.mTemplate.getTemplate();
        int line = 0;
        String separator = "%";
        if (this.mInterface != null) {
            this.mHasLocal = this.implementsInterface(this.mInterface, "com.sas.rmi.LocalModelInterface");
            if (!this.mHasLocal) {
                this.mHasLocal = this.implementsInterface(this.mSource, "com.sas.rmi.LocalModelInterface");
            }
        }
        this.mHasLocal = true;
        this.m_definedFields = this.loadDefinedFields(this.mInterface);
        this.mIfLevel = 0;
        this.bWrite[0] = true;
        this.mExclude[this.nExclude++] = "java.lang.Object";
        ProxyName pn = new ProxyName();
        String corbaInterfaceName = pn.getCORBAInterfaceName(this.mSource, this.mOptions);
        try {
            RocfClass.forName(corbaInterfaceName);
            this.mExistsIOMDtype = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_overrideDelegateInterface = this.mOptions.existsArg("-ruleodi");
        while (line < template.length && !didFail) {
            String trimLine = template[line].trim();
            if (!trimLine.startsWith("#")) {
                int startPos = template[line].indexOf(separator);
                while (startPos >= 0) {
                    int endPos = template[line].indexOf(separator, startPos + 1);
                    if (endPos >= 0) {
                        if (startPos > 0) {
                            this.print(template[line].substring(0, startPos));
                        }
                        String tag = template[line].substring(startPos + 1, endPos);
                        didFail = this.processTag(tag);
                        if (endPos + 1 < template[line].length()) {
                            template[line] = template[line].substring(endPos + 1);
                            startPos = template[line].indexOf(separator);
                            continue;
                        }
                        startPos = -1;
                        template[line] = "";
                        continue;
                    }
                    startPos = -1;
                }
                this.println(template[line]);
            }
            ++line;
        }
        if (!didFail) {
            this.displayWarnings();
        }
        return didFail;
    }

    protected boolean processTag(String tag) throws Exception {
        boolean failed = false;
        String uTag = tag.toUpperCase();
        if (tag.equalsIgnoreCase("NAME")) {
            this.print(this.mClassName);
        } else if (tag.equalsIgnoreCase("PROXYNAME")) {
            this.print(this.mTargetName);
        } else if (tag.equalsIgnoreCase("IOMDTYPE")) {
            ProxyName pn = new ProxyName();
            this.print(pn.getCORBAInterfaceName(this.mSource, this.mOptions));
        } else if (!tag.equalsIgnoreCase("OVERRIDE_DELEGATE_INTERFACE")) {
            if (tag.equalsIgnoreCase("ALLOW_PROXY_SUBCLASS")) {
                this.m_isProxySubclass = this.isProxySubclass(this.mSource);
                if (this.m_isProxySubclass) {
                    System.out.println("NOTE: Class extends proxy " + this.m_proxySubclass.getName());
                }
            } else if (tag.equalsIgnoreCase("PROXY_SUBCLASS")) {
                if (this.m_proxySubclass != null) {
                    this.print(this.m_proxySubclass.getName());
                }
            } else if (tag.equalsIgnoreCase("PROXY_INTERFACE")) {
                ProxyName pn = new ProxyName();
                pn.setClassName(this.mClassName);
                this.print(pn.getProxyInterfaceClassName());
            } else if (tag.equalsIgnoreCase("DELEGATE_CLASS")) {
                Class c = this._getDelegateClass();
                if (c == null) {
                    this.print("null");
                } else {
                    this.print(c.getName() + ".class");
                }
            } else if (tag.equalsIgnoreCase("PROXYINTERFACE")) {
                ProxyName pn = new ProxyName();
                pn.setAccessMethod(Connection.RMI);
                pn.setClassName(this.mClassName);
                String s = pn.getInterfaceProxyName();
                if (this.mPackageName != null) {
                    s = this.mPackageName + "." + s;
                }
                this.print(s);
            } else if (tag.equalsIgnoreCase("CATALOG")) {
                String catalog = this.getAttribute(this.mInterface, "ContextClassPath");
                if (catalog == null) {
                    catalog = this.getAttribute(this.mInterface, "m_ContextClassPath");
                }
                if (catalog == null) {
                    catalog = "";
                }
                this.print(catalog);
            } else if (tag.equalsIgnoreCase("FULLNAME")) {
                String name = "";
                if (this.mPackageName != null) {
                    name = this.mPackageName + ".";
                }
                name = name + this.mClassName;
                this.print(name);
            } else if (tag.equalsIgnoreCase("REUSESINGLEDELEGATE")) {
                boolean b = this.getBooleanAttribute(this.mInterface, "reuseSingleDelegate");
                this.print("" + b);
            } else if (tag.equalsIgnoreCase("PACKAGE")) {
                if (this.mPackageName != null) {
                    this.print("package " + this.mPackageName + ";");
                }
            } else if (tag.equalsIgnoreCase("PACKAGENAME")) {
                if (this.mPackageName != null) {
                    this.print(this.mPackageName);
                }
            } else if (tag.equalsIgnoreCase("PACKAGEPREFIX")) {
                String name = "";
                if (this.mPackageName != null) {
                    name = this.mPackageName + ".";
                }
                this.print(name);
            } else if (tag.equalsIgnoreCase("VERSION")) {
                this.print("12");
            } else if (tag.equalsIgnoreCase("TIMESTAMP")) {
                this.print(new Date().toString());
            } else if (tag.equalsIgnoreCase("INTERFACE")) {
                this.createInterfaceNames(false, false);
            } else if (tag.equalsIgnoreCase("INTERFACE,")) {
                this.createInterfaceNames(true, false);
            } else if (tag.equalsIgnoreCase("EXTENDSINTERFACES")) {
                this.createInterfaceNames(false, true);
            } else if (tag.equalsIgnoreCase("METHODS")) {
                failed = this.createMethods();
            } else if (tag.equalsIgnoreCase("ATTRIBUTES")) {
                failed = this.createAttributes();
            } else if (uTag.startsWith("IF")) {
                ++this.mIfLevel;
                this.bWrite[this.mIfLevel] = this.ifMacro(tag.substring(2));
            } else if (uTag.startsWith("EXCLUDE ")) {
                String intf = tag.substring(8).trim();
                this.sendToOutput("Unconditionally excluding " + intf);
                this.mExclude[this.nExclude] = intf;
                ++this.nExclude;
            } else if (tag.equalsIgnoreCase("ENDIF")) {
                if (this.mIfLevel > 0) {
                    --this.mIfLevel;
                } else {
                    this.sendToOutput("Unmatched %ENDIF%");
                    failed = true;
                }
            } else {
                boolean validTag = this.mTarget.generateTagCode(this.mSource, tag, this.mOut);
                if (!validTag) {
                    this.print(" <<Unknown tag " + tag + ">> ");
                    failed = true;
                }
            }
        }
        return failed;
    }

    protected boolean ifMacro(String macro) {
        boolean rc = false;
        boolean Not = false;
        String org = macro;
        String uMacro = (macro = macro.trim()).toUpperCase();
        if (uMacro.startsWith("NOT")) {
            Not = true;
            macro = macro.substring(3).trim();
        } else if (uMacro.startsWith("!")) {
            Not = true;
            macro = macro.substring(1).trim();
        }
        if (!macro.startsWith("(")) {
            this.sendToOutput("Malformed %IF macro: " + org);
            return false;
        }
        uMacro = (macro = macro.substring(1).trim()).toUpperCase();
        if (uMacro.startsWith("INTERFACE")) {
            if (!(macro = macro.substring(9).trim()).startsWith("(")) {
                this.sendToOutput("Malformed INTERFACE directive: " + org);
                return false;
            }
            int index = (macro = macro.substring(1).trim()).indexOf(")");
            if (index == -1) {
                this.sendToOutput("Malformed INTERFACE directive: " + org);
                return false;
            }
            String intf = macro.substring(0, index).trim();
            rc = this.implementsInterface(intf);
        } else if (uMacro.startsWith("LOCALMODEL")) {
            rc = this.mHasLocal;
        } else if (uMacro.startsWith("PROXY_SUBCLASS")) {
            rc = this.m_isProxySubclass;
        } else if (uMacro.startsWith("PROXY_INTERFACE")) {
            rc = this.mProxyInterfaceExists;
        } else if (uMacro.startsWith("OVERRIDE_DELEGATE_INTERFACE")) {
            rc = this.m_overrideDelegateInterface;
        } else if (uMacro.startsWith("DELEGATE_CLASS")) {
            rc = this._getDelegateClass() != null;
        } else if (uMacro.startsWith("IOMDTYPE")) {
            rc = this.mExistsIOMDtype;
        } else {
            this.sendToOutput("Unknown %IF directive: " + org);
            return false;
        }
        if (Not && rc) {
            rc = false;
        } else if (Not && !rc) {
            rc = true;
        }
        return rc;
    }

    protected boolean implementsInterface(Class c, String intf) {
        boolean rc = false;
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (intf.equals(interfaces[i].getName())) {
                rc = true;
                break;
            }
            rc = this.implementsInterface(interfaces[i], intf);
            if (rc) break;
        }
        if (!rc && (c = c.getSuperclass()) != null) {
            rc = this.implementsInterface(c, intf);
        }
        return rc;
    }

    protected boolean implementsInterface(String intf) {
        return this.implementsInterface(this.mSource, intf);
    }

    protected boolean excludeMethod(Method m) throws Exception {
        boolean rc = false;
        String name = m.getName();
        Class<?>[] params = m.getParameterTypes();
        if (this.mTarget.definedInTemplate(m)) {
            return true;
        }
        int modifier = m.getModifiers();
        if (!Modifier.isPublic(modifier) || Modifier.isFinal(modifier) || Modifier.isStatic(modifier)) {
            this.sendToOutput("Excluding " + m.getName() + " due to modifiers");
            return true;
        }
        for (int i = 0; i < this.nExclude; ++i) {
            try {
                this.sendToOutput("Verifying " + name + " against interface " + this.mExclude[i]);
                Class c = RocfClass.forName(this.mExclude[i]);
                rc = this.methodInClass(m, c, true, false);
                if (!rc) continue;
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return rc;
    }

    protected boolean methodInProxySuperclass(Method m) throws Exception {
        return this.m_isProxySubclass && this.methodInClass(m, this.m_proxySubclass, false, false);
    }

    protected boolean methodInProxySuperclassNotInInterface(Method m) throws Exception {
        return this.methodInProxySuperclass(m) && !this.methodInClass(m, this.mSource, false, true);
    }

    protected boolean isStatic(Method m) {
        return Modifier.isStatic(m.getModifiers());
    }

    protected boolean isFinal(Method m) {
        return Modifier.isFinal(m.getModifiers());
    }

    protected boolean hasLocal(Method m) {
        boolean rc = false;
        if (!this.mTarget.supportsLocalImplementation()) {
            return false;
        }
        if (this.mHasLocal) {
            if (this.mInterface != null) {
                this.p("hasLocal:mClassname=" + this.mClassName);
                this.p("hasLocal:method=" + m.getName());
                Class delCls = this._getDelegateClass();
                boolean mic = false;
                try {
                    mic = this.methodInClass(m, delCls, true, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.p("MIC=" + mic);
                return mic;
            }
            this.sendToOutput("Expected to have " + this.mClassName + "Interface");
        }
        return rc;
    }

    protected boolean methodInClass(Method m, Class c, boolean checkTree, boolean declaredOnly) throws Exception {
        boolean inClass = false;
        int numParams = 0;
        if (c != null) {
            Class<?>[] params = m.getParameterTypes();
            String name = m.getName();
            Class<?>[] exceptions = m.getExceptionTypes();
            numParams = params.length;
            Method[] methods = declaredOnly ? c.getDeclaredMethods() : c.getMethods();
            if (methods != null) {
                for (int j = 0; j < methods.length; ++j) {
                    Class<?>[] compareExceptions;
                    if (!name.equals(methods[j].getName())) continue;
                    Class<?>[] compareParams = methods[j].getParameterTypes();
                    int numCompareParams = 0;
                    if (compareParams != null) {
                        numCompareParams = compareParams.length;
                    }
                    if (numParams != numCompareParams) continue;
                    boolean sameParams = true;
                    for (int k = 0; k < numParams; ++k) {
                        if (params[k].getName().equals(compareParams[k].getName())) continue;
                        sameParams = false;
                        break;
                    }
                    if (!sameParams || exceptions.length != (compareExceptions = methods[j].getExceptionTypes()).length) continue;
                    boolean sameExceptions = true;
                    for (int k = 0; k < exceptions.length; ++k) {
                        if (exceptions[k].getName().equals(compareExceptions[k].getName())) continue;
                        sameExceptions = false;
                        break;
                    }
                    if (!sameExceptions) continue;
                    return true;
                }
            }
            if (checkTree) {
                Class<?>[] interfaces = c.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!this.methodInClass(m, interfaces[i], checkTree, declaredOnly)) continue;
                    inClass = true;
                    break;
                }
            }
        }
        return inClass;
    }

    protected boolean createInterfaceNames(boolean comma, boolean extendsInt) {
        String baseInterface;
        boolean failed = false;
        String s = baseInterface = this.mClassName + "Interface";
        if (extendsInt) {
            s = "";
        }
        Class<?>[] interfaces = this.mSource.getInterfaces();
        try {
            for (int i = 0; i < interfaces.length; ++i) {
                String iName = this.stripPackage(interfaces[i].getName(), this.mPackageName);
                if (iName.equals(baseInterface)) continue;
                s = s.length() == 0 ? "extends " + iName : s + ", " + iName;
            }
            if (s.length() > 0) {
                if (comma) {
                    s = s + ", ";
                }
                this.print(s);
            }
        }
        catch (Exception ex) {
            failed = true;
        }
        return failed;
    }

    protected boolean createMethods() {
        boolean failed = false;
        Constructor<?>[] constructors = this.mSource.getConstructors();
        Method[] methods = this.mSource.getMethods();
        methods = this.sortDeclaredHigh(this.mSource.getName(), methods);
        int n = 0;
        if (constructors != null) {
            n = constructors.length;
        }
        try {
            for (int i = 0; i < n; ++i) {
                this.mTarget.generateConstructorCode(this.mSource, constructors[i], this.mOut);
            }
            if (n == 0) {
                this.mTarget.generateConstructorCode(this.mSource, this.mClassName, this.mOut);
            }
        }
        catch (Exception ex) {
            this.sendToOutput("Error creating constructors: " + ex.getMessage());
            failed = true;
        }
        this.m_generatedMethods.clear();
        if (!failed && methods != null) {
            boolean excludeIt = false;
            boolean inProxySuperclass = false;
            boolean generateLocal = false;
            boolean delOverProxySuper = this.mOptions.existsArg("-ruledops");
            try {
                for (int i = 0; i < methods.length; ++i) {
                    if (this.isStatic(methods[i]) || this.isFinal(methods[i]) || this.methodInProxySuperclass(methods[i])) continue;
                    generateLocal = false;
                    excludeIt = this.excludeMethod(methods[i]);
                    inProxySuperclass = this.methodInProxySuperclassNotInInterface(methods[i]);
                    if (!delOverProxySuper && inProxySuperclass) {
                        excludeIt = true;
                    }
                    if (excludeIt || this.alreadyGenerated(methods[i])) continue;
                    if (this.hasLocal(methods[i])) {
                        if (!this.mTarget.generatesInterfaceCode()) {
                            if (delOverProxySuper && this.methodInClass(methods[i], this._getDelegateClass(), true, false)) {
                                generateLocal = true;
                            } else if (!inProxySuperclass) {
                                generateLocal = true;
                            }
                        }
                        if (generateLocal) {
                            this.mTarget.generateLocal(this.mSource, methods[i], this.mOut);
                            this.add(methods[i]);
                            if (this.m_generateTrueRemote && !this.mTarget.generatesServerCode()) {
                                this.m_innerMethods.addElement(methods[i]);
                            }
                        }
                    }
                    if (generateLocal) continue;
                    this.mTarget.generateMethodCode(this.mSource, methods[i], this.mOut);
                    this.add(methods[i]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.sendToOutput("Error creating methods: " + ex.getMessage());
                failed = true;
            }
        }
        if (!failed) {
            failed = this.superMethods(this.mSource);
        }
        if (!failed && this.m_innerMethods.size() > 0) {
            try {
                this.println("");
                this.println("// Inner class for server-side method calls from the delegate", 1);
                String superClassName = this.mTarget.getTargetName(this.mClassName);
                this.println("public class " + superClassName + "_Remote extends " + superClassName, 1);
                this.println("{", 1);
                this.println(superClassName + " m_proxy;", 2);
                this.println("public " + superClassName + "_Remote(" + superClassName + " proxy)", 2);
                this.println("{", 2);
                this.println("m_proxy = proxy;", 3);
                this.println("}", 2);
                for (int i = 0; i < this.m_innerMethods.size(); ++i) {
                    Method m = (Method)this.m_innerMethods.elementAt(i);
                    Class<?> rt = m.getReturnType();
                    String ret = CodeGenerator.convertType(rt.getName());
                    Class<?>[] exceptions = m.getExceptionTypes();
                    String ex = "";
                    for (int j = 0; j < exceptions.length; ++j) {
                        if (j == 0) {
                            ex = ex + " throws  ";
                        }
                        if (j > 0) {
                            ex = ex + ",";
                        }
                        ex = ex + exceptions[j].getName();
                    }
                    String s = "public " + ret + " " + m.getName() + ex + " (";
                    String p = "";
                    Class<?>[] params = m.getParameterTypes();
                    for (int j = 0; j < params.length; ++j) {
                        if (j > 0) {
                            s = s + ", ";
                            p = p + ", ";
                        }
                        p = p + "p" + (j + 1);
                        s = s + CodeGenerator.convertType(params[j].getName()) + " p" + (j + 1);
                    }
                    s = s + ")";
                    this.println(s, 2);
                    this.println("{", 2);
                    s = "";
                    if (!ret.equals("void")) {
                        s = "return ";
                    }
                    s = s + "m_proxy._Remote_" + m.getName() + "(" + p + ");";
                    this.println(s, 3);
                    this.println("}", 2);
                }
                this.println("}", 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                failed = true;
            }
        }
        return failed;
    }

    protected void add(Method m) {
        String s = this.getSignature(m);
        this.m_generatedMethods.put(s, m);
    }

    protected String getSignature(Method m) {
        String s = m.getName();
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            s = s + "," + params[i].getName();
        }
        return s;
    }

    protected boolean alreadyGenerated(Method m) {
        boolean rc = false;
        String s = this.getSignature(m);
        if (this.m_generatedMethods.get(s) != null) {
            rc = true;
        }
        return rc;
    }

    protected boolean createAttributes() {
        boolean failed = false;
        try {
            this.mTarget.generateAttributes(this.mSource, this.mOut);
        }
        catch (Exception ex) {
            this.sendToOutput("Error creating attributes: " + ex.getMessage());
            failed = true;
        }
        return failed;
    }

    protected boolean superMethods(Class c) {
        boolean didFail = false;
        Class sc = c.getSuperclass();
        this.mExclude[this.nExclude++] = c.getName();
        if (sc != null) {
            try {
                Method[] methods = sc.getDeclaredMethods();
                if (methods != null) {
                    for (int i = 0; i < methods.length; ++i) {
                        if (this.excludeMethod(methods[i]) || this.methodInProxySuperclassNotInInterface(methods[i])) continue;
                        this.mTarget.generateMethodCode(this.mSource, methods[i], this.mOut);
                    }
                }
            }
            catch (Exception ex) {
                this.sendToOutput("Error creating super methods: " + ex.getMessage());
                didFail = true;
            }
            if (!didFail) {
                didFail = this.superMethods(sc);
            }
        }
        return didFail;
    }

    protected String stripPackage(String name, String pkg) {
        String temp;
        String s = name;
        if (pkg != null && name.startsWith(pkg) && (temp = name.substring(pkg.length())).startsWith(".") && (temp = temp.substring(1)).indexOf(".") == -1) {
            s = temp;
        }
        return s;
    }

    protected boolean validateSource() {
        boolean didFail = false;
        String invalidType = null;
        this.sendToOutput("Validating source class file");
        if (this.mSource == null) {
            invalidType = "null";
        } else if (this.mSource.isArray()) {
            invalidType = "array";
        } else if (this.mSource.isInterface()) {
            this.mIsInterface = true;
        } else if (this.mSource.isPrimitive()) {
            invalidType = "primitive type";
        }
        if (invalidType != null) {
            this.sendToOutput("\nInvalid class type: " + invalidType);
            didFail = true;
        }
        return didFail;
    }

    protected void sendToOutput(String s) {
        PrintStream out;
        if (this.mOptions != null && (out = this.mOptions.getVerboseStream()) != null) {
            out.println(s);
        }
    }

    protected void setNames() {
        String name = this.mSource.getName();
        int pos = name.lastIndexOf(".");
        if (pos < 0) {
            this.mClassName = name;
            this.mPackageName = null;
        } else {
            this.mPackageName = name.substring(0, pos);
            this.mClassName = name.substring(pos + 1);
        }
        if (this.mIsInterface) {
            if (this.mClassName.endsWith("Interface")) {
                this.mClassName = this.mClassName.substring(0, this.mClassName.length() - 9);
            }
            this.mInterface = this.mSource;
        } else {
            try {
                String iName = this.mClassName + "Interface";
                if (this.mPackageName != null) {
                    iName = this.mPackageName + "." + iName;
                }
                this.mInterface = RocfClass.forName(iName);
            }
            catch (Exception ex) {
                this.mInterface = null;
            }
        }
    }

    protected boolean createTarget() {
        boolean didFail = false;
        try {
            this.mTargetName = this.mTarget.getTargetName(this.mClassName);
            String prefix = "";
            if (this.mOptions.getDirectory() != null) {
                prefix = this.getFilePrefix();
            }
            this.mTargetFileName = prefix + this.mTargetName + this.mTarget.getFileExtension();
            this.sendToOutput("Creating " + this.mTargetFileName);
            File f = new File(this.mTargetFileName);
            if (f.exists()) {
                boolean overwrite = false;
                if (this.mOptions != null) {
                    overwrite = this.mOptions.getOverwriteSource();
                }
                if (overwrite) {
                    f.delete();
                } else {
                    throw new Exception(this.mTargetFileName + " already exists");
                }
            }
            this.mTargetFile = new FileOutputStream(f);
        }
        catch (Exception ex) {
            this.sendToOutput("Unable to create target: " + ex.getMessage());
            didFail = true;
        }
        return didFail;
    }

    protected String getFilePrefix() {
        String d;
        String s = "";
        if (this.mOptions != null && (d = this.mOptions.getDirectory()) != null && !(s = s + d.trim()).endsWith("/") && !s.endsWith("\\")) {
            s = s + "/";
        }
        if (this.mPackageName != null && !(s = s + this.mPackageName.replace('.', '/')).endsWith("/") && !s.endsWith("\\")) {
            s = s + "/";
        }
        return s;
    }

    protected void cleanup() {
        try {
            this.sendToOutput("Closing files");
            if (this.mTargetFile != null) {
                this.mTargetFile.close();
            }
        }
        catch (Exception ex) {
            this.mTargetFile = null;
        }
    }

    protected void println(String line, int indent) throws Exception {
        if (this.shouldWrite(this.mIfLevel)) {
            this.mOut.println(line, indent);
        }
    }

    protected void println(String line) throws Exception {
        if (this.shouldWrite(this.mIfLevel)) {
            this.mOut.println(line, 0);
        }
    }

    protected void print(String line) throws Exception {
        if (this.shouldWrite(this.mIfLevel)) {
            this.mOut.print(line);
        }
    }

    protected boolean shouldWrite(int level) {
        boolean rc = true;
        for (int i = 0; i <= level; ++i) {
            if (this.bWrite[i]) continue;
            rc = false;
            break;
        }
        return rc;
    }

    public static String convertType(String descriptor) {
        String s = descriptor;
        String a = "";
        while (descriptor.startsWith("[")) {
            a = a + "[]";
            descriptor = descriptor.substring(1);
        }
        if (a.length() > 0) {
            char field = descriptor.charAt(0);
            descriptor = descriptor.substring(1);
            switch (field) {
                case 'B': {
                    s = "byte";
                    break;
                }
                case 'C': {
                    s = "char";
                    break;
                }
                case 'D': {
                    s = "double";
                    break;
                }
                case 'F': {
                    s = "float";
                    break;
                }
                case 'I': {
                    s = "int";
                    break;
                }
                case 'J': {
                    s = "long";
                    break;
                }
                case 'L': {
                    s = descriptor.substring(0, descriptor.length() - 1);
                    break;
                }
                case 'S': {
                    s = "short";
                    break;
                }
                case 'Z': {
                    s = "boolean";
                    break;
                }
                default: {
                    s = descriptor;
                }
            }
            s = s + a;
        }
        return s;
    }

    public static boolean isSuperClass(Class c, String superName) {
        boolean isSuper = false;
        Class superClass = c.getSuperclass();
        if (superClass != null) {
            isSuper = superClass.getName().equals(superName) ? true : CodeGenerator.isSuperClass(superClass, superName);
        }
        return isSuper;
    }

    public String getAttribute(Class c, String attr) {
        String s = this.getAttribute(c, attr, true);
        if (s == null) {
            s = this.getAttribute(c, attr, false);
        }
        return s;
    }

    public String getAttribute(Class c, String attr, boolean declaredOnly) {
        String value = null;
        Field[] f = declaredOnly ? c.getDeclaredFields() : c.getFields();
        for (int i = 0; i < f.length; ++i) {
            if (!attr.equalsIgnoreCase(f[i].getName())) continue;
            try {
                value = (String)f[i].get(c);
                break;
            }
            catch (Exception e) {
                value = null;
            }
        }
        return value;
    }

    public boolean getBooleanAttribute(Class c, String attr) {
        boolean value = false;
        Field[] f = c.getFields();
        for (int i = 0; i < f.length; ++i) {
            if (!attr.equalsIgnoreCase(f[i].getName())) continue;
            try {
                value = f[i].getBoolean(c);
                break;
            }
            catch (Exception e) {
                value = false;
            }
        }
        return value;
    }

    protected Hashtable loadDefinedFields(Class c) {
        if (c == null) {
            return null;
        }
        Hashtable<String, Integer> names = new Hashtable<String, Integer>();
        Field[] f = c.getFields();
        for (int i = 0; i < f.length; ++i) {
            String gname;
            int pos;
            boolean useit = true;
            String name = f[i].getName();
            if (name.equalsIgnoreCase("contextclasspath") || name.equalsIgnoreCase("m_contextclasspath") || name.equalsIgnoreCase("reuseSingleDelegate")) {
                useit = false;
            }
            if (useit && !name.endsWith(this.mLocalSuffix) && (pos = name.indexOf(this.mLocalSuffix)) > 0 && !(gname = name.substring(pos + this.mLocalSuffix.length())).equals(this.mTarget.getGeneratorName())) {
                useit = false;
            }
            if (!useit) continue;
            names.put(name, new Integer(0));
        }
        return names;
    }

    protected void displayWarnings() {
        if (this.m_definedFields != null && this.mTarget.supportsLocalImplementation() && !this.mTarget.generatesServerCode()) {
            Enumeration enumer = this.m_definedFields.keys();
            while (enumer.hasMoreElements()) {
                Integer count;
                String name = (String)enumer.nextElement();
                if (name == null || (count = (Integer)this.m_definedFields.get(name)) == null || count != 0) continue;
                String t_n = "";
                if (this.mPackageName != null) {
                    t_n = this.mPackageName + ".";
                }
                t_n = t_n + this.mClassName;
                t_n = this.mInterface.getName();
                String t_p = this.mTarget.getGeneratorName();
                if (name.equals(name.toUpperCase())) continue;
                System.out.println("Warning: " + t_n + ": " + name + " defined but not used during " + t_p + " Proxy Generation");
            }
        }
    }

    void p(String s) {
    }

    Class _getDelegateClass() {
        this.p("alu=" + this.alreadyLookedUp + " _dc=" + this._delClass);
        if (!this.alreadyLookedUp) {
            try {
                this.p("mClassName=" + this.mClassName);
                String clsName = this.mClassName + "Delegate";
                if (this.mPackageName != null) {
                    clsName = this.mPackageName + "." + clsName;
                }
                this.p("del class = " + clsName);
                this._delClass = RocfClass.forName(clsName);
            }
            catch (ClassNotFoundException e) {
                this._delClass = null;
            }
            this.p("del class = " + this._delClass);
            this.alreadyLookedUp = true;
        }
        return this._delClass;
    }

    protected boolean isProxySubclass(Class c) {
        String className;
        if (!c.isInterface()) {
            return false;
        }
        Class<?>[] interfaces = c.getInterfaces();
        if (interfaces.length == 0) {
            return false;
        }
        String iName = interfaces[0].getName();
        int pos = iName.lastIndexOf(".");
        String packageName = null;
        if (pos < 0) {
            className = iName;
        } else {
            packageName = iName.substring(0, pos);
            className = iName.substring(pos + 1);
        }
        String proxyName = this.mTarget.getTargetName(className);
        String finalName = null;
        if (proxyName.startsWith("_rprx")) {
            finalName = "Final" + proxyName.substring(5);
            if (packageName != null) {
                finalName = packageName + "." + finalName;
            }
        }
        if (packageName != null) {
            proxyName = packageName + "." + proxyName;
        }
        boolean rc = false;
        try {
            try {
                this.m_proxySubclass = RocfClass.forName(finalName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_proxySubclass == null) {
                this.m_proxySubclass = RocfClass.forName(proxyName);
            }
            rc = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rc;
    }

    protected Method[] sortDeclaredHigh(String className, Method[] m) {
        int i;
        Method[] methods = new Method[m.length];
        Method[] temp = new Method[m.length];
        int pos = 0;
        int tempPos = 0;
        for (i = 0; i < m.length; ++i) {
            String s = m[i].getDeclaringClass().getName().trim();
            int indx = s.lastIndexOf(" ");
            if (indx > 0) {
                s = s.substring(indx + 1);
            }
            if (s.equals(className)) {
                methods[pos++] = m[i];
                continue;
            }
            temp[tempPos++] = m[i];
        }
        for (i = 0; i < pos; ++i) {
            String name = methods[i].getName();
            Class<?>[] ex = methods[i].getExceptionTypes();
            for (int j = 0; j < tempPos; ++j) {
                if (!temp[j].getName().equals(name)) continue;
                Class<?>[] ex2 = temp[j].getExceptionTypes();
                boolean diff = false;
                if (ex.length != ex2.length) {
                    diff = true;
                } else {
                    int k;
                    Hashtable<String, String> h = new Hashtable<String, String>();
                    for (k = 0; k < ex.length; ++k) {
                        h.put(ex[k].getName(), "");
                    }
                    for (k = 0; k < ex2.length; ++k) {
                        if (h.get(ex2[k].getName()) != null) continue;
                        diff = true;
                        break;
                    }
                }
                if (!diff) continue;
                System.out.println("WARNING: The exception list of method " + className + "." + name + " differs from " + temp[j].getDeclaringClass());
            }
        }
        for (i = 0; i < tempPos; ++i) {
            methods[pos++] = temp[i];
        }
        return methods;
    }

    public static String GetTypeCast(String type1, String type2) throws RuntimeException {
        if (type1.equalsIgnoreCase(type2)) {
            return "";
        }
        if (type1.equalsIgnoreCase("void") || type1.length() == 0 || type2.length() == 0) {
            return "";
        }
        boolean invalid = false;
        if (type2.equalsIgnoreCase("void") || type2.equalsIgnoreCase("boolean") || type1.equalsIgnoreCase("java.lang.String") || type2.equalsIgnoreCase("java.lang.String") || type1.indexOf("[]") != -1 || type2.indexOf("[]") != -1) {
            invalid = true;
        }
        if (type1.equalsIgnoreCase("java.lang.String") && type2.equalsIgnoreCase("org.omg.CORBA.StringHolder")) {
            invalid = false;
        }
        if (invalid) {
            throw new RuntimeException("Cannot cast to " + type1 + " from " + type2 + ".");
        }
        String cast = "";
        if (type1.equalsIgnoreCase("int")) {
            if (type2.equalsIgnoreCase("double") || type2.equalsIgnoreCase("float") || type2.equalsIgnoreCase("long")) {
                cast = type1;
            }
        } else if (type1.equalsIgnoreCase("short")) {
            if (type2.equalsIgnoreCase("double") || type2.equalsIgnoreCase("float") || type2.equalsIgnoreCase("long")) {
                cast = type1;
            }
        } else if (type1.equalsIgnoreCase("long")) {
            if (type2.equalsIgnoreCase("double") || type2.equalsIgnoreCase("float")) {
                cast = type1;
            }
        } else if (type1.equalsIgnoreCase("float")) {
            if (type2.equalsIgnoreCase("double")) {
                cast = type1;
            }
        } else if (type1.equalsIgnoreCase("char")) {
            if (type2.equalsIgnoreCase("double") || type2.equalsIgnoreCase("float") || type2.equalsIgnoreCase("long")) {
                cast = type1;
            }
        } else if (type1.equalsIgnoreCase("byte") && (type2.equalsIgnoreCase("double") || type2.equalsIgnoreCase("float") || type2.equalsIgnoreCase("long") || type2.equalsIgnoreCase("char"))) {
            cast = type1;
        }
        if (cast.length() > 0) {
            return "(" + cast + ")";
        }
        return "";
    }

    public static boolean ParametersMatch(Class[] params1, Class[] params2, boolean convertToCORBA) {
        if (params1 == null && params2 == null) {
            return true;
        }
        if (params1 == null) {
            return params2.length == 0;
        }
        if (params2 == null) {
            return params1.length == 0;
        }
        if (params1.length != params2.length) {
            return false;
        }
        try {
            for (int i = 0; i < params1.length; ++i) {
                String name1 = CodeGenerator.convertType(params1[i].getName());
                String name2 = CodeGenerator.convertType(params2[i].getName());
                if (convertToCORBA) {
                    try {
                        CodeGenerator.GetTypeCast(name1, name2);
                    }
                    catch (RuntimeException re1) {
                        String param1 = name1;
                        if (param1.equalsIgnoreCase("java.lang.String[]")) {
                            name1 = "byte[]";
                        } else if (param1.equalsIgnoreCase("com.sas.collection.hlist.HListInterface")) {
                            name1 = "byte[]";
                        } else if (param1.equalsIgnoreCase("com.sas.collection.hlist.HListInterface[]")) {
                            name1 = "byte[][]";
                        } else if (param1.equalsIgnoreCase("com.sas.collection.hlist.HListInterface[][]")) {
                            name1 = "byte[][][]";
                        }
                        try {
                            CodeGenerator.GetTypeCast(name1, name2);
                        }
                        catch (RuntimeException re2) {
                            if (param1.equalsIgnoreCase("java.lang.String[]")) {
                                name1 = "double";
                            } else if (param1.equalsIgnoreCase("com.sas.collection.hlist.HListInterface")) {
                                name1 = "double";
                            } else if (param1.equalsIgnoreCase("com.sas.collection.hlist.HListInterface[]")) {
                                name1 = "double[]";
                            } else if (param1.equalsIgnoreCase("com.sas.collection.hlist.HListInterface[][]")) {
                                name1 = "double[][]";
                            }
                            CodeGenerator.GetTypeCast(name1, name2);
                        }
                    }
                    continue;
                }
                CodeGenerator.GetTypeCast(name1, name2);
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }
}

