/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.ChooserInterface;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Chooser
extends UnicastRemoteObject
implements ChooserInterface {
    private transient String[] orbNames;
    private transient int index;

    public static void main(String[] argv) {
        try {
            new Chooser().doit(argv);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private void doit(String[] argv) throws RemoteException, UnknownHostException, MalformedURLException, NotBoundException, IOException {
        String s;
        int i;
        String localHost = InetAddress.getLocalHost().getHostName();
        int port = 1098;
        String defMWS = localHost + ":1099";
        if (argv.length == 0) {
            argv = new String[]{defMWS};
        }
        String[] torbNames = new String[argv.length];
        int count = 0;
        for (i = 0; i < argv.length; ++i) {
            s = argv[i];
            if (s.startsWith("-p")) {
                port = Integer.parseInt(s.substring(2));
                continue;
            }
            torbNames[count++] = argv[i];
        }
        if (count == 0) {
            torbNames[count++] = defMWS;
        }
        this.index = 0;
        this.orbNames = new String[count];
        for (i = 0; i < count; ++i) {
            this.orbNames[i] = torbNames[i];
        }
        System.out.println("Testing...locally");
        for (i = 0; i < 5; ++i) {
            s = this.nextName();
            System.out.println(i + ":" + s);
        }
        System.out.println();
        String bindName = "Chooser";
        System.out.println("Binding to " + bindName + " on port " + port);
        Registry registry = LocateRegistry.createRegistry(port);
        registry.rebind(bindName, this);
        System.out.println("Testing...remotely");
        ChooserInterface ci = (ChooserInterface)registry.lookup(bindName);
        for (int i2 = 0; i2 < 5; ++i2) {
            String s2 = ci.nextName();
            System.out.println(i2 + ":" + s2);
        }
        System.out.println();
        System.out.println("Ready");
    }

    @Override
    public synchronized String nextName() throws RemoteException {
        String retval = this.orbNames[this.index++];
        if (this.index >= this.orbNames.length) {
            this.index = 0;
        }
        return retval;
    }

    public static synchronized String nextName(String chooserHost) {
        if (!chooserHost.startsWith("//")) {
            chooserHost = "//" + chooserHost;
        }
        if (!chooserHost.endsWith("/Chooser")) {
            chooserHost = chooserHost + "/Chooser";
        }
        String name = "localhost";
        String msg = "Cannot contact " + chooserHost;
        try {
            ChooserInterface ci = (ChooserInterface)Chooser.rmilookup(chooserHost);
            name = ci.nextName();
        }
        catch (RemoteException e) {
            System.err.println(msg);
        }
        catch (NotBoundException e) {
            System.err.println(msg);
        }
        catch (MalformedURLException e) {
            System.err.println(msg);
        }
        return name;
    }

    public static synchronized Object rmilookup(final String key) throws RemoteException, MalformedURLException, NotBoundException {
        Object obj = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object o = null;
                try {
                    o = Naming.lookup(key);
                }
                catch (RemoteException e) {
                    o = e;
                }
                catch (MalformedURLException e) {
                    o = e;
                }
                catch (NotBoundException e) {
                    o = e;
                }
                return o;
            }
        });
        if (obj instanceof RemoteException) {
            throw (RemoteException)obj;
        }
        if (obj instanceof MalformedURLException) {
            throw (MalformedURLException)obj;
        }
        if (obj instanceof NotBoundException) {
            throw (NotBoundException)obj;
        }
        return obj;
    }
}

